/*
 * Decompiled with CFR 0.152.
 */
package org.gwtwidgets.server.spring;

import java.lang.reflect.Method;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.gwtwidgets.server.spring.ServletUtils;

public class RequestInjection
implements MethodInterceptor {
    protected String requestSetterName;
    protected String responseSetterName;

    private void setRequestOnTarget(HttpServletRequest request, HttpServletResponse response, Object target) throws Exception {
        Method method2;
        if (this.requestSetterName != null) {
            try {
                method2 = target.getClass().getMethod(this.requestSetterName, HttpServletRequest.class);
                method2.invoke(target, request);
            }
            catch (NoSuchMethodException method2) {
                // empty catch block
            }
        }
        if (this.responseSetterName != null) {
            try {
                method2 = target.getClass().getMethod(this.responseSetterName, HttpServletResponse.class);
                method2.invoke(target, response);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Object target = invocation.getThis();
        this.setRequestOnTarget(ServletUtils.getRequest(), ServletUtils.getResponse(), target);
        return invocation.proceed();
    }

    public void setRequestSetterName(String setterName) {
        this.requestSetterName = setterName;
    }

    public void setResponseSetterName(String setterName) {
        this.responseSetterName = setterName;
    }
}

