/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.web.design;

import com.google.common.base.Charsets;
import de.justsoftware.onx.design.business.ThemeService;
import de.justsoftware.onx.design.shared.model.Theme;
import de.justsoftware.onx.design.shared.model.ThemeId;
import de.justsoftware.web.design.theme.ThemeRenderer;
import freemarker.template.TemplateException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.lang.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import ro.isdc.wro.model.resource.locator.UriLocator;

@Service(value="themeLocator")
@ParametersAreNonnullByDefault
public class ThemeUriLocator
implements UriLocator {
    public static final String ALIAS = "theme";
    private static final Logger LOG = LoggerFactory.getLogger(ThemeUriLocator.class);
    private static final String LOCATE_FAILS_RULE = ".THEME_FAILS_TO_LOAD {}";
    private final ThemeService _themeService;
    private final ThemeRenderer _themeRenderer;

    @Autowired
    public ThemeUriLocator(ThemeService themeService, ThemeRenderer themeRenderer) {
        this._themeService = themeService;
        this._themeRenderer = themeRenderer;
    }

    public InputStream locate(String uri) throws IOException {
        try {
            String[] uriParts = uri.split(":");
            if (uriParts.length == 2 && NumberUtils.isDigits((String)uriParts[1])) {
                ThemeId themeId = new ThemeId(Long.parseLong(uriParts[1]));
                return new ByteArrayInputStream(this.renderTheme(themeId).getBytes(Charsets.UTF_8));
            }
        }
        catch (TemplateException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        return new ByteArrayInputStream(LOCATE_FAILS_RULE.getBytes(Charsets.UTF_8));
    }

    @Nonnull
    private String renderTheme(ThemeId themeId) throws IOException, TemplateException {
        Theme theme = this._themeService.getByIdUnauthorized(themeId);
        if (theme != null) {
            return this._themeRenderer.renderTheme(theme);
        }
        return LOCATE_FAILS_RULE;
    }

    @Nonnull
    private String createVariablesTemplate(Map<String, Object> variablesMap) {
        StringBuilder templateBuilder = new StringBuilder();
        String template = "@%s: %s;%n";
        for (Map.Entry<String, Object> entry : variablesMap.entrySet()) {
            templateBuilder.append(String.format("@%s: %s;%n", entry.getKey(), entry.getValue()));
        }
        return templateBuilder.toString();
    }

    public boolean accept(String uri) {
        return uri != null && uri.startsWith(ALIAS);
    }
}

