/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.presentation.client.ui;

import com.freiheit.toro.client.mediator.I18nMediator;
import com.freiheit.toro.common.shared.util.ClientStringUtil;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.DialogBox;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.onx.common.presentation.client.ui.DialogBoxView;
import de.justsoftware.onx.common.presentation.client.ui.JCButton;
import de.justsoftware.onx.common.presentation.client.ui.JCClosePopupIcon;
import de.justsoftware.onx.common.presentation.client.ui.JCDialogBox;
import de.justsoftware.onx.common.presentation.client.ui.NoActionCloseCallback;
import de.justsoftware.onx.common.shared.i18n.BasicConstants;
import de.justsoftware.onx.components.presentation.client.ui.ShowPopupUtils;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class JCDialogBox
extends DialogBox
implements NoActionCloseCallback,
DialogBoxView {
    private static final JCDialogBoxCaptionUiBinder UI_BINDER = (JCDialogBoxCaptionUiBinder)GWT.create(JCDialogBoxCaptionUiBinder.class);
    private static final String DIALOGBOXSTYLE_DEFAULT = "jc-dialogbox";
    private static final BasicConstants BASIC = I18nMediator.BASIC_CONSTANTS;
    private static final int MIN_POPUP_POSITION_IN_PX = 20;
    protected FlowPanel _buttonPanel;
    protected final SimplePanel _contentPanel = new SimplePanel();
    protected Widget _content = null;
    protected final FlexTable _container = new FlexTable();
    protected final JCClosePopupIcon _closeIcon;
    protected final Size _size;
    private boolean _shown = false;

    public JCDialogBox(boolean autoHide, boolean modal, @Nullable String headingText, @Nonnull Size size) {
        super(autoHide, modal, (DialogBox.Caption)new JCDialogBoxCaption());
        this._size = size;
        this._closeIcon = new JCClosePopupIcon((NoActionCloseCallback)this);
        this.getCaption().setAction((Widget)this._closeIcon);
        if (headingText != null) {
            this.setText(headingText);
        }
        this._container.setStyleName(DIALOGBOXSTYLE_DEFAULT);
        this.setWidget((Widget)this._container);
        if (modal) {
            this.setGlassEnabled(true);
        }
        this.applySize();
        this._contentPanel.setStyleName("db_content");
        this._container.setWidget(1, 0, (Widget)this._contentPanel);
    }

    public JCDialogBox(boolean autoHide, boolean modal, @Nullable String headingText) {
        this(autoHide, modal, headingText, Size.DEFAULT);
    }

    public JCDialogBox(boolean autoHide, boolean modal, @Nonnull Size size) {
        this(autoHide, modal, null, size);
    }

    public JCDialogBox(boolean autoHide, boolean modal) {
        this(autoHide, modal, null, Size.DEFAULT);
    }

    public JCDialogBox(boolean autoHide) {
        this(autoHide, true);
    }

    public JCDialogBox() {
        this(false);
    }

    public JCDialogBox(@Nullable String headingLabel) {
        this(false, true, headingLabel, Size.DEFAULT);
    }

    public JCDialogBoxCaption getCaption() {
        return (JCDialogBoxCaption)super.getCaption();
    }

    public void hideWithoutAction() {
        this.hide();
    }

    public void setContent(IsWidget newcontent) {
        if (this._content != null) {
            this._content.removeFromParent();
            this._content = null;
        }
        if (newcontent != null) {
            this._content = newcontent.asWidget();
            this.addContentStyle("content");
            this._contentPanel.setWidget(this._content);
        }
    }

    public void addContentStyle(String styleName) {
        if (this._content != null) {
            this._content.addStyleName(styleName);
        }
    }

    public void setFooter(Widget newcontent) {
        this._container.setWidget(this._container.getRowCount(), 0, newcontent);
    }

    public void addButton(JCButton button) {
        if (this._buttonPanel == null) {
            this._buttonPanel = new FlowPanel();
            this._buttonPanel.addStyleName("buttonPanel");
            this._container.setWidget(2, 0, (Widget)this._buttonPanel);
        }
        if (this._buttonPanel.getWidgetCount() > 0) {
            Widget previous = this._buttonPanel.getWidget(this._buttonPanel.getWidgetCount() - 1);
            previous.removeStyleDependentName("last");
        }
        if (button != null) {
            this._buttonPanel.add((Widget)button);
            button.addStyleDependentName("last");
        }
    }

    public void hide() {
        this._shown = false;
        super.hide();
    }

    public void hide(boolean autoClosed) {
        this._shown = false;
        super.hide(autoClosed);
    }

    public void show() {
        this.superShow();
        this._shown = true;
        int left = Window.getScrollLeft() + (Window.getClientWidth() - this.getOffsetWidth()) / 2;
        int top = Window.getScrollTop() + (Window.getClientHeight() - this.getOffsetHeight()) / 2;
        this.setPopupPosition(left > 0 ? left : 20, top > 0 ? top : 20);
    }

    private void superShow() {
        ShowPopupUtils.showPopupAction((PopupPanel)this, (Widget)this._container, (ShowPopupUtils.ShowPopupCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void show(int left, int top) {
        this.setPopupPosition(left, top);
        this.superShow();
        this._shown = true;
    }

    public void center() {
        int clientHeight = Window.getClientHeight();
        int clientWidth = Window.getClientWidth();
        int offsetWidth = this.getOffsetWidth();
        int offsetHeight = this.getOffsetHeight();
        if (!this.isShowing() || clientHeight > offsetHeight && clientWidth > offsetWidth) {
            ShowPopupUtils.showPopupAction((PopupPanel)this, (Widget)this._container, (ShowPopupUtils.ShowPopupCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    public boolean showIfNotDeactivated() {
        this.show();
        return true;
    }

    public void setPopupPositionAndShow(PopupPanel.PositionCallback callback) {
        ShowPopupUtils.showPopupAction((PopupPanel)this, (Widget)this._container, (ShowPopupUtils.ShowPopupCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public boolean isShown() {
        return this._shown;
    }

    @Deprecated
    public void addStyleName(String style) {
        super.addStyleName(style);
    }

    protected void onPreviewNativeEvent(Event.NativePreviewEvent previewEvent) {
        if (previewEvent.isCanceled() || previewEvent.getNativeEvent() == null) {
            super.onPreviewNativeEvent(previewEvent);
            return;
        }
        Event event = Event.as((NativeEvent)previewEvent.getNativeEvent());
        if (event.getTypeInt() == 131072 || this.isScrollbarClickEvent(event)) {
            previewEvent.consume();
        }
        super.onPreviewNativeEvent(previewEvent);
    }

    private boolean isScrollbarClickEvent(@Nonnull Event event) {
        if (event.getTypeInt() != 4 && event.getTypeInt() != 1 && event.getTypeInt() != 0x100000) {
            return false;
        }
        if (!Element.is((JavaScriptObject)event.getEventTarget())) {
            return false;
        }
        Element element = Element.as((JavaScriptObject)event.getEventTarget());
        return "HTML".equals(element.getTagName());
    }

    private void applySize() {
        String cssClassString = this.getSize().getCssClass();
        if (ClientStringUtil.hasText((String)cssClassString)) {
            this.getElement().addClassName(cssClassString);
        }
    }

    @Nonnull
    protected Size getSize() {
        return this._size;
    }

    public void setCloseIconVisible(boolean visible) {
        this._closeIcon.setVisible(visible);
    }

    public void setHeadline(String headline) {
        this.setText(headline);
    }

    static /* synthetic */ void access$001(JCDialogBox x0) {
        super.show();
    }

    static /* synthetic */ void access$101(JCDialogBox x0) {
        super.center();
    }

    static /* synthetic */ void access$201(JCDialogBox x0, PopupPanel.PositionCallback x1) {
        super.setPopupPositionAndShow(x1);
    }
}

