/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.gwt.requestcollect.client;

import com.freiheit.toro.util.client.LoggingUtil;
import com.google.common.collect.Lists;
import com.google.gwt.user.client.rpc.AsyncCallback;
import de.justsoftware.gwt.requestcollect.client.AbstractRequestCollectorCache;
import de.justsoftware.gwt.requestcollect.client.RequestCollector;
import java.util.LinkedList;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public abstract class SingleValueRequestCollectorCache<O>
extends AbstractRequestCollectorCache {
    private AbstractRequestCollectorCache.CacheEntry<O> _cache = null;
    private LinkedList<AsyncCallback<O>> _callbacks = Lists.newLinkedList();
    private boolean _requestPending = false;
    private final long _timeToLiveMillis;

    protected SingleValueRequestCollectorCache(@Nonnull Class<?> asyncControllerClass, @Nonnull String name, long timeToLiveMillis) {
        super(asyncControllerClass, name);
        this._timeToLiveMillis = timeToLiveMillis;
    }

    public void bundleRequests() {
        this.getClearedCache();
        if (this._callbacks.isEmpty() || this._requestPending) {
            return;
        }
        this._requestPending = true;
        this.callback((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    @CheckForNull
    private AbstractRequestCollectorCache.CacheEntry<O> getClearedCache() {
        if (this._cache != null && this._cache.isOutDated(System.currentTimeMillis())) {
            this._cache = null;
        }
        return this._cache;
    }

    @Nonnull
    private Iterable<AsyncCallback<O>> copyOfCallbacks() {
        LinkedList result = this._callbacks;
        this._callbacks = Lists.newLinkedList();
        return result;
    }

    protected abstract void callback(@Nonnull AsyncCallback<O> var1);

    public void call(@Nonnull AsyncCallback<O> asyncCallback) {
        AbstractRequestCollectorCache.CacheEntry cache = this.getClearedCache();
        if (cache != null) {
            try {
                asyncCallback.onSuccess(cache._value);
            }
            catch (RuntimeException e) {
                LoggingUtil.error((Object)this, (String)e.toString());
            }
        } else {
            this._callbacks.add(asyncCallback);
            RequestCollector.INSTANCE.scheduleTimer();
        }
    }

    void invalidateKeys(Iterable<?> keys) {
        this.invalidateAll();
    }

    void invalidateAll() {
        this._cache = null;
    }
}

