/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.auth.controller;

import de.justsoftware.onx.design.shared.ImageAttributeToStorageServerUrlVisitor;
import de.justsoftware.onx.design.shared.model.Theme;
import de.justsoftware.onx.design.shared.model.ThemeAttribute;
import de.justsoftware.onx.design.shared.model.ThemeAttributeType;
import de.justsoftware.onx.design.shared.model.ThemeAttributeVisitor;
import de.justsoftware.onx.tenantdesign.ThemeService;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/auth"})
@ParametersAreNonnullByDefault
public class OAuthLoginController {
    public static final String USERNAME_PARAMETER = "j_username";
    public static final String PASSWORD_PARAMETER = "j_password";
    public static final String OAUTH_LOGIN_URL = "/auth/login";
    public static final String OAUTH_LOGIN_ACTION = "/auth/login.do";
    public static final String AUTH_ERROR_PARAM = "authorization_error";
    public static final String OAUTH_FAILURE_URL = "/auth/login?authorization_error=true";
    private final ThemeService _themeService;

    @Autowired
    public OAuthLoginController(ThemeService themeService) {
        this._themeService = themeService;
    }

    @Nonnull
    @GetMapping(value={"/login"})
    public ModelAndView login(HttpServletRequest request) {
        return new ModelAndView("oauth_login_page", this.loginParameters(request));
    }

    @Nonnull
    private Map<String, Object> loginParameters(HttpServletRequest request) {
        boolean hasAuthError;
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        boolean bl = hasAuthError = request.getParameter(AUTH_ERROR_PARAM) != null;
        if (hasAuthError) {
            parameters.put("authError", true);
        }
        String loginAction = request.getContextPath() + OAUTH_LOGIN_ACTION;
        parameters.put("loginAction", loginAction);
        this.addLoginThemeAttributes(parameters);
        return parameters;
    }

    private void addLoginThemeAttributes(Map<String, Object> model) {
        Theme legacyTheme = this._themeService.getLegacyTheme(null);
        ThemeAttribute logo = legacyTheme.getAttribute(ThemeAttributeType.NG_LOGIN_PAGE_LOGO);
        if (logo != null) {
            String logoFileName = logo.getValue();
            ImageAttributeToStorageServerUrlVisitor visitor = new ImageAttributeToStorageServerUrlVisitor(logoFileName);
            String logoPath = (String)ThemeAttributeType.NG_LOGIN_PAGE_LOGO.accept((ThemeAttributeVisitor)visitor);
            model.put("logo", logoPath);
        }
        this.addThemeAttribute(model, "backgroundGradientStartColor", legacyTheme, ThemeAttributeType.NG_LOGIN_PAGE_BACKGROUND_GRADIENT_START_COLOR);
        this.addThemeAttribute(model, "buttonBackgroundColor", legacyTheme, ThemeAttributeType.NG_LOGIN_BUTTON_BACKGROUND_COLOR);
        this.addThemeAttribute(model, "buttonTextColor", legacyTheme, ThemeAttributeType.NG_LOGIN_BUTTON_TEXT_COLOR);
        this.addThemeAttribute(model, "linkColor", legacyTheme, ThemeAttributeType.NG_LOGIN_LINK_COLOR);
        this.addThemeAttribute(model, "textColor", legacyTheme, ThemeAttributeType.NG_LOGIN_TEXT_COLOR);
    }

    private void addThemeAttribute(Map<String, Object> model, String name, Theme theme, ThemeAttributeType attributeType) {
        ThemeAttribute attribute = theme.getAttribute(attributeType);
        if (attribute == null) {
            return;
        }
        model.put(name, attribute.getValue());
    }
}

