/*
 * Decompiled with CFR 0.152.
 */
package com.freiheit.toro.admin.presentation.server;

import com.freiheit.toro.admin.presentation.client.AdminController;
import com.freiheit.toro.common.shared.model.ServiceException;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.admin.SuperAdminService;
import de.justsoftware.onx.authorization.business.AuthorizationContext;
import de.justsoftware.onx.authorization.business.SessionAuthorizationContextProvider;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.common.shared.model.action.StaticAction;
import de.justsoftware.onx.license.business.LicenseService;
import de.justsoftware.onx.license.shared.model.LicenseInfo;
import org.springframework.stereotype.Service;

@Service
public class AdminControllerImpl
implements AdminController {
    private final SessionAuthorizationContextProvider _authorizationContextProvider;
    private final SuperAdminService _superAdminService;
    private final LicenseService _licenseService;

    public AdminControllerImpl(SessionAuthorizationContextProvider authorizationContextProvider, SuperAdminService superAdminService, LicenseService licenseService) {
        this._authorizationContextProvider = authorizationContextProvider;
        this._superAdminService = superAdminService;
        this._licenseService = licenseService;
    }

    public void syncAllPermissions() throws ServiceException {
        this.authCtx().check((Action)StaticAction.ADMIN_KAFKA_ADMIN);
        this._superAdminService.syncAllPermissions();
    }

    public void syncJustPeople() throws ServiceException {
        this.authCtx().check((Action)StaticAction.ADMIN_KAFKA_ADMIN);
        this._superAdminService.syncJustPeople();
    }

    public void syncJustDrive() throws ServiceException {
        this.authCtx().check((Action)StaticAction.ADMIN_KAFKA_ADMIN);
        this._superAdminService.syncJustDrive();
    }

    public void flushCache() {
        this.authCtx().check((Action)StaticAction.ADMIN_FLUSH_CACHE);
        this._superAdminService.flushCache();
    }

    public void reloadOverrideLess() throws ServiceException {
        this.authCtx().check((Action)StaticAction.ADMIN_FLUSH_CACHE);
        this._superAdminService.reloadOverrideLess();
    }

    public void reloadConfigFile() {
        this.authCtx().check((Action)StaticAction.ADMIN_RELOAD_CONFIG);
        this._superAdminService.reloadConfigFile();
    }

    private AuthorizationContext authCtx() {
        return this._authorizationContextProvider.getAuthorizationContextForCurrentUser();
    }

    public void syncPersonData() {
        this.authCtx().check((Action)StaticAction.ADMIN_KAFKA_ADMIN);
        this._superAdminService.syncPersonData();
    }

    public void syncDrivePermissions() {
        this.authCtx().check((Action)StaticAction.ADMIN_KAFKA_ADMIN);
        this._superAdminService.syncDrivePermissions();
    }

    public void syncPeopleUserGroups() throws ServiceException {
        this.authCtx().check((Action)StaticAction.ADMIN_KAFKA_ADMIN);
        this._superAdminService.syncPeopleUserGroups();
    }

    public void syncWikiPermissions() throws ServiceException {
        this.authCtx().check((Action)StaticAction.ADMIN_KAFKA_ADMIN);
        this._superAdminService.syncWikiPermissions();
    }

    public void syncToroPermissions() {
        this.authCtx().check((Action)StaticAction.ADMIN_KAFKA_ADMIN);
        this._superAdminService.syncToroPermissions();
    }

    public void syncChatPermissions() throws ServiceException {
        this.authCtx().check((Action)StaticAction.ADMIN_KAFKA_ADMIN);
        this._superAdminService.syncChatPermissions();
    }

    public void syncDocuments() {
        this.authCtx().check((Action)StaticAction.ADMIN_KAFKA_ADMIN);
        this._superAdminService.syncDocuments();
    }

    public LicenseInfo getLicenseInfo() throws ServiceException {
        this.authCtx().check((Action)StaticAction.ADMIN_IMPORT_EXTERNAL_PERSONS);
        return this._licenseService.getLicenseInfo();
    }

    public void syncConversationNodes() {
        this.authCtx().check((Action)StaticAction.ADMIN_KAFKA_ADMIN);
        this._superAdminService.clearAndSyncChatNodes();
    }

    public void runDriveHistoryCompactionJob() {
        this.authCtx().check((Action)StaticAction.ADMIN_SYSTEM_ADMINISTRATION);
        this._superAdminService.runDriveHistoryCompactionJob();
    }

    public ImmutableSet<Action> getAllowedSystemActions() throws ServiceException {
        AuthorizationContext authCtx = this._authorizationContextProvider.getAuthorizationContextForCurrentUser();
        return authCtx.may(SYSTEM_FUNCTION_ACTIONS);
    }
}

