/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.publicAPI.controller;

import de.justsoftware.publicAPI.authorization.AuthContext;
import de.justsoftware.publicAPI.controller.WikiController;
import de.justsoftware.publicAPI.controller.model.ArticleExportDto;
import de.justsoftware.publicAPI.exception.BadRequestException;
import de.justsoftware.search.shared.SearchServiceInternalConnector;
import de.justsoftware.search.shared.model.ProfileId;
import de.justsoftware.search.shared.model.SearchParam;
import de.justsoftware.search.shared.model.SearchResult;
import de.justsoftware.search.shared.model.SearchType;
import de.justsoftware.search.shared.model.SortBy;
import de.justsoftware.search.shared.model.SortDirection;
import de.justsoftware.search.shared.model.TenantId;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.core.io.buffer.DataBufferLimitException;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/wiki"})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J6\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\n\b\u0001\u0010\t\u001a\u0004\u0018\u00010\n2\b\b\u0001\u0010\u000b\u001a\u00020\f2\b\b\u0001\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lde/justsoftware/publicAPI/controller/WikiController;", "", "searchServiceInternalConnector", "Lde/justsoftware/search/shared/SearchServiceInternalConnector;", "<init>", "(Lde/justsoftware/search/shared/SearchServiceInternalConnector;)V", "exportArticles", "", "Lde/justsoftware/publicAPI/controller/model/ArticleExportDto;", "modifiedAfter", "Ljava/time/Instant;", "offset", "", "limit", "authContext", "Lde/justsoftware/publicAPI/authorization/AuthContext;", "Companion", "public-api-service"})
@SourceDebugExtension(value={"SMAP\nWikiController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WikiController.kt\nde/justsoftware/publicAPI/controller/WikiController\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,60:1\n1#2:61\n1557#3:62\n1628#3,3:63\n*S KotlinDebug\n*F\n+ 1 WikiController.kt\nde/justsoftware/publicAPI/controller/WikiController\n*L\n47#1:62\n47#1:63,3\n*E\n"})
public class WikiController {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SearchServiceInternalConnector searchServiceInternalConnector;
    public static final int MAX_EXPORT_LIMIT = 1000;

    public WikiController(@NotNull SearchServiceInternalConnector searchServiceInternalConnector) {
        Intrinsics.checkNotNullParameter((Object)searchServiceInternalConnector, (String)"searchServiceInternalConnector");
        this.searchServiceInternalConnector = searchServiceInternalConnector;
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(value={"articles"})
    @NotNull
    public List<ArticleExportDto> exportArticles(@RequestParam(value="modifiedAfter", required=false) @Nullable Instant modifiedAfter, @RequestParam(value="offset", required=false, defaultValue="0") int offset, @RequestParam(value="limit", required=false, defaultValue="50") int limit, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        if (limit > 1000) {
            throw new BadRequestException("Limit of " + limit + " exceeds the max limit of 1000.");
        }
        try {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Date date;
            SortDirection p0;
            Object object;
            SearchServiceInternalConnector searchServiceInternalConnector = this.searchServiceInternalConnector;
            Object object2 = new ProfileId(authContext.getUser().getId());
            TenantId tenantId = new TenantId(authContext.getTenantId().getId());
            Instant instant = modifiedAfter;
            if (instant != null) {
                Instant instant2 = instant;
                object = searchServiceInternalConnector;
                boolean $i$f$exportArticles$stub_for_inlining = false;
                boolean bl = false;
                date = Date.from((Instant)p0);
                searchServiceInternalConnector = object;
            } else {
                date = null;
            }
            Date date2 = date;
            Set set = SetsKt.setOf((Object)SearchType.WIKI_ARTICLE);
            p0 = SortDirection.DESC;
            SortBy $i$f$exportArticles$stub_for_inlining = SortBy.MODIFY_DATE;
            object2 = searchServiceInternalConnector.search(new SearchParam(tenantId, object2, null, set, null, null, null, null, null, null, null, null, null, null, date2, null, true, offset, limit, $i$f$exportArticles$stub_for_inlining, p0, 49140, null)).getResults();
            tenantId = ArticleExportDto.Companion;
            boolean $i$f$map = false;
            set = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p02;
                SearchResult searchResult = (SearchResult)item$iv$iv;
                object = destination$iv$iv;
                boolean $i$f$exportArticles$stub_for_inlining$0 = false;
                boolean bl = false;
                object.add(tenantId.fromSearchResult((SearchResult)p02));
            }
            return (List)destination$iv$iv;
        }
        catch (RuntimeException e) {
            if (!(!(e.getCause() instanceof DataBufferLimitException))) {
                boolean bl = false;
                String string = "Too many data loaded. Reduce the limit to avoid this error. Current limit was: " + limit + ".";
                throw new IllegalArgumentException(string.toString());
            }
            throw e;
        }
    }
}

