/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.publicAPI.config;

import de.justsoftware.publicAPI.authorization.AuthContext;
import de.justsoftware.publicAPI.config.OpenAPIConfiguration;
import de.justsoftware.publicAPI.model.ArticleId;
import de.justsoftware.publicAPI.model.TenantId;
import de.justsoftware.publicAPI.model.WikiId;
import io.swagger.v3.core.jackson.ModelResolver;
import io.swagger.v3.oas.annotations.enums.SecuritySchemeType;
import io.swagger.v3.oas.annotations.security.OAuthFlow;
import io.swagger.v3.oas.annotations.security.OAuthFlows;
import io.swagger.v3.oas.annotations.security.OAuthScope;
import io.swagger.v3.oas.annotations.security.SecurityScheme;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springdoc.core.utils.SpringDocUtils;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@SecurityScheme(type=SecuritySchemeType.OAUTH2, name="oauth2", flows=@OAuthFlows(authorizationCode=@OAuthFlow(authorizationUrl="/toro/oauth/authorize", tokenUrl="/toro/oauth/token", scopes={@OAuthScope(name="api", description="Access to all your data.")})))
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 \u00062\u00020\u0001:\u0001\u0006B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0017\u00a8\u0006\u0007"}, d2={"Lde/justsoftware/publicAPI/config/OpenAPIConfiguration;", "", "<init>", "()V", "publicAPIDocumentation", "Lio/swagger/v3/oas/models/OpenAPI;", "Companion", "public-api-service"})
public class OpenAPIConfiguration {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Bean
    @NotNull
    public OpenAPI publicAPIDocumentation() {
        OpenAPI openAPI = new OpenAPI().security(CollectionsKt.listOf((Object)new SecurityRequirement().addList("oauth2"))).info(new Info().title("Just Public API").version("1.0.0"));
        Intrinsics.checkNotNullExpressionValue((Object)openAPI, (String)"info(...)");
        return openAPI;
    }

    static {
        ModelResolver.enumsAsRef = true;
        Class[] classArray = new Class[]{AuthContext.class};
        SpringDocUtils.getConfig().addRequestWrapperToIgnore(classArray).replaceWithClass(TenantId.class, String.class).replaceWithClass(ArticleId.class, String.class).replaceWithClass(WikiId.class, String.class);
    }
}

