/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.publicAPI.config;

import de.justsoftware.publicAPI.config.ExceptionHandlerConfiguration;
import de.justsoftware.publicAPI.exception.BadRequestException;
import de.justsoftware.publicAPI.exception.UnauthorizedException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpStatus;
import org.springframework.http.converter.HttpMessageConversionException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.method.annotation.MethodArgumentTypeMismatchException;

@Configuration
@ControllerAdvice
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u0000 \u000f2\u00020\u0001:\u0002\u000e\u000fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u00060\u0007j\u0002`\bH\u0017J\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\nH\u0017J\u0014\u0010\u000b\u001a\u00020\u00052\n\u0010\u0006\u001a\u00060\u0007j\u0002`\bH\u0017J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\rH\u0017\u00a8\u0006\u0010"}, d2={"Lde/justsoftware/publicAPI/config/ExceptionHandlerConfiguration;", "", "<init>", "()V", "handleAllExceptions", "Lde/justsoftware/publicAPI/config/ExceptionHandlerConfiguration$ErrorResponse;", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "handleBadRequestException", "Lde/justsoftware/publicAPI/exception/BadRequestException;", "handleBadRequestExceptions", "handleUnauthorizedException", "Lde/justsoftware/publicAPI/exception/UnauthorizedException;", "ErrorResponse", "Companion", "public-api-service"})
@SourceDebugExtension(value={"SMAP\nExceptionHandlerConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExceptionHandlerConfiguration.kt\nde/justsoftware/publicAPI/config/ExceptionHandlerConfiguration\n+ 2 LoggerUtils.kt\nde/justsoftware/publicAPI/util/LoggerUtilsKt\n*L\n1#1,57:1\n8#2:58\n7#2,3:59\n*S KotlinDebug\n*F\n+ 1 ExceptionHandlerConfiguration.kt\nde/justsoftware/publicAPI/config/ExceptionHandlerConfiguration\n*L\n53#1:58\n53#1:59,3\n*E\n"})
public class ExceptionHandlerConfiguration {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final String DEFAULT_ERROR = "An unexpected error occurred.";

    @ExceptionHandler(value={Exception.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @ResponseBody
    @NotNull
    public ErrorResponse handleAllExceptions(@NotNull Exception e) {
        ErrorResponse errorResponse;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        ErrorResponse it = errorResponse = new ErrorResponse(DEFAULT_ERROR);
        boolean bl = false;
        LOG.error(DEFAULT_ERROR, (Throwable)e);
        return errorResponse;
    }

    @ExceptionHandler(value={BadRequestException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    @NotNull
    public ErrorResponse handleBadRequestException(@NotNull BadRequestException e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return new ErrorResponse(e.getMessage());
    }

    @ExceptionHandler(value={MethodArgumentTypeMismatchException.class, HttpMessageConversionException.class, IllegalArgumentException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    @NotNull
    public ErrorResponse handleBadRequestExceptions(@NotNull Exception e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return new ErrorResponse(e.getMessage());
    }

    @ExceptionHandler(value={UnauthorizedException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    @ResponseBody
    @NotNull
    public ErrorResponse handleUnauthorizedException(@NotNull UnauthorizedException e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return new ErrorResponse(e.getMessage());
    }

    static {
        Companion $this$logger$iv = Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = LoggerFactory.getLogger(Reflection.getOrCreateKotlinClass(Companion.class).isCompanion() ? Companion.class.getEnclosingClass() : Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOG = logger;
    }
}

