/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.permission.kafka;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.annotations.VisibleForTesting;
import de.justsoftware.permission.business.config.ConfigService;
import de.justsoftware.permission.business.config.model.ConfigForItemType;
import de.justsoftware.permission.business.config.model.PermissionPath;
import de.justsoftware.permission.business.config.model.Replacement;
import de.justsoftware.permission.business.item.model.ItemType;
import de.justsoftware.permission.business.offsets.ConsumerOffsetService;
import de.justsoftware.permission.kafka.AbstractKafkaConsumer;
import de.justsoftware.permission.kafka.ConfigConsumer;
import de.justsoftware.permission.kafka.ConsumerUtils;
import de.justsoftware.permission.kafka.KafkaConfigurationProvider;
import de.justsoftware.permission.persistence.TransactionSupport;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.lang3.StringUtils;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
@ParametersAreNonnullByDefault
public class ConfigConsumer
extends AbstractKafkaConsumer<String, String> {
    @VisibleForTesting
    static final String TOPIC = "just.permission.config";
    private static final Logger LOG = LoggerFactory.getLogger(ConfigConsumer.class);
    private final ConfigService _configService;

    @Autowired
    public ConfigConsumer(KafkaConfigurationProvider configurationProvider, ConfigService configService, ConsumerOffsetService consumerOffsetService, TransactionSupport transactionSupport) {
        this(() -> configurationProvider.manualAssignmentStringConsumer(), configService, consumerOffsetService, configurationProvider, transactionSupport);
    }

    @VisibleForTesting
    ConfigConsumer(Supplier<Consumer<String, String>> consumerSupplier, ConfigService configService, ConsumerOffsetService consumerOffsetService, KafkaConfigurationProvider configurationProvider, TransactionSupport transactionSupport) {
        super(consumerSupplier, "just.permission.config", 0, consumerOffsetService, configurationProvider, transactionSupport);
        this._configService = configService;
    }

    protected void unsubscribe() {
    }

    protected void subscribe() {
        this.assign(arg_0 -> ((ConfigConsumer)this).seekToBeginning(arg_0));
    }

    protected void commit() {
    }

    protected Logger getLog() {
        return LOG;
    }

    protected void process(ConsumerRecords<String, String> records) {
        HashMap<String, String> recordsWithoutDuplicates = new HashMap<String, String>();
        records.forEach(r -> {
            String key = StringUtils.trimToNull((String)((String)r.key()));
            if (key != null) {
                recordsWithoutDuplicates.put(key, (String)r.value());
            }
        });
        recordsWithoutDuplicates.forEach((arg_0, arg_1) -> this.processRecord(arg_0, arg_1));
    }

    private void processRecord(String key, @Nullable String value) {
        JsonNode jsonNode;
        ItemType itemType = ItemType.get((String)key);
        ConfigForItemType.Builder replacements = ConfigForItemType.builder();
        String trimmedValue = StringUtils.trimToNull((String)value);
        LinkedHashMap<String, JsonNode> orderedNonnullJsonFields = new LinkedHashMap<String, JsonNode>();
        if (trimmedValue != null && (jsonNode = this.parseJson(trimmedValue)) != null) {
            jsonNode.fields().forEachRemaining(e -> orderedNonnullJsonFields.put((String)e.getKey(), (JsonNode)e.getValue()));
        }
        orderedNonnullJsonFields.forEach((pathString, expr) -> {
            Replacement replacementExpression = ConsumerUtils.parseReplacement((JsonNode)expr);
            PermissionPath permissionPath = PathParser.parse((String)pathString);
            if (!permissionPath.isEmpty()) {
                replacements.add(permissionPath, replacementExpression);
            }
        });
        this._configService.replaceConfig(itemType, replacements.build());
        LOG.info("Successfully replaced config for item type '{}'", (Object)itemType);
    }
}

