/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.graphql;

import com.netflix.graphql.dgs.exceptions.DefaultDataFetcherExceptionHandler;
import com.netflix.graphql.types.errors.ErrorDetail;
import com.netflix.graphql.types.errors.TypedGraphQLError;
import de.justsoftware.news.auth.exceptions.NotAuthorizedException;
import de.justsoftware.news.domain.error.NewsException;
import de.justsoftware.news.graphql.CustomErrorDetail;
import de.justsoftware.news.graphql.ErrorHandler;
import graphql.GraphQLError;
import graphql.execution.DataFetcherExceptionHandler;
import graphql.execution.DataFetcherExceptionHandlerParameters;
import graphql.execution.DataFetcherExceptionHandlerResult;
import graphql.execution.ResultPath;
import graphql.language.SourceLocation;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u00072\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lde/justsoftware/news/graphql/ErrorHandler;", "Lgraphql/execution/DataFetcherExceptionHandler;", "<init>", "()V", "defaultHandler", "Lcom/netflix/graphql/dgs/exceptions/DefaultDataFetcherExceptionHandler;", "handleException", "Ljava/util/concurrent/CompletableFuture;", "Lgraphql/execution/DataFetcherExceptionHandlerResult;", "handlerParameters", "Lgraphql/execution/DataFetcherExceptionHandlerParameters;", "Companion", "news-service"})
public class ErrorHandler
implements DataFetcherExceptionHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DefaultDataFetcherExceptionHandler defaultHandler = new DefaultDataFetcherExceptionHandler();
    @NotNull
    private static final Logger log;

    @Nullable
    public CompletableFuture<DataFetcherExceptionHandlerResult> handleException(@NotNull DataFetcherExceptionHandlerParameters handlerParameters) {
        Intrinsics.checkNotNullParameter((Object)handlerParameters, (String)"handlerParameters");
        Throwable exception = handlerParameters.getException();
        ResultPath path = handlerParameters.getPath();
        SourceLocation location = handlerParameters.getSourceLocation();
        log.error("Exception while executing data fetcher for " + handlerParameters.getPath() + ": " + exception.getMessage(), exception);
        Throwable throwable = exception;
        TypedGraphQLError customError = throwable instanceof IllegalArgumentException ? TypedGraphQLError.newBadRequestBuilder().path(path).location(location).message("Bad argument").build() : (throwable instanceof NotAuthorizedException ? TypedGraphQLError.newPermissionDeniedBuilder().path(path).location(location).message("Not authorized").build() : (throwable instanceof EmptyResultDataAccessException ? TypedGraphQLError.newNotFoundBuilder().path(path).location(location).message("No data found").build() : (throwable instanceof NewsException ? TypedGraphQLError.newBuilder().errorType(CustomErrorDetail.Companion.from((NewsException)exception).getErrorType()).path(path).location(location).message("Check error details").errorDetail((ErrorDetail)CustomErrorDetail.Companion.from((NewsException)exception)).build() : (throwable instanceof RuntimeException ? TypedGraphQLError.newInternalErrorBuilder().path(path).location(location).message("Internal server error").build() : null))));
        return customError == null ? CompletableFuture.completedFuture(this.defaultHandler.handleException(handlerParameters).get()) : CompletableFuture.completedFuture(DataFetcherExceptionHandlerResult.newResult().error((GraphQLError)customError).build());
    }

    static {
        Logger logger = LoggerFactory.getLogger(ErrorHandler.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        log = logger;
    }
}

