/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.domain.subscription.subscriber;

import de.justsoftware.news.domain.subscription.subscriber.SubscriberRepo;
import de.justsoftware.news.domain.user.Profile;
import de.justsoftware.news.id.ChannelId;
import de.justsoftware.news.id.ProfileId;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0017\u0018\u0000 \u001c2\u00020\u0001:\u0003\u001c\u001d\u001eB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J?\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016\u00a2\u0006\u0002\u0010\u0012J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\t2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0012\u0010\u0015\u001a\u00020\u00112\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0012J!\u0010\u0016\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016\u00a2\u0006\u0002\u0010\u0017R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\u0018\u001a\u00020\u0019X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lde/justsoftware/news/domain/subscription/subscriber/SubscriberRepo;", "", "jdbcTemplate", "Lorg/springframework/jdbc/core/namedparam/NamedParameterJdbcTemplate;", "<init>", "(Lorg/springframework/jdbc/core/namedparam/NamedParameterJdbcTemplate;)V", "getJdbcTemplate", "()Lorg/springframework/jdbc/core/namedparam/NamedParameterJdbcTemplate;", "getSubscribers", "", "Lde/justsoftware/news/domain/user/Profile;", "channelId", "Lde/justsoftware/news/id/ChannelId;", "limit", "", "offset", "query", "", "(Lde/justsoftware/news/id/ChannelId;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/String;)Ljava/util/List;", "getNotificationSubscribers", "Lde/justsoftware/news/id/ProfileId;", "getLikeQuery", "countSubscribersByChannel", "(Lde/justsoftware/news/id/ChannelId;Ljava/lang/String;)Ljava/lang/Integer;", "profileRowMapper", "Lde/justsoftware/news/domain/subscription/subscriber/SubscriberRepo$ProfileRowMapper;", "profileIdRowMapper", "Lde/justsoftware/news/domain/subscription/subscriber/SubscriberRepo$ProfileIdRowMapper;", "Companion", "ProfileRowMapper", "ProfileIdRowMapper", "news-service"})
@SourceDebugExtension(value={"SMAP\nSubscriberRepo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SubscriberRepo.kt\nde/justsoftware/news/domain/subscription/subscriber/SubscriberRepo\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,223:1\n1#2:224\n*E\n"})
public class SubscriberRepo {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final NamedParameterJdbcTemplate jdbcTemplate;
    @NotNull
    private final ProfileRowMapper profileRowMapper;
    @NotNull
    private final ProfileIdRowMapper profileIdRowMapper;
    @NotNull
    private static final String getNotificationSubscribersIds = "\n            -- subscribed personal_subscriptions\n            select ps.profile_id\n            from personal_subscription ps\n            where ps.channel_id = :channelId and ps.user_has_unsubscribed = false and ps.notifications_enabled = true\n            union\n\n            -- recommended managed_subscriptions (from profiles) who have not unsubscribed\n            select ms.user_id\n            from managed_subscription ms\n            where ms.channel_id = :channelId and ms.type = 'RECOMMENDED' and ms.user_id like 'PROFILE,%'\n            and not exists (\n            select ps.profile_id\n            from personal_subscription ps\n            where ps.channel_id = :channelId and (ps.user_has_unsubscribed = true OR ps.notifications_enabled = false) and ps.profile_id=ms.user_id)\n            union\n\n            -- recommended managed_subscriptions (from groups) who have not unsubscribed\n            select ugm.profile_id\n            from user_group_member ugm\n            where ugm.user_group_id in (\n                select ms.user_id\n                from managed_subscription ms\n                where ms.channel_id = :channelId and ms.type = 'RECOMMENDED' and ms.user_id like 'USER_GROUP,%'\n            )\n            and not exists (\n            select ps.profile_id\n            from personal_subscription ps\n            where ps.channel_id = :channelId and (ps.user_has_unsubscribed = true OR ps.notifications_enabled = false) and ps.profile_id=ugm.profile_id)\n            union\n\n            -- mandatory managed_subscriptions (from profiles)\n            select ms.user_id\n            from managed_subscription ms\n            where ms.channel_id = :channelId and ms.type = 'MANDATORY' and ms.user_id like 'PROFILE,%'\n            union\n\n            -- mandatory managed_subscriptions (from groups)\n            select ugm.profile_id\n            from user_group_member ugm\n            where ugm.user_group_id in (\n                select ms.user_id\n                from managed_subscription ms\n                where ms.channel_id = :channelId and ms.type = 'MANDATORY' and ms.user_id like 'USER_GROUP,%'\n            )\n        ";
    @NotNull
    private static final String getSubscriberIdsSql = "\n            -- subscribed personal_subscriptions\n            select ps.profile_id\n            from personal_subscription ps\n            where ps.channel_id = :channelId and ps.user_has_unsubscribed = false\n            union\n\n            -- recommended managed_subscriptions (from profiles) who have not unsubscribed\n            select ms.user_id\n            from managed_subscription ms\n            where ms.channel_id = :channelId and ms.type = 'RECOMMENDED' and ms.user_id like 'PROFILE,%'\n            and not exists (\n            select ps.profile_id\n            from personal_subscription ps\n            where ps.channel_id = :channelId and ps.user_has_unsubscribed = true and ps.profile_id=ms.user_id)\n            union\n\n            -- recommended managed_subscriptions (from groups) who have not unsubscribed\n            select ugm.profile_id\n            from user_group_member ugm\n            where ugm.user_group_id in (\n                select ms.user_id\n                from managed_subscription ms\n                where ms.channel_id = :channelId and ms.type = 'RECOMMENDED' and ms.user_id like 'USER_GROUP,%'\n            )\n            and not exists (\n            select ps.profile_id\n            from personal_subscription ps\n            where ps.channel_id = :channelId and ps.user_has_unsubscribed = true and ps.profile_id=ugm.profile_id)\n            union\n\n            -- mandatory managed_subscriptions (from profiles)\n            select ms.user_id\n            from managed_subscription ms\n            where ms.channel_id = :channelId and ms.type = 'MANDATORY' and ms.user_id like 'PROFILE,%'\n            union\n\n            -- mandatory managed_subscriptions (from groups)\n            select ugm.profile_id\n            from user_group_member ugm\n            where ugm.user_group_id in (\n                select ms.user_id\n                from managed_subscription ms\n                where ms.channel_id = :channelId and ms.type = 'MANDATORY' and ms.user_id like 'USER_GROUP,%'\n            )\n        ";
    @NotNull
    private static final String getSubscriberProfilesSql = "\n            select * from profile p where p.status ='ACTIVE' and p.id in (\n                \n            -- subscribed personal_subscriptions\n            select ps.profile_id\n            from personal_subscription ps\n            where ps.channel_id = :channelId and ps.user_has_unsubscribed = false\n            union\n\n            -- recommended managed_subscriptions (from profiles) who have not unsubscribed\n            select ms.user_id\n            from managed_subscription ms\n            where ms.channel_id = :channelId and ms.type = 'RECOMMENDED' and ms.user_id like 'PROFILE,%'\n            and not exists (\n            select ps.profile_id\n            from personal_subscription ps\n            where ps.channel_id = :channelId and ps.user_has_unsubscribed = true and ps.profile_id=ms.user_id)\n            union\n\n            -- recommended managed_subscriptions (from groups) who have not unsubscribed\n            select ugm.profile_id\n            from user_group_member ugm\n            where ugm.user_group_id in (\n                select ms.user_id\n                from managed_subscription ms\n                where ms.channel_id = :channelId and ms.type = 'RECOMMENDED' and ms.user_id like 'USER_GROUP,%'\n            )\n            and not exists (\n            select ps.profile_id\n            from personal_subscription ps\n            where ps.channel_id = :channelId and ps.user_has_unsubscribed = true and ps.profile_id=ugm.profile_id)\n            union\n\n            -- mandatory managed_subscriptions (from profiles)\n            select ms.user_id\n            from managed_subscription ms\n            where ms.channel_id = :channelId and ms.type = 'MANDATORY' and ms.user_id like 'PROFILE,%'\n            union\n\n            -- mandatory managed_subscriptions (from groups)\n            select ugm.profile_id\n            from user_group_member ugm\n            where ugm.user_group_id in (\n                select ms.user_id\n                from managed_subscription ms\n                where ms.channel_id = :channelId and ms.type = 'MANDATORY' and ms.user_id like 'USER_GROUP,%'\n            )\n        \n            )\n            ";
    @NotNull
    private static final String getNotificationSubscribersStatement = "\n            select p.id from profile p where p.status ='ACTIVE' and p.id in (\n                \n            -- subscribed personal_subscriptions\n            select ps.profile_id\n            from personal_subscription ps\n            where ps.channel_id = :channelId and ps.user_has_unsubscribed = false and ps.notifications_enabled = true\n            union\n\n            -- recommended managed_subscriptions (from profiles) who have not unsubscribed\n            select ms.user_id\n            from managed_subscription ms\n            where ms.channel_id = :channelId and ms.type = 'RECOMMENDED' and ms.user_id like 'PROFILE,%'\n            and not exists (\n            select ps.profile_id\n            from personal_subscription ps\n            where ps.channel_id = :channelId and (ps.user_has_unsubscribed = true OR ps.notifications_enabled = false) and ps.profile_id=ms.user_id)\n            union\n\n            -- recommended managed_subscriptions (from groups) who have not unsubscribed\n            select ugm.profile_id\n            from user_group_member ugm\n            where ugm.user_group_id in (\n                select ms.user_id\n                from managed_subscription ms\n                where ms.channel_id = :channelId and ms.type = 'RECOMMENDED' and ms.user_id like 'USER_GROUP,%'\n            )\n            and not exists (\n            select ps.profile_id\n            from personal_subscription ps\n            where ps.channel_id = :channelId and (ps.user_has_unsubscribed = true OR ps.notifications_enabled = false) and ps.profile_id=ugm.profile_id)\n            union\n\n            -- mandatory managed_subscriptions (from profiles)\n            select ms.user_id\n            from managed_subscription ms\n            where ms.channel_id = :channelId and ms.type = 'MANDATORY' and ms.user_id like 'PROFILE,%'\n            union\n\n            -- mandatory managed_subscriptions (from groups)\n            select ugm.profile_id\n            from user_group_member ugm\n            where ugm.user_group_id in (\n                select ms.user_id\n                from managed_subscription ms\n                where ms.channel_id = :channelId and ms.type = 'MANDATORY' and ms.user_id like 'USER_GROUP,%'\n            )\n        \n            )\n            ";

    public SubscriberRepo(@NotNull NamedParameterJdbcTemplate jdbcTemplate) {
        Intrinsics.checkNotNullParameter((Object)jdbcTemplate, (String)"jdbcTemplate");
        this.jdbcTemplate = jdbcTemplate;
        this.profileRowMapper = new ProfileRowMapper();
        this.profileIdRowMapper = new ProfileIdRowMapper();
    }

    @NotNull
    public NamedParameterJdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    @NotNull
    public List<Profile> getSubscribers(@NotNull ChannelId channelId, @Nullable Integer limit, @Nullable Integer offset, @Nullable String query) {
        String string;
        int it;
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        StringBuilder $this$getSubscribers_u24lambda_u242 = stringBuilder = new StringBuilder();
        boolean bl = false;
        Integer n = limit;
        if (n != null) {
            it = ((Number)n).intValue();
            boolean bl2 = false;
            $this$getSubscribers_u24lambda_u242.append("LIMIT :limit ");
        }
        Integer n2 = offset;
        if (n2 != null) {
            it = ((Number)n2).intValue();
            boolean bl3 = false;
            $this$getSubscribers_u24lambda_u242.append("OFFSET :offset ");
        }
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        String limitString = ((Object)StringsKt.trimEnd((CharSequence)string2)).toString();
        String likeQuery = this.getLikeQuery(query);
        String orderByString = "ORDER by p.last_name ASC";
        String finalStatement = "\n            select * from profile p where p.status ='ACTIVE' and p.id in (\n                \n            -- subscribed personal_subscriptions\n            select ps.profile_id\n            from personal_subscription ps\n            where ps.channel_id = :channelId and ps.user_has_unsubscribed = false\n            union\n\n            -- recommended managed_subscriptions (from profiles) who have not unsubscribed\n            select ms.user_id\n            from managed_subscription ms\n            where ms.channel_id = :channelId and ms.type = 'RECOMMENDED' and ms.user_id like 'PROFILE,%'\n            and not exists (\n            select ps.profile_id\n            from personal_subscription ps\n            where ps.channel_id = :channelId and ps.user_has_unsubscribed = true and ps.profile_id=ms.user_id)\n            union\n\n            -- recommended managed_subscriptions (from groups) who have not unsubscribed\n            select ugm.profile_id\n            from user_group_member ugm\n            where ugm.user_group_id in (\n                select ms.user_id\n                from managed_subscription ms\n                where ms.channel_id = :channelId and ms.type = 'RECOMMENDED' and ms.user_id like 'USER_GROUP,%'\n            )\n            and not exists (\n            select ps.profile_id\n            from personal_subscription ps\n            where ps.channel_id = :channelId and ps.user_has_unsubscribed = true and ps.profile_id=ugm.profile_id)\n            union\n\n            -- mandatory managed_subscriptions (from profiles)\n            select ms.user_id\n            from managed_subscription ms\n            where ms.channel_id = :channelId and ms.type = 'MANDATORY' and ms.user_id like 'PROFILE,%'\n            union\n\n            -- mandatory managed_subscriptions (from groups)\n            select ugm.profile_id\n            from user_group_member ugm\n            where ugm.user_group_id in (\n                select ms.user_id\n                from managed_subscription ms\n                where ms.channel_id = :channelId and ms.type = 'MANDATORY' and ms.user_id like 'USER_GROUP,%'\n            )\n        \n            )\n             " + likeQuery + " " + orderByString + " " + limitString;
        Pair[] pairArray = new Pair[4];
        pairArray[0] = TuplesKt.to((Object)"channelId", (Object)channelId.toTypedString());
        String string3 = query;
        if (string3 != null) {
            String string4 = string3.toUpperCase(Locale.ROOT);
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toUpperCase(...)");
        } else {
            string = null;
        }
        pairArray[1] = TuplesKt.to((Object)"query", (Object)("%" + string + "%"));
        pairArray[2] = TuplesKt.to((Object)"limit", (Object)limit);
        pairArray[3] = TuplesKt.to((Object)"offset", (Object)offset);
        Map paramsMap = MapsKt.mapOf((Pair[])pairArray);
        List list = this.getJdbcTemplate().query(finalStatement, paramsMap, (RowMapper)this.profileRowMapper);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"query(...)");
        return list;
    }

    public static /* synthetic */ List getSubscribers$default(SubscriberRepo subscriberRepo, ChannelId channelId, Integer n, Integer n2, String string, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getSubscribers");
        }
        if ((n3 & 2) != 0) {
            n = null;
        }
        if ((n3 & 4) != 0) {
            n2 = null;
        }
        if ((n3 & 8) != 0) {
            string = null;
        }
        return subscriberRepo.getSubscribers(channelId, n, n2, string);
    }

    @NotNull
    public List<ProfileId> getNotificationSubscribers(@NotNull ChannelId channelId) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        List list = this.getJdbcTemplate().query(getNotificationSubscribersStatement, MapsKt.mapOf((Pair)TuplesKt.to((Object)"channelId", (Object)channelId.toTypedString())), (RowMapper)this.profileIdRowMapper);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"query(...)");
        return list;
    }

    private String getLikeQuery(String query) {
        CharSequence charSequence = query;
        return !(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) ? "            AND (UPPER(p.last_name) LIKE :query\n            OR UPPER(p.first_name) LIKE :query\n            OR UPPER(p.prefix) LIKE :query\n            OR UPPER(p.suffix) LIKE :query)" : " ";
    }

    @Nullable
    public Integer countSubscribersByChannel(@NotNull ChannelId channelId, @Nullable String query) {
        String string;
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        String likeQuery = this.getLikeQuery(query);
        String statement = StringsKt.trimIndent((String)("\n            SELECT count(1) FROM profile p WHERE p.status ='ACTIVE' and p.id IN (\n                \n            -- subscribed personal_subscriptions\n            select ps.profile_id\n            from personal_subscription ps\n            where ps.channel_id = :channelId and ps.user_has_unsubscribed = false\n            union\n\n            -- recommended managed_subscriptions (from profiles) who have not unsubscribed\n            select ms.user_id\n            from managed_subscription ms\n            where ms.channel_id = :channelId and ms.type = 'RECOMMENDED' and ms.user_id like 'PROFILE,%'\n            and not exists (\n            select ps.profile_id\n            from personal_subscription ps\n            where ps.channel_id = :channelId and ps.user_has_unsubscribed = true and ps.profile_id=ms.user_id)\n            union\n\n            -- recommended managed_subscriptions (from groups) who have not unsubscribed\n            select ugm.profile_id\n            from user_group_member ugm\n            where ugm.user_group_id in (\n                select ms.user_id\n                from managed_subscription ms\n                where ms.channel_id = :channelId and ms.type = 'RECOMMENDED' and ms.user_id like 'USER_GROUP,%'\n            )\n            and not exists (\n            select ps.profile_id\n            from personal_subscription ps\n            where ps.channel_id = :channelId and ps.user_has_unsubscribed = true and ps.profile_id=ugm.profile_id)\n            union\n\n            -- mandatory managed_subscriptions (from profiles)\n            select ms.user_id\n            from managed_subscription ms\n            where ms.channel_id = :channelId and ms.type = 'MANDATORY' and ms.user_id like 'PROFILE,%'\n            union\n\n            -- mandatory managed_subscriptions (from groups)\n            select ugm.profile_id\n            from user_group_member ugm\n            where ugm.user_group_id in (\n                select ms.user_id\n                from managed_subscription ms\n                where ms.channel_id = :channelId and ms.type = 'MANDATORY' and ms.user_id like 'USER_GROUP,%'\n            )\n        \n            ) " + likeQuery + "\n        "));
        Pair[] pairArray = new Pair[2];
        pairArray[0] = TuplesKt.to((Object)"channelId", (Object)channelId.toTypedString());
        String string2 = query;
        if (string2 != null) {
            String string3 = string2.toUpperCase(Locale.ROOT);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toUpperCase(...)");
        } else {
            string = null;
        }
        pairArray[1] = TuplesKt.to((Object)"query", (Object)(string + "%"));
        Map paramsMap = MapsKt.mapOf((Pair[])pairArray);
        return (Integer)this.getJdbcTemplate().queryForObject(statement, paramsMap, Integer.TYPE);
    }
}

