/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.domain.post;

import de.justsoftware.news.auth.AuthorizationContext;
import de.justsoftware.news.connector.drive.DriveApiConnector;
import de.justsoftware.news.connector.drive.DriveDocument;
import de.justsoftware.news.connector.drive.DriveKafkaProducer;
import de.justsoftware.news.connector.permission.PermissionKafkaProducer;
import de.justsoftware.news.domain.attachment.Attachment;
import de.justsoftware.news.domain.attachment.AttachmentInput;
import de.justsoftware.news.domain.attachment.AttachmentRepo;
import de.justsoftware.news.domain.attachment.AttachmentsInput;
import de.justsoftware.news.domain.channel.Channel;
import de.justsoftware.news.domain.channel.ChannelAction;
import de.justsoftware.news.domain.channel.ChannelRepo;
import de.justsoftware.news.domain.channel.permission.PermissionRole;
import de.justsoftware.news.domain.event.Event;
import de.justsoftware.news.domain.event.EventRepo;
import de.justsoftware.news.domain.poll.Poll;
import de.justsoftware.news.domain.poll.PollAnswer;
import de.justsoftware.news.domain.poll.PollAnswerRepo;
import de.justsoftware.news.domain.poll.PollRepo;
import de.justsoftware.news.domain.post.Post;
import de.justsoftware.news.domain.post.PostRepo;
import de.justsoftware.news.domain.post.PostService;
import de.justsoftware.news.domain.post.PostService$findAllByIds$;
import de.justsoftware.news.domain.post.error.PostAlreadyPinnedUnpinnedException;
import de.justsoftware.news.domain.post.error.PostAlreadyUpdatedException;
import de.justsoftware.news.domain.post.model.PostAction;
import de.justsoftware.news.domain.subscription.SubscriptionRepoWrapper;
import de.justsoftware.news.events.PostCreatedEvent;
import de.justsoftware.news.events.PostPublishedEvent;
import de.justsoftware.news.events.PostUpdatedEvent;
import de.justsoftware.news.events.PostUpdatedMentions;
import de.justsoftware.news.id.ChannelId;
import de.justsoftware.news.id.DocumentId;
import de.justsoftware.news.id.DriveFileReferenceId;
import de.justsoftware.news.id.ItemId;
import de.justsoftware.news.id.PostId;
import de.justsoftware.news.id.ProfileId;
import de.justsoftware.news.id.UserId;
import de.justsoftware.news.kafka.KafkaPublishOperation;
import de.justsoftware.news.util.DateUtilsKt;
import de.justsoftware.news.util.PaginationSupportKt;
import de.justsoftware.news.util.QuillUtils;
import de.justsoftware.news.util.TransactionSupport;
import de.justsoftware.news.util.Unauthorized;
import io.micrometer.observation.annotation.Observed;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@Observed
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00d0\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\u000f\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\b\u0017\u0018\u00002\u00020\u0001Bg\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u0012\u0006\u0010\u0016\u001a\u00020\u0017\u0012\u0006\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u00b5\u0001\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020!2\u0006\u0010#\u001a\u00020!2\b\b\u0002\u0010$\u001a\u00020%2\n\b\u0002\u0010&\u001a\u0004\u0018\u00010'2\n\b\u0002\u0010(\u001a\u0004\u0018\u00010)2\b\u0010*\u001a\u0004\u0018\u00010+2\n\b\u0002\u0010,\u001a\u0004\u0018\u00010-2\u0010\b\u0002\u0010.\u001a\n\u0012\u0004\u0012\u000200\u0018\u00010/2\n\b\u0002\u00101\u001a\u0004\u0018\u00010+2\b\u00102\u001a\u0004\u0018\u00010+2\n\b\u0002\u00103\u001a\u0004\u0018\u0001042\b\b\u0002\u00105\u001a\u0002042\b\b\u0002\u00106\u001a\u00020+2\u0006\u00107\u001a\u000208H\u0017\u00a2\u0006\u0002\u00109J\u00df\u0001\u0010:\u001a\u00020\u001d2\u0006\u0010$\u001a\u00020%2\u0006\u0010;\u001a\u00020+2\n\b\u0002\u0010 \u001a\u0004\u0018\u00010!2\n\b\u0002\u0010\"\u001a\u0004\u0018\u00010!2\n\b\u0002\u0010#\u001a\u0004\u0018\u00010!2\n\b\u0002\u0010&\u001a\u0004\u0018\u00010'2\n\b\u0002\u0010(\u001a\u0004\u0018\u00010)2\n\b\u0002\u0010<\u001a\u0004\u0018\u0001042\n\b\u0002\u0010*\u001a\u0004\u0018\u00010+2\n\b\u0002\u0010,\u001a\u0004\u0018\u00010-2\u0010\b\u0002\u0010.\u001a\n\u0012\u0004\u0012\u000200\u0018\u00010/2\n\b\u0002\u0010=\u001a\u0004\u0018\u0001042\n\b\u0002\u00101\u001a\u0004\u0018\u00010+2\n\b\u0002\u0010>\u001a\u0004\u0018\u0001042\n\b\u0002\u00102\u001a\u0004\u0018\u00010+2\n\b\u0002\u0010?\u001a\u0004\u0018\u0001042\n\b\u0002\u00103\u001a\u0004\u0018\u0001042\u0006\u00107\u001a\u000208H\u0017\u00a2\u0006\u0002\u0010@J>\u0010A\u001a\b\u0012\u0004\u0012\u00020\u001d0/2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020C2\u0006\u0010E\u001a\u0002042\u0006\u0010F\u001a\u0002042\u0006\u00107\u001a\u000208H\u0016J.\u0010G\u001a\b\u0012\u0004\u0012\u00020\u001d0/2\u0006\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020C2\u0006\u0010F\u001a\u0002042\u0006\u00107\u001a\u000208H\u0016J&\u0010H\u001a\b\u0012\u0004\u0012\u00020\u001d0/2\u0006\u00107\u001a\u0002082\u0006\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020CH\u0016J\u001c\u0010I\u001a\b\u0012\u0004\u0012\u00020\u001d0/2\f\u0010J\u001a\b\u0012\u0004\u0012\u00020%0/H\u0017J\u0018\u0010K\u001a\u00020\u001d2\u0006\u0010L\u001a\u00020%2\u0006\u00107\u001a\u000208H\u0016J\u001a\u0010M\u001a\u0004\u0018\u00010\u001d2\u0006\u0010L\u001a\u00020%2\u0006\u00107\u001a\u000208H\u0016J\u0012\u0010N\u001a\u0004\u0018\u00010\u001d2\u0006\u0010L\u001a\u00020%H\u0017J*\u0010O\u001a\b\u0012\u0004\u0012\u00020\u001d0/2\u0006\u00107\u001a\u0002082\b\b\u0002\u0010P\u001a\u0002042\b\b\u0002\u0010D\u001a\u00020CH\u0016J8\u0010Q\u001a\b\u0012\u0004\u0012\u00020\u001d0/2\f\u0010R\u001a\b\u0012\u0004\u0012\u00020\u001f0S2\u0006\u00107\u001a\u0002082\b\b\u0002\u0010P\u001a\u0002042\b\b\u0002\u0010D\u001a\u00020CH\u0016J0\u0010T\u001a\b\u0012\u0004\u0012\u00020\u001d0/2\f\u0010R\u001a\b\u0012\u0004\u0012\u00020\u001f0S2\b\b\u0002\u0010P\u001a\u0002042\b\b\u0002\u0010D\u001a\u00020CH\u0012J\u000e\u0010U\u001a\b\u0012\u0004\u0012\u00020\u001d0/H\u0017J\b\u0010V\u001a\u00020WH\u0017J&\u0010X\u001a\u00020W2\u0006\u0010,\u001a\u00020-2\f\u0010.\u001a\b\u0012\u0004\u0012\u0002000/2\u0006\u0010$\u001a\u00020%H\u0012J6\u0010Y\u001a \u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020[\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001d0\\0Z2\u0006\u0010E\u001a\u0002042\u0006\u0010F\u001a\u000204H\u0012J4\u0010]\u001a&\u0012\u0004\u0012\u00020\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001f0S\u0012\u0004\u0012\u00020[\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001d0\\0Z2\u0006\u0010F\u001a\u000204H\u0012J\u0016\u0010^\u001a\b\u0012\u0004\u0012\u00020\u001f0_2\u0006\u00107\u001a\u000208H\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006`"}, d2={"Lde/justsoftware/news/domain/post/PostService;", "", "attachmentRepo", "Lde/justsoftware/news/domain/attachment/AttachmentRepo;", "channelRepo", "Lde/justsoftware/news/domain/channel/ChannelRepo;", "driveKafkaProducer", "Lde/justsoftware/news/connector/drive/DriveKafkaProducer;", "eventRepo", "Lde/justsoftware/news/domain/event/EventRepo;", "pollRepo", "Lde/justsoftware/news/domain/poll/PollRepo;", "pollAnswerRepo", "Lde/justsoftware/news/domain/poll/PollAnswerRepo;", "driveApiConnector", "Lde/justsoftware/news/connector/drive/DriveApiConnector;", "postRepo", "Lde/justsoftware/news/domain/post/PostRepo;", "permissionKafkaProducer", "Lde/justsoftware/news/connector/permission/PermissionKafkaProducer;", "subscriptionRepoWrapper", "Lde/justsoftware/news/domain/subscription/SubscriptionRepoWrapper;", "transactionSupport", "Lde/justsoftware/news/util/TransactionSupport;", "eventPublisher", "Lorg/springframework/context/ApplicationEventPublisher;", "<init>", "(Lde/justsoftware/news/domain/attachment/AttachmentRepo;Lde/justsoftware/news/domain/channel/ChannelRepo;Lde/justsoftware/news/connector/drive/DriveKafkaProducer;Lde/justsoftware/news/domain/event/EventRepo;Lde/justsoftware/news/domain/poll/PollRepo;Lde/justsoftware/news/domain/poll/PollAnswerRepo;Lde/justsoftware/news/connector/drive/DriveApiConnector;Lde/justsoftware/news/domain/post/PostRepo;Lde/justsoftware/news/connector/permission/PermissionKafkaProducer;Lde/justsoftware/news/domain/subscription/SubscriptionRepoWrapper;Lde/justsoftware/news/util/TransactionSupport;Lorg/springframework/context/ApplicationEventPublisher;)V", "create", "Lde/justsoftware/news/domain/post/Post;", "channelId", "Lde/justsoftware/news/id/ChannelId;", "title", "", "text", "jsonContent", "postId", "Lde/justsoftware/news/id/PostId;", "attachments", "Lde/justsoftware/news/domain/attachment/AttachmentsInput;", "event", "Lde/justsoftware/news/domain/event/Event;", "pinExpiration", "Ljava/time/Instant;", "poll", "Lde/justsoftware/news/domain/poll/Poll;", "pollAnswers", "", "Lde/justsoftware/news/domain/poll/PollAnswer;", "publishDate", "deleteDate", "commentsDisabled", "", "createNotifications", "createDate", "authContext", "Lde/justsoftware/news/auth/AuthorizationContext;", "(Lde/justsoftware/news/id/ChannelId;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lde/justsoftware/news/id/PostId;Lde/justsoftware/news/domain/attachment/AttachmentsInput;Lde/justsoftware/news/domain/event/Event;Ljava/time/Instant;Lde/justsoftware/news/domain/poll/Poll;Ljava/util/List;Ljava/time/Instant;Ljava/time/Instant;Ljava/lang/Boolean;ZLjava/time/Instant;Lde/justsoftware/news/auth/AuthorizationContext;)Lde/justsoftware/news/domain/post/Post;", "update", "lastKnownModifyDate", "pin", "deletePoll", "published", "removeDeleteDate", "(Lde/justsoftware/news/id/PostId;Ljava/time/Instant;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lde/justsoftware/news/domain/attachment/AttachmentsInput;Lde/justsoftware/news/domain/event/Event;Ljava/lang/Boolean;Ljava/time/Instant;Lde/justsoftware/news/domain/poll/Poll;Ljava/util/List;Ljava/lang/Boolean;Ljava/time/Instant;Ljava/lang/Boolean;Ljava/time/Instant;Ljava/lang/Boolean;Ljava/lang/Boolean;Lde/justsoftware/news/auth/AuthorizationContext;)Lde/justsoftware/news/domain/post/Post;", "getChannelPosts", "offset", "", "limit", "scheduled", "pinned", "getFeed", "getEvents", "findAllByIds", "postIds", "getById", "id", "findById", "findByIdDeleted", "latest", "pinnedOnly", "byChannelIds", "channelIds", "", "getByChannelIds", "publishScheduledPosts", "unpinPostsAfterPinExpiration", "", "insertPoll", "getMatchingChannelQuery", "Lkotlin/Function3;", "Lorg/springframework/data/domain/Pageable;", "Lorg/springframework/data/domain/Page;", "getMatchingFeedQuery", "getSubscribedChannels", "", "news-service"})
@SourceDebugExtension(value={"SMAP\nPostService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PostService.kt\nde/justsoftware/news/domain/post/PostService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,522:1\n1#2:523\n1557#3:524\n1628#3,3:525\n1872#3,3:528\n1557#3:531\n1628#3,3:532\n1557#3:535\n1628#3,3:536\n774#3:539\n865#3,2:540\n1863#3,2:542\n774#3:544\n865#3,2:545\n1863#3,2:547\n774#3:549\n865#3,2:550\n1863#3,2:552\n1872#3,3:554\n1557#3:557\n1628#3,3:558\n1557#3:561\n1628#3,3:562\n1053#3:565\n1557#3:566\n1628#3,3:567\n1557#3:570\n1628#3,3:571\n1557#3:574\n1628#3,3:575\n774#3:578\n865#3,2:579\n1557#3:581\n1628#3,3:582\n1863#3,2:585\n*S KotlinDebug\n*F\n+ 1 PostService.kt\nde/justsoftware/news/domain/post/PostService\n*L\n124#1:524\n124#1:525,3\n128#1:528,3\n259#1:531\n259#1:532,3\n262#1:535\n262#1:536,3\n265#1:539\n265#1:540,2\n266#1:542,2\n270#1:544\n270#1:545,2\n272#1:547,2\n287#1:549\n287#1:550,2\n288#1:552,2\n294#1:554,3\n355#1:557\n355#1:558,3\n375#1:561\n375#1:562,3\n384#1:565\n441#1:566\n441#1:567,3\n462#1:570\n462#1:571,3\n475#1:574\n475#1:575,3\n516#1:578\n516#1:579,2\n518#1:581\n518#1:582,3\n446#1:585,2\n*E\n"})
public class PostService {
    @NotNull
    private final AttachmentRepo attachmentRepo;
    @NotNull
    private final ChannelRepo channelRepo;
    @NotNull
    private final DriveKafkaProducer driveKafkaProducer;
    @NotNull
    private final EventRepo eventRepo;
    @NotNull
    private final PollRepo pollRepo;
    @NotNull
    private final PollAnswerRepo pollAnswerRepo;
    @NotNull
    private final DriveApiConnector driveApiConnector;
    @NotNull
    private final PostRepo postRepo;
    @NotNull
    private final PermissionKafkaProducer permissionKafkaProducer;
    @NotNull
    private final SubscriptionRepoWrapper subscriptionRepoWrapper;
    @NotNull
    private final TransactionSupport transactionSupport;
    @NotNull
    private final ApplicationEventPublisher eventPublisher;

    public PostService(@NotNull AttachmentRepo attachmentRepo, @NotNull ChannelRepo channelRepo, @NotNull DriveKafkaProducer driveKafkaProducer, @NotNull EventRepo eventRepo, @NotNull PollRepo pollRepo, @NotNull PollAnswerRepo pollAnswerRepo, @NotNull DriveApiConnector driveApiConnector, @NotNull PostRepo postRepo, @NotNull PermissionKafkaProducer permissionKafkaProducer, @NotNull SubscriptionRepoWrapper subscriptionRepoWrapper, @NotNull TransactionSupport transactionSupport, @NotNull ApplicationEventPublisher eventPublisher) {
        Intrinsics.checkNotNullParameter((Object)attachmentRepo, (String)"attachmentRepo");
        Intrinsics.checkNotNullParameter((Object)channelRepo, (String)"channelRepo");
        Intrinsics.checkNotNullParameter((Object)driveKafkaProducer, (String)"driveKafkaProducer");
        Intrinsics.checkNotNullParameter((Object)eventRepo, (String)"eventRepo");
        Intrinsics.checkNotNullParameter((Object)pollRepo, (String)"pollRepo");
        Intrinsics.checkNotNullParameter((Object)pollAnswerRepo, (String)"pollAnswerRepo");
        Intrinsics.checkNotNullParameter((Object)driveApiConnector, (String)"driveApiConnector");
        Intrinsics.checkNotNullParameter((Object)postRepo, (String)"postRepo");
        Intrinsics.checkNotNullParameter((Object)permissionKafkaProducer, (String)"permissionKafkaProducer");
        Intrinsics.checkNotNullParameter((Object)subscriptionRepoWrapper, (String)"subscriptionRepoWrapper");
        Intrinsics.checkNotNullParameter((Object)transactionSupport, (String)"transactionSupport");
        Intrinsics.checkNotNullParameter((Object)eventPublisher, (String)"eventPublisher");
        this.attachmentRepo = attachmentRepo;
        this.channelRepo = channelRepo;
        this.driveKafkaProducer = driveKafkaProducer;
        this.eventRepo = eventRepo;
        this.pollRepo = pollRepo;
        this.pollAnswerRepo = pollAnswerRepo;
        this.driveApiConnector = driveApiConnector;
        this.postRepo = postRepo;
        this.permissionKafkaProducer = permissionKafkaProducer;
        this.subscriptionRepoWrapper = subscriptionRepoWrapper;
        this.transactionSupport = transactionSupport;
        this.eventPublisher = eventPublisher;
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    @NotNull
    public Post create(@NotNull ChannelId channelId, @NotNull String title, @NotNull String text, @NotNull String jsonContent, @NotNull PostId postId, @Nullable AttachmentsInput attachments, @Nullable Event event, @Nullable Instant pinExpiration, @Nullable Poll poll, @Nullable List<PollAnswer> pollAnswers, @Nullable Instant publishDate, @Nullable Instant deleteDate, @Nullable Boolean commentsDisabled, boolean createNotifications, @NotNull Instant createDate, @NotNull AuthorizationContext authContext) {
        Collection $i$a$-require-PostService$create$622;
        Event it;
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)jsonContent, (String)"jsonContent");
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        Intrinsics.checkNotNullParameter((Object)createDate, (String)"createDate");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        authContext.checkChannelAction(channelId, ChannelAction.CREATE_POST);
        Instant now = Instant.now();
        if (publishDate != null && !publishDate.isAfter(now)) {
            boolean $i$a$-require-PostService$create$42 = false;
            String $i$a$-require-PostService$create$42 = "If provided, 'publishDate' must be a date in the future.";
            throw new IllegalArgumentException($i$a$-require-PostService$create$42.toString());
        }
        if (pinExpiration != null && !pinExpiration.isAfter(now)) {
            boolean $i$a$-require-PostService$create$52 = false;
            String $i$a$-require-PostService$create$52 = "If provided, 'pinExpiration' must be a date in the future.";
            throw new IllegalArgumentException($i$a$-require-PostService$create$52.toString());
        }
        if (pinExpiration != null && publishDate != null && !(pinExpiration.compareTo(publishDate) >= 0)) {
            boolean $i$a$-require-PostService$create$622 = false;
            String $i$a$-require-PostService$create$622 = "If provided, 'pinExpiration' must be set after publication date.";
            throw new IllegalArgumentException($i$a$-require-PostService$create$622.toString());
        }
        boolean isScheduled = publishDate != null && publishDate.isAfter(now);
        AttachmentsInput attachmentsInput = attachments;
        Boolean bl = commentsDisabled;
        PostRepo.insert$default((PostRepo)this.postRepo, (PostId)postId, (ProfileId)authContext.getUser(), (ChannelId)channelId, (Instant)createDate, (Instant)createDate, (String)title, (String)text, (String)jsonContent, (DocumentId)(attachmentsInput != null ? attachmentsInput.getCoverElementId() : null), (Instant)pinExpiration, (Instant)(pinExpiration != null ? now : null), (Instant)(publishDate != null && isScheduled ? publishDate : createDate), (!isScheduled ? 1 : 0) != 0, (boolean)false, (Instant)deleteDate, (boolean)(bl != null ? bl : false), (int)8192, null);
        Event event2 = event;
        if (event2 != null) {
            it = event2;
            boolean bl2 = false;
            this.eventRepo.insert(it.getId(), it.getPostId(), it.getStartDate(), it.getEndDate());
        }
        AttachmentsInput attachmentsInput2 = attachments;
        if (attachmentsInput2 != null) {
            void $this$forEachIndexed$iv;
            void $this$mapTo$iv$iv;
            it = attachmentsInput2;
            boolean bl3 = false;
            Iterable $this$map$iv = attachments.getValues();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                AttachmentInput attachmentInput = (AttachmentInput)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl4 = false;
                collection.add(it2.getId());
            }
            List documentIds = (List)destination$iv$iv;
            $this$map$iv = this.driveApiConnector.addFiles(documentIds, (DriveFileReferenceId)postId, authContext.getUser());
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                Object v4;
                AttachmentRepo attachmentRepo;
                DocumentId documentId;
                DriveFileReferenceId driveFileReferenceId;
                String string;
                String string2;
                int n;
                int n2;
                block10: {
                    void attachment;
                    int n3;
                    Object item$iv$iv;
                    if ((n3 = index$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    item$iv$iv = (DriveDocument)item$iv;
                    int index = n3;
                    boolean bl5 = false;
                    Iterable iterable2 = attachments.getValues();
                    n2 = index;
                    n = attachment.getSize();
                    string2 = attachment.getName();
                    string = attachment.getMimeType();
                    driveFileReferenceId = (DriveFileReferenceId)postId;
                    documentId = attachment.getDocumentId();
                    attachmentRepo = this.attachmentRepo;
                    Iterable iterable3 = iterable2;
                    for (Object t : iterable3) {
                        AttachmentInput it3 = (AttachmentInput)t;
                        boolean bl6 = false;
                        if (!Intrinsics.areEqual((Object)it3.getId(), (Object)attachment.getDocumentId())) continue;
                        v4 = t;
                        break block10;
                    }
                    v4 = null;
                }
                Object var46_56 = v4;
                AttachmentInput attachmentInput = var46_56;
                attachmentRepo.insert(documentId, driveFileReferenceId, string, string2, n, n2, attachmentInput != null ? attachmentInput.getAltText() : null);
            }
        }
        if (poll != null && !(($i$a$-require-PostService$create$622 = (Collection)pollAnswers) == null || $i$a$-require-PostService$create$622.isEmpty())) {
            this.insertPoll(poll, pollAnswers, postId);
        }
        Post post = this.postRepo.getByIdAndDeletedFalse(postId);
        this.transactionSupport.afterCommit(() -> PostService.create$lambda$8(this, post, authContext, createNotifications));
        return post;
    }

    public static /* synthetic */ Post create$default(PostService postService, ChannelId channelId, String string, String string2, String string3, PostId postId, AttachmentsInput attachmentsInput, Event event, Instant instant, Poll poll, List list, Instant instant2, Instant instant3, Boolean bl, boolean bl2, Instant instant4, AuthorizationContext authorizationContext, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: create");
        }
        if ((n & 0x10) != 0) {
            postId = PostId.Companion.random();
        }
        if ((n & 0x20) != 0) {
            attachmentsInput = null;
        }
        if ((n & 0x40) != 0) {
            event = null;
        }
        if ((n & 0x100) != 0) {
            poll = null;
        }
        if ((n & 0x200) != 0) {
            list = null;
        }
        if ((n & 0x400) != 0) {
            instant2 = null;
        }
        if ((n & 0x1000) != 0) {
            bl = false;
        }
        if ((n & 0x2000) != 0) {
            bl2 = true;
        }
        if ((n & 0x4000) != 0) {
            instant4 = Instant.now();
        }
        return postService.create(channelId, string, string2, string3, postId, attachmentsInput, event, instant, poll, list, instant2, instant3, bl, bl2, instant4, authorizationContext);
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    @NotNull
    public Post update(@NotNull PostId postId, @NotNull Instant lastKnownModifyDate, @Nullable String title, @Nullable String text, @Nullable String jsonContent, @Nullable AttachmentsInput attachments, @Nullable Event event, @Nullable Boolean pin, @Nullable Instant pinExpiration, @Nullable Poll poll, @Nullable List<PollAnswer> pollAnswers, @Nullable Boolean deletePoll, @Nullable Instant publishDate, @Nullable Boolean published, @Nullable Instant deleteDate, @Nullable Boolean removeDeleteDate, @Nullable Boolean commentsDisabled, @NotNull AuthorizationContext authContext) {
        Collection originPoll;
        Instant instant;
        Instant instant2;
        Event event2;
        String string3;
        String string2;
        Object object;
        Object it;
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        Intrinsics.checkNotNullParameter((Object)lastKnownModifyDate, (String)"lastKnownModifyDate");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        Post origin = this.postRepo.getByIdAndDeletedFalse(postId);
        authContext.checkPostAction(origin.getId(), PostAction.EDIT);
        boolean publishNow = !origin.getPublished() && Intrinsics.areEqual((Object)published, (Object)true);
        Instant now = Instant.now();
        if (!DateUtilsKt.equals((Instant)lastKnownModifyDate, (Instant)origin.getModifyDate(), (boolean)true)) {
            boolean bl = false;
            if (pin != null && pinExpiration == null) {
                throw new PostAlreadyPinnedUnpinnedException("Post has already been pinned/unpinned by someone else.");
            }
            throw new PostAlreadyUpdatedException("Post has already been edited by someone else.");
        }
        if (origin.getPublished() && publishDate != null && publishDate.compareTo(now) > 0 || Intrinsics.areEqual((Object)published, (Object)false)) {
            throw new IllegalArgumentException("Already published posts may not be planned again.");
        }
        Instant instant3 = pinExpiration;
        if (instant3 != null) {
            it = instant3;
            boolean string3 = false;
            if (!((Instant)it).isAfter(now)) {
                boolean $i$a$-require-PostService$update$2$42 = false;
                String $i$a$-require-PostService$update$2$42 = "Pin expiration must be a date in the future.";
                throw new IllegalArgumentException($i$a$-require-PostService$update$2$42.toString());
            }
            if (publishDate != null) {
                if (!((Instant)it).isAfter(publishDate)) {
                    boolean $i$a$-require-PostService$update$2$52 = false;
                    String $i$a$-require-PostService$update$2$52 = "'pinExpiration' must be set after publication date.";
                    throw new IllegalArgumentException($i$a$-require-PostService$update$2$52.toString());
                }
            } else if (!((Instant)it).isAfter(origin.getPublishDate())) {
                boolean $i$a$-require-PostService$update$2$62 = false;
                String $i$a$-require-PostService$update$2$62 = "'pinExpiration' must be set after publication date.";
                throw new IllegalArgumentException($i$a$-require-PostService$update$2$62.toString());
            }
            v1 = Unit.INSTANCE;
        } else {
            v1 = null;
        }
        if ((object = title) == null) {
            object = it = origin.getTitle();
        }
        if ((string2 = text) == null) {
            string2 = string3 = origin.getText();
        }
        if ((event2 = event) == null) {
            event2 = origin.getEvent();
        }
        Event $i$a$-require-PostService$update$2$62 = event2;
        AttachmentsInput attachmentsInput = attachments;
        DocumentId documentId = attachmentsInput == null ? origin.getCoverElementId() : attachmentsInput.getCoverElementId();
        String string4 = jsonContent;
        if (string4 == null) {
            string4 = origin.getJsonContent();
        }
        String string5 = string4;
        Instant instant4 = PostService.update$getPinExpiration((Instant)pinExpiration, (Boolean)pin, (Post)origin, (Instant)now, (Instant)publishDate);
        Object object2 = PostService.update$getPinnedAt((Boolean)pin, (Post)origin);
        if (publishNow) {
            instant2 = now;
        } else {
            instant2 = publishDate;
            if (instant2 == null) {
                instant2 = origin.getPublishDate();
            }
        }
        Instant instant5 = instant2;
        Intrinsics.checkNotNull((Object)instant5);
        Instant instant6 = instant5;
        Boolean bl = published;
        boolean bl2 = bl != null ? bl.booleanValue() : origin.getPublished();
        Intrinsics.checkNotNull((Object)now);
        Instant instant7 = now;
        ProfileId profileId = authContext.getUser();
        if (Intrinsics.areEqual((Object)removeDeleteDate, (Object)true)) {
            instant = null;
        } else {
            instant = deleteDate;
            if (instant == null) {
                instant = origin.getDeleteDate();
            }
        }
        Instant instant8 = instant;
        Boolean bl3 = commentsDisabled;
        boolean bl4 = bl3 != null ? bl3.booleanValue() : origin.getCommentsDisabled();
        Post update = Post.copy$default((Post)origin, null, null, null, null, (Instant)instant7, (String)it, (String)string3, (String)string5, (DocumentId)documentId, (boolean)false, (Instant)instant8, (Instant)instant4, (Instant)object2, (Instant)instant6, (boolean)bl2, (ProfileId)profileId, (Event)$i$a$-require-PostService$update$2$62, (boolean)bl4, (int)527, null);
        AttachmentsInput attachmentsInput2 = attachments;
        if (attachmentsInput2 != null) {
            Iterable $this$forEach$iv;
            int n;
            Iterator $this$filterTo$iv$iv;
            Object element$iv2;
            Object element$iv$iv;
            Iterator $this$filterTo$iv$iv2;
            void $this$mapTo$iv$iv;
            void $this$mapTo$iv$iv2;
            AttachmentsInput it2 = attachmentsInput2;
            boolean bl5 = false;
            List originAttachments = this.attachmentRepo.findAllByItemIdOrderByPosition((DriveFileReferenceId)postId);
            Iterable $this$map$iv = originAttachments;
            boolean $i$f$map = false;
            object2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo22 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                Iterator it3;
                instant8 = (Attachment)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl6 = false;
                collection.add(it3.getId());
            }
            List originAttachmentIds = (List)destination$iv$iv;
            List updateAttachments = attachments.getValues();
            Iterable $this$map$iv2 = updateAttachments;
            boolean $i$f$map2 = false;
            Iterable $i$f$mapTo22 = $this$map$iv2;
            Iterable destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it4;
                AttachmentInput attachmentInput = (AttachmentInput)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl7 = false;
                collection.add(it4.getId());
            }
            List updateAttachmentIds = (List)destination$iv$iv2;
            Iterable $this$filter$iv = originAttachmentIds;
            boolean $i$f$filter = false;
            destination$iv$iv2 = $this$filter$iv;
            Collection destination$iv$iv3 = new ArrayList();
            boolean $i$f$filterTo = false;
            Iterator item$iv$iv = $this$filterTo$iv$iv2.iterator();
            while (item$iv$iv.hasNext()) {
                element$iv$iv = item$iv$iv.next();
                DocumentId it5 = (DocumentId)element$iv$iv;
                boolean bl8 = false;
                if (!(!updateAttachmentIds.contains(it5))) continue;
                destination$iv$iv3.add(element$iv$iv);
            }
            List toDelete = (List)destination$iv$iv3;
            Iterable $this$forEach$iv2 = toDelete;
            boolean $i$f$forEach = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                DocumentId it6 = (DocumentId)element$iv2;
                boolean bl9 = false;
                this.driveApiConnector.deleteFile(it6, authContext.getUser());
            }
            this.attachmentRepo.deleteAllById((Iterable)toDelete);
            Iterable $this$filter$iv2 = updateAttachmentIds;
            boolean $i$f$filter2 = false;
            element$iv2 = $this$filter$iv2;
            Collection destination$iv$iv4 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            element$iv$iv = $this$filterTo$iv$iv.iterator();
            while (element$iv$iv.hasNext()) {
                Object element$iv$iv2 = element$iv$iv.next();
                DocumentId it7 = (DocumentId)element$iv$iv2;
                n = 0;
                if (!(!originAttachmentIds.contains(it7))) continue;
                destination$iv$iv4.add(element$iv$iv2);
            }
            List toAdd = (List)destination$iv$iv4;
            $this$filter$iv2 = this.driveApiConnector.addFiles(toAdd, (DriveFileReferenceId)postId, authContext.getUser());
            boolean $i$f$forEach2 = false;
            for (Object element$iv3 : $this$forEach$iv) {
                Object v12;
                AttachmentRepo attachmentRepo;
                DocumentId documentId2;
                DriveFileReferenceId driveFileReferenceId;
                String string6;
                String string7;
                int it7;
                block37: {
                    DriveDocument attachment = (DriveDocument)element$iv3;
                    boolean bl10 = false;
                    Iterable element$iv$iv2 = updateAttachments;
                    it7 = 999;
                    n = attachment.getSize();
                    string7 = attachment.getName();
                    string6 = attachment.getMimeType();
                    driveFileReferenceId = (DriveFileReferenceId)postId;
                    documentId2 = attachment.getDocumentId();
                    attachmentRepo = this.attachmentRepo;
                    Iterable iterable = element$iv$iv2;
                    for (Object t : iterable) {
                        AttachmentInput it8 = (AttachmentInput)t;
                        boolean bl11 = false;
                        if (!Intrinsics.areEqual((Object)it8.getId(), (Object)attachment.getDocumentId())) continue;
                        v12 = t;
                        break block37;
                    }
                    v12 = null;
                }
                Object var52_103 = v12;
                AttachmentInput attachmentInput = var52_103;
                attachmentRepo.insert(documentId2, driveFileReferenceId, string6, string7, n, it7, attachmentInput != null ? attachmentInput.getAltText() : null);
            }
            $this$forEach$iv = updateAttachments;
            $i$f$filter2 = false;
            $this$filterTo$iv$iv = $this$filter$iv2;
            destination$iv$iv4 = new ArrayList();
            $i$f$filterTo = false;
            Iterator bl10 = $this$filterTo$iv$iv.iterator();
            while (bl10.hasNext()) {
                Object element$iv$iv3 = bl10.next();
                AttachmentInput it9 = (AttachmentInput)element$iv$iv3;
                boolean bl12 = false;
                if (!originAttachmentIds.contains(it9.getId())) continue;
                destination$iv$iv4.add(element$iv$iv3);
            }
            $this$filter$iv2 = (List)destination$iv$iv4;
            $i$f$forEach2 = false;
            for (Object element$iv3 : $this$forEach$iv) {
                AttachmentInput toUpdate = (AttachmentInput)element$iv3;
                boolean bl13 = false;
                this.attachmentRepo.updateAltText(toUpdate.getId(), toUpdate.getAltText());
            }
            Iterable $this$forEachIndexed$iv = updateAttachments;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void attachment;
                int n2;
                if ((n2 = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                AttachmentInput element$iv$iv3 = (AttachmentInput)item$iv;
                int index = n2;
                boolean bl14 = false;
                this.attachmentRepo.updatePosition(attachment.getId(), index);
            }
            v14 = Unit.INSTANCE;
        } else {
            v14 = null;
        }
        if (Intrinsics.areEqual((Object)deletePoll, (Object)true) && (originPoll = this.pollRepo.findByPostId(origin.getId())) != null) {
            this.pollRepo.deleteById((Object)originPoll.getId());
        }
        if (poll != null) {
            originPoll = pollAnswers;
            if (!(!(originPoll == null || originPoll.isEmpty()))) {
                boolean bl15 = false;
                String string8 = "Answers are required when adding a Poll";
                throw new IllegalArgumentException(string8.toString());
            }
            originPoll = this.pollRepo.findByPostId(origin.getId());
            if (!(originPoll == null)) {
                boolean bl16 = false;
                String string9 = "The Post '" + origin.getId() + "' has already a Poll and can only have one Poll";
                throw new IllegalArgumentException(string9.toString());
            }
            this.insertPoll(poll, pollAnswers, postId);
        }
        this.transactionSupport.afterCommit(() -> PostService.update$lambda$27(title, text, origin, publishNow, this, postId, update, authContext));
        Object object3 = this.postRepo.save((Object)update);
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"save(...)");
        return (Post)object3;
    }

    public static /* synthetic */ Post update$default(PostService postService, PostId postId, Instant instant, String string, String string2, String string3, AttachmentsInput attachmentsInput, Event event, Boolean bl, Instant instant2, Poll poll, List list, Boolean bl2, Instant instant3, Boolean bl3, Instant instant4, Boolean bl4, Boolean bl5, AuthorizationContext authorizationContext, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: update");
        }
        if ((n & 4) != 0) {
            string = null;
        }
        if ((n & 8) != 0) {
            string2 = null;
        }
        if ((n & 0x10) != 0) {
            string3 = null;
        }
        if ((n & 0x20) != 0) {
            attachmentsInput = null;
        }
        if ((n & 0x40) != 0) {
            event = null;
        }
        if ((n & 0x80) != 0) {
            bl = null;
        }
        if ((n & 0x100) != 0) {
            instant2 = null;
        }
        if ((n & 0x200) != 0) {
            poll = null;
        }
        if ((n & 0x400) != 0) {
            list = null;
        }
        if ((n & 0x800) != 0) {
            bl2 = null;
        }
        if ((n & 0x1000) != 0) {
            instant3 = null;
        }
        if ((n & 0x2000) != 0) {
            bl3 = null;
        }
        if ((n & 0x4000) != 0) {
            instant4 = null;
        }
        if ((n & 0x8000) != 0) {
            bl4 = null;
        }
        if ((n & 0x10000) != 0) {
            bl5 = null;
        }
        return postService.update(postId, instant, string, string2, string3, attachmentsInput, event, bl, instant2, poll, list, bl2, instant3, bl3, instant4, bl4, bl5, authorizationContext);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<Post> getChannelPosts(@NotNull ChannelId channelId, int offset, int limit, boolean scheduled, boolean pinned, @NotNull AuthorizationContext authContext) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        List posts = PaginationSupportKt.convertPaging((int)offset, (int)limit, (arg_0, arg_1) -> PostService.getChannelPosts$lambda$28(this, scheduled, pinned, channelId, arg_0, arg_1));
        Iterable iterable = posts;
        AuthorizationContext authorizationContext = authContext;
        boolean $i$f$map = false;
        void var10_11 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Post post = (Post)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getId());
        }
        authorizationContext.checkReadAll((Collection)((List)destination$iv$iv));
        return posts;
    }

    @NotNull
    public List<Post> getFeed(int offset, int limit, boolean pinned, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        Set subscribedChannelIds = this.getSubscribedChannels(authContext);
        Function3 feedQuery = this.getMatchingFeedQuery(pinned);
        return PaginationSupportKt.convertPaging((int)offset, (int)limit, (arg_0, arg_1) -> PostService.getFeed$lambda$30(feedQuery, this, subscribedChannelIds, arg_0, arg_1));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<Post> getEvents(@NotNull AuthorizationContext authContext, int offset, int limit) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        Set tenantChannels = this.channelRepo.getByTenantIdAndDeletedFalse(authContext.getTenantId());
        Iterable iterable = tenantChannels;
        AuthorizationContext authorizationContext = authContext;
        boolean $i$f$map = false;
        void var8_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Channel channel = (Channel)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getId());
        }
        Set channelIds = CollectionsKt.toSet((Iterable)authorizationContext.filterReadable((Collection)((List)destination$iv$iv)));
        if (channelIds.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        return this.postRepo.getEvents(channelIds, offset, limit);
    }

    @Unauthorized
    @NotNull
    public List<Post> findAllByIds(@NotNull List<PostId> postIds) {
        Intrinsics.checkNotNullParameter(postIds, (String)"postIds");
        Iterable iterable = this.postRepo.findAllById((Iterable)postIds);
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"findAllById(...)");
        Iterable $this$sortedBy$iv = iterable;
        boolean $i$f$sortedBy = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)((Comparator)new findAllByIds$$inlined$sortedBy$1(postIds)));
    }

    @NotNull
    public Post getById(@NotNull PostId id, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        Post post = this.findById(id, authContext);
        if (post == null) {
            throw new NoSuchElementException("Post with id :'" + id + "' does not exist.");
        }
        return post;
    }

    @Nullable
    public Post findById(@NotNull PostId id, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        Post post = PostRepo.findByIdAndDeleted$default((PostRepo)this.postRepo, (PostId)id, (boolean)false, (int)2, null);
        if (post == null) {
            return null;
        }
        Post post2 = post;
        authContext.checkRead((ItemId)post2.getId());
        return post2;
    }

    @Unauthorized
    @Nullable
    public Post findByIdDeleted(@NotNull PostId id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return this.postRepo.findByIdAndDeleted(id, true);
    }

    @NotNull
    public List<Post> latest(@NotNull AuthorizationContext authContext, boolean pinnedOnly, int limit) {
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        Set channelIds = this.channelRepo.getIdsByTenant(authContext.getTenantId());
        List channelIdsReadable = authContext.filterReadable((Collection)channelIds);
        return this.getByChannelIds((Collection)channelIdsReadable, pinnedOnly, limit);
    }

    public static /* synthetic */ List latest$default(PostService postService, AuthorizationContext authorizationContext, boolean bl, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: latest");
        }
        if ((n2 & 2) != 0) {
            bl = false;
        }
        if ((n2 & 4) != 0) {
            n = 8;
        }
        return postService.latest(authorizationContext, bl, n);
    }

    @NotNull
    public List<Post> byChannelIds(@NotNull Collection<ChannelId> channelIds, @NotNull AuthorizationContext authContext, boolean pinnedOnly, int limit) {
        Intrinsics.checkNotNullParameter(channelIds, (String)"channelIds");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        List channelIdsReadable = authContext.filterReadable(channelIds);
        return this.getByChannelIds((Collection)channelIdsReadable, pinnedOnly, limit);
    }

    public static /* synthetic */ List byChannelIds$default(PostService postService, Collection collection, AuthorizationContext authorizationContext, boolean bl, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: byChannelIds");
        }
        if ((n2 & 4) != 0) {
            bl = false;
        }
        if ((n2 & 8) != 0) {
            n = 8;
        }
        return postService.byChannelIds(collection, authorizationContext, bl, n);
    }

    private List<Post> getByChannelIds(Collection<ChannelId> channelIds, boolean pinnedOnly, int limit) {
        List list;
        if (pinnedOnly) {
            PageRequest pageRequest = PageRequest.of((int)0, (int)limit);
            Intrinsics.checkNotNullExpressionValue((Object)pageRequest, (String)"of(...)");
            List list2 = this.postRepo.findByChannelIdInAndPinExpirationNotNullAndPublishedTrueAndDeletedFalseOrderByPinnedAtDesc(channelIds, (Pageable)pageRequest).getContent();
            Intrinsics.checkNotNull((Object)list2);
            list = list2;
        } else {
            PageRequest pageRequest = PageRequest.of((int)0, (int)limit);
            Intrinsics.checkNotNullExpressionValue((Object)pageRequest, (String)"of(...)");
            List list3 = this.postRepo.findByChannelIdInAndPublishedTrueAndDeletedFalseOrderByPublishDateDesc(channelIds, (Pageable)pageRequest).getContent();
            Intrinsics.checkNotNull((Object)list3);
            list = list3;
        }
        return list;
    }

    static /* synthetic */ List getByChannelIds$default(PostService postService, Collection collection, boolean bl, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getByChannelIds");
        }
        if ((n2 & 2) != 0) {
            bl = false;
        }
        if ((n2 & 4) != 0) {
            n = 8;
        }
        return postService.getByChannelIds(collection, bl, n);
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    @Unauthorized
    @NotNull
    public List<Post> publishScheduledPosts() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = PostRepo.getByDeletedFalseAndPublishedFalseAndPublishDateLessThanEqual$default((PostRepo)this.postRepo, null, (int)1, null);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Post post = (Post)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Post.copy$default((Post)it, null, null, null, null, null, null, null, null, null, (boolean)false, null, null, null, null, (boolean)true, null, null, (boolean)false, (int)245759, null));
        }
        List it = (List)destination$iv$iv;
        boolean bl = false;
        Iterable iterable2 = this.postRepo.saveAll((Iterable)it);
        Intrinsics.checkNotNullExpressionValue((Object)iterable2, (String)"let(...)");
        List publishedPosts = CollectionsKt.toList((Iterable)iterable2);
        this.transactionSupport.afterCommit(() -> PostService.publishScheduledPosts$lambda$36(publishedPosts, this));
        return publishedPosts;
    }

    /*
     * WARNING - void declaration
     */
    @Unauthorized
    public void unpinPostsAfterPinExpiration() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = PostRepo.getByDeletedFalseAndPinExpirationLessThanEqual$default((PostRepo)this.postRepo, null, (int)1, null);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Post post = (Post)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Post.copy$default((Post)it, null, null, null, null, null, null, null, null, null, (boolean)false, null, null, null, null, (boolean)false, null, null, (boolean)false, (int)255999, null));
        }
        List it = (List)destination$iv$iv;
        boolean bl = false;
        this.postRepo.saveAll((Iterable)it);
    }

    /*
     * WARNING - void declaration
     */
    private void insertPoll(Poll poll, List<PollAnswer> pollAnswers, PostId postId) {
        void $this$mapTo$iv$iv;
        this.pollRepo.insert(poll.getId(), poll.getQuestion(), poll.getAllowMultipleAnswers(), postId, poll.getPrivacy());
        Iterable $this$map$iv = pollAnswers;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void answer;
            PollAnswer pollAnswer = (PollAnswer)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            this.pollAnswerRepo.insert(answer.getId(), answer.getText(), answer.getPosition(), answer.getPollId());
            collection.add(Unit.INSTANCE);
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
    }

    private Function3<PostRepo, ChannelId, Pageable, Page<Post>> getMatchingChannelQuery(boolean scheduled, boolean pinned) {
        return scheduled && pinned ? (Function3)getMatchingChannelQuery.1.INSTANCE : (scheduled && !pinned ? (Function3)getMatchingChannelQuery.2.INSTANCE : (!scheduled && pinned ? (Function3)getMatchingChannelQuery.3.INSTANCE : (Function3)getMatchingChannelQuery.4.INSTANCE));
    }

    private Function3<PostRepo, Collection<ChannelId>, Pageable, Page<Post>> getMatchingFeedQuery(boolean pinned) {
        return pinned ? (Function3)getMatchingFeedQuery.1.INSTANCE : (Function3)getMatchingFeedQuery.2.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private Set<ChannelId> getSubscribedChannels(AuthorizationContext authContext) {
        void $this$mapTo$iv$iv;
        ChannelId channelId;
        void $this$filterTo$iv$iv;
        Set channelIdsOfTenant = this.channelRepo.getIdsByTenant(authContext.getTenantId());
        Iterable $this$filter$iv = this.subscriptionRepoWrapper.getSubscribedChannelIds(authContext.getUser());
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            channelId = (ChannelId)element$iv$iv;
            boolean bl = false;
            if (!channelIdsOfTenant.contains(channelId)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List it = (List)destination$iv$iv;
        boolean $i$a$-let-PostService$getSubscribedChannels$32 = false;
        Iterable $this$map$iv = authContext.filterReadable((Collection)it);
        boolean $i$f$map = false;
        Iterable $i$a$-let-PostService$getSubscribedChannels$32 = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            channelId = (ChannelId)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(ChannelId.Companion.fromString(it2.toTypedString()));
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    private static final Unit create$lambda$8(PostService this$0, Post $post, AuthorizationContext $authContext, boolean $createNotifications) {
        KafkaPublishOperation[] kafkaPublishOperationArray = new KafkaPublishOperation[]{this$0.permissionKafkaProducer.publishPost($post.getId(), $post.getChannelId(), $post.getPublished()), this$0.permissionKafkaProducer.addPermission((ItemId)$post.getId(), (UserId)$authContext.getUser(), PermissionRole.MANAGER)};
        KafkaPublishOperation.waitForCompletion$default((KafkaPublishOperation)new KafkaPublishOperation(kafkaPublishOperationArray), null, (int)1, null);
        this$0.driveKafkaProducer.publishPost($post, $authContext.getTenantId());
        this$0.eventPublisher.publishEvent((ApplicationEvent)new PostCreatedEvent($post, $authContext.getTenantId()));
        if ($post.getPublished()) {
            this$0.eventPublisher.publishEvent((ApplicationEvent)new PostPublishedEvent($post, $authContext.getTenantId(), $createNotifications));
        }
        return Unit.INSTANCE;
    }

    private static final Instant update$getPinExpiration(Instant $pinExpiration, Boolean $pin, Post origin, Instant now, Instant $publishDate) {
        if ($pinExpiration != null) {
            return $pinExpiration;
        }
        if ($pin == null) {
            return origin.getPinExpiration();
        }
        if ($pin.booleanValue()) {
            return origin.getPublishDate().isBefore(now) ? now.plus(14L, ChronoUnit.DAYS) : ($publishDate == null ? origin.getPublishDate().plus(14L, ChronoUnit.DAYS) : $publishDate.plus(14L, ChronoUnit.DAYS));
        }
        return null;
    }

    private static final Instant update$getPinnedAt(Boolean $pin, Post origin) {
        if ($pin == null) {
            return origin.getPinnedAt();
        }
        if ($pin.booleanValue()) {
            return Instant.now();
        }
        return null;
    }

    private static final Unit update$lambda$27(String $title, String $text, Post $origin, boolean $publishNow, PostService this$0, PostId $postId, Post $update, AuthorizationContext $authContext) {
        boolean titleOrTextChanged;
        boolean bl = titleOrTextChanged = $title != null || $text != null;
        if ($origin.getPublished() && titleOrTextChanged || $publishNow) {
            this$0.eventPublisher.publishEvent((ApplicationEvent)new PostUpdatedEvent($postId));
        }
        if ($publishNow) {
            this$0.permissionKafkaProducer.publishPost($update.getId(), $update.getChannelId(), true);
            this$0.eventPublisher.publishEvent((ApplicationEvent)new PostPublishedEvent($update, $authContext.getTenantId(), false, 4, null));
        } else if ($text != null && $origin.getPublished()) {
            Set originMentions = QuillUtils.Companion.extractMentions($origin.getJsonContent());
            Set updateMentions = QuillUtils.Companion.extractMentions($update.getJsonContent());
            Set newMentions = CollectionsKt.subtract((Iterable)updateMentions, (Iterable)originMentions);
            if (!((Collection)newMentions).isEmpty()) {
                this$0.eventPublisher.publishEvent((ApplicationEvent)new PostUpdatedMentions($update, $authContext.getTenantId(), (Collection)newMentions));
            }
        }
        return Unit.INSTANCE;
    }

    private static final List getChannelPosts$lambda$28(PostService this$0, boolean $scheduled, boolean $pinned, ChannelId $channelId, int pageIndex, int pageSize) {
        PageRequest pageRequest = PageRequest.of((int)pageIndex, (int)pageSize);
        Intrinsics.checkNotNullExpressionValue((Object)pageRequest, (String)"of(...)");
        PageRequest pageable = pageRequest;
        Function3 postsQuery = this$0.getMatchingChannelQuery($scheduled, $pinned);
        List list = ((Page)postsQuery.invoke((Object)this$0.postRepo, (Object)$channelId, (Object)pageable)).getContent();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getContent(...)");
        return list;
    }

    private static final List getFeed$lambda$30(Function3 $feedQuery, PostService this$0, Set $subscribedChannelIds, int pageIndex, int pageSize) {
        PageRequest pageRequest = PageRequest.of((int)pageIndex, (int)pageSize);
        Intrinsics.checkNotNullExpressionValue((Object)pageRequest, (String)"of(...)");
        PageRequest pageable = pageRequest;
        List list = ((Page)$feedQuery.invoke((Object)this$0.postRepo, (Object)$subscribedChannelIds, (Object)pageable)).getContent();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getContent(...)");
        return list;
    }

    private static final Unit publishScheduledPosts$lambda$36(List $publishedPosts, PostService this$0) {
        Iterable $this$forEach$iv = $publishedPosts;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Post it = (Post)element$iv;
            boolean bl = false;
            Channel channel = this$0.channelRepo.getByIdAndDeletedFalse(it.getChannelId());
            this$0.permissionKafkaProducer.publishPost(it.getId(), it.getChannelId(), true);
            this$0.eventPublisher.publishEvent((ApplicationEvent)new PostUpdatedEvent(it.getId()));
            ApplicationEventPublisher applicationEventPublisher = this$0.eventPublisher;
            Intrinsics.checkNotNull((Object)it);
            applicationEventPublisher.publishEvent((ApplicationEvent)new PostPublishedEvent(it, channel.getTenantId(), false, 4, null));
        }
        return Unit.INSTANCE;
    }
}

