/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.domain.post;

import com.netflix.graphql.dgs.DgsComponent;
import com.netflix.graphql.dgs.DgsData;
import com.netflix.graphql.dgs.DgsDataFetchingEnvironment;
import com.netflix.graphql.dgs.DgsMutation;
import com.netflix.graphql.dgs.DgsQuery;
import com.netflix.graphql.dgs.InputArgument;
import com.netflix.graphql.dgs.context.DgsContext;
import de.justsoftware.news.auth.AuthorizationContext;
import de.justsoftware.news.domain.attachment.AttachmentDataLoader;
import de.justsoftware.news.domain.attachment.AttachmentDataLoaderKt;
import de.justsoftware.news.domain.attachment.AttachmentsInput;
import de.justsoftware.news.domain.channel.ChannelDataLoader;
import de.justsoftware.news.domain.delete.DeleteService;
import de.justsoftware.news.domain.event.Event;
import de.justsoftware.news.domain.poll.Poll;
import de.justsoftware.news.domain.post.AllowedPostActionsDataLoader;
import de.justsoftware.news.domain.post.CommentCountByPostIds;
import de.justsoftware.news.domain.post.CommentDataLoader;
import de.justsoftware.news.domain.post.CommentNotificationsEnabledBatchLoader;
import de.justsoftware.news.domain.post.PollDataLoader;
import de.justsoftware.news.domain.post.Post;
import de.justsoftware.news.domain.post.PostDataFetcherKt;
import de.justsoftware.news.domain.post.PostIdWithSortOrder;
import de.justsoftware.news.domain.post.PostService;
import de.justsoftware.news.domain.post.model.PostAction;
import de.justsoftware.news.domain.reaction.ReactionDataLoader;
import de.justsoftware.news.domain.user.ProfileDataLoader;
import de.justsoftware.news.graphql.generated.types.AddPollInput;
import de.justsoftware.news.graphql.generated.types.AddPostInput;
import de.justsoftware.news.graphql.generated.types.Attachment;
import de.justsoftware.news.graphql.generated.types.Channel;
import de.justsoftware.news.graphql.generated.types.Comment;
import de.justsoftware.news.graphql.generated.types.EventInput;
import de.justsoftware.news.graphql.generated.types.Likes;
import de.justsoftware.news.graphql.generated.types.Profile;
import de.justsoftware.news.graphql.generated.types.Reaction;
import de.justsoftware.news.graphql.generated.types.UpdatePostInput;
import de.justsoftware.news.id.ChannelId;
import de.justsoftware.news.id.PollId;
import de.justsoftware.news.id.PostId;
import de.justsoftware.news.id.ProfileId;
import de.justsoftware.news.util.DateUtilsKt;
import de.justsoftware.news.util.Sort;
import graphql.execution.DataFetcherResult;
import graphql.schema.DataFetchingEnvironment;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.dataloader.DataLoader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@DgsComponent
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007JH\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u00102\b\b\u0001\u0010\u0011\u001a\u00020\u00122\b\b\u0001\u0010\u0013\u001a\u00020\u00142\b\b\u0001\u0010\u0015\u001a\u00020\u00142\b\b\u0001\u0010\u0016\u001a\u00020\u00172\b\b\u0001\u0010\u0018\u001a\u00020\u0017H\u0017J*\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u00102\b\b\u0001\u0010\u0013\u001a\u00020\u00142\b\b\u0001\u0010\u0015\u001a\u00020\u0014H\u0017J4\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u00102\b\b\u0001\u0010\u0013\u001a\u00020\u00142\b\b\u0001\u0010\u0015\u001a\u00020\u00142\b\b\u0001\u0010\u0018\u001a\u00020\u0017H\u0017J\u001c\u0010\u001b\u001a\u0004\u0018\u00010\u000e2\b\b\u0001\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u000f\u001a\u00020\u0010H\u0017J\u001a\u0010\u001e\u001a\u00020\u000e2\b\b\u0001\u0010\u001f\u001a\u00020 2\u0006\u0010\u000f\u001a\u00020\u0010H\u0017J\u001a\u0010!\u001a\u00020\u000e2\b\b\u0001\u0010\u001f\u001a\u00020\"2\u0006\u0010\u000f\u001a\u00020\u0010H\u0017J\u001a\u0010#\u001a\u00020\u001d2\b\b\u0001\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u000f\u001a\u00020\u0010H\u0017J\u001c\u0010$\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020&0\r0%2\u0006\u0010\u000f\u001a\u00020\u0010H\u0017J\u0016\u0010'\u001a\b\u0012\u0004\u0012\u00020(0%2\u0006\u0010\u000f\u001a\u00020\u0010H\u0017J\u0018\u0010)\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010(0%2\u0006\u0010\u000f\u001a\u00020\u0010H\u0017J\u0016\u0010*\u001a\b\u0012\u0004\u0012\u00020+0%2\u0006\u0010\u000f\u001a\u00020\u0010H\u0017J\u001e\u0010,\u001a\b\u0012\u0004\u0012\u00020-0%2\u0006\u0010.\u001a\u00020/2\u0006\u0010\u000f\u001a\u00020\u0010H\u0017J\u0016\u00100\u001a\b\u0012\u0004\u0012\u00020\u00170%2\u0006\u0010\u000f\u001a\u00020\u0010H\u0017J\u0016\u00101\u001a\b\u0012\u0004\u0012\u0002020%2\u0006\u0010\u000f\u001a\u00020\u0010H\u0017J\u0016\u00103\u001a\b\u0012\u0004\u0012\u0002040%2\u0006\u0010\u000f\u001a\u00020\u0010H\u0017J\u0016\u00105\u001a\b\u0012\u0004\u0012\u00020\u00140%2\u0006\u0010\u000f\u001a\u00020\u0010H\u0017J\u001c\u00106\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u000208070%2\u0006\u0010\u000f\u001a\u00020\u0010H\u0017J\u0016\u00109\u001a\b\u0012\u0004\u0012\u00020;0:2\u0006\u0010\u000f\u001a\u00020\u0010H\u0017R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006<"}, d2={"Lde/justsoftware/news/domain/post/PostDataFetcher;", "", "postService", "Lde/justsoftware/news/domain/post/PostService;", "deleteService", "Lde/justsoftware/news/domain/delete/DeleteService;", "<init>", "(Lde/justsoftware/news/domain/post/PostService;Lde/justsoftware/news/domain/delete/DeleteService;)V", "getPostService", "()Lde/justsoftware/news/domain/post/PostService;", "getDeleteService", "()Lde/justsoftware/news/domain/delete/DeleteService;", "channelPosts", "", "Lde/justsoftware/news/graphql/generated/types/Post;", "dfe", "Lcom/netflix/graphql/dgs/DgsDataFetchingEnvironment;", "channelId", "Lde/justsoftware/news/id/ChannelId;", "offset", "", "limit", "scheduled", "", "pinned", "events", "feed", "post", "id", "Lde/justsoftware/news/id/PostId;", "addPost", "input", "Lde/justsoftware/news/graphql/generated/types/AddPostInput;", "updatePost", "Lde/justsoftware/news/graphql/generated/types/UpdatePostInput;", "deletePost", "attachments", "Ljava/util/concurrent/CompletableFuture;", "Lde/justsoftware/news/graphql/generated/types/Attachment;", "author", "Lde/justsoftware/news/graphql/generated/types/Profile;", "editor", "channel", "Lde/justsoftware/news/graphql/generated/types/Channel;", "comments", "Lde/justsoftware/news/graphql/generated/types/Comment;", "sort", "Lde/justsoftware/news/util/Sort;", "commentNotificationsEnabled", "poll", "Lde/justsoftware/news/graphql/generated/types/Poll;", "reactions", "Lde/justsoftware/news/graphql/generated/types/Reaction;", "commentCount", "allowedActions", "", "Lde/justsoftware/news/domain/post/model/PostAction;", "likes", "Lgraphql/execution/DataFetcherResult;", "Lde/justsoftware/news/graphql/generated/types/Likes;", "news-service"})
@SourceDebugExtension(value={"SMAP\nPostDataFetcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PostDataFetcher.kt\nde/justsoftware/news/domain/post/PostDataFetcher\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,374:1\n1557#2:375\n1628#2,3:376\n1557#2:379\n1628#2,3:380\n1557#2:383\n1628#2,3:384\n*S KotlinDebug\n*F\n+ 1 PostDataFetcher.kt\nde/justsoftware/news/domain/post/PostDataFetcher\n*L\n76#1:375\n76#1:376,3\n87#1:379\n87#1:380,3\n98#1:383\n98#1:384,3\n*E\n"})
public class PostDataFetcher {
    @NotNull
    private final PostService postService;
    @NotNull
    private final DeleteService deleteService;

    public PostDataFetcher(@NotNull PostService postService, @NotNull DeleteService deleteService) {
        Intrinsics.checkNotNullParameter((Object)postService, (String)"postService");
        Intrinsics.checkNotNullParameter((Object)deleteService, (String)"deleteService");
        this.postService = postService;
        this.deleteService = deleteService;
    }

    @NotNull
    public PostService getPostService() {
        return this.postService;
    }

    @NotNull
    public DeleteService getDeleteService() {
        return this.deleteService;
    }

    /*
     * WARNING - void declaration
     */
    @DgsQuery(field="channelPosts")
    @NotNull
    public List<de.justsoftware.news.graphql.generated.types.Post> channelPosts(@NotNull DgsDataFetchingEnvironment dfe, @InputArgument @NotNull ChannelId channelId, @InputArgument int offset, @InputArgument int limit, @InputArgument boolean scheduled, @InputArgument boolean pinned) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Iterable iterable = this.getPostService().getChannelPosts(channelId, offset, limit, scheduled, pinned, (AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)dfe));
        boolean $i$f$map = false;
        void var9_9 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Post post = (Post)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(PostDataFetcherKt.toGql((Post)it));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @DgsQuery(field="events")
    @NotNull
    public List<de.justsoftware.news.graphql.generated.types.Post> events(@NotNull DgsDataFetchingEnvironment dfe, @InputArgument int offset, @InputArgument int limit) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        Iterable iterable = this.getPostService().getEvents((AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)dfe), offset, limit);
        boolean $i$f$map = false;
        void var6_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Post post = (Post)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(PostDataFetcherKt.toGql((Post)it));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @DgsQuery(field="feed")
    @NotNull
    public List<de.justsoftware.news.graphql.generated.types.Post> feed(@NotNull DgsDataFetchingEnvironment dfe, @InputArgument int offset, @InputArgument int limit, @InputArgument boolean pinned) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        Iterable iterable = this.getPostService().getFeed(offset, limit, pinned, (AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)dfe));
        boolean $i$f$map = false;
        void var7_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Post post = (Post)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(PostDataFetcherKt.toGql((Post)it));
        }
        return (List)destination$iv$iv;
    }

    @DgsQuery(field="post")
    @Nullable
    public de.justsoftware.news.graphql.generated.types.Post post(@InputArgument @NotNull PostId id, @NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        Post post = this.getPostService().findById(id, (AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)dfe));
        return post != null ? PostDataFetcherKt.toGql((Post)post) : null;
    }

    @DgsMutation(field="addPost")
    @NotNull
    public de.justsoftware.news.graphql.generated.types.Post addPost(@InputArgument @NotNull AddPostInput input, @NotNull DgsDataFetchingEnvironment dfe) {
        List list;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        PostId postId = PostId.Companion.random();
        AddPollInput addPollInput = input.getPoll();
        Poll poll = addPollInput != null ? PostDataFetcherKt.toPollDomain((AddPollInput)addPollInput, (PostId)postId) : null;
        PostService postService = this.getPostService();
        ChannelId channelId = input.getChannelId();
        String string = input.getTitle();
        String string2 = input.getText();
        String string3 = input.getJsonContent();
        de.justsoftware.news.graphql.generated.types.AttachmentsInput attachmentsInput = input.getAttachments();
        Object object = attachmentsInput != null ? AttachmentDataLoaderKt.toDomain((de.justsoftware.news.graphql.generated.types.AttachmentsInput)attachmentsInput) : null;
        EventInput eventInput = input.getEvent();
        Object object2 = eventInput != null ? PostDataFetcherKt.toDomain((EventInput)eventInput, (PostId)postId) : null;
        Long l = input.getPinExpiration();
        Instant instant = l != null ? DateUtilsKt.toInstant((long)l) : null;
        AddPollInput addPollInput2 = input.getPoll();
        if (addPollInput2 != null) {
            Poll poll2 = poll;
            list = PostDataFetcherKt.toPollAnswerDomain((AddPollInput)addPollInput2, (PollId)(poll2 != null ? poll2.getId() : null), (AddPollInput)input.getPoll());
        } else {
            list = null;
        }
        Long l2 = input.getPublishDate();
        Long l3 = input.getDeleteDate();
        return PostDataFetcherKt.toGql((Post)PostService.create$default((PostService)postService, (ChannelId)channelId, (String)string, (String)string2, (String)string3, (PostId)postId, (AttachmentsInput)object, (Event)object2, (Instant)instant, (Poll)poll, (List)list, (Instant)(l2 != null ? DateUtilsKt.toInstant((long)l2) : null), (Instant)(l3 != null ? DateUtilsKt.toInstant((long)l3) : null), (Boolean)input.getCommentsDisabled(), (boolean)false, null, (AuthorizationContext)((AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)dfe)), (int)24576, null));
    }

    @DgsMutation(field="updatePost")
    @NotNull
    public de.justsoftware.news.graphql.generated.types.Post updatePost(@InputArgument @NotNull UpdatePostInput input, @NotNull DgsDataFetchingEnvironment dfe) {
        List list;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        AddPollInput addPollInput = input.getPoll();
        Poll poll = addPollInput != null ? PostDataFetcherKt.toPollDomain((AddPollInput)addPollInput, (PostId)input.getId()) : null;
        PostService postService = this.getPostService();
        PostId postId = input.getId();
        String string = input.getTitle();
        String string2 = input.getText();
        String string3 = input.getJsonContent();
        de.justsoftware.news.graphql.generated.types.AttachmentsInput attachmentsInput = input.getAttachments();
        AttachmentsInput attachmentsInput2 = attachmentsInput != null ? AttachmentDataLoaderKt.toDomain((de.justsoftware.news.graphql.generated.types.AttachmentsInput)attachmentsInput) : null;
        EventInput eventInput = input.getEvent();
        Event event = eventInput != null ? PostDataFetcherKt.toDomain((EventInput)eventInput, (PostId)input.getId()) : null;
        Boolean bl = input.getPin();
        Long l = input.getPinExpiration();
        Instant instant = l != null ? DateUtilsKt.toInstant((long)l) : null;
        AddPollInput addPollInput2 = input.getPoll();
        if (addPollInput2 != null) {
            Poll poll2 = poll;
            list = PostDataFetcherKt.toPollAnswerDomain((AddPollInput)addPollInput2, (PollId)(poll2 != null ? poll2.getId() : null), (AddPollInput)input.getPoll());
        } else {
            list = null;
        }
        List list2 = list;
        Boolean bl2 = input.getDeletePoll();
        Long l2 = input.getPublishDate();
        Instant instant2 = l2 != null ? DateUtilsKt.toInstant((long)l2) : null;
        Boolean bl3 = input.getPublished();
        Instant instant3 = DateUtilsKt.toInstant((long)input.getLastKnownModifyDate());
        Long l3 = input.getDeleteDate();
        Instant instant4 = l3 != null ? DateUtilsKt.toInstant((long)l3) : null;
        Boolean bl4 = input.getRemoveDeleteDate();
        Boolean bl5 = input.getCommentsDisabled();
        AuthorizationContext authorizationContext = (AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)dfe);
        return PostDataFetcherKt.toGql((Post)postService.update(postId, instant3, string, string2, string3, attachmentsInput2, event, bl, instant, poll, list2, bl2, instant2, bl3, instant4, bl4, bl5, authorizationContext));
    }

    @DgsMutation(field="deletePost")
    @NotNull
    public PostId deletePost(@InputArgument @NotNull PostId id, @NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        return this.getDeleteService().markPostForDeletion(id, (AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)dfe));
    }

    @DgsData(parentType="Post", field="attachments")
    @NotNull
    public CompletableFuture<List<Attachment>> attachments(@NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        DataLoader dataLoader = dfe.getDataLoader(AttachmentDataLoader.class);
        PostId postId = ((de.justsoftware.news.graphql.generated.types.Post)dfe.getSourceOrThrow()).getId();
        CompletableFuture completableFuture = dataLoader.load((Object)postId);
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"load(...)");
        return completableFuture;
    }

    @DgsData(parentType="Post", field="author")
    @NotNull
    public CompletableFuture<Profile> author(@NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        DataLoader dataLoader = dfe.getDataLoader(ProfileDataLoader.class);
        ProfileId authorId = ((de.justsoftware.news.graphql.generated.types.Post)dfe.getSourceOrThrow()).getAuthorId();
        CompletableFuture completableFuture = dataLoader.load((Object)authorId);
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"load(...)");
        return completableFuture;
    }

    @DgsData(parentType="Post", field="editor")
    @NotNull
    public CompletableFuture<Profile> editor(@NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        ProfileId profileId = ((de.justsoftware.news.graphql.generated.types.Post)dfe.getSourceOrThrow()).getEditorId();
        if (profileId == null) {
            CompletableFuture<Profile> completableFuture = CompletableFuture.supplyAsync(PostDataFetcher::editor$lambda$3);
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"supplyAsync(...)");
            return completableFuture;
        }
        ProfileId editorId = profileId;
        DataLoader dataLoader = dfe.getDataLoader(ProfileDataLoader.class);
        CompletableFuture completableFuture = dataLoader.load((Object)editorId);
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"load(...)");
        return completableFuture;
    }

    @DgsData(parentType="Post", field="channel")
    @NotNull
    public CompletableFuture<Channel> channel(@NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        DataLoader dataLoader = dfe.getDataLoader(ChannelDataLoader.class);
        ChannelId channelId = ((de.justsoftware.news.graphql.generated.types.Post)dfe.getSourceOrThrow()).getChannelId();
        CompletableFuture completableFuture = dataLoader.load((Object)channelId);
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"load(...)");
        return completableFuture;
    }

    @DgsData(parentType="Post", field="comments")
    @NotNull
    public CompletableFuture<Comment> comments(@NotNull Sort sort, @NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)sort, (String)"sort");
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        PostId postId = ((de.justsoftware.news.graphql.generated.types.Post)dfe.getSourceOrThrow()).getId();
        DataLoader dataLoader = dfe.getDataLoader(CommentDataLoader.class);
        CompletableFuture completableFuture = dataLoader.load((Object)new PostIdWithSortOrder(postId, sort));
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"load(...)");
        return completableFuture;
    }

    @DgsData(parentType="Post", field="commentNotificationsEnabled")
    @NotNull
    public CompletableFuture<Boolean> commentNotificationsEnabled(@NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        PostId postId = ((de.justsoftware.news.graphql.generated.types.Post)dfe.getSourceOrThrow()).getId();
        DataLoader dataLoader = dfe.getDataLoader(CommentNotificationsEnabledBatchLoader.class);
        CompletableFuture completableFuture = dataLoader.load((Object)postId);
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"load(...)");
        return completableFuture;
    }

    @DgsData(parentType="Post", field="poll")
    @NotNull
    public CompletableFuture<de.justsoftware.news.graphql.generated.types.Poll> poll(@NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        DataLoader dataLoader = dfe.getDataLoader(PollDataLoader.class);
        PostId postId = ((de.justsoftware.news.graphql.generated.types.Post)dfe.getSourceOrThrow()).getId();
        CompletableFuture completableFuture = dataLoader.load((Object)postId);
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"load(...)");
        return completableFuture;
    }

    @DgsData(parentType="Post", field="reactions")
    @NotNull
    public CompletableFuture<Reaction> reactions(@NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        DataLoader dataLoader = dfe.getDataLoader(ReactionDataLoader.class);
        PostId postId = ((de.justsoftware.news.graphql.generated.types.Post)dfe.getSourceOrThrow()).getId();
        CompletableFuture completableFuture = dataLoader.load((Object)postId);
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"load(...)");
        return completableFuture;
    }

    @DgsData(parentType="Post", field="commentCount")
    @NotNull
    public CompletableFuture<Integer> commentCount(@NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        PostId postId = ((de.justsoftware.news.graphql.generated.types.Post)dfe.getSourceOrThrow()).getId();
        DataLoader dataLoader = dfe.getDataLoader(CommentCountByPostIds.class);
        CompletableFuture completableFuture = dataLoader.load((Object)postId);
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"load(...)");
        return completableFuture;
    }

    @DgsData(parentType="Post", field="allowedActions")
    @NotNull
    public CompletableFuture<Set<PostAction>> allowedActions(@NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        PostId postId = ((de.justsoftware.news.graphql.generated.types.Post)dfe.getSourceOrThrow()).getId();
        DataLoader dataLoader = dfe.getDataLoader(AllowedPostActionsDataLoader.class);
        CompletableFuture completableFuture = dataLoader.load((Object)postId);
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"load(...)");
        return completableFuture;
    }

    @DgsData(parentType="Post", field="likes")
    @NotNull
    public DataFetcherResult<Likes> likes(@NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        DataFetcherResult dataFetcherResult = DataFetcherResult.newResult().data((Object)new Likes(null, null, null, 7, null)).localContext((Object)((de.justsoftware.news.graphql.generated.types.Post)dfe.getSourceOrThrow()).getId()).build();
        Intrinsics.checkNotNullExpressionValue((Object)dataFetcherResult, (String)"build(...)");
        return dataFetcherResult;
    }

    private static final Profile editor$lambda$3() {
        return null;
    }
}

