/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.domain.newscover;

import de.justsoftware.news.auth.AuthorizationContext;
import de.justsoftware.news.domain.newscover.NewsCover;
import de.justsoftware.news.domain.newscover.NewsCoverRepo;
import de.justsoftware.news.domain.newscover.NewsCoverSection;
import de.justsoftware.news.domain.newscover.NewsCoverSectionInput;
import de.justsoftware.news.id.ItemId;
import de.justsoftware.news.id.TenantId;
import io.micrometer.observation.annotation.Observed;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Service;

@Service
@Observed
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J9\u0010\n\u001a\u00020\u00072\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u000e\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u00102\u0006\u0010\b\u001a\u00020\tH\u0016\u00a2\u0006\u0002\u0010\u0012J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lde/justsoftware/news/domain/newscover/NewsCoverService;", "", "newsCoverRepo", "Lde/justsoftware/news/domain/newscover/NewsCoverRepo;", "<init>", "(Lde/justsoftware/news/domain/newscover/NewsCoverRepo;)V", "getNewsCover", "Lde/justsoftware/news/domain/newscover/NewsCover;", "authContext", "Lde/justsoftware/news/auth/AuthorizationContext;", "updateNewsCover", "openOnStart", "", "cycleDelay", "", "sections", "", "Lde/justsoftware/news/domain/newscover/NewsCoverSectionInput;", "(Ljava/lang/Boolean;Ljava/lang/Integer;Ljava/util/Collection;Lde/justsoftware/news/auth/AuthorizationContext;)Lde/justsoftware/news/domain/newscover/NewsCover;", "insertDefaultNewsCover", "", "tenantId", "Lde/justsoftware/news/id/TenantId;", "news-service"})
@SourceDebugExtension(value={"SMAP\nNewsCoverService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NewsCoverService.kt\nde/justsoftware/news/domain/newscover/NewsCoverService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,78:1\n1557#2:79\n1628#2,3:80\n*S KotlinDebug\n*F\n+ 1 NewsCoverService.kt\nde/justsoftware/news/domain/newscover/NewsCoverService\n*L\n58#1:79\n58#1:80,3\n*E\n"})
public class NewsCoverService {
    @NotNull
    private final NewsCoverRepo newsCoverRepo;

    public NewsCoverService(@NotNull NewsCoverRepo newsCoverRepo) {
        Intrinsics.checkNotNullParameter((Object)newsCoverRepo, (String)"newsCoverRepo");
        this.newsCoverRepo = newsCoverRepo;
    }

    @NotNull
    public NewsCover getNewsCover(@NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        NewsCover newsCover = this.newsCoverRepo.findById((Object)authContext.getTenantId()).orElseGet(() -> NewsCoverService.getNewsCover$lambda$0(this, authContext));
        Intrinsics.checkNotNullExpressionValue((Object)newsCover, (String)"orElseGet(...)");
        return newsCover;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public NewsCover updateNewsCover(@Nullable Boolean openOnStart, @Nullable Integer cycleDelay, @Nullable Collection<NewsCoverSectionInput> sections, @NotNull AuthorizationContext authContext) {
        Set set;
        int n;
        boolean bl;
        TenantId tenantId;
        NewsCover newsCover;
        NewsCoverRepo newsCoverRepo;
        block4: {
            NewsCover origin;
            block3: {
                Collection<NewsCoverSection> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
                TenantId tenantId2 = authContext.getTenantId();
                authContext.checkManage((ItemId)tenantId2);
                origin = this.newsCoverRepo.findById((Object)tenantId2).orElseGet(() -> NewsCoverService.updateNewsCover$lambda$1(this, tenantId2));
                newsCoverRepo = this.newsCoverRepo;
                newsCover = origin;
                tenantId = null;
                Boolean bl2 = openOnStart;
                bl = bl2 != null ? bl2.booleanValue() : origin.getOpenOnStart();
                Integer n2 = cycleDelay;
                n = n2 != null ? n2.intValue() : origin.getCycleDelay();
                set = sections;
                if (set == null) break block3;
                Iterable iterable = set;
                int n3 = n;
                boolean bl3 = bl;
                TenantId tenantId3 = tenantId;
                NewsCover newsCover2 = newsCover;
                NewsCoverRepo newsCoverRepo2 = newsCoverRepo;
                boolean $i$f$map = false;
                void var9_14 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    NewsCoverSectionInput newsCoverSectionInput = (NewsCoverSectionInput)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl4 = false;
                    collection.add(it.toNewsCoverSection());
                }
                collection = (List)destination$iv$iv;
                newsCoverRepo = newsCoverRepo2;
                newsCover = newsCover2;
                tenantId = tenantId3;
                bl = bl3;
                n = n3;
                set = CollectionsKt.toSet((Iterable)collection);
                if (set != null) break block4;
            }
            set = origin.getSections();
        }
        Object object = newsCoverRepo.save((Object)NewsCover.copy$default((NewsCover)newsCover, tenantId, (boolean)bl, (int)n, (Set)set, (int)1, null));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"save(...)");
        return (NewsCover)object;
    }

    private void insertDefaultNewsCover(TenantId tenantId) {
        NewsCover defaultNewsCover = NewsCover.Companion.default(tenantId);
        NewsCoverSection firstSection = (NewsCoverSection)CollectionsKt.first((Iterable)defaultNewsCover.getSections());
        this.newsCoverRepo.insert(defaultNewsCover.getTenantId(), defaultNewsCover.getOpenOnStart(), defaultNewsCover.getCycleDelay(), firstSection.getId(), firstSection.getTitle(), firstSection.getPinnedOnly(), firstSection.getPosition());
    }

    private static final NewsCover getNewsCover$lambda$0(NewsCoverService this$0, AuthorizationContext $authContext) {
        this$0.insertDefaultNewsCover($authContext.getTenantId());
        return this$0.newsCoverRepo.getByTenantId($authContext.getTenantId());
    }

    private static final NewsCover updateNewsCover$lambda$1(NewsCoverService this$0, TenantId $tenantId) {
        this$0.insertDefaultNewsCover($tenantId);
        return this$0.newsCoverRepo.getByTenantId($tenantId);
    }
}

