/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.domain.channel.permission;

import de.justsoftware.news.auth.AuthorizationContext;
import de.justsoftware.news.connector.permission.PermissionItem;
import de.justsoftware.news.connector.permission.PermissionKafkaProducer;
import de.justsoftware.news.domain.channel.ChannelAction;
import de.justsoftware.news.domain.channel.ChannelRepo;
import de.justsoftware.news.domain.channel.permission.ChannelPermission;
import de.justsoftware.news.domain.channel.permission.ChannelPermissionAdd;
import de.justsoftware.news.domain.channel.permission.ChannelPermissionChanges;
import de.justsoftware.news.domain.channel.permission.ChannelPermissionRepo;
import de.justsoftware.news.domain.channel.permission.ChannelPermissionUpdate;
import de.justsoftware.news.domain.channel.permission.PermissionRole;
import de.justsoftware.news.events.ChannelPermissionChangedEvent;
import de.justsoftware.news.events.GroupDeletedEvent;
import de.justsoftware.news.events.ProfileDeletedEvent;
import de.justsoftware.news.id.ChannelId;
import de.justsoftware.news.id.ItemId;
import de.justsoftware.news.id.PermissionId;
import de.justsoftware.news.id.UserId;
import de.justsoftware.news.kafka.KafkaPublishOperation;
import de.justsoftware.news.util.TransactionSupport;
import de.justsoftware.news.util.Unauthorized;
import io.micrometer.observation.annotation.Observed;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Observed
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0017J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0017J\u0010\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u001bH\u0017J\u0010\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u001cH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lde/justsoftware/news/domain/channel/permission/ChannelPermissionService;", "", "channelPermissionRepo", "Lde/justsoftware/news/domain/channel/permission/ChannelPermissionRepo;", "permissionKafkaProducer", "Lde/justsoftware/news/connector/permission/PermissionKafkaProducer;", "transactionSupport", "Lde/justsoftware/news/util/TransactionSupport;", "eventPublisher", "Lorg/springframework/context/ApplicationEventPublisher;", "channelRepo", "Lde/justsoftware/news/domain/channel/ChannelRepo;", "<init>", "(Lde/justsoftware/news/domain/channel/permission/ChannelPermissionRepo;Lde/justsoftware/news/connector/permission/PermissionKafkaProducer;Lde/justsoftware/news/util/TransactionSupport;Lorg/springframework/context/ApplicationEventPublisher;Lde/justsoftware/news/domain/channel/ChannelRepo;)V", "findAllByChannelId", "", "Lde/justsoftware/news/domain/channel/permission/ChannelPermission;", "channelId", "Lde/justsoftware/news/id/ChannelId;", "update", "", "changes", "Lde/justsoftware/news/domain/channel/permission/ChannelPermissionChanges;", "authContext", "Lde/justsoftware/news/auth/AuthorizationContext;", "deletePermissions", "event", "Lde/justsoftware/news/events/ProfileDeletedEvent;", "Lde/justsoftware/news/events/GroupDeletedEvent;", "news-service"})
@SourceDebugExtension(value={"SMAP\nChannelPermissionService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChannelPermissionService.kt\nde/justsoftware/news/domain/channel/permission/ChannelPermissionService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,91:1\n1557#2:92\n1628#2,3:93\n1863#2,2:96\n1557#2:98\n1628#2,3:99\n1557#2:102\n1628#2,2:103\n1630#2:106\n1557#2:107\n1628#2,3:108\n1557#2:111\n1628#2,3:112\n1557#2:115\n1628#2,3:116\n1557#2:119\n1628#2,3:120\n1557#2:123\n1628#2,3:124\n1#3:105\n*S KotlinDebug\n*F\n+ 1 ChannelPermissionService.kt\nde/justsoftware/news/domain/channel/permission/ChannelPermissionService\n*L\n39#1:92\n39#1:93,3\n41#1:96,2\n46#1:98\n46#1:99,3\n47#1:102\n47#1:103,2\n47#1:106\n61#1:107\n61#1:108,3\n67#1:111\n67#1:112,3\n68#1:115\n68#1:116,3\n69#1:119\n69#1:120,3\n70#1:123\n70#1:124,3\n*E\n"})
public class ChannelPermissionService {
    @NotNull
    private final ChannelPermissionRepo channelPermissionRepo;
    @NotNull
    private final PermissionKafkaProducer permissionKafkaProducer;
    @NotNull
    private final TransactionSupport transactionSupport;
    @NotNull
    private final ApplicationEventPublisher eventPublisher;
    @NotNull
    private final ChannelRepo channelRepo;

    public ChannelPermissionService(@NotNull ChannelPermissionRepo channelPermissionRepo, @NotNull PermissionKafkaProducer permissionKafkaProducer, @NotNull TransactionSupport transactionSupport, @NotNull ApplicationEventPublisher eventPublisher, @NotNull ChannelRepo channelRepo) {
        Intrinsics.checkNotNullParameter((Object)channelPermissionRepo, (String)"channelPermissionRepo");
        Intrinsics.checkNotNullParameter((Object)permissionKafkaProducer, (String)"permissionKafkaProducer");
        Intrinsics.checkNotNullParameter((Object)transactionSupport, (String)"transactionSupport");
        Intrinsics.checkNotNullParameter((Object)eventPublisher, (String)"eventPublisher");
        Intrinsics.checkNotNullParameter((Object)channelRepo, (String)"channelRepo");
        this.channelPermissionRepo = channelPermissionRepo;
        this.permissionKafkaProducer = permissionKafkaProducer;
        this.transactionSupport = transactionSupport;
        this.eventPublisher = eventPublisher;
        this.channelRepo = channelRepo;
    }

    @Unauthorized
    @NotNull
    public List<ChannelPermission> findAllByChannelId(@NotNull ChannelId channelId) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        return this.channelPermissionRepo.findAllByChannelId(channelId);
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    public void update(@NotNull ChannelPermissionChanges changes, @NotNull AuthorizationContext authContext) {
        List list;
        void $this$mapTo$iv$iv;
        ChannelPermission origin;
        void $this$mapTo$iv$iv2;
        Iterable $this$map$iv;
        void $this$mapTo$iv$iv3;
        void $this$map$iv2;
        Object element$iv2;
        Collection<UserId> collection;
        Object item$iv$iv;
        Iterable $this$mapTo$iv$iv4;
        void $this$map$iv3;
        Intrinsics.checkNotNullParameter((Object)changes, (String)"changes");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        authContext.checkChannelAction(changes.getChannelId(), ChannelAction.MANAGE_PERMISSIONS);
        Iterable iterable = changes.getAdds();
        Object object = (ItemId)this.channelRepo.getByIdAndDeletedFalse(changes.getChannelId()).getTenantId();
        Object object2 = authContext;
        boolean $i$f$map = false;
        void var5_8 = $this$map$iv3;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv4.iterator();
        while (iterator.hasNext()) {
            void add;
            item$iv$iv = iterator.next();
            ChannelPermissionAdd channelPermissionAdd = (ChannelPermissionAdd)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(add.getGranteeId());
        }
        collection = (List)destination$iv$iv;
        object2.checkAllReader((ItemId)object, (Collection)collection);
        Iterable $this$forEach$iv = changes.getAdds();
        boolean $i$f$forEach = false;
        for (Object element$iv2 : $this$forEach$iv) {
            ChannelPermissionAdd it = (ChannelPermissionAdd)element$iv2;
            boolean bl = false;
            this.channelPermissionRepo.insert(PermissionId.Companion.random(), changes.getChannelId(), it.getGranteeId(), it.getRole());
        }
        List updatedOriginPermissions = new ArrayList();
        Iterable it = changes.getUpdates();
        object2 = this.channelPermissionRepo;
        boolean $i$f$map22 = false;
        item$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv2 : $this$mapTo$iv$iv3) {
            void it2;
            ChannelPermissionUpdate channelPermissionUpdate = (ChannelPermissionUpdate)item$iv$iv2;
            object = destination$iv$iv2;
            boolean bl = false;
            object.add(it2.getPermissionId());
        }
        Iterable iterable2 = object2.findAllById((Iterable)((List)destination$iv$iv2));
        Intrinsics.checkNotNullExpressionValue((Object)iterable2, (String)"findAllById(...)");
        element$iv2 = iterable2;
        boolean $i$f$map3 = false;
        void $i$f$map22 = $this$map$iv;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo3 = false;
        for (Object item$iv$iv3 : $this$mapTo$iv$iv2) {
            Object v1;
            block8: {
                Object item$iv$iv2;
                item$iv$iv2 = (ChannelPermission)item$iv$iv3;
                object2 = destination$iv$iv3;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)origin.getChannelId(), (Object)changes.getChannelId())) {
                    boolean $i$a$-require-ChannelPermissionService$update$updatedPermissions$2$22 = false;
                    String $i$a$-require-ChannelPermissionService$update$updatedPermissions$2$22 = "Only changes for the same channel are allowed.";
                    throw new IllegalArgumentException($i$a$-require-ChannelPermissionService$update$updatedPermissions$2$22.toString());
                }
                Intrinsics.checkNotNull((Object)origin);
                updatedOriginPermissions.add(origin);
                Iterable iterable3 = changes.getUpdates();
                for (Object t : iterable3) {
                    ChannelPermissionUpdate it3 = (ChannelPermissionUpdate)t;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it3.getPermissionId(), (Object)origin.getId())) continue;
                    v1 = t;
                    break block8;
                }
                v1 = null;
            }
            Intrinsics.checkNotNull(v1);
            PermissionRole updatedRole = ((ChannelPermissionUpdate)v1).getRole();
            object2.add(ChannelPermission.copy$default((ChannelPermission)origin, null, null, null, (PermissionRole)updatedRole, (int)7, null));
        }
        List it2 = (List)destination$iv$iv3;
        boolean $i$a$-let-ChannelPermissionService$update$updatedPermissions$42 = false;
        $this$mapTo$iv$iv4 = this.channelPermissionRepo.saveAll((Iterable)it2);
        Intrinsics.checkNotNullExpressionValue((Object)$this$mapTo$iv$iv4, (String)"let(...)");
        Iterable updatedPermissions = $this$mapTo$iv$iv4;
        Iterable iterable4 = this.channelPermissionRepo.findAllById((Iterable)changes.getDeletes());
        Intrinsics.checkNotNullExpressionValue((Object)iterable4, (String)"findAllById(...)");
        $this$map$iv = iterable4;
        $i$f$map = false;
        Iterable $i$a$-let-ChannelPermissionService$update$updatedPermissions$42 = $this$map$iv;
        destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo3 = false;
        for (Object item$iv$iv3 : $this$mapTo$iv$iv) {
            void it4;
            origin = (ChannelPermission)item$iv$iv3;
            object2 = destination$iv$iv3;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it4.getChannelId(), (Object)changes.getChannelId())) {
                boolean bl3 = false;
                String string = "Only changes for the same channel are allowed.";
                throw new IllegalArgumentException(string.toString());
            }
            object2.add(it4);
        }
        List it3 = list = (List)destination$iv$iv3;
        boolean bl = false;
        this.channelPermissionRepo.deleteAll((Iterable)it3);
        List deletedPermissions = list;
        this.transactionSupport.afterCommit(() -> ChannelPermissionService.update$lambda$14(changes, updatedOriginPermissions, updatedPermissions, deletedPermissions, this));
    }

    @EventListener
    public void deletePermissions(@NotNull ProfileDeletedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.channelPermissionRepo.deleteByGranteeId((UserId)event.getProfileId());
    }

    @EventListener
    public void deletePermissions(@NotNull GroupDeletedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.channelPermissionRepo.deleteByGranteeId((UserId)event.getUserGroupId());
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit update$lambda$14(ChannelPermissionChanges $changes, List $updatedOriginPermissions, Iterable $updatedPermissions, List $deletedPermissions, ChannelPermissionService this$0) {
        void $this$mapTo$iv$iv;
        void $this$mapTo$iv$iv2;
        void $this$mapTo$iv$iv3;
        Collection collection;
        void $this$mapTo$iv$iv4;
        Iterable $this$map$iv = $changes.getAdds();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv4) {
            void it;
            ChannelPermissionAdd channelPermissionAdd = (ChannelPermissionAdd)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new PermissionItem((ItemId)$changes.getChannelId(), it.getGranteeId(), it.getRole()));
        }
        List adds = (List)destination$iv$iv;
        Iterable $this$map$iv2 = $updatedOriginPermissions;
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Iterable destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv3) {
            void it;
            ChannelPermission bl = (ChannelPermission)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            collection.add(new PermissionItem((ItemId)$changes.getChannelId(), it.getGranteeId(), it.getRole()));
        }
        List updateOrigins = (List)destination$iv$iv2;
        Iterable $this$map$iv3 = $updatedPermissions;
        boolean $i$f$map3 = false;
        destination$iv$iv2 = $this$map$iv3;
        Iterable destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
        boolean $i$f$mapTo3 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            ChannelPermission bl2 = (ChannelPermission)item$iv$iv;
            collection = destination$iv$iv3;
            boolean bl = false;
            collection.add(new PermissionItem((ItemId)$changes.getChannelId(), it.getGranteeId(), it.getRole()));
        }
        List updates = (List)destination$iv$iv3;
        Iterable $this$map$iv4 = $deletedPermissions;
        boolean $i$f$map4 = false;
        destination$iv$iv3 = $this$map$iv4;
        Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv4, (int)10));
        boolean $i$f$mapTo4 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ChannelPermission bl = (ChannelPermission)item$iv$iv;
            collection = destination$iv$iv4;
            boolean bl3 = false;
            collection.add(new PermissionItem((ItemId)$changes.getChannelId(), it.getGranteeId(), it.getRole()));
        }
        List deletes = (List)destination$iv$iv4;
        KafkaPublishOperation[] kafkaPublishOperationArray = new KafkaPublishOperation[]{this$0.permissionKafkaProducer.deletePermissions(CollectionsKt.plus((Collection)updateOrigins, (Iterable)deletes)), this$0.permissionKafkaProducer.addPermissions(CollectionsKt.plus((Collection)updates, (Iterable)adds))};
        KafkaPublishOperation.waitForCompletion$default((KafkaPublishOperation)new KafkaPublishOperation(kafkaPublishOperationArray), null, (int)1, null);
        this$0.eventPublisher.publishEvent((ApplicationEvent)new ChannelPermissionChangedEvent($changes.getChannelId()));
        return Unit.INSTANCE;
    }
}

