/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.mobile.gateway.drive.service;

import de.justsoftware.mobile.gateway.drive.model.local.DriveId;
import de.justsoftware.mobile.gateway.drive.model.local.DriveIdType;
import de.justsoftware.mobile.gateway.drive.model.remote.ApiAddFolderData;
import de.justsoftware.mobile.gateway.drive.model.remote.ApiDocumentDetails;
import de.justsoftware.mobile.gateway.drive.model.remote.ApiFolderDetails;
import de.justsoftware.mobile.gateway.drive.model.remote.ApiShare;
import de.justsoftware.mobile.gateway.drive.model.remote.ApiShares;
import de.justsoftware.mobile.gateway.drive.service.DriveApiGatewayService$addFolder$;
import de.justsoftware.mobile.gateway.drive.service.DriveApiGatewayService$deleteDocument$;
import de.justsoftware.mobile.gateway.drive.service.DriveApiGatewayService$getDocumentDetails$;
import de.justsoftware.mobile.gateway.drive.service.DriveApiGatewayService$getFolderDetails$;
import de.justsoftware.mobile.gateway.drive.service.DriveApiGatewayService$getShare$;
import de.justsoftware.mobile.gateway.drive.service.DriveApiGatewayService$getUnauthorizedAttachmentVideoUrl$;
import de.justsoftware.mobile.gateway.drive.service.DriveApiGatewayService$subscribeToShare$;
import de.justsoftware.mobile.gateway.exception.NotFoundException;
import de.justsoftware.mobile.gateway.util.UrisKt;
import java.net.URI;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.reactive.function.client.WebClient;

@Service
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0013\b\u0017\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u0015\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\rH\u0016J \u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0016J\u0018\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u0003H\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0019H\u0016J\u0010\u0010 \u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020\u0019H\u0016J\u0010\u0010!\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020\u0003H\u0016J\u0010\u0010\"\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020\u0003H\u0016J\u0010\u0010#\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u0003H\u0016J\u0010\u0010$\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u0003H\u0016J\u0010\u0010%\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u0003H\u0012J\u0018\u0010&\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0012J\u0010\u0010'\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0012J\u0010\u0010(\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0012J \u0010)\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0012J\u0010\u0010*\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020\u0003H\u0012J\u0010\u0010+\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020\u0003H\u0012J\u0010\u0010,\u001a\u00020\t2\u0006\u0010-\u001a\u00020\u0003H\u0012J\u0010\u0010.\u001a\u00020\t2\u0006\u0010-\u001a\u00020\u0003H\u0012J\u0010\u0010/\u001a\u00020\u00032\u0006\u0010-\u001a\u00020\u0003H\u0012J\u0010\u00100\u001a\u00020\t2\u0006\u0010-\u001a\u00020\u0003H\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lde/justsoftware/mobile/gateway/drive/service/DriveApiGatewayService;", "", "driveApiUrl", "", "webClient", "Lorg/springframework/web/reactive/function/client/WebClient;", "<init>", "(Ljava/lang/String;Lorg/springframework/web/reactive/function/client/WebClient;)V", "addFolderUri", "Ljava/net/URI;", "getShare", "Lde/justsoftware/mobile/gateway/drive/model/remote/ApiShare;", "shareId", "Lde/justsoftware/mobile/gateway/drive/model/local/DriveId$Share;", "getShares", "Lde/justsoftware/mobile/gateway/drive/model/remote/ApiShares;", "offset", "", "limit", "subscribeToShare", "", "unsubscribeFromShare", "getFolderDetails", "Lde/justsoftware/mobile/gateway/drive/model/remote/ApiFolderDetails;", "folderId", "Lde/justsoftware/mobile/gateway/drive/model/local/DriveId$DriveDocument;", "addFolder", "parentFolderId", "folderName", "getDocumentDetails", "Lde/justsoftware/mobile/gateway/drive/model/remote/ApiDocumentDetails;", "documentId", "deleteDocument", "getDownloadAttachmentUri", "getDownloadAttachmentPreviewUri", "getDownloadAttachmentVideoStreamUrl", "getUnauthorizedAttachmentVideoUrl", "shareUri", "sharesUri", "subscribeToShareUri", "unsubscribeFromShareUri", "folderDetailsUri", "documentDetailsUri", "deleteDocumentUri", "downloadAttachmentUri", "id", "downloadAttachmentPreviewUri", "downloadAttachmentVideoStreamUrl", "driveAccessTokenUri", "mobile-gateway"})
@SourceDebugExtension(value={"SMAP\nDriveApiGatewayService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DriveApiGatewayService.kt\nde/justsoftware/mobile/gateway/drive/service/DriveApiGatewayService\n+ 2 WebClients.kt\nde/justsoftware/mobile/gateway/util/WebClientsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,146:1\n48#2:147\n48#2:148\n57#2:149\n57#2:150\n48#2:151\n60#2:152\n48#2:153\n91#2:154\n54#2:155\n1#3:156\n*S KotlinDebug\n*F\n+ 1 DriveApiGatewayService.kt\nde/justsoftware/mobile/gateway/drive/service/DriveApiGatewayService\n*L\n29#1:147\n35#1:148\n43#1:149\n46#1:150\n54#1:151\n67#1:152\n76#1:153\n79#1:154\n92#1:155\n*E\n"})
public class DriveApiGatewayService {
    @NotNull
    private final String driveApiUrl;
    @NotNull
    private final WebClient webClient;
    @NotNull
    private final URI addFolderUri;

    public DriveApiGatewayService(@Value(value="${just.drive.api.url}") @NotNull String driveApiUrl, @NotNull WebClient webClient) {
        Intrinsics.checkNotNullParameter((Object)driveApiUrl, (String)"driveApiUrl");
        Intrinsics.checkNotNullParameter((Object)webClient, (String)"webClient");
        this.driveApiUrl = driveApiUrl;
        this.webClient = webClient;
        this.addFolderUri = UrisKt.buildUri$default((String)(this.driveApiUrl + "/document"), null, null, (int)6, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public ApiShare getShare(@NotNull DriveId.Share shareId) {
        void $this$get$iv;
        Intrinsics.checkNotNullParameter((Object)shareId, (String)"shareId");
        WebClient webClient = this.webClient;
        URI uri$iv = this.shareUri(shareId.getFullyQualifiedId());
        boolean $i$f$get = false;
        return (ApiShare)BuildersKt.runBlocking$default(null, (Function2)((Function2)new getShare$$inlined$get$1((WebClient)$this$get$iv, uri$iv, null)), (int)1, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public ApiShares getShares(int offset, int limit) {
        void uri$iv;
        void $this$get$iv;
        WebClient webClient = this.webClient;
        URI uRI = this.sharesUri(offset, limit);
        boolean $i$f$get = false;
        return (ApiShares)BuildersKt.runBlocking$default(null, (Function2)((Function2)new /* Unavailable Anonymous Inner Class!! */), (int)1, null);
    }

    /*
     * WARNING - void declaration
     */
    public void subscribeToShare(@NotNull DriveId.Share shareId) {
        void $this$post$iv;
        Intrinsics.checkNotNullParameter((Object)shareId, (String)"shareId");
        WebClient webClient = this.webClient;
        URI uri$iv = this.subscribeToShareUri(shareId);
        boolean $i$f$post = false;
        BuildersKt.runBlocking$default(null, (Function2)((Function2)new subscribeToShare$$inlined$post$1((WebClient)$this$post$iv, uri$iv, null)), (int)1, null);
    }

    /*
     * WARNING - void declaration
     */
    public void unsubscribeFromShare(@NotNull DriveId.Share shareId) {
        void $this$post$iv;
        Intrinsics.checkNotNullParameter((Object)shareId, (String)"shareId");
        WebClient webClient = this.webClient;
        URI uri$iv = this.unsubscribeFromShareUri(shareId);
        boolean $i$f$post = false;
        BuildersKt.runBlocking$default(null, (Function2)((Function2)new /* Unavailable Anonymous Inner Class!! */), (int)1, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public ApiFolderDetails getFolderDetails(@NotNull DriveId.DriveDocument folderId, int offset, int limit) {
        void uri$iv;
        void $this$get$iv;
        Intrinsics.checkNotNullParameter((Object)folderId, (String)"folderId");
        WebClient webClient = this.webClient;
        URI uRI = this.folderDetailsUri(folderId.getId(), offset, limit);
        boolean $i$f$get = false;
        return (ApiFolderDetails)BuildersKt.runBlocking$default(null, (Function2)((Function2)new getFolderDetails$$inlined$get$1((WebClient)$this$get$iv, (URI)uri$iv, null)), (int)1, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public String addFolder(@NotNull DriveId.DriveDocument parentFolderId, @NotNull String folderName) {
        void body$iv;
        void uri$iv;
        void $this$post$iv;
        Intrinsics.checkNotNullParameter((Object)parentFolderId, (String)"parentFolderId");
        Intrinsics.checkNotNullParameter((Object)folderName, (String)"folderName");
        WebClient webClient = this.webClient;
        URI uRI = this.addFolderUri;
        ApiAddFolderData apiAddFolderData = ApiAddFolderData.Companion.apiAddFolderDataOf(parentFolderId, folderName);
        boolean $i$f$post = false;
        return (String)BuildersKt.runBlocking$default(null, (Function2)((Function2)new addFolder$$inlined$post$1((WebClient)$this$post$iv, (URI)uri$iv, (Object)body$iv, null)), (int)1, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public ApiDocumentDetails getDocumentDetails(@NotNull DriveId.DriveDocument documentId) {
        void $this$get$iv;
        Intrinsics.checkNotNullParameter((Object)documentId, (String)"documentId");
        WebClient webClient = this.webClient;
        URI uri$iv = this.documentDetailsUri(documentId.getId());
        boolean $i$f$get = false;
        return (ApiDocumentDetails)BuildersKt.runBlocking$default(null, (Function2)((Function2)new getDocumentDetails$$inlined$get$1((WebClient)$this$get$iv, uri$iv, null)), (int)1, null);
    }

    /*
     * WARNING - void declaration
     */
    public void deleteDocument(@NotNull DriveId.DriveDocument documentId) {
        void $this$delete$iv;
        Intrinsics.checkNotNullParameter((Object)documentId, (String)"documentId");
        WebClient webClient = this.webClient;
        URI uri$iv = this.deleteDocumentUri(documentId.getId());
        boolean $i$f$delete = false;
        BuildersKt.runBlocking$default(null, (Function2)((Function2)new deleteDocument$$inlined$delete$1((WebClient)$this$delete$iv, uri$iv, null)), (int)1, null);
    }

    @NotNull
    public URI getDownloadAttachmentUri(@NotNull String documentId) {
        Intrinsics.checkNotNullParameter((Object)documentId, (String)"documentId");
        return this.downloadAttachmentUri(DriveIdType.Companion.removeDriveIdType(documentId));
    }

    @NotNull
    public URI getDownloadAttachmentPreviewUri(@NotNull String documentId) {
        Intrinsics.checkNotNullParameter((Object)documentId, (String)"documentId");
        return this.downloadAttachmentPreviewUri(DriveIdType.Companion.removeDriveIdType(documentId));
    }

    @NotNull
    public String getDownloadAttachmentVideoStreamUrl(@NotNull String documentId) {
        Intrinsics.checkNotNullParameter((Object)documentId, (String)"documentId");
        return this.downloadAttachmentVideoStreamUrl(DriveIdType.Companion.removeDriveIdType(documentId));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public String getUnauthorizedAttachmentVideoUrl(@NotNull String documentId) {
        Object object;
        block3: {
            block2: {
                void $this$getOrNull$iv;
                Intrinsics.checkNotNullParameter((Object)documentId, (String)"documentId");
                Object object2 = this.webClient;
                URI uri$iv = this.driveAccessTokenUri(DriveIdType.Companion.removeDriveIdType(documentId));
                boolean $i$f$getOrNull = false;
                String string = (String)BuildersKt.runBlocking$default(null, (Function2)((Function2)new getUnauthorizedAttachmentVideoUrl$$inlined$getOrNull$1((WebClient)$this$getOrNull$iv, uri$iv, null)), (int)1, null);
                if (string == null) break block2;
                object = new char[]{'\"'};
                object2 = StringsKt.trim((String)string, (char[])object);
                if (object2 == null) break block2;
                Object accessToken = object2;
                boolean bl = false;
                object = "/drive/api/unauthenticated/previewVideoFile/" + (String)accessToken;
                if (object != null) break block3;
            }
            throw new NotFoundException("Could not get accessToken for document: " + documentId);
        }
        return object;
    }

    private URI shareUri(String shareId) {
        return UrisKt.buildUri$default((String)(this.driveApiUrl + "/shares/" + shareId + "/withSubscription"), null, null, (int)6, null);
    }

    private URI sharesUri(int offset, int limit) {
        Map map;
        Map $this$sharesUri_u24lambda_u241 = map = MapsKt.createMapBuilder();
        boolean bl = false;
        $this$sharesUri_u24lambda_u241.put("offset", offset);
        $this$sharesUri_u24lambda_u241.put("limit", limit);
        Map params = MapsKt.build((Map)map);
        return UrisKt.buildUri$default((String)(this.driveApiUrl + "/shares/page"), (Map)params, null, (int)4, null);
    }

    private URI subscribeToShareUri(DriveId.Share shareId) {
        return UrisKt.buildUri$default((String)(this.driveApiUrl + "/shares/subscriptions/" + shareId.getFullyQualifiedId() + "/subscribe"), null, null, (int)6, null);
    }

    private URI unsubscribeFromShareUri(DriveId.Share shareId) {
        return UrisKt.buildUri$default((String)(this.driveApiUrl + "/shares/subscriptions/" + shareId.getFullyQualifiedId() + "/unsubscribe"), null, null, (int)6, null);
    }

    private URI folderDetailsUri(String folderId, int offset, int limit) {
        Map map;
        Map $this$folderDetailsUri_u24lambda_u242 = map = MapsKt.createMapBuilder();
        boolean bl = false;
        $this$folderDetailsUri_u24lambda_u242.put("offset", offset);
        $this$folderDetailsUri_u24lambda_u242.put("limit", limit);
        Map params = MapsKt.build((Map)map);
        return UrisKt.buildUri$default((String)(this.driveApiUrl + "/documents/folder/" + folderId), (Map)params, null, (int)4, null);
    }

    private URI documentDetailsUri(String documentId) {
        return UrisKt.buildUri$default((String)(this.driveApiUrl + "/documents/document/" + documentId), null, null, (int)6, null);
    }

    private URI deleteDocumentUri(String documentId) {
        return UrisKt.buildUri$default((String)(this.driveApiUrl + "/documents/file/" + documentId), null, null, (int)6, null);
    }

    private URI downloadAttachmentUri(String id) {
        return UrisKt.buildUri$default((String)(this.driveApiUrl + "/documents/" + id + "/download"), null, null, (int)6, null);
    }

    private URI downloadAttachmentPreviewUri(String id) {
        return UrisKt.buildUri$default((String)(this.driveApiUrl + "/previews/previewImage/" + id + "/latest"), null, null, (int)6, null);
    }

    private String downloadAttachmentVideoStreamUrl(String id) {
        return this.driveApiUrl + "/previews/embed/" + id + "/latest";
    }

    private URI driveAccessTokenUri(String id) {
        return UrisKt.buildUri$default((String)(this.driveApiUrl + "/previews/preview/" + id + "/accessToken"), null, null, (int)6, null);
    }
}

