/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.mobile.gateway.auth.controller;

import de.justsoftware.mobile.gateway.auth.model.local.TotpInfo;
import de.justsoftware.mobile.gateway.auth.model.local.TotpSecret;
import de.justsoftware.mobile.gateway.auth.service.TotpService;
import de.justsoftware.mobile.gateway.authorization.model.AuthorizationContext;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/auth/totp"})
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\b\u0010\n\u001a\u00020\u000bH\u0017J\u0012\u0010\f\u001a\u00020\r2\b\b\u0001\u0010\u000e\u001a\u00020\u000fH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lde/justsoftware/mobile/gateway/auth/controller/TotpController;", "", "totpService", "Lde/justsoftware/mobile/gateway/auth/service/TotpService;", "<init>", "(Lde/justsoftware/mobile/gateway/auth/service/TotpService;)V", "info", "Lde/justsoftware/mobile/gateway/auth/model/local/TotpInfo;", "authContext", "Lde/justsoftware/mobile/gateway/authorization/model/AuthorizationContext;", "setup", "Lde/justsoftware/mobile/gateway/auth/model/local/TotpSecret;", "verify", "", "code", "", "mobile-gateway"})
public class TotpController {
    @NotNull
    private final TotpService totpService;

    public TotpController(@NotNull TotpService totpService) {
        Intrinsics.checkNotNullParameter((Object)totpService, (String)"totpService");
        this.totpService = totpService;
    }

    @GetMapping(value={"/info"})
    @NotNull
    public TotpInfo info(@NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.totpService.getTotpInfo(authContext);
    }

    @GetMapping(value={"/setup"})
    @NotNull
    public TotpSecret setup() {
        return this.totpService.setupNewTotpDevice();
    }

    @PutMapping(value={"/setup"})
    public void verify(@RequestParam(value="code") @NotNull String code) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        this.totpService.verifyNewTotpDevice(code);
    }
}

