/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.gateway.controller;

import de.justsoftware.gateway.controller.model.IdpMobileConfig;
import de.justsoftware.gateway.security.oauth2.ClientTarget;
import de.justsoftware.gateway.security.oauth2.JustClientRegistrationService;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.http.ResponseEntity;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping(value={"/gateway/config/idps"})
@ParametersAreNonnullByDefault
public class IdpConfigController {
    public static final String MAPPING = "/gateway/config/idps";
    private static final String DEFAULT_IDP_KEY = "default";
    private static final String JUST_IDP_KEY = "just";
    private final JustClientRegistrationService _clientRegistrationRepository;

    protected IdpConfigController(JustClientRegistrationService clientRegistrationRepository) {
        this._clientRegistrationRepository = clientRegistrationRepository;
    }

    @GetMapping(value={"/mobile"})
    @Nonnull
    public Mono<ResponseEntity<Map<String, IdpMobileConfig>>> getMobileIdpConfigsMap(@RequestParam(value="appId") String appId) {
        ClientTarget target = ClientTarget.from((String)appId);
        return this._clientRegistrationRepository.getMobileClientRegistrationForTarget(target).map(client -> {
            Map<String, IdpMobileConfig> mobileConfigMap = Map.of(DEFAULT_IDP_KEY, this.toIdpMobileConfig(client), JUST_IDP_KEY, this.toIdpMobileConfig(this._clientRegistrationRepository.getJustMobileClientRegistration()));
            return ResponseEntity.ok().body(mobileConfigMap);
        });
    }

    @Nonnull
    private IdpMobileConfig toIdpMobileConfig(ClientRegistration clientRegistration) {
        String clientId = clientRegistration.getClientId();
        Set scopes = clientRegistration.getScopes();
        String authorizationUri = clientRegistration.getProviderDetails().getAuthorizationUri();
        String tokenUri = clientRegistration.getProviderDetails().getTokenUri();
        return new IdpMobileConfig(clientId, scopes, authorizationUri, tokenUri);
    }
}

