/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.rest.file.impl;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import de.justsoftware.drive.business.file.FileLockService;
import de.justsoftware.drive.common.document.model.DocumentId;
import de.justsoftware.drive.common.file.model.FileLockBO;
import de.justsoftware.drive.rest.file.FileLockFrontendService;
import de.justsoftware.drive.rest.models.FileLock;
import de.justsoftware.drive.rest.models.Person;
import de.justsoftware.drive.rest.person.PersonFrontendService;
import java.util.Map;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class FileLockFrontendServiceImpl
implements FileLockFrontendService {
    private final FileLockService _fileLockService;
    private final PersonFrontendService _personFrontendService;

    @Autowired
    public FileLockFrontendServiceImpl(FileLockService fileLockService, PersonFrontendService personFrontendService) {
        this._fileLockService = fileLockService;
        this._personFrontendService = personFrontendService;
    }

    public ImmutableMap<DocumentId, FileLock> getFileLocks(Set<DocumentId> fileIds) {
        ImmutableMap locks = this._fileLockService.getLocks(fileIds);
        ImmutableSet personIds = FluentIterable.from((Iterable)locks.values()).transform(FileLockBO::getOwner).toSet();
        ImmutableMap persons = this._personFrontendService.getFrontendPersons((Set)personIds);
        return ImmutableMap.copyOf((Map)Maps.transformValues((Map)locks, l -> new FileLock((Person)persons.get((Object)l.getOwner()), l.getLockDate())));
    }
}

