/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.persistence.item;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import de.justsoftware.drive.common.item.model.ItemBO;
import de.justsoftware.drive.common.item.model.ItemId;
import de.justsoftware.drive.common.item.model.ItemType;
import de.justsoftware.drive.common.tenant.model.TenantId;
import de.justsoftware.drive.mybatis.DAOSupport;
import de.justsoftware.drive.persistence.item.ItemCreateModel;
import de.justsoftware.drive.persistence.item.ItemDAO;
import de.justsoftware.drive.persistence.item.ItemMapper;
import java.time.Clock;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@ParametersAreNonnullByDefault
@Repository
public class ItemDAOImpl
implements ItemDAO {
    private final DAOSupport _daoSupport;
    private final ItemMapper _itemMapper;
    private final Clock _clock;

    @Autowired
    public ItemDAOImpl(DAOSupport daoSupport, ItemMapper itemMapper, Clock clock) {
        this._daoSupport = daoSupport;
        this._itemMapper = itemMapper;
        this._clock = clock;
    }

    public void setParents(Map<ItemId, Optional<ItemId>> parents) {
        this.createItemsIfNotExist(Maps.filterValues(parents, (Predicate)Predicates.not((Predicate)Predicates.equalTo((Object)Optional.absent()))).keySet());
        parents.forEach((itemId, parent) -> this._itemMapper.updateParent(itemId, (ItemId)parent.orNull()));
    }

    public void setNames(Map<ItemId, String> names) {
        this.createItemsIfNotExist(names.keySet());
        names.forEach((arg_0, arg_1) -> ((ItemMapper)this._itemMapper).updateName(arg_0, arg_1));
    }

    public void setTenantIdIfNotExists(ItemId itemId, TenantId tenantId) {
        this._itemMapper.setTenantIdIfNotExists(itemId, tenantId);
    }

    private void createItemsIfNotExist(Set<ItemId> ids) {
        Sets.difference(ids, (Set)this.getExistingItemIds(ids)).forEach(arg_0 -> ((ItemMapper)this._itemMapper).create(arg_0));
    }

    @Nonnull
    private ImmutableSet<ItemId> getExistingItemIds(Set<ItemId> itemIds) {
        return this._daoSupport.partition(itemIds).asSet((arg_0, arg_1) -> ((ItemMapper)this._itemMapper).getExistingItemIds(arg_0, arg_1));
    }

    public ImmutableMap<ItemId, ItemBO> getItems(Set<ItemId> itemIds) {
        return (ImmutableMap)this._daoSupport.partition(itemIds).index(ItemBO::getId).asMap().query((arg_0, arg_1) -> ((ItemMapper)this._itemMapper).getItems(arg_0, arg_1));
    }

    public ImmutableSetMultimap<ItemId, ItemId> getChildren(Set<ItemId> itemIds) {
        return this._daoSupport.partition(itemIds).asSetMultimap((arg_0, arg_1) -> ((ItemMapper)this._itemMapper).getChildren(arg_0, arg_1));
    }

    public void markAsDeleted(Set<ItemId> itemIds) {
        this.createItemsIfNotExist(itemIds);
        this._daoSupport.partition(itemIds).noResult(arg_0 -> ((ItemMapper)this._itemMapper).markAsDeleted(arg_0));
    }

    public void storeItems(Map<ItemId, ItemCreateModel> items) {
        this.createItemsIfNotExist(items.keySet());
        items.values().forEach(arg_0 -> ((ItemMapper)this._itemMapper).updateItem(arg_0));
    }

    public int forAllItemsWithDocuments(int chunkSize, Consumer<List<ItemId>> consumer) {
        return this._daoSupport.forAllChunked(chunkSize, consumer, arg_0 -> ((ItemMapper)this._itemMapper).forAllItemsWithDocuments(arg_0));
    }

    public void forEachItemOfTypeWithAtLeastNChanges(ItemType type, int numberOfChanges, Consumer<ItemId> consumer) {
        this._daoSupport.forAll(consumer, itemIdResultHandler -> this._itemMapper.forEachItemOfTypeWithAtLeastNChanges(type.name(), numberOfChanges, itemIdResultHandler));
    }

    public int forAllShares(Consumer<ItemBO> shareConsumer) {
        return this._daoSupport.forAll(shareConsumer, arg_0 -> ((ItemMapper)this._itemMapper).forAllShareItems(arg_0));
    }

    public Set<ItemId> getAllShareIds(TenantId tenantId) {
        return this._itemMapper.getAllShareIds(tenantId);
    }

    public Set<ItemBO> getAllSharesForTenant(TenantId tenantId) {
        return this._itemMapper.getAllSharesForTenant(tenantId);
    }

    public Set<ItemId> getDeletedItems(Duration deletedForMoreThan) {
        return this._itemMapper.getDeletedItems(this._clock.instant().minus(deletedForMoreThan));
    }

    public Set<ItemId> filterDeleted(Set<ItemId> itemIds) {
        return this._daoSupport.partition(itemIds).asSet((arg_0, arg_1) -> ((ItemMapper)this._itemMapper).filterDeleted(arg_0, arg_1));
    }

    public void deleteItems(Set<ItemId> itemIds) {
        this._daoSupport.partition(itemIds).noResult(arg_0 -> ((ItemMapper)this._itemMapper).deleteItems(arg_0));
    }

    @Nonnull
    public Set<ItemId> filterChildFree(Set<ItemId> items) {
        return this._daoSupport.partition(items).asSet((arg_0, arg_1) -> ((ItemMapper)this._itemMapper).filterChildFree(arg_0, arg_1));
    }
}

