/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.business.thumbor.util;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.net.MediaType;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Locale;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

/*
 * Exception performing whole class analysis ignored.
 */
@ParametersAreNonnullByDefault
public class ThumborURLBuilder {
    private static final String INVALID_THUMBOR_URL_MESSAGE = "The generated Thumbor URL is not a valid URL.";
    private static final String URI_ENCODING = "UTF-8";
    private static final String DOCKER_HOST = "dockerhost";
    private static final ImmutableSet<String> LOCALHOST_NAMES = ImmutableSet.of((Object)"localhost", (Object)"127.0.0.1");
    private static final int MAXIMUM_RADIUS_FOR_GAUSSIAN_BLUR = 150;
    private static final int MAXIMUM_QUALITY_PERCENTAGE = 100;
    private final String _thumborHostname;
    private final int _port;
    private final String _imageURL;
    private final String _mimeType;
    private int _width = 0;
    private int _height = 0;
    private boolean _trim = false;
    private boolean _smart = false;
    private boolean _flipHorizontally = false;
    private boolean _flipVertically = false;
    private boolean _fitIn = false;
    private boolean _gifToStaticImage = false;
    private final SortedMap<String, ImmutableList<String>> _filtersAndParams = new TreeMap();

    public ThumborURLBuilder(String thumborHostname, int port, String imageUrl, String mimeType) {
        this._thumborHostname = thumborHostname;
        this._port = port;
        this._imageURL = imageUrl;
        this._mimeType = mimeType;
    }

    @Nonnull
    private static URL rewriteLocalhostToDockerHostIP(String rawUrl) {
        try {
            URL url = new URL(rawUrl);
            if (LOCALHOST_NAMES.contains((Object)url.getHost().toLowerCase(Locale.ENGLISH))) {
                return new URL(url.getProtocol(), "dockerhost", url.getPort(), url.getFile());
            }
            return url;
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("Unexpected error while rewriting URL host from localhost to docker host IP.", e);
        }
    }

    @Nonnull
    public ThumborURLBuilder withWidth(int width) {
        if (width < 0) {
            throw new IllegalArgumentException("Width has to be >= 0");
        }
        this._width = width;
        return this;
    }

    @Nonnull
    public ThumborURLBuilder withHeight(int height) {
        if (height < 0) {
            throw new IllegalArgumentException("Height has to be >= 0");
        }
        this._height = height;
        return this;
    }

    @Nonnull
    public ThumborURLBuilder withTrim(boolean trim) {
        this._trim = trim;
        return this;
    }

    @Nonnull
    public ThumborURLBuilder convertGifToStaticImage(boolean gifToStaticImage) {
        this._gifToStaticImage = gifToStaticImage;
        return this;
    }

    @Nonnull
    public ThumborURLBuilder withSmart(boolean smart) {
        this._smart = smart;
        return this;
    }

    @Nonnull
    public ThumborURLBuilder withFitIn(boolean fitIn) {
        this._fitIn = fitIn;
        return this;
    }

    @Nonnull
    public ThumborURLBuilder withFlipHorizontally(boolean flipHorizontally) {
        this._flipHorizontally = flipHorizontally;
        return this;
    }

    @Nonnull
    public ThumborURLBuilder withFlipVertically(boolean flipVertically) {
        this._flipVertically = flipVertically;
        return this;
    }

    @Nonnull
    public ThumborURLBuilder withExtractCoverFilter() {
        this.addFilter("extract_cover", new String[0]);
        return this;
    }

    @Nonnull
    public ThumborURLBuilder withGrayscaleFilter() {
        this.addFilter("grayscale", new String[0]);
        return this;
    }

    @Nonnull
    public ThumborURLBuilder withBlurFilter(int radius) {
        if (radius > 150) {
            throw new IllegalArgumentException("Radius of blur filter has to be <= 150");
        }
        this.addFilter("blur", new String[]{String.valueOf(radius)});
        return this;
    }

    @Nonnull
    public ThumborURLBuilder withQualityFilter(int amount) {
        if (amount < 0 || amount > 100) {
            throw new IllegalArgumentException("Amount of quality filter has to be between 0 and 100");
        }
        this.addFilter("quality", new String[]{String.valueOf(amount)});
        return this;
    }

    private void addFilter(String filtername, String ... filterParams) {
        this._filtersAndParams.put(filtername, ImmutableList.copyOf((Object[])filterParams));
    }

    private void conditionalAppend(StringBuilder destination, boolean condition, String value) {
        if (condition) {
            destination.append(value);
        }
    }

    @Nonnull
    private static String encodeUrl(String url) {
        try {
            return URLEncoder.encode(url, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("UTF-8 encoding is not supported", e);
        }
    }

    private void appendFilters(StringBuilder destination) {
        boolean hasFilters;
        boolean bl = hasFilters = this._filtersAndParams.size() > 0;
        if (hasFilters) {
            destination.append("filters");
        }
        for (Map.Entry filterAndParems : this._filtersAndParams.entrySet()) {
            destination.append(":").append(ThumborURLBuilder.encodeUrl((String)((String)filterAndParems.getKey()))).append("(").append(Joiner.on((String)",").join((Iterable)((ImmutableList)filterAndParems.getValue()).stream().map(ThumborURLBuilder::encodeUrl).collect(Collectors.toList()))).append(")");
        }
        if (hasFilters) {
            destination.append("/");
        }
    }

    @Nonnull
    public URL build() {
        if (!this._gifToStaticImage && MediaType.GIF.toString().equals(this._mimeType)) {
            try {
                return new URL(this._imageURL);
            }
            catch (MalformedURLException e) {
                throw new IllegalStateException("Unexpected error while parsing image URL.", e);
            }
        }
        StringBuilder builder = new StringBuilder("http://").append(this._thumborHostname).append(":").append(this._port).append("/");
        if (this._gifToStaticImage && MediaType.GIF.toString().equals(this._mimeType)) {
            this.withExtractCoverFilter();
        }
        this.conditionalAppend(builder, this._trim, "trim/");
        this.conditionalAppend(builder, this._fitIn, "fit-in/");
        this.conditionalAppend(builder, this._flipHorizontally, "-");
        builder.append(this._width).append("x");
        this.conditionalAppend(builder, this._flipVertically, "-");
        builder.append(this._height).append("/");
        this.conditionalAppend(builder, this._smart, "smart/");
        this.appendFilters(builder);
        builder.append(ThumborURLBuilder.rewriteLocalhostToDockerHostIP((String)this._imageURL).toString());
        try {
            return new URL(builder.toString());
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("The generated Thumbor URL is not a valid URL.", e);
        }
    }
}

