/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.business.search.impl;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import de.justsoftware.drive.business.change.ChangeService;
import de.justsoftware.drive.business.document.DocumentService;
import de.justsoftware.drive.business.file.FileService;
import de.justsoftware.drive.business.folder.CurrentVersionData;
import de.justsoftware.drive.business.folder.FolderService;
import de.justsoftware.drive.business.item.ItemReadService;
import de.justsoftware.drive.business.search.IndexerData;
import de.justsoftware.drive.business.search.SearchIndexDataService;
import de.justsoftware.drive.business.search.SearchVisibilityService;
import de.justsoftware.drive.business.search.impl.SearchIndexDataServiceImpl;
import de.justsoftware.drive.common.document.model.DocumentId;
import de.justsoftware.drive.common.document.model.PublishedFilter;
import de.justsoftware.drive.common.folder.model.FolderVersionBO;
import de.justsoftware.drive.common.item.model.ItemId;
import de.justsoftware.drive.common.item.model.ItemType;
import de.justsoftware.search.shared.model.SolrIndexType;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@ParametersAreNonnullByDefault
public class SearchIndexDataServiceImpl
implements SearchIndexDataService {
    private final FolderService _folderService;
    private final SearchVisibilityService _searchVisibilityService;
    private final ItemReadService _itemReadService;
    private final DocumentService _documentService;
    private final ChangeService _changeService;
    private final FileService _fileService;

    @Autowired
    public SearchIndexDataServiceImpl(FolderService folderService, FileService fileService, SearchVisibilityService searchVisibilityService, ItemReadService itemReadService, DocumentService documentService, ChangeService changeService) {
        this._folderService = folderService;
        this._fileService = fileService;
        this._searchVisibilityService = searchVisibilityService;
        this._itemReadService = itemReadService;
        this._documentService = documentService;
        this._changeService = changeService;
    }

    private static boolean isIndexed(FolderVersionBO f) {
        return !f.isRoot() || SearchIndexDataServiceImpl.isIndexed((ItemId)f.getItemId());
    }

    private static boolean isIndexed(ItemId itemId) {
        return ItemType.SHARE.equals((Object)itemId.getType());
    }

    @Nonnull
    private ImmutableMap<DocumentId, CurrentVersionData> getCurrentDocumentVersions(Set<DocumentId> documentsToIndex) {
        ImmutableMap publicDocuments = this._folderService.getCurrentVersionDataOfDocuments(documentsToIndex, PublishedFilter.ONLY_PUBLISHED);
        Sets.SetView missing = Sets.difference(documentsToIndex, (Set)publicDocuments.keySet());
        if (missing.isEmpty()) {
            return publicDocuments;
        }
        ImmutableMap privateDocuments = this._folderService.getCurrentVersionDataOfDocuments((Set)missing, PublishedFilter.PUBLISHED_OR_PRIVATE);
        return ImmutableMap.builder().putAll((Map)publicDocuments).putAll((Map)privateDocuments).build();
    }

    public IndexerData getIndexData(SetMultimap<DocumentId, SolrIndexType> documents) {
        return new IndexerDataImpl(this, documents);
    }
}

