/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.business.search;

import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.drive.business.authorization.PersonAuthorizationContext;
import de.justsoftware.drive.business.file.FileService;
import de.justsoftware.drive.business.folder.FolderService;
import de.justsoftware.drive.business.search.DocumentSearchException;
import de.justsoftware.drive.business.search.DocumentSearchResultBO;
import de.justsoftware.drive.business.search.DocumentSearchResultEntryBO;
import de.justsoftware.drive.business.search.DocumentSearchService;
import de.justsoftware.drive.business.search.DocumentSearchServiceImpl;
import de.justsoftware.drive.business.search.DriveSearchParameters;
import de.justsoftware.drive.business.search.SearchSortParams;
import de.justsoftware.drive.business.search.SearchUtils;
import de.justsoftware.drive.common.document.model.DocumentId;
import de.justsoftware.drive.common.document.model.DocumentVersionBO;
import de.justsoftware.drive.common.document.model.DocumentVersionId;
import de.justsoftware.drive.common.document.model.PublishedFilter;
import de.justsoftware.drive.common.tenant.model.TenantId;
import de.justsoftware.search.shared.SearchServiceInternalConnector;
import de.justsoftware.search.shared.model.SearchParam;
import de.justsoftware.search.shared.model.SearchResponse;
import de.justsoftware.search.shared.model.SearchResult;
import de.justsoftware.search.shared.model.SearchableId;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@ParametersAreNonnullByDefault
public class DocumentSearchServiceImpl
implements DocumentSearchService {
    private static final int DEFAULT_SEARCH_LIMIT = 50;
    private final FolderService _folderService;
    private final FileService _fileService;
    private final SearchServiceInternalConnector _searchServiceInternalConnector;

    @Autowired
    public DocumentSearchServiceImpl(FolderService folderService, FileService fileService, SearchServiceInternalConnector searchServiceInternalConnector) {
        this._folderService = folderService;
        this._fileService = fileService;
        this._searchServiceInternalConnector = searchServiceInternalConnector;
    }

    public DocumentSearchResultBO search(PersonAuthorizationContext authCtx, DriveSearchParameters searchParameters) throws DocumentSearchException {
        SearchParam searchParam = SearchParamBuilder.forTenant((TenantId)authCtx.getNonnullTenantId()).query(searchParameters._searchText).limit(((Integer)searchParameters._limit.or((Object)50)).intValue()).offset(((Integer)searchParameters._offset.or((Object)0)).intValue()).parentFolderId((DocumentId)searchParameters._searchInFolder.orNull()).sortParams((SearchSortParams)searchParameters._sortParams.orNull()).personId(authCtx.getPersonId()).build();
        SearchResponse searchResponse = this._searchServiceInternalConnector.search(searchParam);
        return new DocumentSearchResultBO(this.transformSearchResults(searchResponse.getResults()), searchResponse.getTotalCount());
    }

    @Nonnull
    private ImmutableList<DocumentSearchResultEntryBO> transformSearchResults(List<SearchResult> entries) {
        Set documents = entries.stream().map(result -> SearchUtils.toDocumentId((SearchableId)result.getId())).collect(Collectors.toSet());
        ImmutableMap currentVersions = this._folderService.getCurrentVersionsOfDocuments(documents, PublishedFilter.PUBLISHED_OR_PRIVATE);
        Set ids = currentVersions.values().stream().collect(Collectors.toUnmodifiableSet());
        HashMap existingDocumentVersions = new HashMap(currentVersions.size());
        existingDocumentVersions.putAll(this._fileService.getVersionsByIds(ids));
        existingDocumentVersions.putAll(this._folderService.getFolderVersionsByIds(ids));
        return (ImmutableList)entries.stream().map(input -> {
            DocumentVersionId versionId = (DocumentVersionId)currentVersions.get((Object)SearchUtils.toDocumentId((SearchableId)input.getId()));
            DocumentVersionBO documentVersionBO = (DocumentVersionBO)existingDocumentVersions.get(versionId);
            return documentVersionBO != null ? new DocumentSearchResultEntryBO(documentVersionBO, ImmutableSet.of()) : null;
        }).filter((Predicate<DocumentSearchResultEntryBO>)Predicates.notNull()).collect(ImmutableList.toImmutableList());
    }
}

