/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.business.kafka;

import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.Profile;
import org.springframework.kafka.annotation.EnableKafka;
import org.springframework.kafka.support.serializer.ErrorHandlingDeserializer;

@EnableKafka
@Configuration
@Profile(value={"!test"})
@DependsOn(value={"liquibase"})
public class KafkaConsumerConfig {
    @Value(value="${just.drive.kafka.boostrapServers:}")
    private String _bootstrapServersUrl;

    public Map<String, Object> defaultConsumerConfig() {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("bootstrap.servers", this._bootstrapServersUrl);
        props.put("key.deserializer", ErrorHandlingDeserializer.class);
        props.put("value.deserializer", ErrorHandlingDeserializer.class);
        props.put("auto.offset.reset", "earliest");
        return props;
    }
}

