/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.persistence;

import de.justsoftware.chat.persistence.model.DbChatProfileId;
import de.justsoftware.chat.persistence.model.DbChatReadDate;
import de.justsoftware.chat.persistence.model.DbChatReadDateAndCount;
import de.justsoftware.chat.persistence.model.DbUserChatUnreadCount;
import jakarta.persistence.QueryHint;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Stream;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.jpa.repository.QueryHints;
import org.springframework.stereotype.Repository;

@Repository
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\bg\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH'J\u001c\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\rH'J(\u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\u000f2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\rH\u0016J$\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\n2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\r2\u0006\u0010\u0014\u001a\u00020\u0006H'J\u001a\u0010\u0015\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0006H&J*\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00110\u000f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\r2\u0006\u0010\u0014\u001a\u00020\u0006H\u0016J,\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00130\n2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00060\r2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0017\u001a\u00020\u0006H'J,\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00130\n2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00060\r2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0017\u001a\u00020\u0006H\u0016J\u0016\u0010\u001e\u001a\u00020\u001f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\rH'J\u0016\u0010 \u001a\u00020\u001f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\rH\u0016\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006!\u00c0\u0006\u0001"}, d2={"Lde/justsoftware/chat/persistence/ChatReadDateRepository;", "Lorg/springframework/data/jpa/repository/JpaRepository;", "Lde/justsoftware/chat/persistence/model/DbChatReadDate;", "Lde/justsoftware/chat/persistence/model/DbChatProfileId;", "usersEligibleForUnreadMail", "Ljava/util/stream/Stream;", "", "sendMailNotificationDefault", "", "unreadCountsForUsersRaw", "", "Lde/justsoftware/chat/persistence/model/DbUserChatUnreadCount;", "userIds", "", "unreadCountsForUsers", "", "readDateAndCountForUserInChatsRaw", "Lde/justsoftware/chat/persistence/model/DbChatReadDateAndCount;", "chatIds", "Ljava/util/UUID;", "userId", "findByChatIdAndProfileId", "chatId", "profileId", "readDateAndCountForUserInChats", "findChatsByUpdatedAtGreaterThanAndParticipantIdsIn", "participantIds", "updatedAt", "Ljava/time/Instant;", "findChatsByUpdatedAtGreaterThanAndParticipantIds", "deleteByChatIdIn", "", "deleteByChatIds", "chat-service"})
@SourceDebugExtension(value={"SMAP\nChatReadDateRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChatReadDateRepository.kt\nde/justsoftware/chat/persistence/ChatReadDateRepository\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,165:1\n1368#2:166\n1454#2,5:167\n1485#2:172\n1510#2,3:173\n1513#2,3:183\n1368#2:186\n1454#2,5:187\n1202#2,2:192\n1230#2,4:194\n1368#2:198\n1454#2,5:199\n1863#2,2:204\n381#3,7:176\n*S KotlinDebug\n*F\n+ 1 ChatReadDateRepository.kt\nde/justsoftware/chat/persistence/ChatReadDateRepository\n*L\n77#1:166\n77#1:167,5\n78#1:172\n78#1:173,3\n78#1:183,3\n115#1:186\n115#1:187,5\n116#1:192,2\n116#1:194,4\n151#1:198\n151#1:199,5\n163#1:204,2\n78#1:176,7\n*E\n"})
public interface ChatReadDateRepository
extends JpaRepository<DbChatReadDate, DbChatProfileId> {
    @Query(value="\n        SELECT DISTINCT\n          p.id\n        FROM DbChatParticipant cp\n          LEFT JOIN DbUserGroupMember ugm ON ugm.groupId = cp.participantId\n          JOIN DbProfile p ON (p.id = cp.participantId OR p.id = ugm.profileId) \n          LEFT JOIN DbChatReadDate crd ON crd.profileId = p.id AND crd.chatId = cp.chatId\n          LEFT JOIN DbMailSettings ms ON ms.profileId = p.id\n          JOIN DbChat c ON cp.chatId = c.id\n        WHERE\n          (crd.readDate IS NULL OR c.sortDate > crd.readDate)\n          AND (ms.lastMailDeliveryDate IS NULL OR c.sortDate > ms.lastMailDeliveryDate)\n          AND ((ms.mailDeliveryEnabled IS NULL AND :sendMailNotificationDefault = true) OR ms.mailDeliveryEnabled = true)\n        ")
    @QueryHints(value={@QueryHint(value="1000", name="org.hibernate.fetchSize")})
    @NotNull
    public Stream<String> usersEligibleForUnreadMail(boolean var1);

    @Deprecated(message="Use chunked version.", replaceWith=@ReplaceWith(expression="unreadCountsForUsers(userIds)", imports={}))
    @Query(value="\n        SELECT DISTINCT\n            COALESCE(m.profileId, p.participantId) as profileId,\n            p.chatId as chatId,\n            COUNT(DISTINCT msg.id) as unreadCount,\n            MAX(CASE WHEN r.markedAsUnread THEN 1 ELSE 0 END) = 1 as markedAsUnread\n        FROM DbChatParticipant p\n            LEFT JOIN DbUserGroupMember m\n                ON m.groupId = p.participantId\n            LEFT JOIN DbChatReadDate r\n                ON (r.profileId = p.participantId OR r.profileId = m.profileId)\n                AND r.chatId = p.chatId\n            LEFT JOIN DbChatMessage msg\n                ON msg.chatId = p.chatId\n                AND msg.messageType IN ('USER_MESSAGE', 'DELETED_MESSAGE')\n                AND (r.readDate IS NULL OR msg.createdAt > r.readDate)\n        WHERE p.participantId IN :userIds OR m.profileId IN :userIds\n        GROUP BY\n            COALESCE(m.profileId, p.participantId),\n            p.chatId\n        HAVING\n            COUNT(DISTINCT msg.id) > 0\n            OR MAX(CASE WHEN r.markedAsUnread THEN 1 ELSE 0 END) = 1\n        ")
    @NotNull
    public List<DbUserChatUnreadCount> unreadCountsForUsersRaw(@NotNull Iterable<String> var1);

    /*
     * WARNING - void declaration
     */
    @NotNull
    default public Map<String, List<DbUserChatUnreadCount>> unreadCountsForUsers(@NotNull Iterable<String> userIds) {
        void $this$groupByTo$iv$iv;
        Iterable list$iv$iv;
        Iterable p0;
        Iterable $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(userIds, (String)"userIds");
        Iterable $this$flatMap$iv = CollectionsKt.chunked(userIds, (int)1000);
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            p0 = (Iterable)element$iv$iv;
            boolean $i$f$unreadCountsForUsers$stub_for_inlining = false;
            boolean bl = false;
            list$iv$iv = this.unreadCountsForUsersRaw(p0);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$groupBy$iv = (List)destination$iv$iv;
        boolean $i$f$groupBy = false;
        $this$flatMapTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            p0 = (DbUserChatUnreadCount)element$iv$iv;
            boolean $i$f$unreadCountsForUsers$stub_for_inlining$0 = false;
            boolean bl = false;
            String key$iv$iv = p0.getProfileId();
            Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        return destination$iv$iv;
    }

    @Deprecated(message="Use chunked version.", replaceWith=@ReplaceWith(expression="readDateAndCountForUserInChats(chatIds, userId)", imports={}))
    @Query(value="\n        SELECT c.id AS chatId, r.readDate AS readDate, r.markedAsUnread AS markedAsUnread, (\n            SELECT count(*)\n            FROM DbChatMessage m\n            WHERE chatId = c.id\n            AND messageType IN ('USER_MESSAGE', 'DELETED_MESSAGE')\n            AND (r.readDate IS NULL OR m.createdAt > r.readDate)\n        ) AS unreadCount, (\n            SELECT EXISTS (\n                SELECT 1\n                FROM DbChatMessage m\n                LEFT JOIN DbPersonMention pm ON pm.chatMessage.id = m.id\n                WHERE chatId = c.id\n                AND messageType IN ('USER_MESSAGE')\n                AND (r.readDate IS NULL OR m.createdAt > r.readDate)\n                AND pm.profileId = :userId)\n        ) as amIMentioned\n        FROM DbChat c\n        LEFT JOIN DbChatReadDate r ON r.chatId = c.id AND r.profileId = :userId\n        WHERE c.id IN :chatIds\n        ")
    @NotNull
    public List<DbChatReadDateAndCount> readDateAndCountForUserInChatsRaw(@NotNull Iterable<UUID> var1, @NotNull String var2);

    @Nullable
    public DbChatReadDate findByChatIdAndProfileId(@NotNull UUID var1, @NotNull String var2);

    /*
     * WARNING - void declaration
     */
    @NotNull
    default public Map<UUID, DbChatReadDateAndCount> readDateAndCountForUserInChats(@NotNull Iterable<UUID> chatIds, @NotNull String userId) {
        void $this$associateByTo$iv$iv;
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(chatIds, (String)"chatIds");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Iterable $this$flatMap$iv = CollectionsKt.chunked(chatIds, (int)1000);
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            List it = (List)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = this.readDateAndCountForUserInChatsRaw((Iterable)it, userId);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$associateBy$iv = (List)destination$iv$iv;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associateBy$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void p0;
            DbChatReadDateAndCount bl = (DbChatReadDateAndCount)element$iv$iv;
            Map map = destination$iv$iv2;
            boolean $i$f$readDateAndCountForUserInChats$stub_for_inlining$2 = false;
            boolean bl2 = false;
            map.put(p0.getChatId(), element$iv$iv);
        }
        return destination$iv$iv2;
    }

    @Deprecated(message="Use chunked version.", replaceWith=@ReplaceWith(expression="findChatsByUpdatedAtGreaterThanAndParticipantIds(participantIds, readDate)", imports={}))
    @Query(value="\n        SELECT c.id\n        FROM DbChat c \n        JOIN DbChatReadDate crd ON c.id = crd.chatId\n        WHERE crd.updatedAt > :updatedAt AND crd.profileId = :profileId\n        AND (c.type = 'MULTI_USER_CHAT' OR c.lastMessageId IS NOT NULL)\n        AND EXISTS (\n            SELECT 1\n            FROM DbChatParticipant cp\n            WHERE cp.chatId = c.id\n            AND cp.participantId IN :participantIds\n        )\n        ")
    @NotNull
    public List<UUID> findChatsByUpdatedAtGreaterThanAndParticipantIdsIn(@NotNull Iterable<String> var1, @NotNull Instant var2, @NotNull String var3);

    /*
     * WARNING - void declaration
     */
    @NotNull
    default public List<UUID> findChatsByUpdatedAtGreaterThanAndParticipantIds(@NotNull Iterable<String> participantIds, @NotNull Instant updatedAt, @NotNull String profileId) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        Intrinsics.checkNotNullParameter(participantIds, (String)"participantIds");
        Intrinsics.checkNotNullParameter((Object)updatedAt, (String)"updatedAt");
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        Iterable iterable = CollectionsKt.chunked(participantIds, (int)1000);
        boolean $i$f$flatMap = false;
        void var6_6 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            List it = (List)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = this.findChatsByUpdatedAtGreaterThanAndParticipantIdsIn((Iterable)it, updatedAt, profileId);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Deprecated(message="Use chunked version.", replaceWith=@ReplaceWith(expression="deleteByChatIds(chatIds)", imports={}))
    public void deleteByChatIdIn(@NotNull Iterable<UUID> var1);

    default public void deleteByChatIds(@NotNull Iterable<UUID> chatIds) {
        Intrinsics.checkNotNullParameter(chatIds, (String)"chatIds");
        Iterable $this$forEach$iv = CollectionsKt.chunked(chatIds, (int)1000);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Iterable p0 = (Iterable)element$iv;
            boolean $i$f$deleteByChatIds$stub_for_inlining$4 = false;
            boolean bl = false;
            this.deleteByChatIdIn(p0);
        }
    }
}

