/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.kafka.search;

import de.justsoftware.chat.business.ChatMessageService;
import de.justsoftware.chat.business.ChatParticipantService;
import de.justsoftware.chat.business.ChatService;
import de.justsoftware.chat.business.model.ChatMessage;
import de.justsoftware.chat.business.model.MultiUserChat;
import de.justsoftware.chat.business.model.UserMessage;
import de.justsoftware.chat.business.model.event.ChatCreatedEvent;
import de.justsoftware.chat.business.model.event.ChatMessageCreatedEvent;
import de.justsoftware.chat.business.model.event.ChatMessageDeletedEvent;
import de.justsoftware.chat.business.model.event.ChatParticipantsChangedEvent;
import de.justsoftware.chat.business.model.event.ChatUpdatedEvent;
import de.justsoftware.chat.business.model.event.ChatsDeletedEvent;
import de.justsoftware.chat.business.model.event.ProfileUpdatedEvent;
import de.justsoftware.chat.kafka.KafkaObjectMapper;
import de.justsoftware.chat.kafka.search.ChatCoreSearchUpdateIndexProducer;
import de.justsoftware.chat.model.ChatId;
import de.justsoftware.chat.model.ChatMessageId;
import de.justsoftware.chat.model.SearchId;
import de.justsoftware.chat.util.CollectionUtilsKt;
import de.justsoftware.kafka.client.KafkaCleaningProducer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\b\u0017\u0018\u0000 02\u00020\u0001:\u00010B3\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010\r\u001a\u00020\u000eH\u0017J\u0015\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0011\u00a2\u0006\u0002\b\u0012J\u0015\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0014H\u0011\u00a2\u0006\u0002\b\u0015J\u0015\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0017H\u0011\u00a2\u0006\u0002\b\u0018J\u0015\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u001aH\u0011\u00a2\u0006\u0002\b\u001bJ\u0015\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u001dH\u0011\u00a2\u0006\u0002\b\u001eJ\u0015\u0010\u001f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020 H\u0011\u00a2\u0006\u0002\b!J\u0015\u0010\"\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020#H\u0011\u00a2\u0006\u0002\b$J\u0010\u0010%\u001a\u00020\u000e2\u0006\u0010&\u001a\u00020'H\u0012J\u0010\u0010(\u001a\u00020\u000e2\u0006\u0010)\u001a\u00020*H\u0012J\u0018\u0010+\u001a\u00020\u000e2\u0006\u0010&\u001a\u00020'2\u0006\u0010,\u001a\u00020-H\u0012J\u001e\u0010+\u001a\u00020\u000e2\u0006\u0010&\u001a\u00020'2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020-0/H\u0012R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lde/justsoftware/chat/kafka/search/ChatCoreSearchUpdateIndexProducer;", "", "kafkaProducer", "Lde/justsoftware/kafka/client/KafkaCleaningProducer;", "", "chatService", "Lde/justsoftware/chat/business/ChatService;", "chatParticipantService", "Lde/justsoftware/chat/business/ChatParticipantService;", "chatMessageService", "Lde/justsoftware/chat/business/ChatMessageService;", "<init>", "(Lde/justsoftware/kafka/client/KafkaCleaningProducer;Lde/justsoftware/chat/business/ChatService;Lde/justsoftware/chat/business/ChatParticipantService;Lde/justsoftware/chat/business/ChatMessageService;)V", "reindexChatCore", "", "handleChatCreated", "evt", "Lde/justsoftware/chat/business/model/event/ChatCreatedEvent;", "handleChatCreated$chat_service", "handleChatUpdated", "Lde/justsoftware/chat/business/model/event/ChatUpdatedEvent;", "handleChatUpdated$chat_service", "handleChatsDeleted", "Lde/justsoftware/chat/business/model/event/ChatsDeletedEvent;", "handleChatsDeleted$chat_service", "handleChatParticipantsChanged", "Lde/justsoftware/chat/business/model/event/ChatParticipantsChangedEvent;", "handleChatParticipantsChanged$chat_service", "handleProfileUpdated", "Lde/justsoftware/chat/business/model/event/ProfileUpdatedEvent;", "handleProfileUpdated$chat_service", "handleChatMessageCreatedEvent", "Lde/justsoftware/chat/business/model/event/ChatMessageCreatedEvent;", "handleChatMessageCreatedEvent$chat_service", "handleChatMessageDeletedEvent", "Lde/justsoftware/chat/business/model/event/ChatMessageDeletedEvent;", "handleChatMessageDeletedEvent$chat_service", "indexChat", "chatId", "Lde/justsoftware/chat/model/ChatId;", "indexMessage", "message", "Lde/justsoftware/chat/business/model/ChatMessage;", "send", "searchId", "Lde/justsoftware/chat/model/SearchId;", "searchIds", "", "Companion", "chat-service"})
@SourceDebugExtension(value={"SMAP\nChatCoreSearchUpdateIndexProducer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChatCoreSearchUpdateIndexProducer.kt\nde/justsoftware/chat/kafka/search/ChatCoreSearchUpdateIndexProducer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 LoggerUtils.kt\nde/justsoftware/chat/util/LoggerUtilsKt\n*L\n1#1,116:1\n1863#2,2:117\n1863#2,2:119\n1498#2:121\n1528#2,3:122\n1531#2,3:132\n381#3,7:125\n216#4,2:135\n9#5:137\n8#5,3:138\n*S KotlinDebug\n*F\n+ 1 ChatCoreSearchUpdateIndexProducer.kt\nde/justsoftware/chat/kafka/search/ChatCoreSearchUpdateIndexProducer\n*L\n75#1:117,2\n82#1:119,2\n50#1:121\n50#1:122,3\n50#1:132,3\n50#1:125,7\n51#1:135,2\n113#1:137\n113#1:138,3\n*E\n"})
public class ChatCoreSearchUpdateIndexProducer {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final KafkaCleaningProducer<String, String> kafkaProducer;
    @NotNull
    private final ChatService chatService;
    @NotNull
    private final ChatParticipantService chatParticipantService;
    @NotNull
    private final ChatMessageService chatMessageService;
    @NotNull
    public static final String TOPIC = "just.chat-service.search.chat.updateIndex";
    @NotNull
    private static final Logger LOG;

    public ChatCoreSearchUpdateIndexProducer(@NotNull KafkaCleaningProducer<String, String> kafkaProducer, @NotNull ChatService chatService, @NotNull ChatParticipantService chatParticipantService, @NotNull ChatMessageService chatMessageService) {
        Intrinsics.checkNotNullParameter(kafkaProducer, (String)"kafkaProducer");
        Intrinsics.checkNotNullParameter((Object)chatService, (String)"chatService");
        Intrinsics.checkNotNullParameter((Object)chatParticipantService, (String)"chatParticipantService");
        Intrinsics.checkNotNullParameter((Object)chatMessageService, (String)"chatMessageService");
        this.kafkaProducer = kafkaProducer;
        this.chatService = chatService;
        this.chatParticipantService = chatParticipantService;
        this.chatMessageService = chatMessageService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(readOnly=true)
    public void reindexChatCore() {
        long start = System.currentTimeMillis();
        LOG.info("Start to fill the index kafka topic with chatIds...");
        Ref.IntRef chatCount = new Ref.IntRef();
        AutoCloseable autoCloseable = this.chatService.streamAllIds();
        Throwable throwable = null;
        try {
            Stream chatIds = (Stream)autoCloseable;
            boolean bl = false;
            chatIds.peek(arg_0 -> ChatCoreSearchUpdateIndexProducer.reindexChatCore$lambda$7$lambda$1(arg_0 -> ChatCoreSearchUpdateIndexProducer.reindexChatCore$lambda$7$lambda$0(chatCount, arg_0), arg_0)).forEach(arg_0 -> ChatCoreSearchUpdateIndexProducer.reindexChatCore$lambda$7$lambda$2((Function1)new /* Unavailable Anonymous Inner Class!! */, arg_0));
            LOG.info("Filling chatIds into index kafka topic finished. Start to fill the index kafka topic with chatMessageIds...");
            Ref.IntRef messageCount = new Ref.IntRef();
            CollectionUtilsKt.chunked((Stream)this.chatMessageService.streamAllUserMessageIds(), (int)1000).forEach(arg_0 -> ChatCoreSearchUpdateIndexProducer.reindexChatCore$lambda$7$lambda$6(arg_0 -> ChatCoreSearchUpdateIndexProducer.reindexChatCore$lambda$7$lambda$5(messageCount, this, arg_0), arg_0));
            LOG.info("Filling chatMessageIds into index kafka topic finished.\n" + chatCount.element + " chatIds was written into index kafka topic.\n" + messageCount.element + " chatMessageIds was written into index kafka topic.\nFilling kafka topic took " + (System.currentTimeMillis() - start) + " ms.");
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    @EventListener
    public void handleChatCreated$chat_service(@NotNull ChatCreatedEvent evt) {
        Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
        if (evt.getChat() instanceof MultiUserChat) {
            this.indexChat(evt.getChatId());
        }
    }

    @EventListener
    public void handleChatUpdated$chat_service(@NotNull ChatUpdatedEvent evt) {
        Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
        this.indexChat(evt.getChatId());
    }

    @EventListener
    public void handleChatsDeleted$chat_service(@NotNull ChatsDeletedEvent evt) {
        Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
        Iterable $this$forEach$iv = evt.getChatIds();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ChatId p0 = (ChatId)element$iv;
            boolean $i$f$handleChatsDeleted$stub_for_inlining$8 = false;
            boolean bl = false;
            this.indexChat(p0);
        }
    }

    @EventListener
    public void handleChatParticipantsChanged$chat_service(@NotNull ChatParticipantsChangedEvent evt) {
        Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
        this.indexChat(evt.getChatId());
    }

    @EventListener
    public void handleProfileUpdated$chat_service(@NotNull ProfileUpdatedEvent evt) {
        Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
        Iterable $this$forEach$iv = this.chatParticipantService.findOneOnOneChatIdsByProfileId(evt.getProfileId());
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ChatId p0 = (ChatId)element$iv;
            boolean $i$f$handleProfileUpdated$stub_for_inlining$9 = false;
            boolean bl = false;
            this.indexChat(p0);
        }
    }

    @EventListener
    public void handleChatMessageCreatedEvent$chat_service(@NotNull ChatMessageCreatedEvent evt) {
        Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
        if (evt.getChatMessage() instanceof UserMessage) {
            this.indexMessage(evt.getChatMessage());
        }
    }

    @EventListener
    public void handleChatMessageDeletedEvent$chat_service(@NotNull ChatMessageDeletedEvent evt) {
        Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
        this.send(evt.getChat().getId(), (SearchId)evt.getChatMessageId());
    }

    private void indexChat(ChatId chatId) {
        this.send(chatId, (SearchId)chatId);
    }

    private void indexMessage(ChatMessage message) {
        this.send(message.getChatId(), (SearchId)message.getId());
    }

    private void send(ChatId chatId, SearchId searchId) {
        this.send(chatId, SetsKt.setOf((Object)searchId));
    }

    private void send(ChatId chatId, Set<? extends SearchId> searchIds) {
        this.kafkaProducer.send(new ProducerRecord(TOPIC, (Object)chatId.toCanonicalId(), (Object)KafkaObjectMapper.INSTANCE.writeValueAsString(searchIds)));
    }

    private static final Unit reindexChatCore$lambda$7$lambda$0(Ref.IntRef $chatCount, ChatId it) {
        int n = $chatCount.element;
        $chatCount.element = n + 1;
        return Unit.INSTANCE;
    }

    private static final void reindexChatCore$lambda$7$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void reindexChatCore$lambda$7$lambda$2(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit reindexChatCore$lambda$7$lambda$5(Ref.IntRef $messageCount, ChatCoreSearchUpdateIndexProducer this$0, List chatMessages) {
        void $this$groupByTo$iv$iv;
        Intrinsics.checkNotNull((Object)chatMessages);
        Iterable $this$groupBy$iv = chatMessages;
        boolean $i$f$groupBy = false;
        Object object = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            void p0;
            Object object2;
            Pair p02 = (Pair)element$iv$iv;
            boolean $i$a$-groupBy-ChatCoreSearchUpdateIndexProducer$reindexChatCore$1$3$32 = false;
            boolean $i$f$reindexChatCore$lambda$7$lambda$5$stub_for_inlining = false;
            ChatId key$iv$iv = (ChatId)p02.getFirst();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object2 = answer$iv$iv$iv;
            } else {
                object2 = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object2;
            Pair $i$a$-groupBy-ChatCoreSearchUpdateIndexProducer$reindexChatCore$1$3$32 = (Pair)element$iv$iv;
            List list = list$iv$iv;
            boolean bl = false;
            boolean $i$f$reindexChatCore$lambda$7$lambda$5$stub_for_inlining$3 = false;
            list.add((ChatMessageId)p0.getSecond());
        }
        Map $this$forEach$iv = destination$iv$iv;
        boolean $i$f$forEach = false;
        object = $this$forEach$iv.entrySet().iterator();
        while (object.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = (Map.Entry)object.next();
            boolean bl = false;
            ChatId chatId = (ChatId)entry.getKey();
            List messageIds = (List)entry.getValue();
            this$0.send(chatId, CollectionsKt.toSet((Iterable)messageIds));
        }
        LOG.info(chatMessages.size() + " chatMessageIds was written into index kafka topic...");
        $messageCount.element += chatMessages.size();
        return Unit.INSTANCE;
    }

    private static final void reindexChatCore$lambda$7$lambda$6(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ void access$indexChat(ChatCoreSearchUpdateIndexProducer $this, ChatId chatId) {
        $this.indexChat(chatId);
    }

    static {
        Companion $this$logger$iv = Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = LoggerFactory.getLogger(Reflection.getOrCreateKotlinClass(Companion.class).isCompanion() ? Companion.class.getEnclosingClass() : Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOG = logger;
    }
}

