/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.config;

import de.justsoftware.chat.config.ChatConfigProperties;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@ConfigurationProperties(prefix="just.chat")
@Configuration
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\b\u0017\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0012\u0010\u0010\u001a\u00020\n2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0005H\u0016J\n\u0010\u0012\u001a\u0004\u0018\u00010\u0005H\u0016J\u0012\u0010\u0013\u001a\u00020\n2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0005H\u0016J\u0016\u0010\u0014\u001a\u00020\n2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016J\b\u0010\u0016\u001a\u00020\fH\u0016J\u0017\u0010\u0017\u001a\u00020\n2\b\u0010\u0018\u001a\u0004\u0018\u00010\fH\u0016\u00a2\u0006\u0002\u0010\u0019R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0092\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0005X\u0092\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\bX\u0092\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0092\u000e\u00a2\u0006\u0004\n\u0002\u0010\r\u00a8\u0006\u001b"}, d2={"Lde/justsoftware/chat/config/ChatConfigProperties;", "", "<init>", "()V", "cleanupAfter", "", "mailCron", "mailCronListeners", "", "Lkotlin/Function0;", "", "defaultEmailNotificationEnabled", "", "Ljava/lang/Boolean;", "getCleanupAfter", "Ljava/time/Duration;", "setCleanupAfter", "expression", "getMailCron", "setMailCron", "addMailCronListener", "listener", "getDefaultEmailNotificationEnabled", "setDefaultEmailNotificationEnabled", "value", "(Ljava/lang/Boolean;)V", "Companion", "chat-service"})
@SourceDebugExtension(value={"SMAP\nChatConfigProperties.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChatConfigProperties.kt\nde/justsoftware/chat/config/ChatConfigProperties\n+ 2 TimeUtils.kt\nde/justsoftware/chat/util/TimeUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,54:1\n19#2:55\n20#2:58\n19#2:59\n1863#3,2:56\n*S KotlinDebug\n*F\n+ 1 ChatConfigProperties.kt\nde/justsoftware/chat/config/ChatConfigProperties\n*L\n22#1:55\n51#1:58\n51#1:59\n35#1:56,2\n*E\n"})
public class ChatConfigProperties {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private String cleanupAfter;
    @Nullable
    private String mailCron;
    @NotNull
    private List<Function0<Unit>> mailCronListeners = new ArrayList();
    @Nullable
    private Boolean defaultEmailNotificationEnabled;
    @NotNull
    private static final Duration DEFAULT_CLEANUP_AFTER;

    @NotNull
    public Duration getCleanupAfter() {
        Duration cleanupAfterDays;
        Duration duration;
        Duration duration2;
        String string = this.cleanupAfter;
        if (string != null) {
            long $this$days$iv = Long.parseLong(string, CharsKt.checkRadix((int)10));
            boolean $i$f$getDays = false;
            Duration duration3 = Duration.ofDays($this$days$iv);
            duration2 = duration3;
            Intrinsics.checkNotNullExpressionValue((Object)duration3, (String)"ofDays(...)");
        } else {
            duration2 = null;
        }
        if ((duration = (cleanupAfterDays = duration2)) == null) {
            duration = DEFAULT_CLEANUP_AFTER;
        }
        return duration;
    }

    public void setCleanupAfter(@Nullable String expression) {
        this.cleanupAfter = expression;
    }

    @Nullable
    public String getMailCron() {
        return this.mailCron;
    }

    public void setMailCron(@Nullable String expression) {
        if (Intrinsics.areEqual((Object)this.mailCron, (Object)expression)) {
            return;
        }
        this.mailCron = expression;
        Iterable $this$forEach$iv = this.mailCronListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Function0 it = (Function0)element$iv;
            boolean bl = false;
            it.invoke();
        }
    }

    public void addMailCronListener(@NotNull Function0<Unit> listener) {
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        this.mailCronListeners.add(listener);
    }

    public boolean getDefaultEmailNotificationEnabled() {
        Boolean bl = this.defaultEmailNotificationEnabled;
        return bl != null ? bl : false;
    }

    public void setDefaultEmailNotificationEnabled(@Nullable Boolean value) {
        this.defaultEmailNotificationEnabled = value;
    }

    static {
        int $this$days$iv = 90;
        boolean $i$f$getDays = false;
        long $this$days$iv$iv = $this$days$iv;
        boolean $i$f$getDays2 = false;
        Duration duration = Duration.ofDays($this$days$iv$iv);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofDays(...)");
        DEFAULT_CLEANUP_AFTER = duration;
    }
}

