/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.authorization.config;

import de.justsoftware.authorization.oauth2.TokenCleanupScheduler;
import de.justsoftware.authorization.oauth2.client.OauthTokenService;
import de.justsoftware.authorization.token.RememberMeTokenRepository;
import java.time.Duration;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableScheduling;

@EnableScheduling
@ConditionalOnProperty(value={"just.auth.scheduledJobs.enabled"}, havingValue="true", matchIfMissing=false)
@Configuration
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0001\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0001\u0010\f\u001a\u00020\tH\u0017\u00a8\u0006\r"}, d2={"Lde/justsoftware/authorization/config/ScheduledJobsConfiguration;", "", "<init>", "()V", "tokenCleanupScheduler", "Lde/justsoftware/authorization/oauth2/TokenCleanupScheduler;", "tokenService", "Lde/justsoftware/authorization/oauth2/client/OauthTokenService;", "oauthTokensExpiredSince", "Ljava/time/Duration;", "rememberMeTokenRepository", "Lde/justsoftware/authorization/token/RememberMeTokenRepository;", "rememberMeTokensExpiredSince", "just-authorization-server"})
public class ScheduledJobsConfiguration {
    @Bean
    @NotNull
    public TokenCleanupScheduler tokenCleanupScheduler(@NotNull OauthTokenService tokenService, @Value(value="${just.auth.scheduledJobs.cleanupOauthTokensAfter}") @NotNull Duration oauthTokensExpiredSince, @NotNull RememberMeTokenRepository rememberMeTokenRepository, @Value(value="${just.auth.scheduledJobs.cleanupRememberMeTokensAfter}") @NotNull Duration rememberMeTokensExpiredSince) {
        Intrinsics.checkNotNullParameter((Object)tokenService, (String)"tokenService");
        Intrinsics.checkNotNullParameter((Object)oauthTokensExpiredSince, (String)"oauthTokensExpiredSince");
        Intrinsics.checkNotNullParameter((Object)rememberMeTokenRepository, (String)"rememberMeTokenRepository");
        Intrinsics.checkNotNullParameter((Object)rememberMeTokensExpiredSince, (String)"rememberMeTokensExpiredSince");
        return new TokenCleanupScheduler(tokenService, oauthTokensExpiredSince, rememberMeTokenRepository, rememberMeTokensExpiredSince);
    }
}

