/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.admin.mybatis.mapper;

import de.justsoftware.admin.domain.appsettings.model.AppPlacement;
import de.justsoftware.admin.id.AppId;
import de.justsoftware.admin.id.TenantId;
import de.justsoftware.admin.id.UserId;
import java.util.Set;
import kotlin.Metadata;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Select;
import org.jetbrains.annotations.NotNull;

@Mapper
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\bg\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H'J\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00072\u0006\u0010\b\u001a\u00020\tH'J\u0010\u0010\n\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H'J\u0010\u0010\u000b\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\tH'J\u0010\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000eH'J\u0010\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0011H'\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0012\u00c0\u0006\u0001"}, d2={"Lde/justsoftware/admin/mybatis/mapper/AppPlacementMapper;", "", "upsert", "", "appPlacement", "Lde/justsoftware/admin/domain/appsettings/model/AppPlacement;", "getByAppId", "", "appId", "Lde/justsoftware/admin/id/AppId;", "delete", "deleteByAppId", "deleteByUserId", "userId", "Lde/justsoftware/admin/id/UserId;", "deleteByTenant", "tenantId", "Lde/justsoftware/admin/id/TenantId;", "admin-service"})
public interface AppPlacementMapper {
    @Insert(value={"\n        <script>\n            <if test=\"_databaseId == 'POSTGRES'\">\n                INSERT INTO app_placement (app_id, user_id, type, tenant_id)\n                    VALUES (#{appId}, #{userId}, #{type}, #{tenantId})\n                ON CONFLICT(app_id, user_id) DO UPDATE SET\n                    type = #{type}\n            </if>\n\n            <if test=\"_databaseId == 'ORACLE'\">\n                MERGE INTO app_placement placement\n                    USING (SELECT #{appId} as appId, #{userId} as userId from dual) a\n                        ON (a.appId = placement.app_id AND a.userId = placement.user_id)\n                        WHEN MATCHED THEN UPDATE SET \n                            type = #{type}\n                        WHEN NOT MATCHED THEN\n                            INSERT (app_id, user_id, type, tenant_id)\n                            VALUES (#{appId}, #{userId}, #{type}, #{tenantId})\n            </if>\n        </script>\n        "})
    public void upsert(@NotNull AppPlacement var1);

    @Select(value={"Select app_id, user_id, type, tenant_id FROM app_placement WHERE app_id = #{appId}"})
    @NotNull
    public Set<AppPlacement> getByAppId(@NotNull AppId var1);

    @Delete(value={"DELETE FROM app_placement WHERE app_id = #{appId} AND user_id = #{userId}"})
    public void delete(@NotNull AppPlacement var1);

    @Delete(value={"DELETE FROM app_placement WHERE app_id = #{appId}"})
    public void deleteByAppId(@NotNull AppId var1);

    @Delete(value={"DELETE FROM app_placement WHERE user_id = #{userId}"})
    public void deleteByUserId(@NotNull UserId var1);

    @Delete(value={"DELETE FROM app_placement WHERE tenant_id = #{tenantId}"})
    public void deleteByTenant(@NotNull TenantId var1);
}

