/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.admin.kafka.publisher.producer;

import de.justsoftware.admin.domain.appsettings.model.AppPlacement;
import de.justsoftware.admin.domain.appsettings.model.AppSettings;
import de.justsoftware.admin.domain.appsettings.model.CoreAppSettings;
import de.justsoftware.admin.domain.appsettings.model.ExternalAppSettings;
import de.justsoftware.admin.id.AppId;
import de.justsoftware.admin.kafka.publisher.model.KafkaPublishOperation;
import de.justsoftware.admin.kafka.publisher.producer.AppPositionUpdateKafkaDto;
import de.justsoftware.admin.kafka.publisher.producer.CoreAppConfigKafkaDto;
import de.justsoftware.admin.kafka.publisher.producer.ExternalAppConfigKafkaDto;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B%\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ#\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0010\u00a2\u0006\u0002\b\u0010J#\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0010\u00a2\u0006\u0002\b\u0014J\u001b\u0010\u0015\u001a\u00020\n2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u000eH\u0010\u00a2\u0006\u0002\b\u0018J\u0015\u0010\u0019\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u001bH\u0010\u00a2\u0006\u0002\b\u001cR\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lde/justsoftware/admin/kafka/publisher/producer/AppSettingsProducer;", "", "kafkaTemplate", "Lorg/springframework/kafka/core/KafkaTemplate;", "", "log", "Lorg/slf4j/Logger;", "<init>", "(Lorg/springframework/kafka/core/KafkaTemplate;Lorg/slf4j/Logger;)V", "publishCoreAppConfig", "Lde/justsoftware/admin/kafka/publisher/model/KafkaPublishOperation;", "coreAppSettings", "Lde/justsoftware/admin/domain/appsettings/model/CoreAppSettings;", "placements", "", "Lde/justsoftware/admin/domain/appsettings/model/AppPlacement;", "publishCoreAppConfig$admin_service", "publishExternalAppConfig", "externalApp", "Lde/justsoftware/admin/domain/appsettings/model/ExternalAppSettings;", "publishExternalAppConfig$admin_service", "publishPositionsUpdate", "apps", "Lde/justsoftware/admin/domain/appsettings/model/AppSettings;", "publishPositionsUpdate$admin_service", "publishDeletedAppConfig", "id", "Lde/justsoftware/admin/id/AppId;", "publishDeletedAppConfig$admin_service", "admin-service"})
@SourceDebugExtension(value={"SMAP\nAppSettingsProducer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AppSettingsProducer.kt\nde/justsoftware/admin/kafka/publisher/producer/AppSettingsProducer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,188:1\n1#2:189\n*E\n"})
public class AppSettingsProducer {
    @NotNull
    private final KafkaTemplate<String, String> kafkaTemplate;
    @NotNull
    private final Logger log;

    public AppSettingsProducer(@NotNull KafkaTemplate<String, String> kafkaTemplate, @NotNull Logger log) {
        Intrinsics.checkNotNullParameter(kafkaTemplate, (String)"kafkaTemplate");
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        this.kafkaTemplate = kafkaTemplate;
        this.log = log;
    }

    public /* synthetic */ AppSettingsProducer(KafkaTemplate kafkaTemplate, Logger logger, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            logger = LoggerFactory.getLogger(AppSettingsProducer.class);
        }
        this(kafkaTemplate, logger);
    }

    @NotNull
    public KafkaPublishOperation publishCoreAppConfig$admin_service(@NotNull CoreAppSettings coreAppSettings, @NotNull Collection<? extends AppPlacement> placements) {
        Intrinsics.checkNotNullParameter((Object)coreAppSettings, (String)"coreAppSettings");
        Intrinsics.checkNotNullParameter(placements, (String)"placements");
        this.log.debug("Sending core app '{}' to topic '{}'", (Object)coreAppSettings.getId(), (Object)"just.appConfig");
        CompletableFuture it = this.kafkaTemplate.send(new ProducerRecord("just.appConfig", (Object)coreAppSettings.getId().toTypedString(), (Object)CoreAppConfigKafkaDto.Companion.from(coreAppSettings, placements).toJsonString()));
        boolean bl = false;
        Intrinsics.checkNotNull((Object)it);
        return new KafkaPublishOperation(it);
    }

    @NotNull
    public KafkaPublishOperation publishExternalAppConfig$admin_service(@NotNull ExternalAppSettings externalApp, @NotNull Collection<? extends AppPlacement> placements) {
        Intrinsics.checkNotNullParameter((Object)externalApp, (String)"externalApp");
        Intrinsics.checkNotNullParameter(placements, (String)"placements");
        this.log.debug("Sending external app '{}' to topic '{}'", (Object)externalApp.getId(), (Object)"just.appConfig");
        CompletableFuture it = this.kafkaTemplate.send(new ProducerRecord("just.appConfig", (Object)externalApp.getId().toTypedString(), (Object)ExternalAppConfigKafkaDto.Companion.from(externalApp, placements).toJsonString()));
        boolean bl = false;
        Intrinsics.checkNotNull((Object)it);
        return new KafkaPublishOperation(it);
    }

    @NotNull
    public KafkaPublishOperation publishPositionsUpdate$admin_service(@NotNull Collection<? extends AppSettings> apps) {
        Intrinsics.checkNotNullParameter(apps, (String)"apps");
        this.log.debug("Sending positions-update: '{}' to topic: '{}'", (Object)"APP_POSITION_UPDATE", (Object)"just.appConfig");
        CompletableFuture it = this.kafkaTemplate.send(new ProducerRecord("just.appConfig", (Object)"APP_POSITION_UPDATE", (Object)AppPositionUpdateKafkaDto.Companion.from(apps).toJsonString()));
        boolean bl = false;
        Intrinsics.checkNotNull((Object)it);
        return new KafkaPublishOperation(it);
    }

    @NotNull
    public KafkaPublishOperation publishDeletedAppConfig$admin_service(@NotNull AppId id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.log.debug("Sending app '{}' to topic '{}' with null message.", (Object)id, (Object)"just.appConfig");
        CompletableFuture completableFuture = this.kafkaTemplate.send("just.appConfig", (Object)id.toTypedString(), null);
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"send(...)");
        return new KafkaPublishOperation(completableFuture);
    }
}

