/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.admin.graphql.dataFetchers;

import com.netflix.graphql.dgs.DgsComponent;
import com.netflix.graphql.dgs.DgsDataFetchingEnvironment;
import com.netflix.graphql.dgs.DgsMutation;
import com.netflix.graphql.dgs.InputArgument;
import com.netflix.graphql.dgs.context.DgsContext;
import de.justsoftware.admin.authorization.AuthorizationContext;
import de.justsoftware.admin.connector.chat.ChatApiConnector;
import de.justsoftware.admin.connector.drive.DriveApiConnector;
import de.justsoftware.admin.connector.people.PeopleConnector;
import de.justsoftware.admin.connector.search.SearchApiConnector;
import de.justsoftware.admin.graphql.dataFetchers.SearchFetcher;
import de.justsoftware.admin.graphql.generated.types.ReindexType;
import de.justsoftware.search.shared.model.JustApp;
import de.justsoftware.search.shared.model.SearchType;
import graphql.schema.DataFetchingEnvironment;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@DgsComponent
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001a\u0010\f\u001a\u00020\r2\b\b\u0001\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J\u0010\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0014H\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lde/justsoftware/admin/graphql/dataFetchers/SearchFetcher;", "", "searchApiConnector", "Lde/justsoftware/admin/connector/search/SearchApiConnector;", "driveApiConnector", "Lde/justsoftware/admin/connector/drive/DriveApiConnector;", "peopleConnector", "Lde/justsoftware/admin/connector/people/PeopleConnector;", "chatApiConnector", "Lde/justsoftware/admin/connector/chat/ChatApiConnector;", "<init>", "(Lde/justsoftware/admin/connector/search/SearchApiConnector;Lde/justsoftware/admin/connector/drive/DriveApiConnector;Lde/justsoftware/admin/connector/people/PeopleConnector;Lde/justsoftware/admin/connector/chat/ChatApiConnector;)V", "reindex", "", "input", "Lde/justsoftware/admin/graphql/generated/types/ReindexType;", "dfe", "Lcom/netflix/graphql/dgs/DgsDataFetchingEnvironment;", "reindexSearchByAppName", "app", "Lde/justsoftware/search/shared/model/JustApp;", "admin-service"})
@SourceDebugExtension(value={"SMAP\nSearchFetcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SearchFetcher.kt\nde/justsoftware/admin/graphql/dataFetchers/SearchFetcher\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,53:1\n1734#2,3:54\n*S KotlinDebug\n*F\n+ 1 SearchFetcher.kt\nde/justsoftware/admin/graphql/dataFetchers/SearchFetcher\n*L\n49#1:54,3\n*E\n"})
public class SearchFetcher {
    @NotNull
    private final SearchApiConnector searchApiConnector;
    @NotNull
    private final DriveApiConnector driveApiConnector;
    @NotNull
    private final PeopleConnector peopleConnector;
    @NotNull
    private final ChatApiConnector chatApiConnector;

    public SearchFetcher(@NotNull SearchApiConnector searchApiConnector, @NotNull DriveApiConnector driveApiConnector, @NotNull PeopleConnector peopleConnector, @NotNull ChatApiConnector chatApiConnector) {
        Intrinsics.checkNotNullParameter((Object)searchApiConnector, (String)"searchApiConnector");
        Intrinsics.checkNotNullParameter((Object)driveApiConnector, (String)"driveApiConnector");
        Intrinsics.checkNotNullParameter((Object)peopleConnector, (String)"peopleConnector");
        Intrinsics.checkNotNullParameter((Object)chatApiConnector, (String)"chatApiConnector");
        this.searchApiConnector = searchApiConnector;
        this.driveApiConnector = driveApiConnector;
        this.peopleConnector = peopleConnector;
        this.chatApiConnector = chatApiConnector;
    }

    @DgsMutation(field="reindex")
    public boolean reindex(@InputArgument @NotNull ReindexType input, @NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        AuthorizationContext authContext = (AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)dfe);
        authContext.checkSuperAdmin();
        return switch (WhenMappings.$EnumSwitchMapping$0[input.ordinal()]) {
            case 1 -> this.searchApiConnector.reindexAll();
            case 2 -> this.reindexSearchByAppName(JustApp.PEOPLE);
            case 3 -> this.reindexSearchByAppName(JustApp.NEWS);
            case 4 -> this.reindexSearchByAppName(JustApp.CHAT);
            case 5 -> this.reindexSearchByAppName(JustApp.WIKI);
            case 6 -> this.reindexSearchByAppName(JustApp.DRIVE);
            case 7 -> this.driveApiConnector.reindexDriveMetadata();
            case 8 -> this.peopleConnector.reindexAllUserGroups();
            case 9 -> this.chatApiConnector.reindexChatCore();
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private boolean reindexSearchByAppName(JustApp app) {
        boolean bl;
        block3: {
            List searchTypes = SearchType.Companion.getByAppName(app);
            Iterable $this$all$iv = searchTypes;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    SearchType it = (SearchType)element$iv;
                    boolean bl2 = false;
                    if (this.searchApiConnector.reindex(it)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }
}

