/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.admin.domain.tenant;

import de.justsoftware.admin.domain.tenant.model.TenantInvitation;
import de.justsoftware.admin.domain.tenant.persistence.TenantInvitationRepository;
import de.justsoftware.admin.id.TenantId;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lde/justsoftware/admin/domain/tenant/TenantInvitationService;", "", "tenantInvitationRepo", "Lde/justsoftware/admin/domain/tenant/persistence/TenantInvitationRepository;", "<init>", "(Lde/justsoftware/admin/domain/tenant/persistence/TenantInvitationRepository;)V", "getTenantInvitations", "", "Lde/justsoftware/admin/domain/tenant/model/TenantInvitation;", "tenantId", "Lde/justsoftware/admin/id/TenantId;", "setTenantInvitationActive", "", "isTenantInvitationActive", "", "admin-service"})
public class TenantInvitationService {
    @NotNull
    private final TenantInvitationRepository tenantInvitationRepo;

    public TenantInvitationService(@NotNull TenantInvitationRepository tenantInvitationRepo) {
        Intrinsics.checkNotNullParameter((Object)tenantInvitationRepo, (String)"tenantInvitationRepo");
        this.tenantInvitationRepo = tenantInvitationRepo;
    }

    @NotNull
    public List<TenantInvitation> getTenantInvitations(@NotNull TenantId tenantId) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        return this.tenantInvitationRepo.getAllByTenant(tenantId);
    }

    public void setTenantInvitationActive(@NotNull TenantId tenantId, boolean isTenantInvitationActive) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        List existingInvitations = this.tenantInvitationRepo.getAllByTenant(tenantId);
        if (existingInvitations.isEmpty() && isTenantInvitationActive) {
            String string = UUID.randomUUID().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            this.tenantInvitationRepo.upsertTenantInvitation(tenantId, string);
        } else if (!((Collection)existingInvitations).isEmpty() && !isTenantInvitationActive) {
            this.tenantInvitationRepo.deleteAllTenantInvitations(tenantId);
        }
    }
}

