/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.admin.connector.permission;

import com.google.common.collect.ImmutableMap;
import de.justsoftware.admin.authorization.exceptions.NotAllowedException;
import de.justsoftware.admin.connector.permission.PermissionConnector;
import de.justsoftware.admin.connector.permission.PermissionConnectorKt;
import de.justsoftware.admin.exceptions.NotAuthorizedException;
import de.justsoftware.admin.id.ItemId;
import de.justsoftware.admin.id.UserId;
import de.justsoftware.permission.client.model.AuthorizationResult;
import de.justsoftware.permission.client.model.Role;
import de.justsoftware.permission.client.rest.PermissionRequestConnector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 !2\u00020\u0001:\u0001!B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J*\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00070\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\u000e2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\u000f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J*\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00070\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\u000e2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\u0010\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001e\u0010\u0014\u001a\u00020\u00122\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\t0\u000e2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001e\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\t2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000eH\u0016J\u0018\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001e\u0010\u0019\u001a\u00020\u00122\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\t0\u000e2\u0006\u0010\n\u001a\u00020\u000bH\u0016J*\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u001b0\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\u000e2\u0006\u0010\n\u001a\u00020\u000bH\u0012J*\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u001b0\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\u000e2\u0006\u0010\n\u001a\u00020\u000bH\u0012J:\u0010\u001d\u001a\u00020\u00122\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\t0\u000e2\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u001b0\f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001f\u001a\u00020 H\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lde/justsoftware/admin/connector/permission/PermissionConnector;", "", "permissionRequestConnector", "Lde/justsoftware/permission/client/rest/PermissionRequestConnector;", "<init>", "(Lde/justsoftware/permission/client/rest/PermissionRequestConnector;)V", "mayRead", "", "item", "Lde/justsoftware/admin/id/ItemId;", "userId", "Lde/justsoftware/admin/id/UserId;", "", "items", "", "mayManage", "isSuperAdmin", "checkRead", "", "itemId", "checkReadAll", "itemIds", "checkAllReaders", "userIds", "checkManage", "checkManageAll", "mayReadResults", "Lde/justsoftware/permission/client/model/AuthorizationResult;", "mayManageResults", "checkItemResults", "permissionResults", "roleToCheck", "Lde/justsoftware/admin/connector/permission/PermissionConnector$Companion$RoleToCheck;", "Companion", "admin-service"})
@SourceDebugExtension(value={"SMAP\nPermissionConnector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PermissionConnector.kt\nde/justsoftware/admin/connector/permission/PermissionConnector\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,130:1\n462#2:131\n412#2:132\n462#2:137\n412#2:138\n477#2:154\n423#2:155\n462#2:160\n412#2:161\n477#2:170\n423#2:171\n462#2:176\n412#2:177\n1246#3,4:133\n1246#3,4:139\n1734#3,3:143\n1557#3:146\n1628#3,3:147\n1557#3:150\n1628#3,3:151\n1246#3,4:156\n1246#3,4:162\n1557#3:166\n1628#3,3:167\n1246#3,4:172\n1246#3,4:178\n1863#3,2:182\n*S KotlinDebug\n*F\n+ 1 PermissionConnector.kt\nde/justsoftware/admin/connector/permission/PermissionConnector\n*L\n41#1:131\n41#1:132\n46#1:137\n46#1:138\n88#1:154\n88#1:155\n89#1:160\n89#1:161\n97#1:170\n97#1:171\n98#1:176\n98#1:177\n41#1:133,4\n46#1:139,4\n52#1:143,3\n67#1:146\n67#1:147,3\n85#1:150\n85#1:151,3\n88#1:156,4\n89#1:162,4\n94#1:166\n94#1:167,3\n97#1:172,4\n98#1:178,4\n110#1:182,2\n*E\n"})
public class PermissionConnector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PermissionRequestConnector permissionRequestConnector;
    @NotNull
    private static final Logger log;

    public PermissionConnector(@NotNull PermissionRequestConnector permissionRequestConnector) {
        Intrinsics.checkNotNullParameter((Object)permissionRequestConnector, (String)"permissionRequestConnector");
        this.permissionRequestConnector = permissionRequestConnector;
    }

    public boolean mayRead(@NotNull ItemId item, @NotNull UserId userId) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        return (Boolean)CollectionsKt.first((Iterable)this.mayRead((Collection)SetsKt.setOf((Object)item), userId).values());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<ItemId, Boolean> mayRead(@NotNull Collection<? extends ItemId> items, @NotNull UserId userId) {
        void $this$mapValuesTo$iv$iv;
        Intrinsics.checkNotNullParameter(items, (String)"items");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Map $this$mapValues$iv = this.mayReadResults(items, userId);
        boolean $i$f$mapValues = false;
        Map map = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map3 = map2;
            boolean bl2 = false;
            Boolean bl3 = it.getValue() == AuthorizationResult.OK;
            map3.put(k, bl3);
        }
        return destination$iv$iv;
    }

    public boolean mayManage(@NotNull ItemId item, @NotNull UserId userId) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        return (Boolean)CollectionsKt.first((Iterable)this.mayManage((Collection)CollectionsKt.listOf((Object)item), userId).values());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<ItemId, Boolean> mayManage(@NotNull Collection<? extends ItemId> items, @NotNull UserId userId) {
        void $this$mapValuesTo$iv$iv;
        Intrinsics.checkNotNullParameter(items, (String)"items");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Map $this$mapValues$iv = this.mayManageResults(items, userId);
        boolean $i$f$mapValues = false;
        Map map = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map3 = map2;
            boolean bl2 = false;
            Boolean bl3 = it.getValue() == AuthorizationResult.OK;
            map3.put(k, bl3);
        }
        return destination$iv$iv;
    }

    public boolean isSuperAdmin(@NotNull UserId userId) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
            Collection collection = this.permissionRequestConnector.hasRoles((Iterable)SetsKt.setOf((Object)Role.SUPERADMIN), (Iterable)SetsKt.setOf((Object)Role.create((String)userId.toTypedString()))).values();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"<get-values>(...)");
            Iterable $this$all$iv = collection;
            boolean $i$f$all = false;
            if (((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    AuthorizationResult it = (AuthorizationResult)element$iv;
                    boolean bl2 = false;
                    if (it == AuthorizationResult.OK) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    public void checkRead(@NotNull ItemId itemId, @NotNull UserId userId) {
        Intrinsics.checkNotNullParameter((Object)itemId, (String)"itemId");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        this.checkReadAll((Collection)SetsKt.setOf((Object)itemId), userId);
    }

    public void checkReadAll(@NotNull Collection<? extends ItemId> itemIds, @NotNull UserId userId) {
        Intrinsics.checkNotNullParameter(itemIds, (String)"itemIds");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Map permissionResults = this.mayReadResults(itemIds, userId);
        this.checkItemResults(itemIds, permissionResults, userId, Companion.RoleToCheck.READ);
    }

    /*
     * WARNING - void declaration
     */
    public void checkAllReaders(@NotNull ItemId itemId, @NotNull Collection<? extends UserId> userIds) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)itemId, (String)"itemId");
        Intrinsics.checkNotNullParameter(userIds, (String)"userIds");
        Iterable $this$map$iv = userIds;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            UserId userId = (UserId)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Role.create((String)it.toTypedString()));
        }
        Set granteeRoles = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        if (!this.permissionRequestConnector.allHaveRole(Role.read((String)itemId.toTypedString()), granteeRoles)) {
            throw new NotAllowedException("Not all userIds '" + userIds + "' may read '" + itemId + "'");
        }
    }

    public void checkManage(@NotNull ItemId itemId, @NotNull UserId userId) {
        Intrinsics.checkNotNullParameter((Object)itemId, (String)"itemId");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        this.checkManageAll((Collection)SetsKt.setOf((Object)itemId), userId);
    }

    public void checkManageAll(@NotNull Collection<? extends ItemId> itemIds, @NotNull UserId userId) {
        Intrinsics.checkNotNullParameter(itemIds, (String)"itemIds");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Map permissionResults = this.mayManageResults(itemIds, userId);
        this.checkItemResults(itemIds, permissionResults, userId, Companion.RoleToCheck.MANAGE);
    }

    /*
     * WARNING - void declaration
     */
    private Map<ItemId, AuthorizationResult> mayReadResults(Collection<? extends ItemId> items, UserId userId) {
        void $this$mapValuesTo$iv$iv;
        Object object;
        Map $this$mapKeysTo$iv$iv;
        Collection<Object> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = CollectionsKt.toSet((Iterable)items);
        Object object2 = this.permissionRequestConnector;
        boolean $i$f$map22 = false;
        void var6_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ItemId itemId = (ItemId)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Role.read((String)it.toTypedString()));
        }
        ImmutableMap immutableMap = object2.hasRoles((Iterable)((List)destination$iv$iv), (Iterable)SetsKt.setOf((Object)Role.create((String)userId.toTypedString())));
        Intrinsics.checkNotNullExpressionValue((Object)immutableMap, (String)"hasRoles(...)");
        Map $this$mapKeys$iv = (Map)immutableMap;
        boolean $i$f$mapKeys = false;
        Map $i$f$map22 = $this$mapKeys$iv;
        Map destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
        boolean $i$f$mapKeysTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            Object it2;
            Map.Entry bl = (Map.Entry)element$iv$iv$iv;
            object2 = destination$iv$iv2;
            boolean bl2 = false;
            Object k = it2.getKey();
            Intrinsics.checkNotNullExpressionValue(k, (String)"<get-key>(...)");
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            object = PermissionConnectorKt.toItemId((Role)((Role)k));
            Object object3 = object2;
            boolean bl3 = false;
            it2 = it$iv$iv.getValue();
            object3.put(object, it2);
        }
        Map $this$mapValues$iv = destination$iv$iv2;
        boolean $i$f$mapValues = false;
        $this$mapKeysTo$iv$iv = $this$mapValues$iv;
        destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            Map.Entry it2 = (Map.Entry)element$iv$iv$iv;
            Map map = destination$iv$iv2;
            boolean bl = false;
            object = (Map.Entry)element$iv$iv$iv;
            collection = it$iv$iv.getKey();
            object2 = map;
            boolean bl4 = false;
            AuthorizationResult authorizationResult = (AuthorizationResult)it.getValue();
            object2.put(collection, authorizationResult);
        }
        return destination$iv$iv2;
    }

    /*
     * WARNING - void declaration
     */
    private Map<ItemId, AuthorizationResult> mayManageResults(Collection<? extends ItemId> items, UserId userId) {
        void $this$mapValuesTo$iv$iv;
        Object object;
        Map $this$mapKeysTo$iv$iv;
        Collection<Object> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = CollectionsKt.toSet((Iterable)items);
        Object object2 = this.permissionRequestConnector;
        boolean $i$f$map22 = false;
        void var6_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ItemId itemId = (ItemId)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Role.manage((String)it.toTypedString()));
        }
        ImmutableMap immutableMap = object2.hasRoles((Iterable)((List)destination$iv$iv), (Iterable)SetsKt.setOf((Object)Role.create((String)userId.toTypedString())));
        Intrinsics.checkNotNullExpressionValue((Object)immutableMap, (String)"hasRoles(...)");
        Map $this$mapKeys$iv = (Map)immutableMap;
        boolean $i$f$mapKeys = false;
        Map $i$f$map22 = $this$mapKeys$iv;
        Map destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
        boolean $i$f$mapKeysTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            Object it2;
            Map.Entry bl = (Map.Entry)element$iv$iv$iv;
            object2 = destination$iv$iv2;
            boolean bl2 = false;
            Object k = it2.getKey();
            Intrinsics.checkNotNullExpressionValue(k, (String)"<get-key>(...)");
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            object = PermissionConnectorKt.toItemId((Role)((Role)k));
            Object object3 = object2;
            boolean bl3 = false;
            it2 = it$iv$iv.getValue();
            object3.put(object, it2);
        }
        Map $this$mapValues$iv = destination$iv$iv2;
        boolean $i$f$mapValues = false;
        $this$mapKeysTo$iv$iv = $this$mapValues$iv;
        destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            Map.Entry it2 = (Map.Entry)element$iv$iv$iv;
            Map map = destination$iv$iv2;
            boolean bl = false;
            object = (Map.Entry)element$iv$iv$iv;
            collection = it$iv$iv.getKey();
            object2 = map;
            boolean bl4 = false;
            AuthorizationResult authorizationResult = (AuthorizationResult)it.getValue();
            object2.put(collection, authorizationResult);
        }
        return destination$iv$iv2;
    }

    private void checkItemResults(Collection<? extends ItemId> itemIds, Map<ItemId, ? extends AuthorizationResult> permissionResults, UserId userId, Companion.RoleToCheck roleToCheck) {
        List notAllowed = new ArrayList();
        List notFound = new ArrayList();
        Iterable $this$forEach$iv = itemIds;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ItemId it = (ItemId)element$iv;
            boolean bl = false;
            AuthorizationResult authorizationResult = permissionResults.get(it);
            switch (authorizationResult == null ? -1 : WhenMappings.$EnumSwitchMapping$0[authorizationResult.ordinal()]) {
                case 1: {
                    break;
                }
                case 2: {
                    notFound.add(it);
                    break;
                }
                case 3: {
                    notAllowed.add(it);
                    break;
                }
                default: {
                    notAllowed.add(it);
                }
            }
        }
        if (!((Collection)notAllowed).isEmpty()) {
            log.warn("User: '" + userId.toTypedString() + "' is not authorized to " + roleToCheck + " items: '" + notAllowed + "'.");
        }
        if (!((Collection)notFound).isEmpty()) {
            log.error("Items not known to permission: '" + notFound + "'.");
        }
        if (!((Collection)notAllowed).isEmpty() || !((Collection)notFound).isEmpty()) {
            throw new NotAuthorizedException("User: '" + userId.toTypedString() + "' is not authorized.");
        }
    }

    static {
        Logger logger = LoggerFactory.getLogger(PermissionConnector.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        log = logger;
    }
}

