/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.admin.application.web;

import de.justsoftware.admin.application.web.people.PeopleSettings;
import de.justsoftware.admin.authorization.AuthorizationContext;
import de.justsoftware.admin.connector.people.PeopleConnector;
import de.justsoftware.admin.graphql.generated.types.PeopleSettingsInput;
import de.justsoftware.admin.id.TenantId;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lde/justsoftware/admin/application/web/PeopleSettingsApplicationService;", "", "peopleConnector", "Lde/justsoftware/admin/connector/people/PeopleConnector;", "<init>", "(Lde/justsoftware/admin/connector/people/PeopleConnector;)V", "getPeopleSettings", "Lde/justsoftware/admin/application/web/people/PeopleSettings;", "authContext", "Lde/justsoftware/admin/authorization/AuthorizationContext;", "setPeopleSettings", "", "peopleSettingsInput", "Lde/justsoftware/admin/graphql/generated/types/PeopleSettingsInput;", "admin-service"})
public class PeopleSettingsApplicationService {
    @NotNull
    private final PeopleConnector peopleConnector;

    public PeopleSettingsApplicationService(@NotNull PeopleConnector peopleConnector) {
        Intrinsics.checkNotNullParameter((Object)peopleConnector, (String)"peopleConnector");
        this.peopleConnector = peopleConnector;
    }

    @NotNull
    public PeopleSettings getPeopleSettings(@NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        TenantId tenantId = authContext.getNonNullTenantId();
        authContext.checkTenantManager(tenantId);
        return new PeopleSettings(tenantId, this.peopleConnector.getBirthdayListEnabled(tenantId), this.peopleConnector.getAbsenceStatusEnabled(tenantId), this.peopleConnector.getAbsenceNoteEnabled(tenantId));
    }

    public void setPeopleSettings(@NotNull AuthorizationContext authContext, @NotNull PeopleSettingsInput peopleSettingsInput) {
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        Intrinsics.checkNotNullParameter((Object)peopleSettingsInput, (String)"peopleSettingsInput");
        TenantId tenantId = authContext.getNonNullTenantId();
        authContext.checkTenantManager(tenantId);
        if (peopleSettingsInput.getBirthdayListEnabled() != null) {
            this.peopleConnector.setBirthdayListEnabled(tenantId, peopleSettingsInput.getBirthdayListEnabled().booleanValue());
        }
        if (peopleSettingsInput.getAbsenceStatusEnabled() != null) {
            this.peopleConnector.setAbsenceStatusEnabled(tenantId, peopleSettingsInput.getAbsenceStatusEnabled().booleanValue());
        }
        if (peopleSettingsInput.getAbsenceNoteEnabled() != null) {
            this.peopleConnector.setAbsenceNoteEnabled(tenantId, peopleSettingsInput.getAbsenceNoteEnabled().booleanValue());
        }
    }
}

