/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.authentication.saml;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Timer;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.opensaml.saml2.metadata.provider.AbstractReloadingMetadataProvider;
import org.opensaml.saml2.metadata.provider.MetadataProviderException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
@SuppressFBWarnings(value={"IS2_INCONSISTENT_SYNC"}, justification="Preserve original code as much as possible.")
public class ModernHTTPMetadataProvider
extends AbstractReloadingMetadataProvider {
    private final Logger _log = LoggerFactory.getLogger(ModernHTTPMetadataProvider.class);
    private CloseableHttpClient _httpClient;
    private URI _metadataURI;
    private String _cachedMetadataETag;
    private String _cachedMetadataLastModified;

    public ModernHTTPMetadataProvider(Timer backgroundTaskTimer, CloseableHttpClient client, String metadataURL) throws MetadataProviderException {
        super(backgroundTaskTimer);
        this._httpClient = client;
        try {
            this._metadataURI = new URI(metadataURL);
        }
        catch (URISyntaxException e) {
            throw new MetadataProviderException("Illegal URL syntax", (Exception)e);
        }
    }

    @Nonnull
    public String getMetadataURI() {
        return this._metadataURI.toASCIIString();
    }

    public synchronized void destroy() {
        this._httpClient = null;
        this._metadataURI = null;
        this._cachedMetadataETag = null;
        this._cachedMetadataLastModified = null;
        super.destroy();
    }

    protected String getMetadataIdentifier() {
        return this._metadataURI.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE"}, justification="False positive, known problem with rule and using try-with-resources.")
    protected byte[] fetchMetadata() throws MetadataProviderException {
        HttpGet httpGet = this.buildHttpGet();
        this._log.debug("Attempting to fetch metadata document from '{}'", (Object)this._metadataURI);
        try (CloseableHttpResponse response = this._httpClient.execute((HttpUriRequest)httpGet);){
            int httpStatus;
            StatusLine statusLine = response.getStatusLine();
            int n = httpStatus = statusLine != null ? statusLine.getStatusCode() : -1;
            if (httpStatus == 304) {
                this._log.debug("Metadata document from '{}' has not changed since last retrieval", (Object)this.getMetadataURI());
                byte[] byArray = null;
                return byArray;
            }
            if (httpStatus != 200) {
                String errMsg = "Non-ok status code " + httpStatus + " returned from remote metadata source " + String.valueOf(this._metadataURI);
                this._log.error(errMsg);
                throw new MetadataProviderException(errMsg);
            }
            this.processConditionalRetrievalHeaders((HttpResponse)response);
            byte[] rawMetadata = this.getMetadataBytesFromResponse((HttpResponse)response);
            this._log.debug("Successfully fetched {}bytes of metadata from {}", (Object)rawMetadata.length, (Object)this.getMetadataURI());
            byte[] byArray = rawMetadata;
            return byArray;
        }
        catch (IOException e) {
            String errMsg = "Error retrieving metadata from " + String.valueOf(this._metadataURI);
            this._log.error(errMsg, (Throwable)e);
            throw new MetadataProviderException(errMsg, (Exception)e);
        }
    }

    @Nonnull
    protected HttpGet buildHttpGet() {
        HttpGet httpGet = new HttpGet(this.getMetadataURI());
        httpGet.addHeader("Connection", "close");
        httpGet.setHeader("Accept-Encoding", "gzip,deflate");
        if (this._cachedMetadataETag != null) {
            httpGet.setHeader("If-None-Match", this._cachedMetadataETag);
        }
        if (this._cachedMetadataLastModified != null) {
            httpGet.setHeader("If-Modified-Since", this._cachedMetadataLastModified);
        }
        return httpGet;
    }

    protected void processConditionalRetrievalHeaders(HttpResponse response) {
        Header httpHeader = response.getFirstHeader("ETag");
        if (httpHeader != null) {
            this._cachedMetadataETag = httpHeader.getValue();
        }
        if ((httpHeader = response.getFirstHeader("Last-Modified")) != null) {
            this._cachedMetadataLastModified = httpHeader.getValue();
        }
    }

    @Nonnull
    protected byte[] getMetadataBytesFromResponse(HttpResponse response) throws MetadataProviderException {
        this._log.debug("Attempting to extract metadata from response to request for metadata from '{}'", (Object)this.getMetadataURI());
        HttpEntity httpEntity = response.getEntity();
        if (httpEntity == null) {
            throw new MetadataProviderException("Unable to read empty response");
        }
        try {
            InputStream ins = httpEntity.getContent();
            Header httpHeader = response.getFirstHeader("Content-Encoding");
            if (httpHeader != null) {
                String contentEncoding = httpHeader.getValue();
                if ("deflate".equalsIgnoreCase(contentEncoding)) {
                    this._log.debug("Metadata document from '{}' was deflate compressed, decompressing it", (Object)this._metadataURI);
                    ins = new InflaterInputStream(ins);
                }
                if ("gzip".equalsIgnoreCase(contentEncoding)) {
                    this._log.debug("Metadata document from '{}' was GZip compressed, decompressing it", (Object)this._metadataURI);
                    ins = new GZIPInputStream(ins);
                }
            }
            return this.inputstreamToByteArray(ins);
        }
        catch (IOException e) {
            this._log.error("Unable to read response", (Throwable)e);
            throw new MetadataProviderException("Unable to read response", (Exception)e);
        }
    }
}

