/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.notificationservice.kafka;

import de.justsoftware.kafka.client.KafkaCleaningProducer;
import de.justsoftware.kafka.client.KafkaCleaningProducerImpl;
import de.justsoftware.notificationclient.InstructionDeserializer;
import de.justsoftware.notificationclient.model.Instruction;
import de.justsoftware.notificationservice.kafka.KafkaConfiguration;
import de.justsoftware.notificationservice.kafka.ProfileDeserializer;
import de.justsoftware.notificationservice.model.Profile;
import java.time.Duration;
import java.util.Map;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.kafka.config.ConcurrentKafkaListenerContainerFactory;
import org.springframework.kafka.core.ConsumerFactory;
import org.springframework.kafka.core.DefaultKafkaConsumerFactory;
import org.springframework.kafka.listener.CommonErrorHandler;
import org.springframework.kafka.listener.DefaultErrorHandler;
import org.springframework.kafka.support.serializer.ErrorHandlingDeserializer;
import org.springframework.util.backoff.BackOff;
import org.springframework.util.backoff.ExponentialBackOff;

@Configuration
@DependsOn(value={"liquibase"})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001:\u0001\u001bB\u000f\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0005\u001a\f\u0012\u0004\u0012\u00020\u0003\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0012JH\u0010\t\u001a\u00020\n\"\u0004\b\u0000\u0010\u000b\"\u0004\b\u0001\u0010\f2\u0006\u0010\r\u001a\u00020\u00032\u0014\u0010\u000e\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u0002H\u000b0\u00100\u000f2\u0014\u0010\u0011\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u0002H\f0\u00100\u000fH\u0012JT\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u0002H\u000b\u0012\u0004\u0012\u0002H\f0\u0013\"\u0004\b\u0000\u0010\u000b\"\u0004\b\u0001\u0010\f2\u0006\u0010\r\u001a\u00020\u00032\u0014\u0010\u000e\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u0002H\u000b0\u00100\u000f2\u0014\u0010\u0011\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u0002H\f0\u00100\u000fH\u0012J\u0014\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00150\u0013H\u0017J\u0014\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0017H\u0017J\u0014\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00190\u0013H\u0017J\u0014\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0013H\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lde/justsoftware/notificationservice/kafka/KafkaConfiguration;", "", "bootstrapServers", "", "(Ljava/lang/String;)V", "createCleaningConsumer", "Lorg/apache/kafka/clients/consumer/Consumer;", "tp", "Lorg/apache/kafka/common/TopicPartition;", "defaultConsumerConfig", "Ljava/util/Properties;", "K", "V", "groupId", "keyDeserializerClass", "Ljava/lang/Class;", "Lorg/apache/kafka/common/serialization/Deserializer;", "valueDeserializerClass", "defaultKafkaListenerContainerFactory", "Lorg/springframework/kafka/config/ConcurrentKafkaListenerContainerFactory;", "instructionListenerContainerFactory", "Lde/justsoftware/notificationclient/model/Instruction;", "kafkaCleaningProducer", "Lde/justsoftware/kafka/client/KafkaCleaningProducer;", "profileListenerContainerFactory", "Lde/justsoftware/notificationservice/model/Profile;", "userGroupMemberListenerContainerFactory", "ClosingKafkaProducerWithTimeout", "notification-service"})
public class KafkaConfiguration {
    @NotNull
    private final String bootstrapServers;

    public KafkaConfiguration(@Value(value="${kafka.bootstrapServers:}") @NotNull String bootstrapServers) {
        Intrinsics.checkNotNullParameter((Object)bootstrapServers, (String)"bootstrapServers");
        this.bootstrapServers = bootstrapServers;
    }

    @Bean(destroyMethod="close")
    @NotNull
    public KafkaCleaningProducer<String, String> kafkaCleaningProducer() {
        Properties properties;
        Properties $this$kafkaCleaningProducer_u24lambda_u240 = properties = new Properties();
        boolean bl = false;
        $this$kafkaCleaningProducer_u24lambda_u240.put("bootstrap.servers", this.bootstrapServers);
        $this$kafkaCleaningProducer_u24lambda_u240.put("acks", "all");
        $this$kafkaCleaningProducer_u24lambda_u240.put("retries", (Object)0);
        $this$kafkaCleaningProducer_u24lambda_u240.put("batch.size", (Object)16384);
        $this$kafkaCleaningProducer_u24lambda_u240.put("linger.ms", (Object)1);
        $this$kafkaCleaningProducer_u24lambda_u240.put("buffer.memory", (Object)0x2000000);
        Properties props = properties;
        ClosingKafkaProducerWithTimeout delegate = new ClosingKafkaProducerWithTimeout(props);
        return (KafkaCleaningProducer)new KafkaCleaningProducerImpl((Producer)delegate, arg_0 -> this.createCleaningConsumer(arg_0));
    }

    private Consumer<String, ?> createCleaningConsumer(TopicPartition tp) {
        Properties properties;
        Properties $this$createCleaningConsumer_u24lambda_u241 = properties = new Properties();
        boolean bl = false;
        $this$createCleaningConsumer_u24lambda_u241.put("bootstrap.servers", this.bootstrapServers);
        $this$createCleaningConsumer_u24lambda_u241.put("enable.auto.commit", "false");
        $this$createCleaningConsumer_u24lambda_u241.put("auto.offset.reset", "earliest");
        $this$createCleaningConsumer_u24lambda_u241.put("max.poll.records", (Object)100);
        Properties props = properties;
        Consumer consumer = KafkaCleaningProducerImpl.createStringConsumer((TopicPartition)tp, (Properties)props);
        Intrinsics.checkNotNullExpressionValue((Object)consumer, (String)"createStringConsumer(...)");
        return consumer;
    }

    @Bean
    @NotNull
    public ConcurrentKafkaListenerContainerFactory<String, String> userGroupMemberListenerContainerFactory() {
        return this.defaultKafkaListenerContainerFactory("just.notificationservice.userGroupMemberConsumer", StringDeserializer.class, StringDeserializer.class);
    }

    @Bean
    @NotNull
    public ConcurrentKafkaListenerContainerFactory<String, Instruction> instructionListenerContainerFactory() {
        return this.defaultKafkaListenerContainerFactory("just.notificationservice.instructionConsumer", StringDeserializer.class, InstructionDeserializer.class);
    }

    @Bean
    @NotNull
    public ConcurrentKafkaListenerContainerFactory<String, Profile> profileListenerContainerFactory() {
        return this.defaultKafkaListenerContainerFactory("just.notificationservice.profileConsumer", StringDeserializer.class, ProfileDeserializer.class);
    }

    private <K, V> ConcurrentKafkaListenerContainerFactory<K, V> defaultKafkaListenerContainerFactory(String groupId, Class<? extends Deserializer<K>> keyDeserializerClass, Class<? extends Deserializer<V>> valueDeserializerClass) {
        ConcurrentKafkaListenerContainerFactory concurrentKafkaListenerContainerFactory;
        ConcurrentKafkaListenerContainerFactory $this$defaultKafkaListenerContainerFactory_u24lambda_u242 = concurrentKafkaListenerContainerFactory = new ConcurrentKafkaListenerContainerFactory();
        boolean bl = false;
        ExponentialBackOff exponentialBackOff = new ExponentialBackOff();
        exponentialBackOff.setMaxElapsedTime(Duration.ofHours(1L).toMillis());
        Properties properties = this.defaultConsumerConfig(groupId, keyDeserializerClass, valueDeserializerClass);
        Intrinsics.checkNotNull((Object)properties, (String)"null cannot be cast to non-null type kotlin.collections.MutableMap<kotlin.String, kotlin.Any?>");
        Map consumerConfig = TypeIntrinsics.asMutableMap((Object)properties);
        $this$defaultKafkaListenerContainerFactory_u24lambda_u242.setConsumerFactory((ConsumerFactory)new DefaultKafkaConsumerFactory(consumerConfig));
        $this$defaultKafkaListenerContainerFactory_u24lambda_u242.setBatchListener(Boolean.valueOf(true));
        $this$defaultKafkaListenerContainerFactory_u24lambda_u242.setCommonErrorHandler((CommonErrorHandler)new DefaultErrorHandler((BackOff)exponentialBackOff));
        return concurrentKafkaListenerContainerFactory;
    }

    private <K, V> Properties defaultConsumerConfig(String groupId, Class<? extends Deserializer<K>> keyDeserializerClass, Class<? extends Deserializer<V>> valueDeserializerClass) {
        Properties properties;
        Properties $this$defaultConsumerConfig_u24lambda_u243 = properties = new Properties();
        boolean bl = false;
        $this$defaultConsumerConfig_u24lambda_u243.put("bootstrap.servers", this.bootstrapServers);
        $this$defaultConsumerConfig_u24lambda_u243.put("enable.auto.commit", "false");
        $this$defaultConsumerConfig_u24lambda_u243.put("auto.offset.reset", "earliest");
        $this$defaultConsumerConfig_u24lambda_u243.put("key.deserializer", ErrorHandlingDeserializer.class);
        $this$defaultConsumerConfig_u24lambda_u243.put("value.deserializer", ErrorHandlingDeserializer.class);
        $this$defaultConsumerConfig_u24lambda_u243.put("max.poll.records", (Object)100);
        $this$defaultConsumerConfig_u24lambda_u243.put("group.id", groupId);
        $this$defaultConsumerConfig_u24lambda_u243.put("spring.deserializer.key.delegate.class", keyDeserializerClass);
        $this$defaultConsumerConfig_u24lambda_u243.put("spring.deserializer.value.delegate.class", valueDeserializerClass);
        return properties;
    }
}

