/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.OptionalLong;
import java.util.TreeMap;
import org.apache.kafka.controller.DeferredEvent;

class ControllerPurgatory {
    private final TreeMap<Long, List<DeferredEvent>> pending = new TreeMap();

    ControllerPurgatory() {
    }

    void completeUpTo(long offset) {
        Map.Entry<Long, List<DeferredEvent>> entry;
        Iterator<Map.Entry<Long, List<DeferredEvent>>> iter = this.pending.entrySet().iterator();
        while (iter.hasNext() && (entry = iter.next()).getKey() <= offset) {
            for (DeferredEvent event : entry.getValue()) {
                event.complete(null);
            }
            iter.remove();
        }
    }

    void failAll(Exception exception) {
        Iterator<Map.Entry<Long, List<DeferredEvent>>> iter = this.pending.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<Long, List<DeferredEvent>> entry = iter.next();
            for (DeferredEvent event : entry.getValue()) {
                event.complete(exception);
            }
            iter.remove();
        }
    }

    void add(long offset, DeferredEvent event) {
        long lastKey;
        if (!this.pending.isEmpty() && offset < (lastKey = this.pending.lastKey().longValue())) {
            throw new RuntimeException("There is already a purgatory event with offset " + lastKey + ".  We should not add one with an offset of " + offset + " which is lower than that.");
        }
        List<DeferredEvent> events = this.pending.get(offset);
        if (events == null) {
            events = new ArrayList<DeferredEvent>();
            this.pending.put(offset, events);
        }
        events.add(event);
    }

    OptionalLong highestPendingOffset() {
        if (this.pending.isEmpty()) {
            return OptionalLong.empty();
        }
        return OptionalLong.of(this.pending.lastKey());
    }
}

