/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.graphql.fetchers;

import de.justsoftware.wikiservice.application.ChapterApplicationService;
import de.justsoftware.wikiservice.application.model.ChapterDto;
import de.justsoftware.wikiservice.application.model.WikiDto;
import de.justsoftware.wikiservice.authorization.AuthContext;
import de.justsoftware.wikiservice.graphql.AuthenticatedGraphQLContext;
import de.justsoftware.wikiservice.graphql.dataloader.DataLoaderFactory;
import de.justsoftware.wikiservice.graphql.dataloader.DataLoaderName;
import de.justsoftware.wikiservice.graphql.generated.MutationCreateChapterArgs;
import de.justsoftware.wikiservice.graphql.generated.MutationDeleteChapterArgs;
import de.justsoftware.wikiservice.graphql.generated.MutationUpdateChapterArgs;
import de.justsoftware.wikiservice.graphql.generated.QueryChapterArgs;
import de.justsoftware.wikiservice.graphql.generated.QuerySubscribedChaptersArgs;
import de.justsoftware.wikiservice.model.ParentId;
import de.justsoftware.wikiservice.model.WikiId;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.dataloader.DataLoader;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\b\u0017\u0018\u00002\u00020\u0001B\u0011\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u0007H\u0017J\u0014\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u0007H\u0017J\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\n0\u000fH\u0016J\u000e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\n0\u000fH\u0016J\u000e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\n0\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\n0\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011R&\u0010\u0014\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u00150\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0011R&\u0010\u0017\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u00150\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0011R \u0010\u001a\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\u00150\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0011\u00a8\u0006\u001e"}, d2={"Lde/justsoftware/wikiservice/graphql/fetchers/ChapterFetcher;", "", "chapterApplicationService", "Lde/justsoftware/wikiservice/application/ChapterApplicationService;", "<init>", "(Lde/justsoftware/wikiservice/application/ChapterApplicationService;)V", "childChapterDataLoaderFactory", "Lde/justsoftware/wikiservice/graphql/dataloader/DataLoaderFactory;", "Lde/justsoftware/wikiservice/model/ParentId;", "", "Lde/justsoftware/wikiservice/application/model/ChapterDto;", "chapterCountForWholeWikiDataLoaderFactory", "Lde/justsoftware/wikiservice/model/WikiId;", "", "subscribedChapters", "Lgraphql/schema/DataFetcher;", "getSubscribedChapters", "()Lgraphql/schema/DataFetcher;", "byId", "getById", "allByChapter", "Ljava/util/concurrent/CompletableFuture;", "getAllByChapter", "allByWiki", "getAllByWiki", "create", "countByWiki", "getCountByWiki", "update", "delete", "wiki-service"})
public class ChapterFetcher {
    @NotNull
    private final ChapterApplicationService chapterApplicationService;
    @NotNull
    private final DataFetcher<List<ChapterDto>> subscribedChapters;
    @NotNull
    private final DataFetcher<ChapterDto> byId;
    @NotNull
    private final DataFetcher<CompletableFuture<List<ChapterDto>>> allByChapter;
    @NotNull
    private final DataFetcher<CompletableFuture<List<ChapterDto>>> allByWiki;
    @NotNull
    private final DataFetcher<CompletableFuture<Integer>> countByWiki;

    @Autowired
    public ChapterFetcher(@NotNull ChapterApplicationService chapterApplicationService) {
        Intrinsics.checkNotNullParameter((Object)chapterApplicationService, (String)"chapterApplicationService");
        this.chapterApplicationService = chapterApplicationService;
        this.subscribedChapters = arg_0 -> ChapterFetcher.subscribedChapters$lambda$2(this, arg_0);
        this.byId = arg_0 -> ChapterFetcher.byId$lambda$3(this, arg_0);
        this.allByChapter = ChapterFetcher::allByChapter$lambda$4;
        this.allByWiki = ChapterFetcher::allByWiki$lambda$5;
        this.countByWiki = ChapterFetcher::countByWiki$lambda$7;
    }

    @Bean
    @NotNull
    public DataLoaderFactory<ParentId, List<ChapterDto>> childChapterDataLoaderFactory() {
        return new DataLoaderFactory(DataLoaderName.CHILD_CHAPTERS_LOADER, (arg_0, arg_1) -> ChapterFetcher.childChapterDataLoaderFactory$lambda$0(this, arg_0, arg_1));
    }

    @Bean
    @NotNull
    public DataLoaderFactory<WikiId, Integer> chapterCountForWholeWikiDataLoaderFactory() {
        return new DataLoaderFactory(DataLoaderName.WIKI_CHAPTER_COUNT_LOADER, (arg_0, arg_1) -> ChapterFetcher.chapterCountForWholeWikiDataLoaderFactory$lambda$1(this, arg_0, arg_1));
    }

    @NotNull
    public DataFetcher<List<ChapterDto>> getSubscribedChapters() {
        return this.subscribedChapters;
    }

    @NotNull
    public DataFetcher<ChapterDto> getById() {
        return this.byId;
    }

    @NotNull
    public DataFetcher<CompletableFuture<List<ChapterDto>>> getAllByChapter() {
        return this.allByChapter;
    }

    @NotNull
    public DataFetcher<CompletableFuture<List<ChapterDto>>> getAllByWiki() {
        return this.allByWiki;
    }

    @NotNull
    public DataFetcher<ChapterDto> create() {
        return arg_0 -> ChapterFetcher.create$lambda$6(this, arg_0);
    }

    @NotNull
    public DataFetcher<CompletableFuture<Integer>> getCountByWiki() {
        return this.countByWiki;
    }

    @NotNull
    public DataFetcher<ChapterDto> update() {
        return arg_0 -> ChapterFetcher.update$lambda$8(this, arg_0);
    }

    @NotNull
    public DataFetcher<ChapterDto> delete() {
        return arg_0 -> ChapterFetcher.delete$lambda$9(this, arg_0);
    }

    private static final Map childChapterDataLoaderFactory$lambda$0(ChapterFetcher this$0, List parentIds, AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)parentIds, (String)"parentIds");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this$0.chapterApplicationService.getAllChildChapters(parentIds, authContext);
    }

    private static final Map chapterCountForWholeWikiDataLoaderFactory$lambda$1(ChapterFetcher this$0, List wikiIds, AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)wikiIds, (String)"wikiIds");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this$0.chapterApplicationService.countChaptersForWikis(wikiIds, authContext);
    }

    private static final List subscribedChapters$lambda$2(ChapterFetcher this$0, DataFetchingEnvironment env) {
        Map map = env.getArguments();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getArguments(...)");
        QuerySubscribedChaptersArgs args = new QuerySubscribedChaptersArgs(map);
        Object object = env.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getContext(...)");
        AuthenticatedGraphQLContext context = (AuthenticatedGraphQLContext)object;
        return this$0.chapterApplicationService.readSubscribedChapters(args.getPage(), args.getSize(), context.getAuthContext());
    }

    private static final ChapterDto byId$lambda$3(ChapterFetcher this$0, DataFetchingEnvironment env) {
        Map map = env.getArguments();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getArguments(...)");
        QueryChapterArgs args = new QueryChapterArgs(map);
        Object object = env.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getContext(...)");
        AuthenticatedGraphQLContext context = (AuthenticatedGraphQLContext)object;
        return this$0.chapterApplicationService.read(args.getId(), context.getAuthContext());
    }

    private static final CompletableFuture allByChapter$lambda$4(DataFetchingEnvironment env) {
        Object object = env.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getContext(...)");
        AuthenticatedGraphQLContext context = (AuthenticatedGraphQLContext)object;
        DataLoader dataLoader = context.getDataLoader(DataLoaderName.CHILD_CHAPTERS_LOADER);
        Object object2 = env.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"getSource(...)");
        ChapterDto chapter = (ChapterDto)object2;
        return dataLoader.load((Object)chapter.getId());
    }

    private static final CompletableFuture allByWiki$lambda$5(DataFetchingEnvironment env) {
        Object object = env.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getContext(...)");
        AuthenticatedGraphQLContext context = (AuthenticatedGraphQLContext)object;
        DataLoader dataLoader = context.getDataLoader(DataLoaderName.CHILD_CHAPTERS_LOADER);
        Object object2 = env.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"getSource(...)");
        WikiDto wiki = (WikiDto)object2;
        return dataLoader.load((Object)wiki.getId());
    }

    private static final ChapterDto create$lambda$6(ChapterFetcher this$0, DataFetchingEnvironment env) {
        Map map = env.getArguments();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getArguments(...)");
        MutationCreateChapterArgs args = new MutationCreateChapterArgs(map);
        Object object = env.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getContext(...)");
        AuthenticatedGraphQLContext context = (AuthenticatedGraphQLContext)object;
        return this$0.chapterApplicationService.create(args.getChapter(), context.getAuthContext());
    }

    private static final CompletableFuture countByWiki$lambda$7(DataFetchingEnvironment env) {
        Object object = env.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getContext(...)");
        AuthenticatedGraphQLContext context = (AuthenticatedGraphQLContext)object;
        DataLoader dataLoader = context.getDataLoader(DataLoaderName.WIKI_CHAPTER_COUNT_LOADER);
        Object object2 = env.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"getSource(...)");
        WikiDto wiki = (WikiDto)object2;
        return dataLoader.load((Object)wiki.getId());
    }

    private static final ChapterDto update$lambda$8(ChapterFetcher this$0, DataFetchingEnvironment env) {
        Map map = env.getArguments();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getArguments(...)");
        MutationUpdateChapterArgs args = new MutationUpdateChapterArgs(map);
        Object object = env.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getContext(...)");
        AuthenticatedGraphQLContext context = (AuthenticatedGraphQLContext)object;
        return this$0.chapterApplicationService.update(args.getId(), args.getChapter(), context.getAuthContext());
    }

    private static final ChapterDto delete$lambda$9(ChapterFetcher this$0, DataFetchingEnvironment env) {
        Map map = env.getArguments();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getArguments(...)");
        MutationDeleteChapterArgs args = new MutationDeleteChapterArgs(map);
        Object object = env.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getContext(...)");
        AuthenticatedGraphQLContext context = (AuthenticatedGraphQLContext)object;
        return this$0.chapterApplicationService.delete(args.getId(), context.getAuthContext());
    }
}

