/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.business;

import de.justsoftware.wikiservice.application.model.ArticleWithTitleDto;
import de.justsoftware.wikiservice.business.AncestorService;
import de.justsoftware.wikiservice.business.ArticleService;
import de.justsoftware.wikiservice.business.PermissionService;
import de.justsoftware.wikiservice.business.exceptions.ArticleVersionNotFoundException;
import de.justsoftware.wikiservice.business.exceptions.EmptyArticleTitleException;
import de.justsoftware.wikiservice.business.model.Article;
import de.justsoftware.wikiservice.business.model.ArticleHeading;
import de.justsoftware.wikiservice.business.model.ArticleVersion;
import de.justsoftware.wikiservice.drive.DriveService;
import de.justsoftware.wikiservice.model.ArticleCreatedEvent;
import de.justsoftware.wikiservice.model.ArticleDeletedEvent;
import de.justsoftware.wikiservice.model.ArticleId;
import de.justsoftware.wikiservice.model.ArticleUpdatedEvent;
import de.justsoftware.wikiservice.model.ArticleVersionId;
import de.justsoftware.wikiservice.model.DeletionId;
import de.justsoftware.wikiservice.model.IdType;
import de.justsoftware.wikiservice.model.MigrationStatus;
import de.justsoftware.wikiservice.model.ParentId;
import de.justsoftware.wikiservice.model.ProfileId;
import de.justsoftware.wikiservice.model.WikiId;
import de.justsoftware.wikiservice.persistence.ArticleHeadingMigrationRepository;
import de.justsoftware.wikiservice.persistence.ArticleHeadingRepository;
import de.justsoftware.wikiservice.persistence.ArticleRepository;
import de.justsoftware.wikiservice.persistence.ArticleVersionRepository;
import de.justsoftware.wikiservice.persistence.model.DbArticle;
import de.justsoftware.wikiservice.persistence.model.DbArticleHeading;
import de.justsoftware.wikiservice.persistence.model.DbArticleHeadingMigrationStatus;
import de.justsoftware.wikiservice.persistence.model.DbArticleVersion;
import de.justsoftware.wikiservice.prosemirror.ArticleHeadingInfo;
import de.justsoftware.wikiservice.prosemirror.ProseMirrorContentParserKt;
import de.justsoftware.wikiservice.util.CollectionUtilsKt;
import de.justsoftware.wikiservice.util.IdUtilsKt;
import de.justsoftware.wikiservice.util.TransactionUtils;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.time.Clock;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00e4\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0017\u0018\u0000 u2\u00020\u0001:\u0001uBk\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u0012\b\b\u0001\u0010\u0016\u001a\u00020\u0017\u0012\u0006\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\u0004\b\u001a\u0010\u001bJH\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020#2\u0006\u0010%\u001a\u00020#2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0017J\u0010\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/H\u0017J\u0010\u00100\u001a\u00020-2\u0006\u0010.\u001a\u00020/H\u0017J\u0012\u00101\u001a\u0004\u0018\u00010-2\u0006\u0010.\u001a\u00020/H\u0017J\u0012\u00102\u001a\u0004\u0018\u00010-2\u0006\u0010.\u001a\u00020/H\u0017J\u0010\u00103\u001a\u00020-2\u0006\u0010.\u001a\u00020/H\u0017J\"\u00104\u001a\u000e\u0012\u0004\u0012\u00020/\u0012\u0004\u0012\u00020-052\f\u00106\u001a\b\u0012\u0004\u0012\u00020/07H\u0017J\"\u00108\u001a\u000e\u0012\u0004\u0012\u00020/\u0012\u0004\u0012\u00020-052\f\u00106\u001a\b\u0012\u0004\u0012\u00020/07H\u0017J&\u00109\u001a\b\u0012\u0004\u0012\u00020;0:2\u0006\u0010<\u001a\u00020'2\u0006\u0010=\u001a\u00020)2\u0006\u0010>\u001a\u00020)H\u0017J\u0010\u0010?\u001a\u00020\u001d2\u0006\u0010.\u001a\u00020/H\u0017J\u0010\u0010@\u001a\u00020-2\u0006\u0010A\u001a\u00020BH\u0017J\u001c\u0010C\u001a\b\u0012\u0004\u0012\u00020-0:2\f\u00106\u001a\b\u0012\u0004\u0012\u00020/07H\u0017J&\u0010D\u001a\b\u0012\u0004\u0012\u00020-0E2\u0006\u0010.\u001a\u00020/2\u0006\u0010=\u001a\u00020)2\u0006\u0010F\u001a\u00020)H\u0017J(\u0010G\u001a\u0014\u0012\u0004\u0012\u00020/\u0012\n\u0012\b\u0012\u0004\u0012\u00020H0:052\f\u00106\u001a\b\u0012\u0004\u0012\u00020/07H\u0017J\"\u0010I\u001a\u000e\u0012\u0004\u0012\u00020/\u0012\u0004\u0012\u00020\u001d052\f\u00106\u001a\b\u0012\u0004\u0012\u00020/07H\u0017J(\u0010J\u001a\u0014\u0012\u0004\u0012\u00020\u001f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001d0:052\f\u0010K\u001a\b\u0012\u0004\u0012\u00020\u001f07H\u0016J\u000e\u0010L\u001a\b\u0012\u0004\u0012\u00020N0MH\u0016J\"\u0010O\u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020)052\f\u0010P\u001a\b\u0012\u0004\u0012\u00020!07H\u0016J\u0016\u0010Q\u001a\u00020\u00172\f\u0010K\u001a\b\u0012\u0004\u0012\u00020\u001f07H\u0016J8\u0010R\u001a\u00020\u001d2\u0006\u0010.\u001a\u00020/2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020#2\u0006\u0010%\u001a\u00020#2\u0006\u0010S\u001a\u00020'2\u0006\u0010*\u001a\u00020+H\u0017JZ\u0010T\u001a\u00020\u001d2\b\u0010U\u001a\u0004\u0018\u00010-2\u0006\u0010.\u001a\u00020/2\u0006\u0010V\u001a\u00020\u001d2\u0006\u0010$\u001a\u00020#2\u0006\u0010W\u001a\u00020#2\u0006\u0010%\u001a\u00020#2\u0006\u0010S\u001a\u00020'2\b\u0010X\u001a\u0004\u0018\u00010-2\f\u0010Y\u001a\b\u0012\u0004\u0012\u00020#0:H\u0012JP\u0010Z\u001a\u00020\u001d2\b\u0010X\u001a\u0004\u0018\u00010-2\u0006\u0010$\u001a\u00020#2\u0006\u0010W\u001a\u00020#2\u0006\u0010V\u001a\u00020\u001d2\u0006\u0010.\u001a\u00020/2\u0006\u0010%\u001a\u00020#2\u0006\u0010S\u001a\u00020'2\f\u0010Y\u001a\b\u0012\u0004\u0012\u00020#0:H\u0012J\"\u0010[\u001a\b\u0012\u0004\u0012\u00020#0:2\b\u0010U\u001a\u0004\u0018\u00010-2\b\u0010X\u001a\u0004\u0018\u00010-H\u0012J\u0018\u0010\\\u001a\u00020]2\u0006\u0010^\u001a\u00020-2\u0006\u0010V\u001a\u00020\u001dH\u0012J\u0018\u0010_\u001a\u00020]2\u0006\u0010$\u001a\u00020#2\u0006\u0010.\u001a\u00020/H\u0012J.\u0010`\u001a\u00020]2\f\u0010Y\u001a\b\u0012\u0004\u0012\u00020#0:2\u0006\u0010a\u001a\u00020#2\u0006\u0010.\u001a\u00020/2\u0006\u0010S\u001a\u00020'H\u0012J&\u0010b\u001a\u00020]2\b\u0010\"\u001a\u0004\u0018\u00010#2\b\u0010$\u001a\u0004\u0018\u00010#2\b\u0010%\u001a\u0004\u0018\u00010#H\u0012J \u0010c\u001a\u00020]2\u0006\u0010.\u001a\u00020/2\u0006\u0010d\u001a\u00020e2\u0006\u0010f\u001a\u00020'H\u0017J\u001e\u0010g\u001a\u00020]2\f\u0010K\u001a\b\u0012\u0004\u0012\u00020\u001f072\u0006\u0010d\u001a\u00020eH\u0017J\u0018\u0010h\u001a\u00020]2\u0006\u0010i\u001a\u00020!2\u0006\u0010d\u001a\u00020eH\u0017J\u0018\u0010j\u001a\u00020+2\u0006\u0010.\u001a\u00020/2\u0006\u0010S\u001a\u00020'H\u0017J\u0018\u0010k\u001a\u00020+2\u0006\u0010.\u001a\u00020/2\u0006\u0010S\u001a\u00020'H\u0017J\u0016\u0010l\u001a\u00020]2\f\u0010m\u001a\b\u0012\u0004\u0012\u00020e07H\u0017J\b\u0010n\u001a\u00020]H\u0017J\b\u0010o\u001a\u00020+H\u0016J\u001d\u0010p\u001a\u00020q2\u0006\u0010r\u001a\u00020q2\u0006\u0010s\u001a\u00020-H\u0011\u00a2\u0006\u0002\btR\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u00020\u00198\u0012X\u0093\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006v"}, d2={"Lde/justsoftware/wikiservice/business/ArticleService;", "", "permissionService", "Lde/justsoftware/wikiservice/business/PermissionService;", "articleRepository", "Lde/justsoftware/wikiservice/persistence/ArticleRepository;", "articleHeadingRepository", "Lde/justsoftware/wikiservice/persistence/ArticleHeadingRepository;", "headingMigrationRepository", "Lde/justsoftware/wikiservice/persistence/ArticleHeadingMigrationRepository;", "articleVersionRepository", "Lde/justsoftware/wikiservice/persistence/ArticleVersionRepository;", "transactionUtils", "Lde/justsoftware/wikiservice/util/TransactionUtils;", "applicationEventPublisher", "Lorg/springframework/context/ApplicationEventPublisher;", "driveService", "Lde/justsoftware/wikiservice/drive/DriveService;", "ancestorService", "Lde/justsoftware/wikiservice/business/AncestorService;", "clock", "Ljava/time/Clock;", "maxEditingTokenDuration", "", "entityManager", "Ljakarta/persistence/EntityManager;", "<init>", "(Lde/justsoftware/wikiservice/business/PermissionService;Lde/justsoftware/wikiservice/persistence/ArticleRepository;Lde/justsoftware/wikiservice/persistence/ArticleHeadingRepository;Lde/justsoftware/wikiservice/persistence/ArticleHeadingMigrationRepository;Lde/justsoftware/wikiservice/persistence/ArticleVersionRepository;Lde/justsoftware/wikiservice/util/TransactionUtils;Lorg/springframework/context/ApplicationEventPublisher;Lde/justsoftware/wikiservice/drive/DriveService;Lde/justsoftware/wikiservice/business/AncestorService;Ljava/time/Clock;JLjakarta/persistence/EntityManager;)V", "create", "Lde/justsoftware/wikiservice/business/model/Article;", "parentId", "Lde/justsoftware/wikiservice/model/ParentId;", "wiki", "Lde/justsoftware/wikiservice/model/WikiId;", "title", "", "content", "textContent", "creator", "Lde/justsoftware/wikiservice/model/ProfileId;", "position", "", "draft", "", "getLatestPublishedOrDraftArticleVersion", "Lde/justsoftware/wikiservice/business/model/ArticleVersion;", "articleId", "Lde/justsoftware/wikiservice/model/ArticleId;", "getLatestPublishedArticleVersion", "findLatestPublishedArticleVersion", "findDraftArticleVersion", "getDraftArticleVersion", "findLatestPublishedArticleVersions", "", "articleIds", "", "findDraftArticleVersions", "readBySubscriber", "", "Lde/justsoftware/wikiservice/application/model/ArticleWithTitleDto;", "subscriber", "page", "limit", "read", "getArticleVersion", "versionId", "Lde/justsoftware/wikiservice/model/ArticleVersionId;", "readPublishedVersions", "readPublishedVersionPage", "Lorg/springframework/data/domain/Page;", "pageSize", "readHeadings", "Lde/justsoftware/wikiservice/business/model/ArticleHeading;", "readByIds", "readByParentIds", "parentIds", "streamAllIds", "Ljava/util/stream/Stream;", "Ljava/util/UUID;", "countByWikiIds", "wikiIds", "countByParentIds", "update", "updater", "updatePublishedVersion", "latestPublishedVersion", "article", "normalizedTitle", "currentDraftVersion", "oldContent", "updateDraft", "getOldContent", "updateAncestors", "", "newVersion", "persistHeadings", "persistNewFiles", "newContent", "verifyTitleAndContent", "delete", "deletionId", "Lde/justsoftware/wikiservice/model/DeletionId;", "deletedBy", "deleteByParentIds", "deleteWikiArticles", "wikiId", "updateEditingToken", "deleteEditingToken", "removeDeletedArticles", "deletionIds", "migrateArticlesHeaders", "articlesHeadersFullyMigrated", "migrateArticleHeaders", "Lde/justsoftware/wikiservice/persistence/model/DbArticleHeadingMigrationStatus;", "toMigrate", "articleVersion", "migrateArticleHeaders$wiki_service", "Companion", "wiki-service"})
@SourceDebugExtension(value={"SMAP\nArticleService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ArticleService.kt\nde/justsoftware/wikiservice/business/ArticleService\n+ 2 CollectionUtils.kt\nde/justsoftware/wikiservice/util/CollectionUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,678:1\n7#2:679\n7#2:687\n7#2:712\n7#2:728\n7#2:747\n7#2:771\n7#2:779\n7#2:784\n7#2:788\n1628#3,3:680\n1628#3,3:688\n1368#3:695\n1454#3,5:696\n2642#3:701\n1279#3,2:703\n1293#3,2:705\n1557#3:707\n1628#3,3:708\n1296#3:711\n1628#3,3:713\n1202#3,2:716\n1230#3,4:718\n1246#3,4:724\n1628#3,3:729\n1246#3,2:734\n1557#3:736\n1628#3,3:737\n1249#3:740\n1279#3,2:741\n1293#3,4:743\n1628#3,3:748\n1279#3,2:751\n1293#3,4:753\n1557#3:757\n1628#3,3:758\n1557#3:761\n1628#3,3:762\n1368#3:765\n1454#3,5:766\n1628#3,3:772\n1863#3,2:775\n1863#3,2:777\n1628#3,3:780\n1557#3:783\n1628#3,3:785\n1628#3,3:789\n1557#3:792\n1628#3,3:793\n1246#3,4:798\n1557#3:802\n1628#3,3:803\n1863#3,2:806\n1863#3,2:808\n1863#3,2:810\n126#4:683\n153#4,3:684\n126#4:691\n153#4,3:692\n1#5:702\n462#6:722\n412#6:723\n462#6:732\n412#6:733\n462#6:796\n412#6:797\n*S KotlinDebug\n*F\n+ 1 ArticleService.kt\nde/justsoftware/wikiservice/business/ArticleService\n*L\n172#1:679\n177#1:687\n236#1:712\n243#1:728\n254#1:747\n499#1:771\n577#1:779\n581#1:784\n582#1:788\n172#1:680,3\n177#1:688,3\n202#1:695\n202#1:696,5\n205#1:701\n223#1:703,2\n223#1:705,2\n226#1:707\n226#1:708,3\n223#1:711\n236#1:713,3\n237#1:716,2\n237#1:718,4\n238#1:724,4\n243#1:729,3\n244#1:734,2\n244#1:736\n244#1:737,3\n244#1:740\n246#1:741,2\n246#1:743,4\n254#1:748,3\n256#1:751,2\n256#1:753,4\n260#1:757\n260#1:758,3\n432#1:761\n432#1:762,3\n449#1:765\n449#1:766,5\n499#1:772,3\n500#1:775,2\n515#1:777,2\n577#1:780,3\n577#1:783\n581#1:785,3\n582#1:789,3\n608#1:792\n608#1:793,3\n609#1:798,4\n649#1:802\n649#1:803,3\n504#1:806,2\n521#1:808,2\n585#1:810,2\n173#1:683\n173#1:684,3\n178#1:691\n178#1:692,3\n205#1:702\n238#1:722\n238#1:723\n244#1:732\n244#1:733\n609#1:796\n609#1:797\n*E\n"})
public class ArticleService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PermissionService permissionService;
    @NotNull
    private final ArticleRepository articleRepository;
    @NotNull
    private final ArticleHeadingRepository articleHeadingRepository;
    @NotNull
    private final ArticleHeadingMigrationRepository headingMigrationRepository;
    @NotNull
    private final ArticleVersionRepository articleVersionRepository;
    @NotNull
    private final TransactionUtils transactionUtils;
    @NotNull
    private final ApplicationEventPublisher applicationEventPublisher;
    @NotNull
    private final DriveService driveService;
    @NotNull
    private final AncestorService ancestorService;
    @NotNull
    private final Clock clock;
    private final long maxEditingTokenDuration;
    @PersistenceContext
    @NotNull
    private final EntityManager entityManager;
    private static final Logger LOG = LoggerFactory.getLogger(ArticleService.class);
    private static boolean articlesHeadersMigrationFinished;

    @Autowired
    public ArticleService(@NotNull PermissionService permissionService, @NotNull ArticleRepository articleRepository, @NotNull ArticleHeadingRepository articleHeadingRepository, @NotNull ArticleHeadingMigrationRepository headingMigrationRepository, @NotNull ArticleVersionRepository articleVersionRepository, @NotNull TransactionUtils transactionUtils, @NotNull ApplicationEventPublisher applicationEventPublisher, @NotNull DriveService driveService, @NotNull AncestorService ancestorService, @NotNull Clock clock, @Value(value="${service.maxArticleEditingTokenDurationSec:28800}") long maxEditingTokenDuration, @NotNull EntityManager entityManager) {
        Intrinsics.checkNotNullParameter((Object)permissionService, (String)"permissionService");
        Intrinsics.checkNotNullParameter((Object)articleRepository, (String)"articleRepository");
        Intrinsics.checkNotNullParameter((Object)articleHeadingRepository, (String)"articleHeadingRepository");
        Intrinsics.checkNotNullParameter((Object)headingMigrationRepository, (String)"headingMigrationRepository");
        Intrinsics.checkNotNullParameter((Object)articleVersionRepository, (String)"articleVersionRepository");
        Intrinsics.checkNotNullParameter((Object)transactionUtils, (String)"transactionUtils");
        Intrinsics.checkNotNullParameter((Object)applicationEventPublisher, (String)"applicationEventPublisher");
        Intrinsics.checkNotNullParameter((Object)driveService, (String)"driveService");
        Intrinsics.checkNotNullParameter((Object)ancestorService, (String)"ancestorService");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)entityManager, (String)"entityManager");
        this.permissionService = permissionService;
        this.articleRepository = articleRepository;
        this.articleHeadingRepository = articleHeadingRepository;
        this.headingMigrationRepository = headingMigrationRepository;
        this.articleVersionRepository = articleVersionRepository;
        this.transactionUtils = transactionUtils;
        this.applicationEventPublisher = applicationEventPublisher;
        this.driveService = driveService;
        this.ancestorService = ancestorService;
        this.clock = clock;
        this.maxEditingTokenDuration = maxEditingTokenDuration;
        this.entityManager = entityManager;
    }

    @Transactional
    @NotNull
    public Article create(@NotNull ParentId parentId, @NotNull WikiId wiki, @NotNull String title, @NotNull String content, @NotNull String textContent, @NotNull ProfileId creator, int position, boolean draft) {
        Intrinsics.checkNotNullParameter((Object)parentId, (String)"parentId");
        Intrinsics.checkNotNullParameter((Object)wiki, (String)"wiki");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)textContent, (String)"textContent");
        Intrinsics.checkNotNullParameter((Object)creator, (String)"creator");
        if (StringsKt.isBlank((CharSequence)title)) {
            throw new EmptyArticleTitleException();
        }
        ProseMirrorContentParserKt.verifyAllHeadingsHaveUniqueIds((String)content);
        ArticleVersionId articleVersionId = new ArticleVersionId();
        UUID uUID = UUID.randomUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"randomUUID(...)");
        Object object = this.articleRepository.save((Object)new DbArticle(uUID, wiki.getId(), parentId.getId(), parentId.type(), null, null, null, Integer.valueOf(position), 112, null));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"save(...)");
        Article article = DbArticle.Companion.toArticle((DbArticle)object);
        ArticleId articleId = article.getId();
        UUID uUID2 = articleVersionId.getId();
        UUID uUID3 = articleId.getId();
        String string = StringUtils.normalizeSpace((String)title);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"normalizeSpace(...)");
        Object object2 = this.articleVersionRepository.save((Object)new DbArticleVersion(uUID2, uUID3, string, content, textContent, draft, creator.getId()));
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"save(...)");
        ArticleVersion version = DbArticleVersion.Companion.toArticleVersion((DbArticleVersion)object2);
        if (!draft) {
            this.persistHeadings(content, articleId);
        }
        this.persistNewFiles(CollectionsKt.emptyList(), content, articleId, creator);
        this.transactionUtils.afterCommit(() -> ArticleService.create$lambda$0(this, articleId));
        this.permissionService.addPermissionItemForNewArticle(articleId, wiki);
        this.updateAncestors(version, article);
        return article;
    }

    @Transactional
    @NotNull
    public ArticleVersion getLatestPublishedOrDraftArticleVersion(@NotNull ArticleId articleId) throws ArticleVersionNotFoundException {
        Intrinsics.checkNotNullParameter((Object)articleId, (String)"articleId");
        ArticleVersion articleVersion = this.findLatestPublishedArticleVersion(articleId);
        if (articleVersion == null && (articleVersion = this.findDraftArticleVersion(articleId)) == null) {
            throw new ArticleVersionNotFoundException(null, 1, null);
        }
        return articleVersion;
    }

    @Transactional
    @NotNull
    public ArticleVersion getLatestPublishedArticleVersion(@NotNull ArticleId articleId) throws ArticleVersionNotFoundException {
        Intrinsics.checkNotNullParameter((Object)articleId, (String)"articleId");
        ArticleVersion articleVersion = this.findLatestPublishedArticleVersion(articleId);
        if (articleVersion == null) {
            throw new ArticleVersionNotFoundException(null, 1, null);
        }
        return articleVersion;
    }

    @Transactional
    @Nullable
    public ArticleVersion findLatestPublishedArticleVersion(@NotNull ArticleId articleId) {
        Intrinsics.checkNotNullParameter((Object)articleId, (String)"articleId");
        DbArticleVersion dbArticleVersion = (DbArticleVersion)this.articleVersionRepository.findLatestPublishedArticleVersionsByArticleIds(SetsKt.setOf((Object)articleId.getId())).get(articleId.getId());
        return dbArticleVersion != null ? DbArticleVersion.Companion.toArticleVersion(dbArticleVersion) : null;
    }

    @Transactional
    @Nullable
    public ArticleVersion findDraftArticleVersion(@NotNull ArticleId articleId) {
        Intrinsics.checkNotNullParameter((Object)articleId, (String)"articleId");
        DbArticleVersion dbArticleVersion = (DbArticleVersion)this.articleVersionRepository.findDraftArticleVersionsByArticleIds(SetsKt.setOf((Object)articleId.getId())).get(articleId.getId());
        return dbArticleVersion != null ? DbArticleVersion.Companion.toArticleVersion(dbArticleVersion) : null;
    }

    @Transactional
    @NotNull
    public ArticleVersion getDraftArticleVersion(@NotNull ArticleId articleId) throws ArticleVersionNotFoundException {
        Intrinsics.checkNotNullParameter((Object)articleId, (String)"articleId");
        ArticleVersion articleVersion = this.findDraftArticleVersion(articleId);
        if (articleVersion == null) {
            throw new ArticleVersionNotFoundException(null, 1, null);
        }
        return articleVersion;
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    @NotNull
    public Map<ArticleId, ArticleVersion> findLatestPublishedArticleVersions(@NotNull Set<ArticleId> articleIds) {
        Object it;
        Object item$iv$iv;
        Map $this$mapTo$iv$iv;
        void $this$mapToSet$iv;
        Intrinsics.checkNotNullParameter(articleIds, (String)"articleIds");
        Iterable iterable = articleIds;
        Object object = this.articleVersionRepository;
        boolean $i$f$mapToSet = false;
        void var4_5 = $this$mapToSet$iv;
        Collection destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
        boolean $i$f$mapTo = false;
        Iterator<Object> iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            item$iv$iv = iterator.next();
            ArticleId articleId = (ArticleId)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getId());
        }
        Map $this$map$iv = object.findLatestPublishedArticleVersionsByArticleIds((Set)destination$iv$iv);
        boolean $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.size());
        $i$f$mapTo = false;
        iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            it = item$iv$iv = (Map.Entry)iterator.next();
            object = destination$iv$iv;
            boolean bl = false;
            object.add(TuplesKt.to((Object)new ArticleId((UUID)it.getKey()), (Object)DbArticleVersion.Companion.toArticleVersion((DbArticleVersion)it.getValue())));
        }
        return MapsKt.toMap((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    @NotNull
    public Map<ArticleId, ArticleVersion> findDraftArticleVersions(@NotNull Set<ArticleId> articleIds) {
        Object it;
        Object item$iv$iv;
        Map $this$mapTo$iv$iv;
        void $this$mapToSet$iv;
        Intrinsics.checkNotNullParameter(articleIds, (String)"articleIds");
        Iterable iterable = articleIds;
        Object object = this.articleVersionRepository;
        boolean $i$f$mapToSet = false;
        void var4_5 = $this$mapToSet$iv;
        Collection destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
        boolean $i$f$mapTo = false;
        Iterator<Object> iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            item$iv$iv = iterator.next();
            ArticleId articleId = (ArticleId)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getId());
        }
        Map $this$map$iv = object.findDraftArticleVersionsByArticleIds((Set)destination$iv$iv);
        boolean $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.size());
        $i$f$mapTo = false;
        iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            it = item$iv$iv = (Map.Entry)iterator.next();
            object = destination$iv$iv;
            boolean bl = false;
            object.add(TuplesKt.to((Object)new ArticleId((UUID)it.getKey()), (Object)DbArticleVersion.Companion.toArticleVersion((DbArticleVersion)it.getValue())));
        }
        return MapsKt.toMap((Iterable)((List)destination$iv$iv));
    }

    @Transactional(readOnly=true)
    @NotNull
    public List<ArticleWithTitleDto> readBySubscriber(@NotNull ProfileId subscriber, int page, int limit) {
        Intrinsics.checkNotNullParameter((Object)subscriber, (String)"subscriber");
        long l = subscriber.getId();
        String[] stringArray = new String[]{"id"};
        PageRequest pageRequest = PageRequest.of((int)page, (int)limit, (Sort)Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])stringArray));
        Intrinsics.checkNotNullExpressionValue((Object)pageRequest, (String)"of(...)");
        List<ArticleWithTitleDto> list = this.articleRepository.findAllBySubscriber(l, (Pageable)pageRequest).get().toList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"toList(...)");
        return list;
    }

    @Transactional
    @NotNull
    public Article read(@NotNull ArticleId articleId) {
        Intrinsics.checkNotNullParameter((Object)articleId, (String)"articleId");
        Object object = this.articleRepository.getReferenceById((Object)articleId.getId());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getReferenceById(...)");
        return DbArticle.Companion.toArticle((DbArticle)object);
    }

    @Transactional
    @NotNull
    public ArticleVersion getArticleVersion(@NotNull ArticleVersionId versionId) {
        Intrinsics.checkNotNullParameter((Object)versionId, (String)"versionId");
        Object t = this.articleVersionRepository.findById((Object)versionId.getId()).orElseThrow(() -> ArticleService.getArticleVersion$lambda$5(versionId));
        Intrinsics.checkNotNullExpressionValue(t, (String)"orElseThrow(...)");
        return DbArticleVersion.Companion.toArticleVersion((DbArticleVersion)t);
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    @NotNull
    public List<ArticleVersion> readPublishedVersions(@NotNull Set<ArticleId> articleIds) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(articleIds, (String)"articleIds");
        Iterable $this$flatMap$iv = articleIds;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            ArticleId article = (ArticleId)element$iv$iv;
            boolean bl = false;
            List<ArticleVersion> list = this.articleVersionRepository.findByArticleIdAndIsDraftFalseOrderByCreatedAtDesc(article.getId()).map(arg_0 -> ArticleService.readPublishedVersions$lambda$8$lambda$7(ArticleService::readPublishedVersions$lambda$8$lambda$6, arg_0)).toList();
            Intrinsics.checkNotNullExpressionValue(list, (String)"toList(...)");
            Iterable list$iv$iv = list;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$onEach$iv = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        boolean $i$f$onEach = false;
        Iterable $this$onEach_u24lambda_u2419$iv = iterable = $this$onEach$iv;
        boolean bl = false;
        for (Object element$iv : $this$onEach_u24lambda_u2419$iv) {
            ArticleVersion it = (ArticleVersion)element$iv;
            boolean bl2 = false;
            this.entityManager.detach((Object)it);
        }
        return (List)iterable;
    }

    @Transactional
    @NotNull
    public Page<ArticleVersion> readPublishedVersionPage(@NotNull ArticleId articleId, int page, int pageSize) {
        Intrinsics.checkNotNullParameter((Object)articleId, (String)"articleId");
        String[] stringArray = new String[]{"createdAt"};
        PageRequest pageable = PageRequest.of((int)page, (int)pageSize, (Sort)Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])stringArray));
        UUID uUID = articleId.getId();
        Intrinsics.checkNotNull((Object)pageable);
        Page page2 = this.articleVersionRepository.findByArticleIdAndIsDraftFalse(uUID, (Pageable)pageable).map(arg_0 -> ArticleService.readPublishedVersionPage$lambda$11(ArticleService::readPublishedVersionPage$lambda$10, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)page2, (String)"map(...)");
        return page2;
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    @NotNull
    public Map<ArticleId, List<ArticleHeading>> readHeadings(@NotNull Set<ArticleId> articleIds) {
        Intrinsics.checkNotNullParameter(articleIds, (String)"articleIds");
        Iterable $this$associateWith$iv = articleIds;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            void id;
            ArticleId articleId = (ArticleId)element$iv$iv;
            Object t = element$iv$iv;
            Map map = result$iv;
            boolean bl = false;
            Iterable iterable = this.articleHeadingRepository.findByArticleIdOrderBySortOrderAsc(id.getId());
            boolean $i$f$map = false;
            void var13_13 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void heading;
                DbArticleHeading dbArticleHeading = (DbArticleHeading)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                this.entityManager.detach((Object)heading);
                collection.add(DbArticleHeading.Companion.toArticleHeading((DbArticleHeading)heading));
            }
            List list = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
            map.put(t, list);
        }
        return result$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    @NotNull
    public Map<ArticleId, Article> readByIds(@NotNull Set<ArticleId> articleIds) {
        void $this$mapValuesTo$iv$iv;
        void $this$associateByTo$iv$iv;
        Collection<Object> collection;
        void $this$mapTo$iv$iv;
        void $this$mapToSet$iv;
        Intrinsics.checkNotNullParameter(articleIds, (String)"articleIds");
        Iterable iterable = articleIds;
        Object object = this.articleRepository;
        boolean $i$f$mapToSet = false;
        void var4_5 = $this$mapToSet$iv;
        Object destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ArticleId articleId = (ArticleId)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getId());
        }
        Iterable $this$associateBy$iv = object.findByIds((Set)destination$iv$iv);
        boolean $i$f$associateBy = false;
        int capacity$iv22 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associateBy$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv22);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            DbArticle bl = (DbArticle)element$iv$iv;
            object = destination$iv$iv2;
            boolean bl2 = false;
            object.put(new ArticleId(it.getId()), element$iv$iv);
        }
        Map $this$mapValues$iv = destination$iv$iv2;
        boolean $i$f$mapValues = false;
        Map capacity$iv22 = $this$mapValues$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo2 = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            Map.Entry bl2 = (Map.Entry)element$iv$iv$iv;
            Object object2 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            collection = it$iv$iv.getKey();
            object = object2;
            boolean bl3 = false;
            Article article = DbArticle.Companion.toArticle((DbArticle)it.getValue());
            object.put(collection, article);
        }
        return destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<ParentId, List<Article>> readByParentIds(@NotNull Set<? extends ParentId> parentIds) {
        List list;
        void $this$mapValuesTo$iv$iv;
        ParentId it;
        Collection<Object> collection;
        Map $this$mapTo$iv$iv;
        void $this$mapToSet$iv;
        Intrinsics.checkNotNullParameter(parentIds, (String)"parentIds");
        Iterable iterable = parentIds;
        Object object = this.articleRepository;
        boolean $i$f$mapToSet = false;
        void var5_5 = $this$mapToSet$iv;
        Object destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object item$iv$iv = iterator.next();
            ParentId parentId = (ParentId)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getId());
        }
        Map $this$mapValues$iv = object.findByParentIds((Set)destination$iv$iv);
        boolean $i$f$mapValues = false;
        $this$mapTo$iv$iv = $this$mapValues$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void $this$mapTo$iv$iv2;
            void it2;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Object object2 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            collection = it$iv$iv.getKey();
            object = object2;
            boolean bl2 = false;
            Iterable $this$map$iv = (Iterable)it2.getValue();
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void dbArticle;
                DbArticle dbArticle2 = (DbArticle)item$iv$iv;
                Collection collection2 = destination$iv$iv2;
                boolean bl3 = false;
                collection2.add(DbArticle.Companion.toArticle((DbArticle)dbArticle));
            }
            list = (List)destination$iv$iv2;
            object.put(collection, list);
        }
        Object parentArticles = destination$iv$iv;
        Iterable $this$associateWith$iv = parentIds;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            it = (ParentId)element$iv$iv;
            collection = element$iv$iv;
            object = result$iv;
            boolean bl = false;
            list = parentArticles.getOrDefault(it.getId(), CollectionsKt.emptyList());
            object.put(collection, list);
        }
        return result$iv;
    }

    @NotNull
    public Stream<UUID> streamAllIds() {
        return this.articleRepository.streamAllIds();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<WikiId, Integer> countByWikiIds(@NotNull Set<WikiId> wikiIds) {
        WikiId it;
        Collection<Object> collection;
        void $this$mapTo$iv$iv;
        void $this$mapToSet$iv;
        Intrinsics.checkNotNullParameter(wikiIds, (String)"wikiIds");
        Iterable iterable = wikiIds;
        Object object = this.articleRepository;
        boolean $i$f$mapToSet = false;
        void var5_5 = $this$mapToSet$iv;
        Collection destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            WikiId wikiId = (WikiId)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getId());
        }
        Map countsByWiki = object.countByWikiIds((Set)destination$iv$iv);
        Iterable $this$associateWith$iv = wikiIds;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            it = (WikiId)element$iv$iv;
            collection = element$iv$iv;
            object = result$iv;
            boolean bl = false;
            Integer n = (int)((Number)countsByWiki.getOrDefault(it.getId(), 0L)).longValue();
            object.put(collection, n);
        }
        return result$iv;
    }

    /*
     * WARNING - void declaration
     */
    public long countByParentIds(@NotNull Set<? extends ParentId> parentIds) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(parentIds, (String)"parentIds");
        Iterable iterable = parentIds;
        ArticleRepository articleRepository = this.articleRepository;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ParentId parentId = (ParentId)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getId());
        }
        return articleRepository.countByParentIds(CollectionsKt.toSet((Iterable)((List)destination$iv$iv)));
    }

    @Transactional
    @NotNull
    public Article update(@NotNull ArticleId articleId, @NotNull String title, @NotNull String content, @NotNull String textContent, @NotNull ProfileId updater, boolean draft) {
        Intrinsics.checkNotNullParameter((Object)articleId, (String)"articleId");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)textContent, (String)"textContent");
        Intrinsics.checkNotNullParameter((Object)updater, (String)"updater");
        this.verifyTitleAndContent(title, content, textContent);
        Object object = this.articleRepository.getReferenceById((Object)articleId.getId());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getReferenceById(...)");
        Article article = DbArticle.Companion.toArticle((DbArticle)object);
        ArticleVersion latestPublishedVersion = this.findLatestPublishedArticleVersion(articleId);
        ArticleVersion currentDraftVersion = this.findDraftArticleVersion(articleId);
        List oldContent = this.getOldContent(latestPublishedVersion, currentDraftVersion);
        String normalizedTitle = StringUtils.normalizeSpace((String)title);
        if (draft) {
            Intrinsics.checkNotNull((Object)normalizedTitle);
            return this.updateDraft(currentDraftVersion, content, normalizedTitle, article, articleId, textContent, updater, oldContent);
        }
        Intrinsics.checkNotNull((Object)normalizedTitle);
        return this.updatePublishedVersion(latestPublishedVersion, articleId, article, content, normalizedTitle, textContent, updater, currentDraftVersion, oldContent);
    }

    private Article updatePublishedVersion(ArticleVersion latestPublishedVersion, ArticleId articleId, Article article, String content, String normalizedTitle, String textContent, ProfileId updater, ArticleVersion currentDraftVersion, List<String> oldContent) {
        if (latestPublishedVersion != null && Intrinsics.areEqual((Object)latestPublishedVersion.getContent(), (Object)content) && Intrinsics.areEqual((Object)latestPublishedVersion.getTitle(), (Object)normalizedTitle)) {
            return article;
        }
        ArticleVersionId newArticleVersionId = new ArticleVersionId();
        DbArticleVersion newArticleVersion = (DbArticleVersion)this.articleVersionRepository.save((Object)new DbArticleVersion(newArticleVersionId.getId(), articleId.getId(), normalizedTitle, content, textContent, false, updater.getId()));
        if (currentDraftVersion != null) {
            this.articleVersionRepository.deleteById((Object)currentDraftVersion.getId().getId());
        }
        this.persistNewFiles(oldContent, content, articleId, updater);
        if (latestPublishedVersion == null || !Intrinsics.areEqual((Object)latestPublishedVersion.getContent(), (Object)content)) {
            this.persistHeadings(content, articleId);
        }
        this.transactionUtils.afterCommit(() -> ArticleService.updatePublishedVersion$lambda$24(this, articleId));
        Intrinsics.checkNotNull((Object)newArticleVersion);
        this.updateAncestors(DbArticleVersion.Companion.toArticleVersion(newArticleVersion), article);
        return article;
    }

    private Article updateDraft(ArticleVersion currentDraftVersion, String content, String normalizedTitle, Article article, ArticleId articleId, String textContent, ProfileId updater, List<String> oldContent) {
        if (currentDraftVersion != null && Intrinsics.areEqual((Object)currentDraftVersion.getContent(), (Object)content) && Intrinsics.areEqual((Object)currentDraftVersion.getTitle(), (Object)normalizedTitle)) {
            return article;
        }
        ArticleVersionId newArticleVersionId = new ArticleVersionId();
        this.articleVersionRepository.save((Object)new DbArticleVersion(newArticleVersionId.getId(), articleId.getId(), normalizedTitle, content, textContent, true, updater.getId()));
        if (currentDraftVersion != null) {
            this.articleVersionRepository.deleteById((Object)currentDraftVersion.getId().getId());
        }
        this.persistNewFiles(oldContent, content, articleId, updater);
        this.transactionUtils.afterCommit(() -> ArticleService.updateDraft$lambda$25(this, articleId));
        return article;
    }

    private List<String> getOldContent(ArticleVersion latestPublishedVersion, ArticleVersion currentDraftVersion) {
        List oldContent = new ArrayList();
        if (latestPublishedVersion != null) {
            oldContent.add(latestPublishedVersion.getContent());
        }
        if (currentDraftVersion != null) {
            oldContent.add(currentDraftVersion.getContent());
        }
        return CollectionsKt.toList((Iterable)oldContent);
    }

    private void updateAncestors(ArticleVersion newVersion, Article article) {
        Instant updatedAt = newVersion.getUpdatedAt();
        if (updatedAt == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        this.ancestorService.updateEditedStatusForAncestors(article.getParentId(), updatedAt, newVersion.getModifiedBy());
    }

    /*
     * WARNING - void declaration
     */
    private void persistHeadings(String content, ArticleId articleId) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        this.articleHeadingRepository.deleteAllByArticleId(articleId.getId());
        Iterable iterable = ProseMirrorContentParserKt.getHeadings((String)content);
        boolean $i$f$map = false;
        void var6_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void heading;
            ArticleHeadingInfo articleHeadingInfo = (ArticleHeadingInfo)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new DbArticleHeading(heading.getId(), articleId.getId(), heading.getText(), heading.getSortOrder()));
        }
        List headings = (List)destination$iv$iv;
        this.articleHeadingRepository.saveAll((Iterable)headings);
    }

    /*
     * WARNING - void declaration
     */
    private void persistNewFiles(List<String> oldContent, String newContent, ArticleId articleId, ProfileId updater) {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = oldContent;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = ProseMirrorContentParserKt.driveMediaIdsFromPMContent((String)it);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Set oldDriveMediaIds = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Set newDriveMediaIds = ProseMirrorContentParserKt.driveMediaIdsFromPMContent((String)newContent);
        Set driveMediaIdsToSave = SetsKt.minus((Set)newDriveMediaIds, (Iterable)oldDriveMediaIds);
        if (!((Collection)driveMediaIdsToSave).isEmpty()) {
            this.driveService.persistFiles(driveMediaIdsToSave, articleId, updater);
        }
    }

    private void verifyTitleAndContent(String title, String content, String textContent) {
        boolean contentIsValidForUpdate;
        if (title != null && StringsKt.isBlank((CharSequence)title)) {
            throw new EmptyArticleTitleException();
        }
        boolean bl = contentIsValidForUpdate = content == null && textContent == null || content != null && textContent != null;
        if (!contentIsValidForUpdate) {
            boolean bl2 = false;
            String string = "You cannot save content without textContent or vice versa";
            throw new IllegalArgumentException(string.toString());
        }
        if (content != null) {
            ProseMirrorContentParserKt.verifyAllHeadingsHaveUniqueIds((String)content);
        }
    }

    @Transactional
    public void delete(@NotNull ArticleId articleId, @NotNull DeletionId deletionId, @NotNull ProfileId deletedBy) {
        Intrinsics.checkNotNullParameter((Object)articleId, (String)"articleId");
        Intrinsics.checkNotNullParameter((Object)deletionId, (String)"deletionId");
        Intrinsics.checkNotNullParameter((Object)deletedBy, (String)"deletedBy");
        DbArticle article = (DbArticle)this.articleRepository.getReferenceById((Object)articleId.getId());
        UUID deletedArticleParentId = article.getParentId();
        IdType deletedArticleParentType = article.getParentType();
        this.articleRepository.deleteById((Object)articleId.getId(), deletionId.getId());
        this.transactionUtils.afterCommit(() -> ArticleService.delete$lambda$29(this, articleId));
        this.permissionService.removePermissionsForDeletedArticle(articleId);
        ParentId parentId = IdUtilsKt.parentIdOf((UUID)deletedArticleParentId, (IdType)deletedArticleParentType);
        Instant instant = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
        this.ancestorService.updateEditedStatusForAncestors(parentId, instant, deletedBy);
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    public void deleteByParentIds(@NotNull Set<? extends ParentId> parentIds, @NotNull DeletionId deletionId) {
        void $this$mapTo$iv$iv;
        void $this$mapToSet$iv;
        Intrinsics.checkNotNullParameter(parentIds, (String)"parentIds");
        Intrinsics.checkNotNullParameter((Object)deletionId, (String)"deletionId");
        Iterable iterable = parentIds;
        ArticleRepository articleRepository = this.articleRepository;
        boolean $i$f$mapToSet = false;
        Iterator iterator = $this$mapToSet$iv;
        Collection destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ParentId parentId = (ParentId)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getId());
        }
        Set deletedArticles = articleRepository.deleteAllByParentIds((Set)destination$iv$iv, deletionId.getId());
        Iterable $this$forEach$iv = deletedArticles;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            UUID it = (UUID)element$iv;
            boolean bl = false;
            this.permissionService.removePermissionsForDeletedArticle(new ArticleId(it));
        }
        this.transactionUtils.afterCommit(() -> ArticleService.deleteByParentIds$lambda$33(deletedArticles, this));
    }

    @Transactional
    public void deleteWikiArticles(@NotNull WikiId wikiId, @NotNull DeletionId deletionId) {
        Intrinsics.checkNotNullParameter((Object)wikiId, (String)"wikiId");
        Intrinsics.checkNotNullParameter((Object)deletionId, (String)"deletionId");
        Set deletedArticles = this.articleRepository.deleteAllByWikiId(wikiId.getId(), deletionId.getId());
        Iterable $this$forEach$iv = deletedArticles;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DbArticle it = (DbArticle)element$iv;
            boolean bl = false;
            this.permissionService.removePermissionsForDeletedArticle(new ArticleId(it.getId()));
        }
        this.transactionUtils.afterCommit(() -> ArticleService.deleteWikiArticles$lambda$36(deletedArticles, this));
    }

    @Transactional
    public boolean updateEditingToken(@NotNull ArticleId articleId, @NotNull ProfileId updater) {
        boolean canUpdateToken;
        Intrinsics.checkNotNullParameter((Object)articleId, (String)"articleId");
        Intrinsics.checkNotNullParameter((Object)updater, (String)"updater");
        Object object = this.articleRepository.getReferenceById((Object)articleId.getId());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getReferenceById(...)");
        Article article = DbArticle.Companion.toArticle((DbArticle)object);
        boolean tokenExpired = Article.Companion.isEditTokenExpired(article, this.clock, this.maxEditingTokenDuration);
        boolean bl = canUpdateToken = tokenExpired || Intrinsics.areEqual((Object)article.getEditingStartedBy(), (Object)updater);
        if (!canUpdateToken) {
            return false;
        }
        Instant now = Instant.ofEpochMilli(this.clock.millis());
        article.setEditingStartedAt(now);
        article.setEditingStartedBy(updater);
        this.articleRepository.save((Object)DbArticle.Companion.toDbArticle(article));
        return true;
    }

    @Transactional
    public boolean deleteEditingToken(@NotNull ArticleId articleId, @NotNull ProfileId updater) {
        boolean canDeleteToken;
        Intrinsics.checkNotNullParameter((Object)articleId, (String)"articleId");
        Intrinsics.checkNotNullParameter((Object)updater, (String)"updater");
        Object object = this.articleRepository.getReferenceById((Object)articleId.getId());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getReferenceById(...)");
        Article article = DbArticle.Companion.toArticle((DbArticle)object);
        boolean tokenExpired = Article.Companion.isEditTokenExpired(article, this.clock, this.maxEditingTokenDuration);
        boolean bl = canDeleteToken = tokenExpired || Intrinsics.areEqual((Object)article.getEditingStartedBy(), (Object)updater);
        if (!canDeleteToken) {
            return false;
        }
        article.setEditingStartedAt(null);
        article.setEditingStartedBy(null);
        this.articleRepository.save((Object)DbArticle.Companion.toDbArticle(article));
        return true;
    }

    @Transactional
    public void removeDeletedArticles(@NotNull Set<DeletionId> deletionIds) {
        Object it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$mapToSet$iv;
        Intrinsics.checkNotNullParameter(deletionIds, (String)"deletionIds");
        Iterable iterable = deletionIds;
        Object object = this.articleRepository;
        boolean $i$f$mapToSet = false;
        void var5_5 = $this$mapToSet$iv;
        Collection destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            DeletionId deletionId = (DeletionId)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getId());
        }
        Iterable $this$map$iv = object.findAllByDeletionIds((Set)destination$iv$iv);
        boolean $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (DbArticle)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(it.getId());
        }
        Set articlesToDelete = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        $this$map$iv = articlesToDelete;
        object = this.articleVersionRepository;
        $i$f$mapToSet = false;
        $this$mapTo$iv$iv = $this$mapToSet$iv;
        destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (UUID)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it);
        }
        object.deleteAllByArticleIds((Set)destination$iv$iv);
        $this$mapToSet$iv = deletionIds;
        object = this.articleRepository;
        $i$f$mapToSet = false;
        $this$mapTo$iv$iv = $this$mapToSet$iv;
        destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (DeletionId)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getId());
        }
        object.deleteAllByDeletionIds((Set)destination$iv$iv);
        this.transactionUtils.afterCommit(() -> ArticleService.removeDeletedArticles$lambda$42(articlesToDelete, this));
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    public void migrateArticlesHeaders() {
        do {
            void $this$mapValuesTo$iv$iv;
            Collection<Object> collection;
            Map $this$mapTo$iv$iv;
            void $this$map$iv;
            Object object = new String[]{"id"};
            PageRequest pageRequest = PageRequest.of((int)0, (int)100, (Sort)Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])object));
            Intrinsics.checkNotNullExpressionValue((Object)pageRequest, (String)"of(...)");
            List articlesToMigrateBatch = this.headingMigrationRepository.findByStatusIsPending((Pageable)pageRequest);
            object = articlesToMigrateBatch;
            Object object2 = this.articleVersionRepository;
            boolean $i$f$map = false;
            void var5_6 = $this$map$iv;
            Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                void it;
                Object item$iv$iv = iterator.next();
                DbArticleHeadingMigrationStatus dbArticleHeadingMigrationStatus = (DbArticleHeadingMigrationStatus)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getArticleId());
            }
            Map $this$mapValues$iv = object2.findLatestPublishedArticleVersionsByArticleIds(CollectionsKt.toSet((Iterable)((List)destination$iv$iv)));
            boolean $i$f$mapValues = false;
            $this$mapTo$iv$iv = $this$mapValues$iv;
            destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void it;
                void it$iv$iv;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                Object object3 = destination$iv$iv;
                boolean bl = false;
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                collection = it$iv$iv.getKey();
                object2 = object3;
                boolean bl2 = false;
                ArticleVersion articleVersion = DbArticleVersion.Companion.toArticleVersion((DbArticleVersion)it.getValue());
                object2.put(collection, articleVersion);
            }
            Object versions = destination$iv$iv;
            for (DbArticleHeadingMigrationStatus migration : articlesToMigrateBatch) {
                ArticleVersion version = (ArticleVersion)versions.get(migration.getArticleId());
                if (version == null) {
                    LOG.warn("Could not find article version for article '" + migration.getArticleId() + "'");
                    migration.setStatus(MigrationStatus.FAILED);
                    this.headingMigrationRepository.save((Object)migration);
                    continue;
                }
                DbArticleHeadingMigrationStatus updatedMigration = this.migrateArticleHeaders$wiki_service(migration, version);
                this.headingMigrationRepository.save((Object)updatedMigration);
            }
            this.articleHeadingRepository.flush();
            this.headingMigrationRepository.flush();
            this.articleVersionRepository.flush();
        } while (!this.articlesHeadersFullyMigrated());
    }

    public boolean articlesHeadersFullyMigrated() {
        if (!articlesHeadersMigrationFinished) {
            articlesHeadersMigrationFinished = this.headingMigrationRepository.countByStatus(MigrationStatus.PENDING) == 0;
        }
        return articlesHeadersMigrationFinished;
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    @NotNull
    public DbArticleHeadingMigrationStatus migrateArticleHeaders$wiki_service(@NotNull DbArticleHeadingMigrationStatus toMigrate, @NotNull ArticleVersion articleVersion) {
        Intrinsics.checkNotNullParameter((Object)toMigrate, (String)"toMigrate");
        Intrinsics.checkNotNullParameter((Object)articleVersion, (String)"articleVersion");
        String migratedContent = null;
        List headings = null;
        try {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            migratedContent = ProseMirrorContentParserKt.addIdsToHeadings((String)articleVersion.getContent());
            Iterable iterable = ProseMirrorContentParserKt.getHeadings((String)migratedContent);
            boolean $i$f$map = false;
            void var7_8 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void heading;
                ArticleHeadingInfo articleHeadingInfo = (ArticleHeadingInfo)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new DbArticleHeading(heading.getId(), articleVersion.getArticleId().getId(), heading.getText(), heading.getSortOrder()));
            }
            headings = (List)destination$iv$iv;
        }
        catch (Exception e) {
            LOG.warn("Failed to migrate headings of article version '" + articleVersion.getId() + "'", (Throwable)e);
            toMigrate.setStatus(MigrationStatus.FAILED);
            return toMigrate;
        }
        articleVersion.setContent(migratedContent);
        this.articleHeadingRepository.saveAll((Iterable)headings);
        toMigrate.setStatus(MigrationStatus.MIGRATED);
        return toMigrate;
    }

    private static final Unit create$lambda$0(ArticleService this$0, ArticleId $articleId) {
        this$0.applicationEventPublisher.publishEvent((ApplicationEvent)new ArticleCreatedEvent($articleId));
        return Unit.INSTANCE;
    }

    private static final ArticleVersionNotFoundException getArticleVersion$lambda$5(ArticleVersionId $versionId) {
        return new ArticleVersionNotFoundException($versionId);
    }

    private static final ArticleVersion readPublishedVersions$lambda$8$lambda$6(DbArticleVersion it) {
        Intrinsics.checkNotNull((Object)it);
        return DbArticleVersion.Companion.toArticleVersion(it);
    }

    private static final ArticleVersion readPublishedVersions$lambda$8$lambda$7(Function1 $tmp0, Object p0) {
        return (ArticleVersion)$tmp0.invoke(p0);
    }

    private static final ArticleVersion readPublishedVersionPage$lambda$10(DbArticleVersion it) {
        Intrinsics.checkNotNull((Object)it);
        return DbArticleVersion.Companion.toArticleVersion(it);
    }

    private static final ArticleVersion readPublishedVersionPage$lambda$11(Function1 $tmp0, Object p0) {
        return (ArticleVersion)$tmp0.invoke(p0);
    }

    private static final Unit updatePublishedVersion$lambda$24(ArticleService this$0, ArticleId $articleId) {
        this$0.applicationEventPublisher.publishEvent((ApplicationEvent)new ArticleUpdatedEvent($articleId));
        return Unit.INSTANCE;
    }

    private static final Unit updateDraft$lambda$25(ArticleService this$0, ArticleId $articleId) {
        this$0.applicationEventPublisher.publishEvent((ApplicationEvent)new ArticleUpdatedEvent($articleId));
        return Unit.INSTANCE;
    }

    private static final Unit delete$lambda$29(ArticleService this$0, ArticleId $articleId) {
        this$0.applicationEventPublisher.publishEvent((ApplicationEvent)new ArticleUpdatedEvent($articleId));
        return Unit.INSTANCE;
    }

    private static final Unit deleteByParentIds$lambda$33(Set $deletedArticles, ArticleService this$0) {
        Iterable $this$forEach$iv = $deletedArticles;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            UUID it = (UUID)element$iv;
            boolean bl = false;
            this$0.applicationEventPublisher.publishEvent((ApplicationEvent)new ArticleUpdatedEvent(new ArticleId(it)));
        }
        return Unit.INSTANCE;
    }

    private static final Unit deleteWikiArticles$lambda$36(Set $deletedArticles, ArticleService this$0) {
        Iterable $this$forEach$iv = $deletedArticles;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DbArticle it = (DbArticle)element$iv;
            boolean bl = false;
            this$0.applicationEventPublisher.publishEvent((ApplicationEvent)new ArticleUpdatedEvent(new ArticleId(it.getId())));
        }
        return Unit.INSTANCE;
    }

    private static final Unit removeDeletedArticles$lambda$42(Set $articlesToDelete, ArticleService this$0) {
        Iterable $this$forEach$iv = $articlesToDelete;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            UUID it = (UUID)element$iv;
            boolean bl = false;
            this$0.applicationEventPublisher.publishEvent((ApplicationEvent)new ArticleDeletedEvent(new ArticleId(it)));
        }
        return Unit.INSTANCE;
    }
}

