/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.applicationForNewRestEndpointsRenameLater;

import de.justsoftware.wikiservice.applicationForNewRestEndpointsRenameLater.model.TableOfContentsDto;
import de.justsoftware.wikiservice.authorization.AuthContext;
import de.justsoftware.wikiservice.authorization.AuthorizationService;
import de.justsoftware.wikiservice.business.TableOfContentsService;
import de.justsoftware.wikiservice.business.WikiService;
import de.justsoftware.wikiservice.business.model.UpdateTableOfContentsElement;
import de.justsoftware.wikiservice.business.model.Wiki;
import de.justsoftware.wikiservice.model.ParentId;
import de.justsoftware.wikiservice.model.WikiId;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="TableOfContentsApplicationServiceForNewRestEndpoint")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0001\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J&\u0010\u0012\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lde/justsoftware/wikiservice/applicationForNewRestEndpointsRenameLater/TableOfContentsApplicationService;", "", "tableOfContentsService", "Lde/justsoftware/wikiservice/business/TableOfContentsService;", "wikiService", "Lde/justsoftware/wikiservice/business/WikiService;", "authorizationService", "Lde/justsoftware/wikiservice/authorization/AuthorizationService;", "maxChapterDepth", "", "<init>", "(Lde/justsoftware/wikiservice/business/TableOfContentsService;Lde/justsoftware/wikiservice/business/WikiService;Lde/justsoftware/wikiservice/authorization/AuthorizationService;I)V", "read", "Lde/justsoftware/wikiservice/applicationForNewRestEndpointsRenameLater/model/TableOfContentsDto;", "wikiId", "Lde/justsoftware/wikiservice/model/WikiId;", "authContext", "Lde/justsoftware/wikiservice/authorization/AuthContext;", "update", "updatedItems", "", "Lde/justsoftware/wikiservice/business/model/UpdateTableOfContentsElement;", "wiki-service"})
public class TableOfContentsApplicationService {
    @NotNull
    private final TableOfContentsService tableOfContentsService;
    @NotNull
    private final WikiService wikiService;
    @NotNull
    private final AuthorizationService authorizationService;
    private final int maxChapterDepth;

    public TableOfContentsApplicationService(@NotNull TableOfContentsService tableOfContentsService, @NotNull WikiService wikiService, @NotNull AuthorizationService authorizationService, @Value(value="${service.maxChapterNestingDepth:5}") int maxChapterDepth) {
        Intrinsics.checkNotNullParameter((Object)tableOfContentsService, (String)"tableOfContentsService");
        Intrinsics.checkNotNullParameter((Object)wikiService, (String)"wikiService");
        Intrinsics.checkNotNullParameter((Object)authorizationService, (String)"authorizationService");
        this.tableOfContentsService = tableOfContentsService;
        this.wikiService = wikiService;
        this.authorizationService = authorizationService;
        this.maxChapterDepth = maxChapterDepth;
    }

    @NotNull
    public TableOfContentsDto read(@NotNull WikiId wikiId, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)wikiId, (String)"wikiId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        authContext.checkReadWiki(wikiId);
        Wiki wiki = this.wikiService.read(wikiId);
        boolean mayWriteWiki = this.authorizationService.mayWriteWikis(SetsKt.setOf((Object)wikiId), authContext.getUser()).getOrDefault(wikiId, false);
        List sortedTOCElements = this.tableOfContentsService.getSortedTOCElements((ParentId)wikiId, wikiId, authContext);
        return new TableOfContentsDto(wikiId, wiki.getTitle(), mayWriteWiki, this.maxChapterDepth, sortedTOCElements);
    }

    @NotNull
    public TableOfContentsDto update(@NotNull WikiId wikiId, @NotNull List<UpdateTableOfContentsElement> updatedItems, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)wikiId, (String)"wikiId");
        Intrinsics.checkNotNullParameter(updatedItems, (String)"updatedItems");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        authContext.checkWriteWiki(wikiId);
        this.tableOfContentsService.update(wikiId, updatedItems, authContext.getUser(), this.maxChapterDepth);
        return this.read(wikiId, authContext);
    }
}

