/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.application;

import de.justsoftware.wikiservice.application.PermissionApplicationService;
import de.justsoftware.wikiservice.application.model.WikiDto;
import de.justsoftware.wikiservice.authorization.AuthContext;
import de.justsoftware.wikiservice.authorization.AuthorizationService;
import de.justsoftware.wikiservice.business.DeletionService;
import de.justsoftware.wikiservice.business.WikiService;
import de.justsoftware.wikiservice.business.model.Wiki;
import de.justsoftware.wikiservice.graphql.generated.CreateWikiInput;
import de.justsoftware.wikiservice.graphql.generated.UpdateWikiInput;
import de.justsoftware.wikiservice.model.DeletionId;
import de.justsoftware.wikiservice.model.ItemId;
import de.justsoftware.wikiservice.model.ProfileId;
import de.justsoftware.wikiservice.model.WikiId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B3\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0001\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J.\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0012\u001a\u00020\u0013H\u0017J \u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u001e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0017J\u0018\u0010\u001f\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lde/justsoftware/wikiservice/application/WikiApplicationService;", "", "authorizationService", "Lde/justsoftware/wikiservice/authorization/AuthorizationService;", "wikiService", "Lde/justsoftware/wikiservice/business/WikiService;", "permissionApplicationService", "Lde/justsoftware/wikiservice/application/PermissionApplicationService;", "deletionService", "Lde/justsoftware/wikiservice/business/DeletionService;", "maxPageSize", "", "<init>", "(Lde/justsoftware/wikiservice/authorization/AuthorizationService;Lde/justsoftware/wikiservice/business/WikiService;Lde/justsoftware/wikiservice/application/PermissionApplicationService;Lde/justsoftware/wikiservice/business/DeletionService;I)V", "read", "Lde/justsoftware/wikiservice/application/model/WikiDto;", "wikiId", "Lde/justsoftware/wikiservice/model/WikiId;", "authContext", "Lde/justsoftware/wikiservice/authorization/AuthContext;", "getWikis", "", "onlySubscribedWikis", "", "page", "size", "create", "input", "Lde/justsoftware/wikiservice/graphql/generated/CreateWikiInput;", "update", "Lde/justsoftware/wikiservice/graphql/generated/UpdateWikiInput;", "delete", "wiki-service"})
@SourceDebugExtension(value={"SMAP\nWikiApplicationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WikiApplicationService.kt\nde/justsoftware/wikiservice/application/WikiApplicationService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,131:1\n1#2:132\n1557#3:133\n1628#3,3:134\n*S KotlinDebug\n*F\n+ 1 WikiApplicationService.kt\nde/justsoftware/wikiservice/application/WikiApplicationService\n*L\n78#1:133\n78#1:134,3\n*E\n"})
public class WikiApplicationService {
    @NotNull
    private final AuthorizationService authorizationService;
    @NotNull
    private final WikiService wikiService;
    @NotNull
    private final PermissionApplicationService permissionApplicationService;
    @NotNull
    private final DeletionService deletionService;
    private final int maxPageSize;

    @Autowired
    public WikiApplicationService(@NotNull AuthorizationService authorizationService, @NotNull WikiService wikiService, @NotNull PermissionApplicationService permissionApplicationService, @NotNull DeletionService deletionService, @Value(value="${service.maxPageSize:200}") int maxPageSize) {
        Intrinsics.checkNotNullParameter((Object)authorizationService, (String)"authorizationService");
        Intrinsics.checkNotNullParameter((Object)wikiService, (String)"wikiService");
        Intrinsics.checkNotNullParameter((Object)permissionApplicationService, (String)"permissionApplicationService");
        Intrinsics.checkNotNullParameter((Object)deletionService, (String)"deletionService");
        this.authorizationService = authorizationService;
        this.wikiService = wikiService;
        this.permissionApplicationService = permissionApplicationService;
        this.deletionService = deletionService;
        this.maxPageSize = maxPageSize;
    }

    @NotNull
    public WikiDto read(@NotNull WikiId wikiId, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)wikiId, (String)"wikiId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        authContext.checkReadWiki(wikiId);
        return WikiDto.Companion.toDto(this.wikiService.read(wikiId));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<WikiDto> getWikis(boolean onlySubscribedWikis, int page, int size, @NotNull AuthContext authContext) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable userRoles;
        List list;
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        if (!(page >= 0)) {
            boolean $i$a$-require-WikiApplicationService$getWikis$32 = false;
            String $i$a$-require-WikiApplicationService$getWikis$32 = "Page must not be < 0";
            throw new IllegalArgumentException($i$a$-require-WikiApplicationService$getWikis$32.toString());
        }
        if (!(1 <= size ? size <= this.maxPageSize : false)) {
            boolean $i$a$-require-WikiApplicationService$getWikis$42 = false;
            String $i$a$-require-WikiApplicationService$getWikis$42 = "PageSize must be between 1 and " + this.maxPageSize;
            throw new IllegalArgumentException($i$a$-require-WikiApplicationService$getWikis$42.toString());
        }
        boolean isTenantManager = (Boolean)MapsKt.getValue((Map)this.authorizationService.mayTenantManageWikis(SetsKt.setOf((Object)authContext.getTenantId()), authContext.getUser()), (Object)authContext.getTenantId());
        if (isTenantManager) {
            list = onlySubscribedWikis ? this.wikiService.readByTenantAndSubscriber(authContext.getTenantId(), authContext.getUser(), page, size) : this.wikiService.readByTenant(authContext.getTenantId(), page, size);
        } else {
            userRoles = this.authorizationService.getUserRoles(authContext.getUser());
            list = onlySubscribedWikis ? this.wikiService.readByRolesAndSubscriber(userRoles, authContext.getUser(), page, size, authContext.getTenantId()) : this.wikiService.readByRoles(userRoles, page, size, authContext.getTenantId());
        }
        userRoles = list;
        boolean $i$f$map = false;
        void var8_12 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Wiki wiki = (Wiki)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(WikiDto.Companion.toDto((Wiki)it));
        }
        return CollectionsKt.toList((Iterable)((List)destination$iv$iv));
    }

    @Transactional
    @NotNull
    public WikiDto create(@NotNull CreateWikiInput input, @NotNull AuthContext authContext) {
        WikiDto wikiDto;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        authContext.checkCreateWiki();
        WikiDto it = wikiDto = WikiDto.Companion.toDto(this.wikiService.create(input.getTitle(), input.getDescription(), authContext.getUser(), authContext.getTenantId()));
        boolean bl = false;
        this.permissionApplicationService.setPermissionsForWikiCreation(it.getId(), input.getPermissions(), authContext);
        return wikiDto;
    }

    @Transactional
    @NotNull
    public WikiDto update(@NotNull WikiId wikiId, @NotNull UpdateWikiInput input, @NotNull AuthContext authContext) {
        WikiDto wikiDto;
        Intrinsics.checkNotNullParameter((Object)wikiId, (String)"wikiId");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        authContext.checkManageWiki(wikiId);
        WikiDto it = wikiDto = WikiDto.Companion.toDto(this.wikiService.update(wikiId, input.getTitle(), input.getDescription(), authContext.getUser()));
        boolean bl = false;
        if (input.getPermissions() != null) {
            this.permissionApplicationService.setPermissionsForWikiUpdate(it.getId(), input.getPermissions(), authContext);
        }
        return wikiDto;
    }

    @Transactional
    @NotNull
    public WikiDto delete(@NotNull WikiId wikiId, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)wikiId, (String)"wikiId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        authContext.checkManageWiki(wikiId);
        DeletionId deletionId = DeletionService.create$default((DeletionService)this.deletionService, (ItemId)((ItemId)wikiId), (ProfileId)authContext.getUser(), null, (int)4, null);
        return WikiDto.Companion.toDto(this.wikiService.delete(wikiId, deletionId));
    }
}

