/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.application;

import de.justsoftware.wikiservice.application.model.TableOfContentsDto;
import de.justsoftware.wikiservice.authorization.AuthContext;
import de.justsoftware.wikiservice.business.AncestorService;
import de.justsoftware.wikiservice.business.TableOfContentsService;
import de.justsoftware.wikiservice.business.model.UpdateTableOfContentsElement;
import de.justsoftware.wikiservice.graphql.generated.UpdateTableOfContentsElementInput;
import de.justsoftware.wikiservice.graphql.generated.UpdateTableOfContentsInput;
import de.justsoftware.wikiservice.model.ParentId;
import de.justsoftware.wikiservice.model.WikiId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B#\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0001\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lde/justsoftware/wikiservice/application/TableOfContentsApplicationService;", "", "tableOfContentsService", "Lde/justsoftware/wikiservice/business/TableOfContentsService;", "ancestorService", "Lde/justsoftware/wikiservice/business/AncestorService;", "maxChapterDepth", "", "<init>", "(Lde/justsoftware/wikiservice/business/TableOfContentsService;Lde/justsoftware/wikiservice/business/AncestorService;I)V", "read", "Lde/justsoftware/wikiservice/application/model/TableOfContentsDto;", "id", "Lde/justsoftware/wikiservice/model/ParentId;", "authContext", "Lde/justsoftware/wikiservice/authorization/AuthContext;", "update", "", "input", "Lde/justsoftware/wikiservice/graphql/generated/UpdateTableOfContentsInput;", "wiki-service"})
@SourceDebugExtension(value={"SMAP\nTableOfContentsApplicationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TableOfContentsApplicationService.kt\nde/justsoftware/wikiservice/application/TableOfContentsApplicationService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,46:1\n1557#2:47\n1628#2,3:48\n*S KotlinDebug\n*F\n+ 1 TableOfContentsApplicationService.kt\nde/justsoftware/wikiservice/application/TableOfContentsApplicationService\n*L\n40#1:47\n40#1:48,3\n*E\n"})
public class TableOfContentsApplicationService {
    @NotNull
    private final TableOfContentsService tableOfContentsService;
    @NotNull
    private final AncestorService ancestorService;
    private final int maxChapterDepth;

    @Autowired
    public TableOfContentsApplicationService(@NotNull TableOfContentsService tableOfContentsService, @NotNull AncestorService ancestorService, @Value(value="${service.maxChapterNestingDepth:5}") int maxChapterDepth) {
        Intrinsics.checkNotNullParameter((Object)tableOfContentsService, (String)"tableOfContentsService");
        Intrinsics.checkNotNullParameter((Object)ancestorService, (String)"ancestorService");
        this.tableOfContentsService = tableOfContentsService;
        this.ancestorService = ancestorService;
        this.maxChapterDepth = maxChapterDepth;
    }

    @NotNull
    public TableOfContentsDto read(@NotNull ParentId id, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        WikiId wikiId = this.ancestorService.getAncestorWikiId(id);
        authContext.checkReadWiki(wikiId);
        List sortedTOCElements = this.tableOfContentsService.getSortedTOCElements(id, wikiId, authContext);
        return new TableOfContentsDto(wikiId, id, this.maxChapterDepth, sortedTOCElements);
    }

    /*
     * WARNING - void declaration
     */
    public boolean update(@NotNull UpdateTableOfContentsInput input, @NotNull AuthContext authContext) {
        Collection<UpdateTableOfContentsElement> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        authContext.checkWriteWiki(input.getWikiId());
        Iterable iterable = input.getItems();
        WikiId wikiId = input.getWikiId();
        TableOfContentsService tableOfContentsService = this.tableOfContentsService;
        boolean $i$f$map = false;
        void var5_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            UpdateTableOfContentsElementInput updateTableOfContentsElementInput = (UpdateTableOfContentsElementInput)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new UpdateTableOfContentsElement(it.getId(), it.getParentId()));
        }
        collection = (List)destination$iv$iv;
        return tableOfContentsService.update(wikiId, (List)collection, authContext.getUser(), this.maxChapterDepth);
    }
}

