/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.application;

import de.justsoftware.wikiservice.application.model.ProfileDto;
import de.justsoftware.wikiservice.authorization.AuthContext;
import de.justsoftware.wikiservice.authorization.AuthorizationService;
import de.justsoftware.wikiservice.business.ProfileService;
import de.justsoftware.wikiservice.business.model.Profile;
import de.justsoftware.wikiservice.model.ProfileId;
import de.justsoftware.wikiservice.model.ProfileStatus;
import de.justsoftware.wikiservice.model.TenantId;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0019\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J*\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\n0\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lde/justsoftware/wikiservice/application/ProfileApplicationService;", "", "profileService", "Lde/justsoftware/wikiservice/business/ProfileService;", "authorizationService", "Lde/justsoftware/wikiservice/authorization/AuthorizationService;", "<init>", "(Lde/justsoftware/wikiservice/business/ProfileService;Lde/justsoftware/wikiservice/authorization/AuthorizationService;)V", "readByIds", "", "Lde/justsoftware/wikiservice/model/ProfileId;", "Lde/justsoftware/wikiservice/application/model/ProfileDto;", "profiles", "", "authContext", "Lde/justsoftware/wikiservice/authorization/AuthContext;", "wiki-service"})
@SourceDebugExtension(value={"SMAP\nProfileApplicationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProfileApplicationService.kt\nde/justsoftware/wikiservice/application/ProfileApplicationService\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,40:1\n462#2:41\n412#2:42\n462#2:47\n412#2:48\n1246#3,4:43\n1246#3,4:49\n*S KotlinDebug\n*F\n+ 1 ProfileApplicationService.kt\nde/justsoftware/wikiservice/application/ProfileApplicationService\n*L\n22#1:41\n22#1:42\n23#1:47\n23#1:48\n22#1:43,4\n23#1:49,4\n*E\n"})
public class ProfileApplicationService {
    @NotNull
    private final ProfileService profileService;
    @NotNull
    private final AuthorizationService authorizationService;

    @Autowired
    public ProfileApplicationService(@NotNull ProfileService profileService, @NotNull AuthorizationService authorizationService) {
        Intrinsics.checkNotNullParameter((Object)profileService, (String)"profileService");
        Intrinsics.checkNotNullParameter((Object)authorizationService, (String)"authorizationService");
        this.profileService = profileService;
        this.authorizationService = authorizationService;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<ProfileId, ProfileDto> readByIds(@NotNull Set<ProfileId> profiles, @NotNull AuthContext authContext) {
        ProfileDto profileDto;
        Map map;
        Object k;
        Map.Entry it$iv$iv;
        Map.Entry entry;
        boolean bl;
        Map map2;
        Map $this$mapValuesTo$iv$iv;
        Map $this$mapValues$iv;
        Intrinsics.checkNotNullParameter(profiles, (String)"profiles");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        TenantId tenantId = authContext.getTenantId();
        Map map3 = this.profileService.readByIds(profiles);
        boolean $i$f$mapValues = false;
        void var6_6 = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            map2 = destination$iv$iv;
            bl = false;
            entry = (Map.Entry)element$iv$iv$iv;
            k = it$iv$iv.getKey();
            map = map2;
            boolean bl2 = false;
            Profile profile = (Profile)entry.getValue();
            profileDto = ProfileDto.Companion.toDto(profile);
            map.put(k, profileDto);
        }
        $this$mapValues$iv = destination$iv$iv;
        $i$f$mapValues = false;
        $this$mapValuesTo$iv$iv = $this$mapValues$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        $i$f$mapValuesTo = false;
        $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            it$iv$iv = (Map.Entry)element$iv$iv$iv;
            map2 = destination$iv$iv;
            bl = false;
            entry = (Map.Entry)element$iv$iv$iv;
            k = it$iv$iv.getKey();
            map = map2;
            boolean bl3 = false;
            profileDto = this.authorizationService.mayProfileReadTenant(tenantId, (ProfileId)it.getKey()) ? (ProfileDto)it.getValue() : new ProfileDto((ProfileId)it.getKey(), ((ProfileDto)it.getValue()).getFullName(), ProfileStatus.DELETED, null, 8, null);
            map.put(k, profileDto);
        }
        return destination$iv$iv;
    }
}

