/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.application;

import de.justsoftware.wikiservice.application.model.Grantee;
import de.justsoftware.wikiservice.application.model.GroupGranteeDto;
import de.justsoftware.wikiservice.application.model.PermissionDto;
import de.justsoftware.wikiservice.application.model.ProfileDto;
import de.justsoftware.wikiservice.application.model.ProfileGranteeDto;
import de.justsoftware.wikiservice.authorization.AuthContext;
import de.justsoftware.wikiservice.authorization.AuthorizationService;
import de.justsoftware.wikiservice.business.PermissionService;
import de.justsoftware.wikiservice.business.ProfileService;
import de.justsoftware.wikiservice.business.UserGroupService;
import de.justsoftware.wikiservice.business.WikiService;
import de.justsoftware.wikiservice.business.exceptions.DuplicateGranteeIdException;
import de.justsoftware.wikiservice.business.exceptions.NoGranteeException;
import de.justsoftware.wikiservice.business.model.Permission;
import de.justsoftware.wikiservice.business.model.Profile;
import de.justsoftware.wikiservice.business.model.UserGroup;
import de.justsoftware.wikiservice.business.model.Wiki;
import de.justsoftware.wikiservice.graphql.generated.SetPermissionItemInput;
import de.justsoftware.wikiservice.model.PermissionId;
import de.justsoftware.wikiservice.model.PermissionType;
import de.justsoftware.wikiservice.model.ProfileId;
import de.justsoftware.wikiservice.model.UserGroupId;
import de.justsoftware.wikiservice.model.WikiId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B1\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\b\u0010\u000e\u001a\u00020\u000fH\u0016J,\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u00112\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J,\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u00112\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J,\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00160\u00112\u0006\u0010\u0017\u001a\u00020\u0018H\u0012J0\u0010\u001c\u001a\u0014\u0012\u0004\u0012\u00020\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00110\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00140\u00112\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\"\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\u00120\u001d2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\"0!H\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lde/justsoftware/wikiservice/application/PermissionApplicationService;", "", "permissionService", "Lde/justsoftware/wikiservice/business/PermissionService;", "wikiService", "Lde/justsoftware/wikiservice/business/WikiService;", "profileService", "Lde/justsoftware/wikiservice/business/ProfileService;", "userGroupService", "Lde/justsoftware/wikiservice/business/UserGroupService;", "authorizationService", "Lde/justsoftware/wikiservice/authorization/AuthorizationService;", "<init>", "(Lde/justsoftware/wikiservice/business/PermissionService;Lde/justsoftware/wikiservice/business/WikiService;Lde/justsoftware/wikiservice/business/ProfileService;Lde/justsoftware/wikiservice/business/UserGroupService;Lde/justsoftware/wikiservice/authorization/AuthorizationService;)V", "republishPermissions", "", "setPermissionsForWikiUpdate", "", "Lde/justsoftware/wikiservice/application/model/PermissionDto;", "wikiId", "Lde/justsoftware/wikiservice/model/WikiId;", "permissions", "Lde/justsoftware/wikiservice/graphql/generated/SetPermissionItemInput;", "authContext", "Lde/justsoftware/wikiservice/authorization/AuthContext;", "setPermissionsForWikiCreation", "setPermissions", "newPermissions", "getPermissionsForWikis", "", "wikiIds", "toPermissionDtos", "Lde/justsoftware/wikiservice/model/PermissionId;", "", "Lde/justsoftware/wikiservice/business/model/Permission;", "wiki-service"})
@SourceDebugExtension(value={"SMAP\nPermissionApplicationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PermissionApplicationService.kt\nde/justsoftware/wikiservice/application/PermissionApplicationService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,156:1\n1611#2,9:157\n1863#2:166\n1864#2:168\n1620#2:169\n1611#2,9:170\n1863#2:179\n1864#2:181\n1620#2:182\n1611#2,9:183\n1863#2:192\n1864#2:194\n1620#2:195\n1611#2,9:196\n1863#2:205\n1864#2:207\n1620#2:208\n1863#2,2:209\n1498#2:211\n1528#2,3:212\n1531#2,3:222\n1246#2,2:227\n1611#2,9:229\n1863#2:238\n1864#2:240\n1620#2:241\n1249#2:242\n1611#2,9:243\n1863#2:252\n1864#2:254\n1620#2:255\n1246#2,4:258\n1611#2,9:262\n1863#2:271\n1864#2:273\n1620#2:274\n1187#2,2:275\n1261#2,4:277\n1#3:167\n1#3:180\n1#3:193\n1#3:206\n1#3:239\n1#3:253\n1#3:272\n381#4,7:215\n462#4:225\n412#4:226\n462#4:256\n412#4:257\n*S KotlinDebug\n*F\n+ 1 PermissionApplicationService.kt\nde/justsoftware/wikiservice/application/PermissionApplicationService\n*L\n60#1:157,9\n60#1:166\n60#1:168\n60#1:169\n61#1:170,9\n61#1:179\n61#1:181\n61#1:182\n82#1:183,9\n82#1:192\n82#1:194\n82#1:195\n84#1:196,9\n84#1:205\n84#1:207\n84#1:208\n91#1:209,2\n100#1:211\n100#1:212,3\n100#1:222,3\n121#1:227,2\n121#1:229,9\n121#1:238\n121#1:240\n121#1:241\n121#1:242\n125#1:243,9\n125#1:252\n125#1:254\n125#1:255\n126#1:258,4\n127#1:262,9\n127#1:271\n127#1:273\n127#1:274\n129#1:275,2\n129#1:277,4\n60#1:167\n61#1:180\n82#1:193\n84#1:206\n121#1:239\n125#1:253\n127#1:272\n100#1:215,7\n121#1:225\n121#1:226\n126#1:256\n126#1:257\n*E\n"})
public class PermissionApplicationService {
    @NotNull
    private final PermissionService permissionService;
    @NotNull
    private final WikiService wikiService;
    @NotNull
    private final ProfileService profileService;
    @NotNull
    private final UserGroupService userGroupService;
    @NotNull
    private final AuthorizationService authorizationService;

    @Autowired
    public PermissionApplicationService(@NotNull PermissionService permissionService, @NotNull WikiService wikiService, @NotNull ProfileService profileService, @NotNull UserGroupService userGroupService, @NotNull AuthorizationService authorizationService) {
        Intrinsics.checkNotNullParameter((Object)permissionService, (String)"permissionService");
        Intrinsics.checkNotNullParameter((Object)wikiService, (String)"wikiService");
        Intrinsics.checkNotNullParameter((Object)profileService, (String)"profileService");
        Intrinsics.checkNotNullParameter((Object)userGroupService, (String)"userGroupService");
        Intrinsics.checkNotNullParameter((Object)authorizationService, (String)"authorizationService");
        this.permissionService = permissionService;
        this.wikiService = wikiService;
        this.profileService = profileService;
        this.userGroupService = userGroupService;
        this.authorizationService = authorizationService;
    }

    public void republishPermissions() {
        this.permissionService.republishPermissions();
    }

    @NotNull
    public List<PermissionDto> setPermissionsForWikiUpdate(@NotNull WikiId wikiId, @NotNull List<SetPermissionItemInput> permissions, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)wikiId, (String)"wikiId");
        Intrinsics.checkNotNullParameter(permissions, (String)"permissions");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        authContext.checkManageWiki(wikiId);
        return this.setPermissions(wikiId, permissions, authContext);
    }

    @NotNull
    public List<PermissionDto> setPermissionsForWikiCreation(@NotNull WikiId wikiId, @NotNull List<SetPermissionItemInput> permissions, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)wikiId, (String)"wikiId");
        Intrinsics.checkNotNullParameter(permissions, (String)"permissions");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        authContext.checkCreateWiki();
        return this.setPermissions(wikiId, permissions, authContext);
    }

    /*
     * WARNING - void declaration
     */
    private List<PermissionDto> setPermissions(WikiId wikiId, List<SetPermissionItemInput> newPermissions, AuthContext authContext) {
        void $this$groupByTo$iv$iv;
        Iterable element$iv2;
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNullTo$iv$iv2;
        void $this$mapNotNullTo$iv$iv3;
        Object element$iv$iv$iv2;
        void $this$mapNotNullTo$iv$iv4;
        Iterable $this$mapNotNull$iv = newPermissions;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Iterable<ProfileId> destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv4;
        boolean $i$f$forEach = false;
        for (Object element$iv$iv$iv2 : $this$forEach$iv$iv$iv) {
            ProfileId it$iv$iv;
            Object element$iv$iv = element$iv$iv$iv2;
            boolean bl = false;
            SetPermissionItemInput it = (SetPermissionItemInput)element$iv$iv;
            boolean bl2 = false;
            if (it.getGranteeId().toProfileId() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Set newProfiles = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Iterable $this$mapNotNull$iv2 = newPermissions;
        boolean $i$f$mapNotNull2 = false;
        destination$iv$iv = $this$mapNotNull$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo2 = false;
        void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv3;
        boolean $i$f$forEach22 = false;
        element$iv$iv$iv2 = $this$forEach$iv$iv$iv2.iterator();
        while (element$iv$iv$iv2.hasNext()) {
            UserGroupId it$iv$iv;
            Object element$iv$iv$iv3;
            Object element$iv$iv = element$iv$iv$iv3 = element$iv$iv$iv2.next();
            boolean bl = false;
            SetPermissionItemInput it = (SetPermissionItemInput)element$iv$iv;
            boolean bl4 = false;
            if (it.getGranteeId().toUserGroupId() == null) continue;
            boolean bl5 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        Set newUserGroups = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
        if (newPermissions.size() != newProfiles.size() + newUserGroups.size()) {
            throw new DuplicateGranteeIdException();
        }
        Wiki wikiToUpdate = this.wikiService.read(wikiId);
        List wikiPermissions = this.permissionService.getPermissionsByWikiId(wikiId);
        List currentPermissions = CollectionsKt.toList((Iterable)this.toPermissionDtos((Collection)wikiPermissions).values());
        Iterable $this$mapNotNull$iv3 = currentPermissions;
        boolean $i$f$mapNotNull3 = false;
        Iterable $i$f$forEach22 = $this$mapNotNull$iv3;
        Iterable<ProfileId> destination$iv$iv3 = new ArrayList();
        boolean $i$f$mapNotNullTo3 = false;
        void $this$forEach$iv$iv$iv3 = $this$mapNotNullTo$iv$iv2;
        boolean $i$f$forEach3 = false;
        Iterator it = $this$forEach$iv$iv$iv3.iterator();
        while (it.hasNext()) {
            ProfileId it$iv$iv;
            Object element$iv$iv$iv4;
            Object element$iv$iv = element$iv$iv$iv4 = it.next();
            boolean bl = false;
            PermissionDto it2 = (PermissionDto)element$iv$iv;
            boolean bl6 = false;
            if (it2.getGrantee().getId().toProfileId() == null) continue;
            boolean bl7 = false;
            destination$iv$iv3.add(it$iv$iv);
        }
        Set currentProfileIds = CollectionsKt.toSet((Iterable)((List)destination$iv$iv3));
        Iterable $this$mapNotNull$iv4 = currentPermissions;
        boolean $i$f$mapNotNull4 = false;
        destination$iv$iv3 = $this$mapNotNull$iv4;
        Collection destination$iv$iv4 = new ArrayList();
        boolean $i$f$mapNotNullTo4 = false;
        void $this$forEach$iv$iv$iv4 = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach4 = false;
        Iterator element$iv$iv$iv4 = $this$forEach$iv$iv$iv4.iterator();
        while (element$iv$iv$iv4.hasNext()) {
            UserGroupId it$iv$iv;
            Object element$iv$iv$iv5;
            Object element$iv$iv = element$iv$iv$iv5 = element$iv$iv$iv4.next();
            boolean bl = false;
            PermissionDto it3 = (PermissionDto)element$iv$iv;
            boolean bl8 = false;
            if (it3.getGrantee().getId().toUserGroupId() == null) continue;
            boolean bl9 = false;
            destination$iv$iv4.add(it$iv$iv);
        }
        Set currentUserGroups = CollectionsKt.toSet((Iterable)((List)destination$iv$iv4));
        Set addedProfiles = SetsKt.minus((Set)newProfiles, (Iterable)currentProfileIds);
        Set addedUserGroups = SetsKt.minus((Set)newUserGroups, (Iterable)currentUserGroups);
        if (!((Collection)addedProfiles).isEmpty()) {
            this.authorizationService.checkReadProfiles(addedProfiles, authContext.getUser());
            Iterable $this$forEach$iv = addedProfiles;
            boolean $i$f$forEach5 = false;
            for (Iterable element$iv2 : $this$forEach$iv) {
                ProfileId it4 = (ProfileId)element$iv2;
                boolean bl = false;
                this.authorizationService.checkIfProfileMayReadTenant(wikiToUpdate.getTenantId(), it4);
            }
        }
        if (!((Collection)addedUserGroups).isEmpty()) {
            this.authorizationService.checkReadUserGroups(addedUserGroups, authContext.getUser());
        }
        Iterable $this$groupBy$iv = newPermissions;
        boolean $i$f$groupBy = false;
        element$iv2 = $this$groupBy$iv;
        Map destination$iv$iv5 = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            void it5;
            Object object;
            SetPermissionItemInput it6 = (SetPermissionItemInput)element$iv$iv;
            boolean $i$a$-groupBy-PermissionApplicationService$setPermissions$permissionMap$32 = false;
            PermissionType key$iv$iv = PermissionType.valueOf((String)it6.getType().name());
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv5;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            SetPermissionItemInput $i$a$-groupBy-PermissionApplicationService$setPermissions$permissionMap$32 = (SetPermissionItemInput)element$iv$iv;
            List list = list$iv$iv;
            boolean bl = false;
            list.add(it5.getGranteeId());
        }
        Map permissionMap = destination$iv$iv5;
        List setPermissions = this.permissionService.setPermissions(wikiId, permissionMap);
        return CollectionsKt.toList((Iterable)this.toPermissionDtos((Collection)setPermissions).values());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<WikiId, List<PermissionDto>> getPermissionsForWikis(@NotNull List<WikiId> wikiIds, @NotNull AuthContext authContext) {
        void $this$mapValuesTo$iv$iv;
        Intrinsics.checkNotNullParameter(wikiIds, (String)"wikiIds");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        Set wikiSet = CollectionsKt.toSet((Iterable)wikiIds);
        authContext.checkManageWikis(wikiSet);
        Map wikiPermissions = this.permissionService.getPermissionsByWikiIds(wikiSet);
        Map permissionDtos = this.toPermissionDtos((Collection)CollectionsKt.flatten((Iterable)wikiPermissions.values()));
        Map $this$mapValues$iv = wikiPermissions;
        boolean $i$f$mapValues = false;
        Map map = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void $this$mapNotNullTo$iv$iv;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map3 = map2;
            boolean bl2 = false;
            List permissions = (List)entry2.getValue();
            Iterable $this$mapNotNull$iv = permissions;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                PermissionDto it$iv$iv2;
                Object element$iv$iv$iv2;
                Object element$iv$iv = element$iv$iv$iv2 = iterator.next();
                boolean bl3 = false;
                Permission it = (Permission)element$iv$iv;
                boolean bl4 = false;
                if ((PermissionDto)permissionDtos.get(it.getId()) == null) continue;
                boolean bl5 = false;
                destination$iv$iv2.add(it$iv$iv2);
            }
            List list = (List)destination$iv$iv2;
            map3.put(k, list);
        }
        return destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private Map<PermissionId, PermissionDto> toPermissionDtos(Collection<Permission> permissions) {
        void $this$associateTo$iv$iv;
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        void $this$mapValuesTo$iv$iv;
        Object element$iv$iv;
        Object element$iv$iv$iv2;
        Map $this$mapNotNullTo$iv$iv2;
        void $this$mapNotNull$iv2;
        Iterable iterable = permissions;
        Object object = this.profileService;
        boolean $i$f$mapNotNull = false;
        void var5_6 = $this$mapNotNull$iv2;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv2;
        boolean $i$f$forEach = false;
        for (Object element$iv$iv$iv2 : $this$forEach$iv$iv$iv) {
            ProfileId it$iv$iv;
            element$iv$iv = element$iv$iv$iv2;
            boolean bl = false;
            Permission it = (Permission)element$iv$iv;
            boolean bl2 = false;
            if (it.getGranteeId().toProfileId() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Map $this$mapValues$iv = object.readByIds(CollectionsKt.toSet((Iterable)((List)destination$iv$iv)));
        boolean $i$f$mapValues22 = false;
        $this$mapNotNullTo$iv$iv2 = $this$mapValues$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv2 : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            element$iv$iv = (Map.Entry)element$iv$iv$iv2;
            Object bl = destination$iv$iv;
            boolean bl4 = false;
            Map.Entry bl2 = (Map.Entry)element$iv$iv$iv2;
            Object k = it$iv$iv.getKey();
            object = bl;
            boolean bl5 = false;
            Profile profile = (Profile)bl2.getValue();
            ProfileDto profileDto = ProfileDto.Companion.toDto(profile);
            object.put(k, profileDto);
        }
        Object profiles = destination$iv$iv;
        Iterable $i$f$mapValues22 = permissions;
        object = this.userGroupService;
        boolean $i$f$mapNotNull2 = false;
        destination$iv$iv = $this$mapNotNull$iv;
        Iterable destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo2 = false;
        void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach2 = false;
        element$iv$iv$iv2 = $this$forEach$iv$iv$iv2.iterator();
        while (element$iv$iv$iv2.hasNext()) {
            UserGroupId it$iv$iv;
            Object element$iv$iv$iv3;
            Object element$iv$iv2 = element$iv$iv$iv3 = element$iv$iv$iv2.next();
            boolean bl = false;
            Permission it = (Permission)element$iv$iv2;
            boolean bl6 = false;
            if (it.getGranteeId().toUserGroupId() == null) continue;
            boolean bl7 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        Map userGroups = object.readByIds(CollectionsKt.toSet((Iterable)((List)destination$iv$iv2)));
        Iterable $this$associate$iv = permissions;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        destination$iv$iv2 = $this$associate$iv;
        Map destination$iv$iv3 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv3 : $this$associateTo$iv$iv) {
            Grantee grantee;
            Map map = destination$iv$iv3;
            Permission it = (Permission)element$iv$iv3;
            boolean bl = false;
            ProfileDto profile = (ProfileDto)profiles.get(it.getGranteeId().toProfileId());
            UserGroup userGroup = (UserGroup)userGroups.get(it.getGranteeId().toUserGroupId());
            if (profile == null && userGroup == null) {
                throw new NoGranteeException(it.getId());
            }
            PermissionId permissionId = it.getId();
            if (userGroup != null) {
                grantee = (Grantee)new GroupGranteeDto(it.getGranteeId(), userGroup.getName(), userGroup.isAllTenantUsersGroup());
            } else if (profile != null) {
                grantee = (Grantee)new ProfileGranteeDto(it.getGranteeId(), profile.getFullName(), StringsKt.replace$default((String)profile.getImageUrl(), (String)"/original/", (String)"/small/", (boolean)false, (int)4, null), profile.getStatus());
            } else {
                throw new NoGranteeException(it.getId());
            }
            Pair pair = TuplesKt.to((Object)permissionId, (Object)PermissionDto.Companion.toDto(it, grantee));
            map.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv3;
    }
}

