/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.connector.search;

import de.justsoftware.news.events.ChannelCreatedEvent;
import de.justsoftware.news.events.ChannelDeletedEvent;
import de.justsoftware.news.events.ChannelPermissionChangedEvent;
import de.justsoftware.news.events.ChannelUpdatedEvent;
import de.justsoftware.news.events.PostDeletedEvent;
import de.justsoftware.news.events.PostPublishedEvent;
import de.justsoftware.news.events.PostUpdatedEvent;
import de.justsoftware.news.id.ChannelId;
import de.justsoftware.news.id.PostId;
import de.justsoftware.search.shared.SolrIndexQueue;
import de.justsoftware.search.shared.model.SearchType;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.event.EventListener;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0017J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0017J\u0010\u0010\u000f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0010H\u0017J\u0010\u0010\u0011\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0012H\u0017J\u0010\u0010\u0011\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0013H\u0017J\u0010\u0010\u0014\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0015H\u0017J\u0010\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0018H\u0012J\u0010\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u001aH\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lde/justsoftware/news/connector/search/SearchConnector;", "", "solrIndexQueue", "Lde/justsoftware/search/shared/SolrIndexQueue;", "<init>", "(Lde/justsoftware/search/shared/SolrIndexQueue;)V", "indexChannel", "", "channelUpdatedEvent", "Lde/justsoftware/news/events/ChannelUpdatedEvent;", "channelEvent", "Lde/justsoftware/news/events/ChannelCreatedEvent;", "indexDeletedChannel", "event", "Lde/justsoftware/news/events/ChannelDeletedEvent;", "indexChannelPermissionChanges", "Lde/justsoftware/news/events/ChannelPermissionChangedEvent;", "indexPost", "Lde/justsoftware/news/events/PostPublishedEvent;", "Lde/justsoftware/news/events/PostUpdatedEvent;", "indexDeletedPost", "Lde/justsoftware/news/events/PostDeletedEvent;", "queueFullIndex", "postId", "Lde/justsoftware/news/id/PostId;", "channelId", "Lde/justsoftware/news/id/ChannelId;", "news-service"})
public class SearchConnector {
    @NotNull
    private final SolrIndexQueue solrIndexQueue;

    public SearchConnector(@NotNull SolrIndexQueue solrIndexQueue) {
        Intrinsics.checkNotNullParameter((Object)solrIndexQueue, (String)"solrIndexQueue");
        this.solrIndexQueue = solrIndexQueue;
    }

    @Async
    @EventListener
    public void indexChannel(@NotNull ChannelUpdatedEvent channelUpdatedEvent) {
        Intrinsics.checkNotNullParameter((Object)channelUpdatedEvent, (String)"channelUpdatedEvent");
        this.queueFullIndex(channelUpdatedEvent.getChannelId());
    }

    @Async
    @EventListener
    public void indexChannel(@NotNull ChannelCreatedEvent channelEvent) {
        Intrinsics.checkNotNullParameter((Object)channelEvent, (String)"channelEvent");
        this.queueFullIndex(channelEvent.getChannelId());
    }

    @Async
    @EventListener
    public void indexDeletedChannel(@NotNull ChannelDeletedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.queueFullIndex(event.getChannelId());
    }

    @Async
    @EventListener
    public void indexChannelPermissionChanges(@NotNull ChannelPermissionChangedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.queueFullIndex(event.getChannelId());
    }

    @Async
    @EventListener
    public void indexPost(@NotNull PostPublishedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.queueFullIndex(event.getPost().getId());
    }

    @Async
    @EventListener
    public void indexPost(@NotNull PostUpdatedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.queueFullIndex(event.getPostId());
    }

    @Async
    @EventListener
    public void indexDeletedPost(@NotNull PostDeletedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.queueFullIndex(event.getPostId());
    }

    private void queueFullIndex(PostId postId) {
        this.solrIndexQueue.queueFullIndex(CollectionsKt.listOf((Object)postId.toSearchableId()), SearchType.NEWS_POST);
    }

    private void queueFullIndex(ChannelId channelId) {
        this.solrIndexQueue.queueFullIndex(CollectionsKt.listOf((Object)channelId.toSearchableId()), SearchType.NEWS_CHANNEL);
    }
}

