/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.mobile.gateway.settings.service;

import de.justsoftware.mobile.gateway.settings.model.PlatformInfo;
import de.justsoftware.mobile.gateway.settings.model.PlatformSettings;
import de.justsoftware.mobile.gateway.settings.model.User;
import de.justsoftware.mobile.gateway.toro.model.ApiMobileAppsInfo;
import de.justsoftware.mobile.gateway.toro.model.ApiMobileAppsSettings;
import de.justsoftware.mobile.gateway.toro.model.ApiMobileAppsUser;
import de.justsoftware.mobile.gateway.toro.service.ToroApiGatewayService;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Service;

@RefreshScope
@Service
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0012J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lde/justsoftware/mobile/gateway/settings/service/SettingsService;", "", "toroApiGatewayService", "Lde/justsoftware/mobile/gateway/toro/service/ToroApiGatewayService;", "<init>", "(Lde/justsoftware/mobile/gateway/toro/service/ToroApiGatewayService;)V", "getPlatformSettings", "Lde/justsoftware/mobile/gateway/settings/model/PlatformSettings;", "getUser", "Lde/justsoftware/mobile/gateway/settings/model/User;", "getPlatformInfo", "Lde/justsoftware/mobile/gateway/settings/model/PlatformInfo;", "mobileAppsSettings", "Lde/justsoftware/mobile/gateway/toro/model/ApiMobileAppsSettings;", "mobileAppsInfo", "Lde/justsoftware/mobile/gateway/toro/model/ApiMobileAppsInfo;", "mobile-gateway"})
public class SettingsService {
    @NotNull
    private final ToroApiGatewayService toroApiGatewayService;

    public SettingsService(@NotNull ToroApiGatewayService toroApiGatewayService) {
        Intrinsics.checkNotNullParameter((Object)toroApiGatewayService, (String)"toroApiGatewayService");
        this.toroApiGatewayService = toroApiGatewayService;
    }

    @NotNull
    public PlatformSettings getPlatformSettings() {
        ApiMobileAppsSettings apiMobileAppsSettings = this.toroApiGatewayService.getMobileAppsInfo().getSettings();
        return this.getPlatformSettings(apiMobileAppsSettings);
    }

    @NotNull
    public User getUser() {
        ApiMobileAppsInfo mobileAppsInfo = this.toroApiGatewayService.getMobileAppsInfo();
        return this.getUser(mobileAppsInfo);
    }

    @NotNull
    public PlatformInfo getPlatformInfo() {
        ApiMobileAppsInfo mobileAppsInfo = this.toroApiGatewayService.getMobileAppsInfo();
        return new PlatformInfo(this.getUser(mobileAppsInfo), this.getPlatformSettings(mobileAppsInfo.getSettings()));
    }

    private PlatformSettings getPlatformSettings(ApiMobileAppsSettings mobileAppsSettings) {
        boolean bl = mobileAppsSettings.getAbsenceNoteEnabled();
        int n = mobileAppsSettings.getAbsenceNoteMaxLength();
        boolean bl2 = mobileAppsSettings.getAbsenceStatusEnabled();
        boolean bl3 = mobileAppsSettings.getBirthdayListEnabled();
        boolean bl4 = mobileAppsSettings.getTrackingEnabled();
        String string = mobileAppsSettings.getMatomoBaseUrl();
        String string2 = mobileAppsSettings.getMatomoSiteId();
        boolean bl5 = mobileAppsSettings.getChatEnabled();
        boolean bl6 = mobileAppsSettings.getNewsEnabled();
        boolean bl7 = mobileAppsSettings.getDeviceLockRequired();
        boolean bl8 = mobileAppsSettings.getCookieBannerEnabled();
        boolean bl9 = mobileAppsSettings.getChangeEmailEnabled();
        boolean bl10 = mobileAppsSettings.getChangePasswordEnabled();
        boolean bl11 = mobileAppsSettings.getDeleteAccountEnabled();
        boolean bl12 = mobileAppsSettings.getMultiFactorAuthenticationEnabled();
        String string3 = mobileAppsSettings.getPlatformVersion();
        String string4 = mobileAppsSettings.getTermsPath();
        return new PlatformSettings(bl5, bl6, bl7, bl8, bl9, bl10, bl11, string3, string4, bl, n, bl2, bl3, bl4, string, string2, false, bl12, 65536, null);
    }

    private User getUser(ApiMobileAppsInfo mobileAppsInfo) {
        ApiMobileAppsUser mobileAppsUser = mobileAppsInfo.getUser();
        return new User(mobileAppsUser.getProfileId(), mobileAppsUser.getName(), mobileAppsUser.getFirstName(), mobileAppsUser.getLastName(), mobileAppsUser.getEmail(), mobileAppsUser.getImageId(), mobileAppsUser.getBirthday(), mobileAppsUser.getTermsAcceptanceRequired(), mobileAppsUser.getPreferredTranslationLanguage());
    }
}

