/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.mobile.gateway.common.service;

import de.justsoftware.mobile.gateway.common.service.UrlService;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0010\b\u0017\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0011\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u0010\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0003H\u0016J\u0010\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u0003H\u0016J\u0010\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0003H\u0016J\u0010\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0003H\u0016R\u000e\u0010\u0006\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lde/justsoftware/mobile/gateway/common/service/UrlService;", "", "systemDomainPrefix", "", "<init>", "(Ljava/lang/String;)V", "newsBaseUrl", "wikiBaseUrl", "getNewsPostUrl", "postId", "getNewsChannelUrl", "channelId", "getWikiUrl", "wikiId", "getWikiChapterUrl", "wikiChapterId", "getWikiArticleUrl", "wikiArticleId", "Companion", "mobile-gateway"})
public class UrlService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String newsBaseUrl;
    @NotNull
    private final String wikiBaseUrl;
    @NotNull
    private static final String TORO_RESOURCE_URL = "/toro/resource/html#";

    public UrlService(@Value(value="${just.common.system.domainprefix}") @NotNull String systemDomainPrefix) {
        Intrinsics.checkNotNullParameter((Object)systemDomainPrefix, (String)"systemDomainPrefix");
        this.newsBaseUrl = systemDomainPrefix + "/toro/resource/html#/news";
        this.wikiBaseUrl = systemDomainPrefix + "/toro/resource/html#/wiki";
    }

    @NotNull
    public String getNewsPostUrl(@NotNull String postId) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        return this.newsBaseUrl + "/posts/" + postId;
    }

    @NotNull
    public String getNewsChannelUrl(@NotNull String channelId) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        return this.newsBaseUrl + "/channel/" + channelId;
    }

    @NotNull
    public String getWikiUrl(@NotNull String wikiId) {
        Intrinsics.checkNotNullParameter((Object)wikiId, (String)"wikiId");
        return this.wikiBaseUrl + "/wikis/" + wikiId;
    }

    @NotNull
    public String getWikiChapterUrl(@NotNull String wikiChapterId) {
        Intrinsics.checkNotNullParameter((Object)wikiChapterId, (String)"wikiChapterId");
        return this.wikiBaseUrl + "/chapters/" + wikiChapterId;
    }

    @NotNull
    public String getWikiArticleUrl(@NotNull String wikiArticleId) {
        Intrinsics.checkNotNullParameter((Object)wikiArticleId, (String)"wikiArticleId");
        return this.wikiBaseUrl + "/articles/" + wikiArticleId;
    }
}

