/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.gateway.config;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.kafka.common.serialization.StringSerializer;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.kafka.core.DefaultKafkaProducerFactory;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.kafka.core.ProducerFactory;

@ParametersAreNonnullByDefault
@Configuration
public class KafkaProducerConfiguration {
    private final String _bootstrapServers;

    public KafkaProducerConfiguration(@Value(value="${spring.kafka.bootstrap-servers}") String bootstrapServers) {
        this._bootstrapServers = bootstrapServers;
    }

    @Nonnull
    @Bean
    public ProducerFactory<String, String> producerFactory() {
        return new DefaultKafkaProducerFactory(this.producerConfigs());
    }

    @Nonnull
    @Bean
    public Map<String, Object> producerConfigs() {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("bootstrap.servers", this._bootstrapServers);
        props.put("key.serializer", StringSerializer.class);
        props.put("value.serializer", StringSerializer.class);
        return props;
    }

    @Nonnull
    @Bean
    public KafkaTemplate<String, String> kafkaTemplate() {
        return new KafkaTemplate(this.producerFactory());
    }
}

