/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.rest.controllers;

import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.io.ByteSource;
import de.justsoftware.drive.business.authorization.AuthorizationContext;
import de.justsoftware.drive.business.change.ChangeModificationService;
import de.justsoftware.drive.business.document.DocumentListService;
import de.justsoftware.drive.business.document.DocumentService;
import de.justsoftware.drive.business.document.DocumentTreeModificationService;
import de.justsoftware.drive.business.document.DocumentVersionCountService;
import de.justsoftware.drive.business.document.NameValidation;
import de.justsoftware.drive.business.exception.PermissionDeniedException;
import de.justsoftware.drive.business.exception.ShareAccessDeniedException;
import de.justsoftware.drive.business.file.FileLockService;
import de.justsoftware.drive.business.file.FileService;
import de.justsoftware.drive.business.folder.CurrentVersionData;
import de.justsoftware.drive.business.folder.FolderService;
import de.justsoftware.drive.business.shares.SharesService;
import de.justsoftware.drive.business.sync.FileSyncService;
import de.justsoftware.drive.business.sync.FileSyncUsage;
import de.justsoftware.drive.common.authorization.model.StaticAction;
import de.justsoftware.drive.common.document.model.AdjacentDocuments;
import de.justsoftware.drive.common.document.model.DocumentBO;
import de.justsoftware.drive.common.document.model.DocumentId;
import de.justsoftware.drive.common.document.model.DocumentListBO;
import de.justsoftware.drive.common.document.model.DocumentSortField;
import de.justsoftware.drive.common.document.model.DocumentSortParams;
import de.justsoftware.drive.common.document.model.DocumentVersionId;
import de.justsoftware.drive.common.document.model.PublishedFilter;
import de.justsoftware.drive.common.file.model.FileVersionBO;
import de.justsoftware.drive.common.folder.model.FolderVersionBO;
import de.justsoftware.drive.common.item.model.ItemId;
import de.justsoftware.drive.common.item.model.ItemType;
import de.justsoftware.drive.common.model.AbstractId;
import de.justsoftware.drive.common.model.SortDirection;
import de.justsoftware.drive.common.person.model.PersonId;
import de.justsoftware.drive.common.shares.model.ShareBO;
import de.justsoftware.drive.common.sync.model.FileSyncUsageBO;
import de.justsoftware.drive.common.util.ObjectUtil;
import de.justsoftware.drive.rest.document.DocumentFrontendService;
import de.justsoftware.drive.rest.exceptions.UnknownResourceException;
import de.justsoftware.drive.rest.exceptions.ZipException;
import de.justsoftware.drive.rest.file.FileLockFrontendService;
import de.justsoftware.drive.rest.models.DocumentDetails;
import de.justsoftware.drive.rest.models.DocumentList;
import de.justsoftware.drive.rest.models.DocumentListEntry;
import de.justsoftware.drive.rest.models.DocumentPath;
import de.justsoftware.drive.rest.models.DocumentType;
import de.justsoftware.drive.rest.models.File;
import de.justsoftware.drive.rest.models.FileDetails;
import de.justsoftware.drive.rest.models.FileLock;
import de.justsoftware.drive.rest.models.FileUpdate;
import de.justsoftware.drive.rest.models.Folder;
import de.justsoftware.drive.rest.models.FolderDetails;
import de.justsoftware.drive.rest.models.GetFileSyncURIResult;
import de.justsoftware.drive.rest.models.Item;
import de.justsoftware.drive.rest.models.NewDocument;
import de.justsoftware.drive.rest.models.SimpleReturnStatus;
import de.justsoftware.drive.rest.util.ContentDispositionUtil;
import de.justsoftware.drive.rest.util.MultipartUtil;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.CacheControl;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/api"}, produces={"application/json"})
@Schema(description="Documents")
@ParametersAreNonnullByDefault
public class DocumentController {
    public static final String API_MAPPING = "/api";
    public static final String FILE_VERSION_DOWNLOAD_MAPPING = "/documents/fileversion/{fileVersionId}/download";
    public static final String DOCUMENT_DOWNLOAD_MAPPING = "/documents/{documentId}/download";
    private static final String REQUESTED_FILE_WAS_NOT_FOUND = "Requested file was not found";
    private static final String NOT_ALLOWED_MESSAGE = "not allowed";
    private final DocumentTreeModificationService _documentTreeModificationService;
    private final FileService _fileService;
    private final FolderService _folderService;
    private final DocumentService _documentService;
    private final DocumentListService _documentListService;
    private final DocumentFrontendService _documentFrontendService;
    private final FileSyncService _fileSyncService;
    private final SharesService _sharesService;
    private final ChangeModificationService _changeModificationService;
    private final FileLockFrontendService _fileLockFrontendService;
    private final FileLockService _fileLockService;
    private final DocumentVersionCountService _documentVersionCountService;

    @Autowired
    public DocumentController(DocumentTreeModificationService documentTreeModificationService, DocumentListService documentListService, FileService fileService, DocumentFrontendService documentFrontendService, FolderService folderService, DocumentService documentService, FileSyncService fileSyncService, SharesService sharesService, ChangeModificationService changeModificationService, FileLockFrontendService fileLockFrontendService, FileLockService fileLockService, DocumentVersionCountService documentVersionCountService) {
        this._documentTreeModificationService = documentTreeModificationService;
        this._documentListService = documentListService;
        this._fileService = fileService;
        this._documentFrontendService = documentFrontendService;
        this._folderService = folderService;
        this._documentService = documentService;
        this._fileSyncService = fileSyncService;
        this._sharesService = sharesService;
        this._changeModificationService = changeModificationService;
        this._fileLockFrontendService = fileLockFrontendService;
        this._fileLockService = fileLockService;
        this._documentVersionCountService = documentVersionCountService;
    }

    @RequestMapping(value={"/documents/item/{itemId}/upload"}, method={RequestMethod.POST})
    @Nonnull
    public ImmutableSet<DocumentId> uploadFiles(AuthorizationContext authCtx, @PathVariable ItemId itemId, MultipartFile ... files) {
        authCtx.check((AbstractId)itemId, StaticAction.DOCUMENT_WRITE);
        PersonId personId = authCtx.getPersonId();
        DocumentId folderId = this.getRootFolderId(authCtx, itemId);
        ImmutableSet versionIds = this._documentTreeModificationService.addFiles(folderId, (Iterable)FluentIterable.from((Object[])files).transform(MultipartUtil.MULTIPART_FILE_TO_BYTESOURCE), personId, null, NameValidation.CLEAN_NAME).keySet();
        return ImmutableSet.copyOf((Collection)this._documentService.getDocumentIdsOfVersions((Set)versionIds).values());
    }

    @RequestMapping(value={"/documents/{folderId}/upload"}, method={RequestMethod.POST})
    @Nonnull
    public DocumentId uploadFiles(AuthorizationContext authCtx, @PathVariable DocumentId folderId, MultipartFile ... files) {
        authCtx.check((AbstractId)folderId, StaticAction.DOCUMENT_WRITE);
        PersonId personId = authCtx.getPersonId();
        this._documentTreeModificationService.addFiles(folderId, (Iterable)FluentIterable.from((Object[])files).transform(MultipartUtil.MULTIPART_FILE_TO_BYTESOURCE), personId, null, NameValidation.CLEAN_NAME);
        return folderId;
    }

    @RequestMapping(value={"/documents/item/{itemId}"}, method={RequestMethod.GET})
    @Nonnull
    public DocumentList documentsByItemId(AuthorizationContext authCtx, @PathVariable ItemId itemId, @RequestParam(value="sortField", defaultValue="NAME") DocumentSortField sortField, @RequestParam(value="offset", defaultValue="0") int offset, @RequestParam(value="limit", defaultValue="100") int limit, @RequestParam(value="direction", defaultValue="ASC") SortDirection direction, @RequestParam(value="language", defaultValue="de") String language) {
        DocumentId rootFolderId = this.getRootFolderId(authCtx, itemId);
        return this.documentsByDocumentId(authCtx, rootFolderId, sortField, offset, limit, direction, language);
    }

    @RequestMapping(value={"/documents/folder/{folderId}"}, method={RequestMethod.GET})
    @Nonnull
    public DocumentList documentsByDocumentId(AuthorizationContext authCtx, @PathVariable DocumentId folderId, @RequestParam(value="sortField", defaultValue="NAME") DocumentSortField sortField, @RequestParam(value="offset", defaultValue="0") int offset, @RequestParam(value="limit", defaultValue="100") int limit, @RequestParam(value="direction", defaultValue="ASC") SortDirection direction, @RequestParam(value="language", defaultValue="de") String language) {
        PublishedFilter publishedFilter = this.checkReadWithShareFallback(authCtx, folderId);
        DocumentSortParams params = new DocumentSortParams(sortField, direction, offset, limit, new Locale(language));
        DocumentListBO documentListBO = this._documentListService.getCurrentDocumentList(folderId, params, publishedFilter);
        return this._documentFrontendService.convertDocumentList(documentListBO, authCtx);
    }

    @Nonnull
    private PublishedFilter checkReadWithShareFallback(AuthorizationContext authCtx, DocumentId documentId) {
        try {
            return this._documentFrontendService.checkRead(authCtx, (AbstractId)documentId);
        }
        catch (PermissionDeniedException ex) {
            CurrentVersionData versionData = (CurrentVersionData)this._folderService.getCurrentVersionDataOfDocuments((Set)ImmutableSet.of((Object)documentId), PublishedFilter.ONLY_PUBLISHED).get((Object)documentId);
            if (versionData == null) {
                throw ex;
            }
            ItemId itemId = versionData.getNewestChange().getItemId();
            if (!itemId.getType().equals((Object)ItemType.SHARE)) {
                throw ex;
            }
            DocumentVersionId rootFolderVersionId = (DocumentVersionId)Iterables.getFirst((Iterable)versionData.getPath(), null);
            if (rootFolderVersionId == null) {
                throw ex;
            }
            ShareBO share = this._sharesService.getShareDetails(itemId);
            ImmutableMap folderVersionsByIds = this._documentService.getDocumentIdsOfVersions((Set)ImmutableSet.of((Object)rootFolderVersionId));
            DocumentId shareRootFolderId = (DocumentId)Preconditions.checkNotNull((Object)((DocumentId)folderVersionsByIds.get((Object)rootFolderVersionId)));
            throw new ShareAccessDeniedException(ex, shareRootFolderId, share.getName());
        }
    }

    @Operation(description="Renames the given folder.")
    @RequestMapping(value={"/documents/folder/{folderId}"}, method={RequestMethod.PUT})
    @Nonnull
    public Folder renameFolder(AuthorizationContext authCtx, @PathVariable DocumentId folderId, @RequestBody String newName) {
        authCtx.check((AbstractId)folderId, StaticAction.DOCUMENT_WRITE);
        this._documentTreeModificationService.renameFolder(folderId, authCtx.getPersonId(), newName);
        PublishedFilter publishedFilter = PublishedFilter.PUBLISHED_OR_PRIVATE;
        FolderVersionBO newestVersionsByIds = (FolderVersionBO)this._folderService.getNewestVersionsByIds((Set)ImmutableSet.of((Object)folderId), publishedFilter).get((Object)folderId);
        DocumentFrontendService.CreateDocumentVisitor documentCreator = this._documentFrontendService.documentCreator((Iterable)ImmutableList.of((Object)newestVersionsByIds), authCtx, publishedFilter);
        return documentCreator.visit(newestVersionsByIds);
    }

    @Operation(description="Move the given files to the given folder.")
    @RequestMapping(value={"/documents/folder/{folderId}/move"}, method={RequestMethod.POST})
    public void moveToFolder(AuthorizationContext authCtx, @PathVariable DocumentId folderId, @RequestBody Set<DocumentId> documents) {
        this._documentFrontendService.checkReadWrite(authCtx, Collections.singleton(folderId), documents);
        this._documentTreeModificationService.moveToFolder(folderId, documents, authCtx.getPersonId());
    }

    @Operation(description="Copy the given files to the given folder.")
    @RequestMapping(value={"/documents/folder/{folderId}/copy"}, method={RequestMethod.POST})
    public void copyToFolder(AuthorizationContext authCtx, @PathVariable DocumentId folderId, @RequestBody Set<DocumentId> documents) {
        ImmutableMap documentsAndFilter = this._documentFrontendService.checkReadWrite(authCtx, Collections.singleton(folderId), documents);
        this._documentTreeModificationService.copyToFolder(folderId, (Map)documentsAndFilter, authCtx.getPersonId());
    }

    @RequestMapping(value={"/document"}, method={RequestMethod.POST})
    @Nonnull
    public DocumentId createDocument(AuthorizationContext authCtx, @RequestBody NewDocument newDocument) {
        DocumentId parentId = newDocument.getParentId();
        String name = newDocument.getName();
        authCtx.check((AbstractId)parentId, StaticAction.DOCUMENT_WRITE);
        PersonId personId = authCtx.getPersonId();
        if (newDocument.getType() == DocumentType.FOLDER) {
            return this._documentTreeModificationService.addSubFolder(parentId, name, personId).getDocumentId();
        }
        DocumentVersionId newVersionId = this._documentTreeModificationService.addEmptyFile(parentId, name, personId, null, NameValidation.THROW_EXCEPTION);
        return (DocumentId)this._documentService.getDocumentIdsOfVersions((Set)ImmutableSet.of((Object)newVersionId)).get((Object)newVersionId);
    }

    @RequestMapping(value={"/documents/file/{fileId}/upload"}, method={RequestMethod.POST})
    @Nonnull
    public FileDetails uploadNewFileVersion(AuthorizationContext authCtx, @PathVariable DocumentId fileId, MultipartFile ... files) {
        MultipartFile file = (MultipartFile)Iterables.getOnlyElement((Iterable)ImmutableList.copyOf((Object[])files));
        authCtx.check((AbstractId)fileId, StaticAction.DOCUMENT_WRITE);
        PersonId personId = authCtx.getPersonId();
        this._documentTreeModificationService.uploadNewFileVersion(fileId, MultipartUtil.multipartFileToByteSource((MultipartFile)file), personId, null);
        return (FileDetails)this.getDocumentDetails(authCtx, fileId);
    }

    @Operation(description="Get detailed information for a given document. Can be a file or folder.")
    @RequestMapping(value={"/documents/document/{documentId}"}, method={RequestMethod.GET})
    @Nonnull
    public DocumentDetails getDocumentDetails(AuthorizationContext authCtx, @PathVariable DocumentId documentId) {
        PublishedFilter publishedFilter = this.checkReadWithShareFallback(authCtx, documentId);
        FileVersionBO file = this._fileService.getLastFileVersion(documentId, publishedFilter);
        if (file != null) {
            return this.createFileDetails(authCtx, publishedFilter, file);
        }
        DocumentVersionId versionId = (DocumentVersionId)this._folderService.getLastVersionsOfDocuments((Set)ImmutableSet.of((Object)documentId), publishedFilter).get((Object)documentId);
        FolderVersionBO folder = (FolderVersionBO)this._folderService.getFolderVersionsByIds((Set)ImmutableSet.of((Object)versionId)).get((Object)versionId);
        if (folder != null) {
            return this.createFolderDetails(authCtx, publishedFilter, folder);
        }
        throw new UnknownResourceException(REQUESTED_FILE_WAS_NOT_FOUND);
    }

    @Operation(description="Get detailed information for a given document. Can be a file or folder.")
    @RequestMapping(value={"/documents/document/file/{documentId}"}, method={RequestMethod.GET})
    @Nonnull
    public FileDetails getFileDetails(AuthorizationContext authCtx, @PathVariable DocumentId documentId, @RequestParam(value="sortField", defaultValue="NAME") DocumentSortField sortField, @RequestParam(value="direction", defaultValue="ASC") SortDirection direction, @RequestParam(value="language", defaultValue="de") String language) {
        DocumentSortParams params = new DocumentSortParams(sortField, direction, new Locale(language));
        PublishedFilter publishedFilter = this.checkReadWithShareFallback(authCtx, documentId);
        FileVersionBO file = this._fileService.getLastFileVersion(documentId, publishedFilter);
        if (file == null) {
            throw new UnknownResourceException(REQUESTED_FILE_WAS_NOT_FOUND);
        }
        AdjacentDocuments adjacentDocuments = this._documentListService.getPreviousAndNextDocuments(documentId, params, publishedFilter);
        return this.createFileDetails(authCtx, publishedFilter, file, adjacentDocuments);
    }

    @Nonnull
    private DocumentBO getEnsuredExistingDocument(DocumentId documentId) {
        DocumentBO document = this._documentService.getDocument(documentId);
        if (document == null) {
            throw new UnknownResourceException("No document with the ID " + String.valueOf(documentId) + " can be found. This should not happen.");
        }
        return document;
    }

    @Nonnull
    private FolderDetails createFolderDetails(AuthorizationContext authCtx, PublishedFilter publishedFilter, FolderVersionBO folder) {
        DocumentVersionId versionId = folder.getId();
        ImmutableSet.Builder folderPath = ImmutableSet.builder();
        folderPath.addAll((Iterable)this._folderService.getPathBOs((Set)ImmutableSet.of((Object)versionId), publishedFilter).get((Object)versionId));
        folderPath.add((Object)folder);
        DocumentFrontendService.CreateDocumentVisitor createDocumentVisitor = this._documentFrontendService.documentCreator((Iterable)folderPath.build(), authCtx, publishedFilter);
        Folder resultFolder = createDocumentVisitor.visit(folder);
        ImmutableList resultPath = (ImmutableList)folderPath.build().stream().map(path -> (Folder)createDocumentVisitor.toFolder().apply(path)).collect(ImmutableList.toImmutableList());
        Item item = this._documentFrontendService.getItem(folder.getItemId(), authCtx);
        DocumentBO document = this.getEnsuredExistingDocument(folder.getDocumentId());
        int downloads = (Integer)this._documentVersionCountService.getCountForDocument((Set)ImmutableSet.of((Object)document.getId())).get((Object)document.getId());
        return new FolderDetails((DocumentListEntry)resultFolder, new DocumentPath((List)resultPath, item), downloads);
    }

    @Nonnull
    private FileDetails createFileDetails(AuthorizationContext authCtx, PublishedFilter publishedFilter, FileVersionBO file) {
        return this.createFileDetails(authCtx, publishedFilter, file, null);
    }

    @Nonnull
    private FileDetails createFileDetails(AuthorizationContext authCtx, PublishedFilter publishedFilter, FileVersionBO file, @Nullable AdjacentDocuments adjacentDocuments) {
        DocumentVersionId versionId = file.getId();
        ImmutableList documentPath = this._folderService.getPathBOs((Set)ImmutableSet.of((Object)versionId), publishedFilter).get((Object)versionId);
        DocumentFrontendService.CreateDocumentVisitor createDocumentVisitor = this._documentFrontendService.documentCreator((Iterable)FluentIterable.concat((Iterable)ImmutableSet.of((Object)file), (Iterable)documentPath).toSet(), authCtx, publishedFilter);
        File resultFile = createDocumentVisitor.visit(file);
        ImmutableList path = FluentIterable.from((Iterable)documentPath).transform(createDocumentVisitor.toFolder()).toList();
        Item item = this._documentFrontendService.getItem(file.getItemId(), authCtx);
        DocumentBO document = this.getEnsuredExistingDocument(file.getDocumentId());
        int downloads = (Integer)this._documentVersionCountService.getCountForDocument((Set)ImmutableSet.of((Object)document.getId())).get((Object)document.getId());
        return new FileDetails((DocumentListEntry)resultFile, new DocumentPath((List)path, item), document.getDescription(), document.getTags(), downloads, adjacentDocuments);
    }

    @Operation(description="Return just-filesync:// URI to command just-filesync to open a file")
    @RequestMapping(value={"/documents/filesync-uri/{fileId}"}, produces={"application/json; charset=UTF-8"})
    @Nonnull
    public GetFileSyncURIResult getFileSyncURI(AuthorizationContext authCtx, @PathVariable DocumentId fileId) {
        PublishedFilter publishedFilter = this._documentFrontendService.checkRead(authCtx, (AbstractId)fileId);
        FileVersionBO file = this._fileService.getLastFileVersion(fileId, publishedFilter);
        if (file == null) {
            throw new UnknownResourceException(REQUESTED_FILE_WAS_NOT_FOUND);
        }
        return new GetFileSyncURIResult(this._fileSyncService.getOpenDocumentUri(file.getId(), authCtx.getPersonId()));
    }

    @Operation(description="Last just-filesync usage for the current user")
    @RequestMapping(value={"/documents/last-filesync-usage"}, produces={"application/json; charset=UTF-8"})
    @CheckForNull
    public FileSyncUsage getLastFileSyncUsage(AuthorizationContext authCtx) {
        FileSyncUsageBO usage = this._fileSyncService.getLastFileSyncUsage(authCtx.getPersonId());
        return usage == null ? null : new FileSyncUsage(usage.getVersionId(), usage.getDownloadDate());
    }

    @Operation(description="Deletes the given file.")
    @RequestMapping(value={"/documents/file/{fileId}"}, method={RequestMethod.DELETE})
    @Nonnull
    public SimpleReturnStatus deleteFile(AuthorizationContext authCtx, @PathVariable DocumentId fileId) {
        authCtx.check((AbstractId)fileId, StaticAction.DOCUMENT_DELETE);
        this._documentTreeModificationService.deleteDocument(fileId, authCtx.getPersonId());
        return SimpleReturnStatus.OK;
    }

    @Operation(description="Updates the metadata of the given file.")
    @RequestMapping(value={"/documents/file/{fileId}"}, method={RequestMethod.PUT})
    @Nonnull
    public FileDetails updateFile(AuthorizationContext authCtx, @PathVariable DocumentId fileId, @RequestBody FileUpdate updateModel) {
        FileVersionBO currentFileVersion;
        authCtx.check((AbstractId)fileId, StaticAction.DOCUMENT_WRITE);
        String newName = updateModel.getName();
        if (newName != null) {
            this._documentTreeModificationService.renameFile(fileId, authCtx.getPersonId(), newName);
        }
        if (updateModel.getDescription() != null || updateModel.getTags() != null) {
            this._fileService.updateMetadata(fileId, updateModel.getDescription(), updateModel.getTags());
        }
        if ((currentFileVersion = this._fileService.getLastFileVersion(fileId, PublishedFilter.PUBLISHED_OR_PRIVATE)) == null) {
            throw new UnknownResourceException("this should not happen: the file was updated but is inexistent for some reason: " + String.valueOf(fileId));
        }
        return this.createFileDetails(authCtx, PublishedFilter.PUBLISHED_OR_PRIVATE, currentFileVersion);
    }

    @Operation(description="Returns latest versions of a given file. By default only the last 50 versions are returned.")
    @RequestMapping(value={"/documents/file/{fileId}/versions"}, method={RequestMethod.GET})
    @Nonnull
    public List<File> getFileVersions(AuthorizationContext authCtx, @PathVariable DocumentId fileId, @Parameter(description="limits the number of version in the result") @RequestParam(name="limit", defaultValue="50") int limit) {
        PublishedFilter publishedFilter = this._documentFrontendService.checkRead(authCtx, (AbstractId)fileId);
        ImmutableList versions = this._fileService.getLatestVersions(fileId, publishedFilter, limit);
        if (versions.isEmpty()) {
            throw new UnknownResourceException(REQUESTED_FILE_WAS_NOT_FOUND);
        }
        DocumentFrontendService.CreateDocumentVisitor documentCreator = this._documentFrontendService.documentCreator((Iterable)versions, authCtx, publishedFilter);
        return FluentIterable.from((Iterable)versions).transform(documentCreator.toFile()).toList();
    }

    @Operation(description="Returns the binary content of the requested document for download.")
    @RequestMapping(value={"/documents/{documentId}/download"}, method={RequestMethod.GET})
    public void downloadDocument(AuthorizationContext authCtx, HttpServletResponse response, @PathVariable DocumentId documentId, @RequestParam(name="view", defaultValue="false") boolean view, @RequestParam(name="withCache", defaultValue="false") boolean withCache) {
        PublishedFilter publishedFilter = this._documentFrontendService.checkRead(authCtx, (AbstractId)documentId);
        FileVersionBO fileVersion = this._fileService.getLastFileVersion(documentId, publishedFilter);
        this.downloadFileVersion(response, publishedFilter, fileVersion, view, withCache);
    }

    @Operation(description="Returns the binary content of the requested file version for download.")
    @RequestMapping(value={"/documents/fileversion/{fileVersionId}/download"}, method={RequestMethod.GET})
    public void downloadFileVersion(AuthorizationContext authCtx, HttpServletResponse response, @PathVariable DocumentVersionId fileVersionId, @RequestParam(name="view", defaultValue="false") boolean view, @RequestParam(name="withCache", defaultValue="false") boolean withCache) {
        PublishedFilter publishedFilter = this._documentFrontendService.checkRead(authCtx, fileVersionId);
        FileVersionBO fileVersion = this._fileService.getSingleVersionById(fileVersionId);
        this.downloadFileVersion(response, publishedFilter, fileVersion, view, withCache);
    }

    private void downloadFileVersion(HttpServletResponse response, PublishedFilter publishedFilter, @Nullable FileVersionBO fileVersion, boolean view, boolean withCache) {
        if (fileVersion == null) {
            throw new UnknownResourceException(REQUESTED_FILE_WAS_NOT_FOUND);
        }
        if (!fileVersion.isPublic() && publishedFilter != PublishedFilter.PUBLISHED_OR_PRIVATE) {
            throw new PermissionDeniedException(NOT_ALLOWED_MESSAGE);
        }
        ByteSource fileSource = this._fileService.getFileByteSource(fileVersion);
        try {
            response.setContentType(fileVersion.getMimeType());
            response.setContentLengthLong(fileVersion.getFileSize());
            if (!view) {
                this._documentVersionCountService.increment((Set)ImmutableSet.of((Object)fileVersion.getId()));
                ContentDispositionUtil.setContentDispositionAttachment((arg_0, arg_1) -> ((HttpServletResponse)response).setHeader(arg_0, arg_1), (String)fileVersion.getName());
            }
            if (withCache) {
                CacheControl cacheControl = CacheControl.maxAge((Duration)Duration.ofDays(1L));
                response.setHeader("Cache-Control", cacheControl.getHeaderValue());
            }
            fileSource.copyTo((OutputStream)response.getOutputStream());
        }
        catch (IOException e) {
            throw new UnknownResourceException(REQUESTED_FILE_WAS_NOT_FOUND);
        }
    }

    @Nonnull
    @Operation(description="Lock a file")
    @RequestMapping(value={"/documents/file/{fileId}/lock"}, method={RequestMethod.PUT})
    public FileLock lockFile(AuthorizationContext authCtx, @PathVariable DocumentId fileId) {
        authCtx.check((AbstractId)fileId, StaticAction.DOCUMENT_WRITE);
        this._fileLockService.lockFile(fileId, authCtx.getPersonId());
        FileLock fileLock = (FileLock)this._fileLockFrontendService.getFileLocks((Set)ImmutableSet.of((Object)fileId)).get((Object)fileId);
        return (FileLock)ObjectUtil.checkNotNull((Object)fileLock);
    }

    @Operation(description="Release a locked file")
    @RequestMapping(value={"/documents/file/{fileId}/lock"}, method={RequestMethod.DELETE})
    public void releaseFileLock(AuthorizationContext authCtx, @PathVariable DocumentId fileId) {
        authCtx.check((AbstractId)fileId, StaticAction.DOCUMENT_WRITE);
        this._fileLockService.release(fileId);
    }

    @Operation(description="Download a folder and all of its files as a single ZIP file")
    @RequestMapping(value={"/documents/folder/{folderId}/zip"}, method={RequestMethod.GET})
    public void downloadFolderAsZip(AuthorizationContext authCtx, @PathVariable DocumentId folderId, HttpServletResponse resp) throws IOException, ZipException {
        PublishedFilter publishedFilter = this._documentFrontendService.checkRead(authCtx, (AbstractId)folderId);
        DocumentVersionId latestVersionOfFolder = (DocumentVersionId)this._folderService.getLastVersionsOfDocuments((Set)ImmutableSet.of((Object)folderId), publishedFilter).get((Object)folderId);
        FolderVersionBO folderVersionBO = (FolderVersionBO)this._folderService.getFolderVersionsByIds((Set)ImmutableSet.of((Object)latestVersionOfFolder)).get((Object)latestVersionOfFolder);
        this._documentFrontendService.downloadFolderAsZip(resp, latestVersionOfFolder, folderVersionBO);
    }

    @Nonnull
    private DocumentId getRootFolderId(AuthorizationContext authCtx, ItemId itemId) {
        PublishedFilter publishedFilter = this._documentFrontendService.checkRead(authCtx, (AbstractId)itemId);
        DocumentVersionId rootFolderVersionId = this._changeModificationService.getOrCreateNewestChange(itemId, authCtx.getPersonId(), publishedFilter, null).getId();
        FolderVersionBO rootFolderVersionBO = (FolderVersionBO)this._folderService.getFolderVersionsByIds((Set)ImmutableSet.of((Object)rootFolderVersionId)).get((Object)rootFolderVersionId);
        if (rootFolderVersionBO == null) {
            throw new UnknownResourceException("missing folder for item " + String.valueOf(itemId));
        }
        return rootFolderVersionBO.getDocumentId();
    }
}

